/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui;

import com.adobe.granite.workflow.WorkflowException;
import com.smartling.aem.connector.automation.impl.AssetLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.TranslationRequest;
import com.smartling.aem.connector.automation.ui.SmartlingJobWorkflowServlet;
import com.smartling.aem.connector.automation.ui.SmartlingJobWorkflowServletValidator;
import com.smartling.aem.connector.automation.ui.SmartlingValidationException;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(methods={"POST"}, paths={"/services/smartling/job/workflows/asset"})
public class SmartlingJobWorkflowAssetServlet
extends SmartlingJobWorkflowServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartlingJobWorkflowAssetServlet.class);
    @Reference
    private SmartlingJobWorkflowServletValidator validator;
    @Reference
    private AssetLanguageCopyManager languageCopyManager;

    @Override
    protected void doPostInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        TranslationRequest translationRequest = this.getTranslationRequestBuilder(request);
        String path = translationRequest.getPaths()[0];
        SmartlingCloudConfig cloudConfig = this.getSmartlingConfig(resourceResolver, path, translationRequest.getProjectUid());
        String sourceLocaleCode = this.languageCopyManager.getLanguage(resourceResolver, path).getCode();
        translationRequest.setSourceLocaleCode(sourceLocaleCode);
        try {
            this.validator.validateConfig(request, resourceResolver);
        }
        catch (SmartlingValidationException e) {
            LOGGER.warn("Validation failed. Failed to create/update job [jobName={}, jobUid={}]:", new Object[]{translationRequest.getJobName(), translationRequest.getJobUid(), e});
            throw new ServletException((Throwable)e);
        }
        catch (SmartlingException e) {
            LOGGER.error("Failed to validate configuration", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        try {
            List<String> actualPaths = this.languageCopyManager.getAssetsUnderPaths(Arrays.asList(translationRequest.getPaths()));
            translationRequest.setPaths(actualPaths.toArray(new String[0]));
            Map<String, Object> metadata = this.prepareMetadata(request, resourceResolver, translationRequest);
            metadata.put("sourcePathList", translationRequest.getPaths());
            metadata.put("configSourceLocaleCode", sourceLocaleCode);
            this.startWorkflow(resourceResolver, path, "/etc/workflow/models/smartling/dam-translate/jcr:content/model", metadata);
            this.logTranslationRequest(translationRequest, cloudConfig);
        }
        catch (WorkflowException | SmartlingException e) {
            LOGGER.error("Failed to start Job Workflow for assets {}:", (Object)translationRequest.getPaths(), (Object)e);
            throw new ServletException(e);
        }
    }

    protected void bindValidator(SmartlingJobWorkflowServletValidator smartlingJobWorkflowServletValidator) {
        this.validator = smartlingJobWorkflowServletValidator;
    }

    protected void unbindValidator(SmartlingJobWorkflowServletValidator smartlingJobWorkflowServletValidator) {
        if (this.validator == smartlingJobWorkflowServletValidator) {
            this.validator = null;
        }
    }

    protected void bindLanguageCopyManager(AssetLanguageCopyManager assetLanguageCopyManager) {
        this.languageCopyManager = assetLanguageCopyManager;
    }

    protected void unbindLanguageCopyManager(AssetLanguageCopyManager assetLanguageCopyManager) {
        if (this.languageCopyManager == assetLanguageCopyManager) {
            this.languageCopyManager = null;
        }
    }
}

