/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.smartling.aem.connector.automation.CloudConfigResolver;
import com.smartling.aem.connector.automation.impl.AssetLanguageCopyManager;
import com.smartling.aem.connector.automation.ui.ServletUtils;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(componentAbstract=true)
public abstract class SmartlingBaseServlet
extends SlingAllMethodsServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartlingBaseServlet.class);
    public static final String PROJECT_UID_PARAM_NAME = "projectUid";
    public static final String ASSET_ROOT_FOLDER = "/content/dam";
    public static final String FORMS_ROOT_FOLDER = "/content/forms";
    private static final Gson GSON = new GsonBuilder().create();
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private ServletUtils servletUtils;
    @Reference
    private CloudConfigResolver cloudConfigResolver;

    public void doPost(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws ServletException, IOException {
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(Collections.emptyMap());
            this.doPostInternal(request, response, resourceResolver);
        }
        catch (LoginException e) {
            LOGGER.error("Couldn't start session to the repository", (Throwable)e);
            throw new ServletException("Couldn't start session to the repository", (Throwable)e);
        }
        finally {
            if (resourceResolver != null && resourceResolver.isLive()) {
                resourceResolver.close();
            }
        }
    }

    public void doGet(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws ServletException, IOException {
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(Collections.emptyMap());
            this.doGetInternal(request, response, resourceResolver);
        }
        catch (LoginException e) {
            LOGGER.error("Couldn't start session to the repository", (Throwable)e);
            throw new ServletException("Couldn't start session to the repository", (Throwable)e);
        }
        finally {
            if (resourceResolver != null && resourceResolver.isLive()) {
                resourceResolver.close();
            }
        }
    }

    protected void doPostInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        this.handleMethodNotImplemented(request, response);
    }

    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        this.handleMethodNotImplemented(request, response);
    }

    protected static String getMandatoryParameter(@Nonnull SlingHttpServletRequest request, String name, String errorMessage) {
        String value = request.getParameter(name);
        if (StringUtils.isEmpty((CharSequence)value)) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    protected static void writeJson(@Nonnull SlingHttpServletResponse response, @Nonnull Object data) throws IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        GSON.toJson(data, (Appendable)response.getWriter());
    }

    protected SmartlingCloudConfig getSmartlingConfig(ResourceResolver resourceResolver, String resourcePath, String projectUid) {
        SmartlingCloudConfig cloudConfig = this.servletUtils.getCloudConfigByPagePath(resourceResolver, resourcePath, SmartlingCloudConfig.class);
        if (cloudConfig == null) {
            throw new IllegalArgumentException(String.format("The resource path=\"%s\" does not have any Smartling Cloud Config associated with it", resourcePath));
        }
        return this.cloudConfigResolver.getConfigByPath(cloudConfig, resourceResolver, resourcePath, projectUid);
    }

    protected List<String> getPayloadPaths(String payload, AssetLanguageCopyManager assetLanguageCopyManager) throws SmartlingException {
        List<String> payloadPaths = Stream.of(StringUtils.split((String)payload, (String)";")).collect(Collectors.toList());
        return StringUtils.startsWithIgnoreCase((CharSequence)payload, (CharSequence)ASSET_ROOT_FOLDER) ? assetLanguageCopyManager.getAssetsUnderPaths(payloadPaths) : payloadPaths;
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindServletUtils(ServletUtils servletUtils) {
        this.servletUtils = servletUtils;
    }

    protected void unbindServletUtils(ServletUtils servletUtils) {
        if (this.servletUtils == servletUtils) {
            this.servletUtils = null;
        }
    }

    protected void bindCloudConfigResolver(CloudConfigResolver cloudConfigResolver) {
        this.cloudConfigResolver = cloudConfigResolver;
    }

    protected void unbindCloudConfigResolver(CloudConfigResolver cloudConfigResolver) {
        if (this.cloudConfigResolver == cloudConfigResolver) {
            this.cloudConfigResolver = null;
        }
    }
}

