/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.smartling.aem.connector.automation.CloudConfigLocator;
import com.smartling.aem.connector.automation.impl.AssetLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.Language;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import com.smartling.aem.connector.automation.impl.PageLanguageCopyManager;
import com.smartling.aem.connector.automation.ui.ProjectConfig;
import com.smartling.aem.connector.automation.ui.ServletUtils;
import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.SmartlingProjectLocaleCredentials;
import com.smartling.aem.connector.core.impl.integration.platform.ProjectApiClient;
import com.smartling.aem.connector.core.impl.integration.platform.ProjectApiClientFactory;
import com.smartling.api.projects.v2.pto.ProjectDetailsPTO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(paths={"/services/smartling/project-configs"})
public class ProjectConfigListServlet
extends SmartlingBaseServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectConfigListServlet.class);
    public static final String PATH_PARAM = "path";
    public static final String DAM_ROOT_FOLDER = "/content/dam";
    public static final String CONTENT_ROOT_FOLDER = "/content";
    @Reference
    private ProjectApiClientFactory clientFactory;
    @Reference
    private ServletUtils servletUtils;
    @Reference
    private CloudConfigLocator cloudConfigLocator;
    @Reference
    private AssetLanguageCopyManager assetLanguageCopyManager;
    @Reference
    private PageLanguageCopyManager pageLanguageCopyManager;
    private Cache<String, ProjectDetailsPTO> projectDetailsCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();

    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        try {
            String path = ProjectConfigListServlet.getMandatoryParameter(request, PATH_PARAM, "Mandatory path parameter is missing");
            path = StringUtils.substringBefore((String)path, (String)";");
            path = StringUtils.removeEnd((String)path, (String)".html");
            if (!StringUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)CONTENT_ROOT_FOLDER)) {
                String message = String.format("Couldn't get project configurations for path=\"%s\"", path);
                LOGGER.warn(message);
                this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, message);
                return;
            }
            Resource resource = resourceResolver.resolve(path);
            if (ResourceUtil.isNonExistingResource((Resource)resource)) {
                throw new IllegalArgumentException(String.format("Resource '%s' can not be found", path));
            }
            SmartlingCloudConfig multiConfig = this.getSmartlingConfig(resource);
            ArrayList<ConfigByLocale> configByLocaleList = new ArrayList<ConfigByLocale>();
            configByLocaleList.add(new ConfigByLocale(null, multiConfig));
            for (SmartlingProjectLocaleCredentials credentials : multiConfig.getLocaleProjectConfigs()) {
                SmartlingCloudConfig cloudConfig = multiConfig.getForLocale(credentials.getLocale());
                configByLocaleList.add(new ConfigByLocale(credentials.getLocale(), cloudConfig));
            }
            List projectConfigList = configByLocaleList.parallelStream().map(this::getProjectConfigSafe).filter(Objects::nonNull).collect(Collectors.toList());
            LanguageCopyManager languageCopyManager = StringUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)DAM_ROOT_FOLDER) ? this.assetLanguageCopyManager : this.pageLanguageCopyManager;
            Language resourceLanguage = languageCopyManager.getLanguage(resourceResolver, path);
            boolean match = false;
            if (resourceLanguage != null && projectConfigList.size() > 1) {
                for (ProjectConfig projectConfig2 : projectConfigList) {
                    if (match || !StringUtils.equalsIgnoreCase((CharSequence)projectConfig2.getConfiguredSourceLocale(), (CharSequence)resourceLanguage.getCode())) continue;
                    projectConfig2.setSelected(true);
                    match = true;
                }
            }
            if (!match) {
                projectConfigList.stream().filter(projectConfig -> StringUtils.isBlank((CharSequence)projectConfig.getConfiguredSourceLocale())).findFirst().ifPresent(projectConfig -> projectConfig.setSelected(true));
            }
            ProjectConfigListServlet.writeJson(response, projectConfigList);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Couldn't get project configurations", (Throwable)e);
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("Couldn't get project configurations", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    @Nullable
    private ProjectConfig getProjectConfigSafe(ConfigByLocale configByLocale) {
        try {
            return this.getProjectConfig(configByLocale.getLocale(), configByLocale.getConfig());
        }
        catch (SmartlingException | ExecutionException e) {
            LOGGER.error("Couldn't get Smartling project info", (Throwable)e);
            return null;
        }
    }

    private ProjectConfig getProjectConfig(String configuredSourceLocale, SmartlingCloudConfig cloudConfig) throws SmartlingException, ExecutionException {
        ProjectDetailsPTO projectDetailsPTO = (ProjectDetailsPTO)this.projectDetailsCache.get((Object)cloudConfig.getProjectId(), String2 -> {
            try (ProjectApiClient client = this.clientFactory.createClient(cloudConfig);){
                ProjectDetailsPTO projectDetailsPTO = client.getProjectDetails();
                return projectDetailsPTO;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return ProjectConfig.builder().configuredSourceLocale(configuredSourceLocale).projectName(projectDetailsPTO.getProjectName()).projectUid(cloudConfig.getProjectId()).projectSourceLocale(projectDetailsPTO.getSourceLocaleId()).build();
    }

    private SmartlingCloudConfig getSmartlingConfig(Resource resource) {
        SmartlingCloudConfig cloudConfig = this.cloudConfigLocator.getCloudConfigAppliedOnResource(resource, SmartlingCloudConfig.class);
        if (cloudConfig == null) {
            throw new IllegalArgumentException("The resource=\"" + resource.getPath() + "\" does not have any Smartling Cloud Config associated with it");
        }
        return cloudConfig;
    }

    protected void bindClientFactory(ProjectApiClientFactory projectApiClientFactory) {
        this.clientFactory = projectApiClientFactory;
    }

    protected void unbindClientFactory(ProjectApiClientFactory projectApiClientFactory) {
        if (this.clientFactory == projectApiClientFactory) {
            this.clientFactory = null;
        }
    }

    @Override
    protected void bindServletUtils(ServletUtils servletUtils) {
        this.servletUtils = servletUtils;
    }

    @Override
    protected void unbindServletUtils(ServletUtils servletUtils) {
        if (this.servletUtils == servletUtils) {
            this.servletUtils = null;
        }
    }

    protected void bindCloudConfigLocator(CloudConfigLocator cloudConfigLocator) {
        this.cloudConfigLocator = cloudConfigLocator;
    }

    protected void unbindCloudConfigLocator(CloudConfigLocator cloudConfigLocator) {
        if (this.cloudConfigLocator == cloudConfigLocator) {
            this.cloudConfigLocator = null;
        }
    }

    protected void bindAssetLanguageCopyManager(AssetLanguageCopyManager assetLanguageCopyManager) {
        this.assetLanguageCopyManager = assetLanguageCopyManager;
    }

    protected void unbindAssetLanguageCopyManager(AssetLanguageCopyManager assetLanguageCopyManager) {
        if (this.assetLanguageCopyManager == assetLanguageCopyManager) {
            this.assetLanguageCopyManager = null;
        }
    }

    protected void bindPageLanguageCopyManager(PageLanguageCopyManager pageLanguageCopyManager) {
        this.pageLanguageCopyManager = pageLanguageCopyManager;
    }

    protected void unbindPageLanguageCopyManager(PageLanguageCopyManager pageLanguageCopyManager) {
        if (this.pageLanguageCopyManager == pageLanguageCopyManager) {
            this.pageLanguageCopyManager = null;
        }
    }

    final class ConfigByLocale {
        String locale;
        SmartlingCloudConfig config;

        public ConfigByLocale(String locale, SmartlingCloudConfig config) {
            this.locale = locale;
            this.config = config;
        }

        public String getLocale() {
            return this.locale;
        }

        public SmartlingCloudConfig getConfig() {
            return this.config;
        }
    }
}

