/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui;

import com.smartling.aem.connector.automation.CloudConfigLocator;
import com.smartling.aem.connector.automation.CloudConfigResolver;
import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.impl.integration.platform.Job;
import com.smartling.aem.connector.core.impl.integration.platform.JobApiClient;
import com.smartling.aem.connector.core.impl.integration.platform.JobApiClientFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(paths={"/services/smartling/jobs"})
public class ListEditableJobsServlet
extends SmartlingBaseServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListEditableJobsServlet.class);
    @Reference
    private JobApiClientFactory clientFactory;
    @Reference
    private CloudConfigLocator cloudConfigLocator;
    @Reference
    private CloudConfigResolver cloudConfigResolver;

    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        String path = request.getParameter("path");
        if (StringUtils.isEmpty((CharSequence)path)) {
            response.sendError(400, "Mandatory path parameter is missing");
            return;
        }
        Resource resource = resourceResolver.resolve(StringUtils.substringBefore((String)path, (String)";"));
        if (ResourceUtil.isNonExistingResource((Resource)resource)) {
            response.sendError(400, "Page can not be found");
            return;
        }
        String projectUid = request.getParameter("projectUid");
        List<Job> jobs = this.loadJobsAvailableForResource(resource, projectUid);
        List sortedJobs = jobs.stream().sorted(new Comparator<Job>(){

            @Override
            public int compare(Job o1, Job o2) {
                return o2.getCreatedDate().compareTo(o1.getCreatedDate());
            }
        }).collect(Collectors.toList());
        ListEditableJobsServlet.writeJson(response, sortedJobs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Job> loadJobsAvailableForResource(@Nonnull Resource resource, String projectUid) throws ServletException {
        SmartlingCloudConfig cloudConfig = this.cloudConfigLocator.getCloudConfigAppliedOnResource(resource, SmartlingCloudConfig.class);
        if (cloudConfig == null) return Collections.emptyList();
        cloudConfig = this.cloudConfigResolver.getConfigByResource(cloudConfig, resource, projectUid);
        try (JobApiClient client = this.clientFactory.createClient(cloudConfig);){
            List<Job> list = client.listJobsByState(Arrays.asList(Job.State.AWAITING_AUTHORIZATION, Job.State.IN_PROGRESS, Job.State.COMPLETED));
            return list;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void bindClientFactory(JobApiClientFactory jobApiClientFactory) {
        this.clientFactory = jobApiClientFactory;
    }

    protected void unbindClientFactory(JobApiClientFactory jobApiClientFactory) {
        if (this.clientFactory == jobApiClientFactory) {
            this.clientFactory = null;
        }
    }

    protected void bindCloudConfigLocator(CloudConfigLocator cloudConfigLocator) {
        this.cloudConfigLocator = cloudConfigLocator;
    }

    protected void unbindCloudConfigLocator(CloudConfigLocator cloudConfigLocator) {
        if (this.cloudConfigLocator == cloudConfigLocator) {
            this.cloudConfigLocator = null;
        }
    }

    @Override
    protected void bindCloudConfigResolver(CloudConfigResolver cloudConfigResolver) {
        this.cloudConfigResolver = cloudConfigResolver;
    }

    @Override
    protected void unbindCloudConfigResolver(CloudConfigResolver cloudConfigResolver) {
        if (this.cloudConfigResolver == cloudConfigResolver) {
            this.cloudConfigResolver = null;
        }
    }
}

