/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.workflow;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.smartling.aem.connector.automation.impl.workflow.JobWorkflowParameters;
import com.smartling.aem.connector.automation.impl.workflow.context.ContextAwareWorkflowProcess;
import com.smartling.aem.connector.core.impl.integration.platform.InboxNotificationService;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component
public class TargetLocalesValidatorProcess
extends ContextAwareWorkflowProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(TargetLocalesValidatorProcess.class);
    public static final String NO_TARGET_LOCALES_ERROR_MESSAGE = "Could not proceed with workflow. No target locales are specified.";
    @Reference
    private InboxNotificationService inboxNotificationService;

    @Override
    public void executeInternal(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        JobWorkflowParameters parameters = new JobWorkflowParameters(workItem);
        if (parameters.getTargetLocaleCodes().isEmpty()) {
            String errorMessage = this.getErrorMessage(workItem);
            String contentNotSubmitted = errorMessage + " Your content is not submitted to Smartling.";
            String sourcePaths = StringUtils.join(parameters.getSourcePathList(), (String)";");
            ResourceResolver resourceResolver = (ResourceResolver)workflowSession.adaptTo(ResourceResolver.class);
            this.inboxNotificationService.sendNotification(resourceResolver, "Smartling: Content was not submitted", contentNotSubmitted, sourcePaths);
            LOGGER.error(NO_TARGET_LOCALES_ERROR_MESSAGE);
            this.setErrorMessage(workItem, NO_TARGET_LOCALES_ERROR_MESSAGE);
            this.terminate(workItem, workflowSession);
        }
    }

    @Override
    protected boolean shouldExecute(WorkItem workItem) {
        return this.isExecutedFirstTime(workItem);
    }

    protected void bindInboxNotificationService(InboxNotificationService inboxNotificationService) {
        this.inboxNotificationService = inboxNotificationService;
    }

    protected void unbindInboxNotificationService(InboxNotificationService inboxNotificationService) {
        if (this.inboxNotificationService == inboxNotificationService) {
            this.inboxNotificationService = null;
        }
    }
}

