/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.workflow;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.smartling.aem.connector.automation.impl.Language;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import com.smartling.aem.connector.automation.impl.PageLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.WcmWorkflows;
import com.smartling.aem.connector.automation.impl.workflow.JobWorkflowParameters;
import com.smartling.aem.connector.automation.impl.workflow.SendForTranslationProcess;
import com.smartling.aem.connector.automation.impl.workflow.WorkflowUtil;
import com.smartling.aem.connector.core.Predicates;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component
public class SendPageForTranslationProcess
extends SendForTranslationProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendPageForTranslationProcess.class);
    @Reference
    private PageLanguageCopyManager languageCopyManager;
    @Reference
    private WcmWorkflows wcmWorkflows;

    @Override
    public void updateLanguageCopy(WorkflowSession workflowSession, WcmWorkflows.Parameters parameters) throws WorkflowException {
        this.wcmWorkflows.updateLanguageCopy(workflowSession, parameters);
    }

    @Override
    protected void putCustomWorkflowParams(WcmWorkflows.Parameters parameters, ResourceResolver resourceResolver, WorkItem workItem) {
        JobWorkflowParameters workflowParameters = new JobWorkflowParameters(workItem);
        String payload = (String)workItem.getWorkflowData().getPayload();
        Language sourceLanguage = this.languageCopyManager.getLanguage(resourceResolver, payload);
        parameters.setSourceLanguage(sourceLanguage.getCode());
        List<String> sourcePaths = workflowParameters.getSourcePathList();
        if (CollectionUtils.isEmpty(sourcePaths)) {
            sourcePaths = Collections.singletonList(payload);
        }
        ArrayList<LanguageCopyManager.LanguageCopy> languageCopies = new ArrayList<LanguageCopyManager.LanguageCopy>();
        if (!workflowParameters.isDeep() || workflowParameters.getExcludedPathList().isEmpty()) {
            for (String sourcePath : sourcePaths) {
                List<LanguageCopyManager.LanguageCopy> copies = this.getLanguageCopiesForLocales(resourceResolver, sourcePath, workflowParameters.getTargetLocaleCodes());
                languageCopies.addAll(copies);
            }
            parameters.setDeep(workflowParameters.isDeep());
            parameters.setLanguageCopies(languageCopies);
        } else {
            TreeSet<String> excludedPaths = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            excludedPaths.addAll(workflowParameters.getExcludedPathList());
            for (String sourcePath : sourcePaths) {
                List<String> childrenPaths = this.languageCopyManager.getSubpagesPaths(resourceResolver, sourcePath, excludedPaths);
                List copies = childrenPaths.stream().flatMap(childPath -> this.getLanguageCopiesForLocales(resourceResolver, (String)childPath, workflowParameters.getTargetLocaleCodes()).stream()).collect(Collectors.toList());
                languageCopies.addAll(copies);
            }
            parameters.setDeep(false);
            parameters.setLanguageCopies(languageCopies);
        }
    }

    private List<LanguageCopyManager.LanguageCopy> getLanguageCopiesForLocales(ResourceResolver resourceResolver, String path, Set<String> locales) {
        List<LanguageCopyManager.LanguageCopy> languageCopies = StreamSupport.stream(this.languageCopyManager.findLanguageCopies(resourceResolver, path).spliterator(), false).filter(WorkflowUtil.byLocaleCode(Predicates.in(locales))).collect(Collectors.toList());
        List nonExisted = languageCopies.stream().filter(languageCopy -> !languageCopy.exists()).map(LanguageCopyManager.LanguageCopy::getPath).collect(Collectors.toList());
        if (nonExisted.isEmpty()) {
            return languageCopies;
        }
        LOGGER.warn("These content=\"{}\" is not existed, so it will not be requested for translation.", (Object)String.join((CharSequence)";", nonExisted));
        return languageCopies.stream().filter(LanguageCopyManager.LanguageCopy::exists).collect(Collectors.toList());
    }

    protected void bindLanguageCopyManager(PageLanguageCopyManager pageLanguageCopyManager) {
        this.languageCopyManager = pageLanguageCopyManager;
    }

    protected void unbindLanguageCopyManager(PageLanguageCopyManager pageLanguageCopyManager) {
        if (this.languageCopyManager == pageLanguageCopyManager) {
            this.languageCopyManager = null;
        }
    }

    protected void bindWcmWorkflows(WcmWorkflows wcmWorkflows) {
        this.wcmWorkflows = wcmWorkflows;
    }

    protected void unbindWcmWorkflows(WcmWorkflows wcmWorkflows) {
        if (this.wcmWorkflows == wcmWorkflows) {
            this.wcmWorkflows = null;
        }
    }
}

