/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.workflow;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.smartling.aem.connector.automation.impl.FormLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.Language;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import com.smartling.aem.connector.automation.impl.WcmWorkflows;
import com.smartling.aem.connector.automation.impl.workflow.JobWorkflowParameters;
import com.smartling.aem.connector.automation.impl.workflow.SendForTranslationProcess;
import com.smartling.aem.connector.automation.impl.workflow.WorkflowUtil;
import com.smartling.aem.connector.core.Predicates;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;

@Service
@Component
public class SendFormForTranslationProcess
extends SendForTranslationProcess {
    @Reference
    private WcmWorkflows wcmWorkflows;
    @Reference
    private FormLanguageCopyManager languageCopyManager;

    @Override
    protected void updateLanguageCopy(WorkflowSession workflowSession, WcmWorkflows.Parameters parameters) throws WorkflowException {
        this.wcmWorkflows.prepareFormLanguageCopy(workflowSession, parameters);
    }

    @Override
    protected void putCustomWorkflowParams(WcmWorkflows.Parameters parameters, ResourceResolver resourceResolver, WorkItem workItem) {
        JobWorkflowParameters workflowParameters = new JobWorkflowParameters(workItem);
        Language sourceLanguage = this.languageCopyManager.getLanguage(resourceResolver, workflowParameters.getSourcePathList().get(0));
        String payload = (String)workItem.getWorkflowData().getPayload();
        List<LanguageCopyManager.LanguageCopy> languageCopies = this.getLanguageCopies(resourceResolver, workflowParameters.getTargetLocaleCodes(), payload);
        parameters.setInitiatorUserID(workItem.getWorkflow().getInitiator());
        parameters.setLanguageCopies(languageCopies);
        parameters.setSourceLanguage(sourceLanguage.getCode());
        parameters.setSourcePaths(Collections.singletonList(payload));
    }

    private List<LanguageCopyManager.LanguageCopy> getLanguageCopies(ResourceResolver resourceResolver, Collection<String> targetLocales, String sourcePath) {
        return StreamSupport.stream(this.languageCopyManager.findLanguageCopies(resourceResolver, sourcePath).spliterator(), false).filter(WorkflowUtil.byLocaleCode(Predicates.in(targetLocales))).collect(Collectors.toList());
    }

    protected void bindWcmWorkflows(WcmWorkflows wcmWorkflows) {
        this.wcmWorkflows = wcmWorkflows;
    }

    protected void unbindWcmWorkflows(WcmWorkflows wcmWorkflows) {
        if (this.wcmWorkflows == wcmWorkflows) {
            this.wcmWorkflows = null;
        }
    }

    protected void bindLanguageCopyManager(FormLanguageCopyManager formLanguageCopyManager) {
        this.languageCopyManager = formLanguageCopyManager;
    }

    protected void unbindLanguageCopyManager(FormLanguageCopyManager formLanguageCopyManager) {
        if (this.languageCopyManager == formLanguageCopyManager) {
            this.languageCopyManager = null;
        }
    }
}

