/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.workflow;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.smartling.aem.connector.automation.impl.AssetLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.Language;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import com.smartling.aem.connector.automation.impl.WcmWorkflows;
import com.smartling.aem.connector.automation.impl.workflow.JobWorkflowParameters;
import com.smartling.aem.connector.automation.impl.workflow.SendForTranslationProcess;
import com.smartling.aem.connector.automation.impl.workflow.WorkflowUtil;
import com.smartling.aem.connector.core.Predicates;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component
public class SendAssetForTranslationProcess
extends SendForTranslationProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendAssetForTranslationProcess.class);
    @Reference
    private AssetLanguageCopyManager languageCopyManager;
    @Reference
    private WcmWorkflows wcmWorkflows;

    @Override
    public void updateLanguageCopy(WorkflowSession workflowSession, WcmWorkflows.Parameters parameters) throws WorkflowException {
        this.wcmWorkflows.prepareAssetLanguageCopy(workflowSession, parameters);
    }

    @Override
    protected void putCustomWorkflowParams(WcmWorkflows.Parameters parameters, ResourceResolver resourceResolver, WorkItem workItem) {
        JobWorkflowParameters workflowParameters = new JobWorkflowParameters(workItem);
        Language sourceLanguage = this.languageCopyManager.getLanguage(resourceResolver, workflowParameters.getSourcePathList().get(0));
        List<LanguageCopyManager.LanguageCopy> languageCopies = workflowParameters.getSourcePathList().stream().flatMap(sourcePath -> this.getLanguageCopies(resourceResolver, (Collection<String>)workflowParameters.getTargetLocaleCodes(), (String)sourcePath).stream()).collect(Collectors.toList());
        parameters.setInitiatorUserID(workItem.getWorkflow().getInitiator());
        parameters.setSourcePaths(workflowParameters.getSourcePathList());
        parameters.setSourceLanguage(sourceLanguage.getCode());
        parameters.setLanguageCopies(languageCopies);
    }

    private List<LanguageCopyManager.LanguageCopy> getLanguageCopies(ResourceResolver resourceResolver, Collection<String> targetLocales, String sourcePath) {
        List<LanguageCopyManager.LanguageCopy> languageCopies = StreamSupport.stream(this.languageCopyManager.findLanguageCopies(resourceResolver, sourcePath).spliterator(), false).filter(WorkflowUtil.byLocaleCode(Predicates.in(targetLocales))).collect(Collectors.toList());
        List nonExisted = languageCopies.stream().filter(languageCopy -> !languageCopy.exists()).map(LanguageCopyManager.LanguageCopy::getPath).collect(Collectors.toList());
        if (nonExisted.isEmpty()) {
            return languageCopies;
        }
        LOGGER.warn("These content=\"{}\" is not existed, so it will not be requested for translation.", (Object)String.join((CharSequence)";", nonExisted));
        return languageCopies.stream().filter(LanguageCopyManager.LanguageCopy::exists).collect(Collectors.toList());
    }

    protected void bindLanguageCopyManager(AssetLanguageCopyManager assetLanguageCopyManager) {
        this.languageCopyManager = assetLanguageCopyManager;
    }

    protected void unbindLanguageCopyManager(AssetLanguageCopyManager assetLanguageCopyManager) {
        if (this.languageCopyManager == assetLanguageCopyManager) {
            this.languageCopyManager = null;
        }
    }

    protected void bindWcmWorkflows(WcmWorkflows wcmWorkflows) {
        this.wcmWorkflows = wcmWorkflows;
    }

    protected void unbindWcmWorkflows(WcmWorkflows wcmWorkflows) {
        if (this.wcmWorkflows == wcmWorkflows) {
            this.wcmWorkflows = null;
        }
    }
}

