/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.workflow;

import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.smartling.aem.connector.core.impl.integration.platform.CustomFieldValue;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public final class JobWorkflowParameters {
    public static final String JOB_UID_PARAM = "jobUid";
    public static final String JOB_NAME_PARAM = "jobName";
    private static final String JOB_DUE_DATE_PARAM = "jobDueDate";
    public static final String TARGET_LOCALE_CODE_PARAM = "targetLocaleCodes";
    public static final String IS_DEEP_PARAM = "isDeep";
    public static final String AUTHORIZE_JOB = "authorizeJob";
    public static final String FORCE_RESUBMISSION = "forceResubmission";
    public static final String BATCH_UID_PARAM = "batchUid";
    public static final String PROJECT_OUTPUT_PARAM = "project";
    public static final String START_TIME_PARAM = "startTime";
    public static final String UPLOADED_FILE_COUNT_PARAM = "uploadedFileCount";
    public static final String SOURCE_PATH_LIST = "sourcePathList";
    public static final String CUSTOM_FIELDS_PARAM = "customFields";
    public static final String CONFIG_SOURCE_LOCALE_CODE = "configSourceLocaleCode";
    public static final String EXCLUDED_PATHS = "excludedPaths";
    public static final String LOGGED_USER = "loggedUser";
    public static final String PROJECT_UID_PARAM = "projectUid";
    public static final String PSEUDO = "pseudo";
    private final String jobUid;
    private final String jobName;
    private final Date jobDueDate;
    private final boolean deep;
    private final Set<String> targetLocaleCodes;
    private final boolean authorizeJob;
    private final boolean forceResubmission;
    private final String batchUid;
    private final int uploadedFileCount;
    private final List<String> sourcePathList;
    private List<CustomFieldValue> customFields = Collections.emptyList();
    private final String configSourceLocaleCode;
    private final List<String> excludedPathList;
    private final String loggedUser;
    private final String projectUid;
    private final boolean pseudo;
    private static final Gson GSON = new GsonBuilder().create();

    JobWorkflowParameters(WorkItem workItem) {
        MetaDataMap workflowMetadata = workItem.getWorkflowData().getMetaDataMap();
        this.jobUid = (String)workflowMetadata.get(JOB_UID_PARAM, (Object)"");
        this.jobName = (String)workflowMetadata.get(JOB_NAME_PARAM, (Object)"");
        this.jobDueDate = (Date)workflowMetadata.get(JOB_DUE_DATE_PARAM, Date.class);
        this.deep = (Boolean)workflowMetadata.get(IS_DEEP_PARAM, (Object)false);
        this.targetLocaleCodes = JobWorkflowParameters.newCaseInsensitiveSet((String[])workflowMetadata.get(TARGET_LOCALE_CODE_PARAM, (Object)new String[0]));
        this.authorizeJob = (Boolean)workflowMetadata.get(AUTHORIZE_JOB, (Object)true);
        this.forceResubmission = (Boolean)workflowMetadata.get(FORCE_RESUBMISSION, (Object)true);
        this.batchUid = (String)workflowMetadata.get(BATCH_UID_PARAM, (Object)"");
        this.uploadedFileCount = ((Double)workflowMetadata.get(UPLOADED_FILE_COUNT_PARAM, (Object)0.0)).intValue();
        this.sourcePathList = Arrays.asList((Object[])workflowMetadata.get(SOURCE_PATH_LIST, (Object)new String[]{(String)workItem.getWorkflowData().getPayload()}));
        this.excludedPathList = Arrays.asList((Object[])workflowMetadata.get(EXCLUDED_PATHS, (Object)new String[0]));
        this.loggedUser = (String)workflowMetadata.get(LOGGED_USER, (Object)"");
        this.projectUid = (String)workflowMetadata.get(PROJECT_UID_PARAM, (Object)"");
        this.pseudo = (Boolean)workflowMetadata.get(PSEUDO, (Object)false);
        String customFieldsStr = (String)workflowMetadata.get(CUSTOM_FIELDS_PARAM, (Object)"");
        if (StringUtils.isNotBlank((CharSequence)customFieldsStr)) {
            Type listType = new TypeToken<ArrayList<CustomFieldValue>>(){}.getType();
            this.customFields = (List)GSON.fromJson(customFieldsStr, listType);
        }
        this.configSourceLocaleCode = (String)workflowMetadata.get(CONFIG_SOURCE_LOCALE_CODE, (Object)"");
    }

    private static Set<String> newCaseInsensitiveSet(String[] items) {
        TreeSet<String> set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        set.addAll(Arrays.asList(items));
        return set;
    }

    Optional<String> getJobName() {
        return StringUtils.isEmpty((CharSequence)this.jobName) ? Optional.empty() : Optional.of(this.jobName);
    }

    Optional<Date> getJobDueDate() {
        return Optional.ofNullable(this.jobDueDate);
    }

    boolean isDeep() {
        return this.deep;
    }

    Set<String> getTargetLocaleCodes() {
        return Collections.unmodifiableSet(this.targetLocaleCodes);
    }

    boolean shouldAuthorizeJob() {
        return this.authorizeJob;
    }

    boolean shouldForceResubmission() {
        return this.forceResubmission;
    }

    String getJobUid() {
        return this.jobUid;
    }

    String getBatchUid() {
        return this.batchUid;
    }

    int getUploadedFileCount() {
        return this.uploadedFileCount;
    }

    public List<String> getSourcePathList() {
        return this.sourcePathList;
    }

    public List<CustomFieldValue> getCustomFields() {
        return this.customFields;
    }

    public String getConfigSourceLocaleCode() {
        return this.configSourceLocaleCode;
    }

    public List<String> getExcludedPathList() {
        return this.excludedPathList;
    }

    public String getLoggedUser() {
        return this.loggedUser;
    }

    public String getProjectUid() {
        return this.projectUid;
    }

    public boolean isPseudo() {
        return this.pseudo;
    }
}

