/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.workflow;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.smartling.aem.connector.automation.impl.PageLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.related.RelatedAssetsException;
import com.smartling.aem.connector.automation.impl.related.RelatedAssetsFactory;
import com.smartling.aem.connector.automation.impl.related.RelatedAssetsManager;
import com.smartling.aem.connector.automation.impl.workflow.DetermineTargetLocalesProcess;
import com.smartling.aem.connector.automation.impl.workflow.JobWorkflowParameters;
import com.smartling.aem.connector.automation.impl.workflow.WorkflowUtil;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component
public class DeterminePageTargetLocalesProcess
extends DetermineTargetLocalesProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeterminePageTargetLocalesProcess.class);
    @Reference
    private PageLanguageCopyManager pageLanguageCopyManager;
    @Reference
    private RelatedAssetsFactory relatedAssetsFactory;

    @Override
    public void executeInternal(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        JobWorkflowParameters parameters = new JobWorkflowParameters(workItem);
        ResourceResolver resourceResolver = (ResourceResolver)workflowSession.adaptTo(ResourceResolver.class);
        Resource payloadResource = this.getPayloadResource(workItem, workflowSession);
        String sourceLocale = parameters.getConfigSourceLocaleCode();
        if (StringUtils.isBlank((CharSequence)sourceLocale)) {
            sourceLocale = this.pageLanguageCopyManager.getLanguage(resourceResolver, payloadResource.getPath()).getCode();
        }
        SmartlingCloudConfig cloudConfig = this.getSmartlingCloudConfig(workItem, workflowSession);
        StringBuilder skipNonValidConfigMessage = new StringBuilder();
        Set<String> targetLocaleCodes = parameters.getTargetLocaleCodes();
        Set<String> supportedLocales = this.getSupportedLocales(sourceLocale, cloudConfig, targetLocaleCodes, skipNonValidConfigMessage);
        List<String> sourcePaths = parameters.getSourcePathList();
        if (CollectionUtils.isEmpty(sourcePaths)) {
            sourcePaths = Collections.singletonList(payloadResource.getPath());
        }
        TreeSet<String> excludedPaths = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        excludedPaths.addAll(parameters.getExcludedPathList());
        ArrayList<String> pagesPaths = new ArrayList<String>();
        for (String sourcePath : sourcePaths) {
            List<String> paths = parameters.isDeep() ? this.pageLanguageCopyManager.getSubpagesPaths(resourceResolver, sourcePath, excludedPaths) : Collections.singletonList(sourcePath);
            pagesPaths.addAll(paths);
        }
        StringBuilder skipUpToDateLocalesMessage = new StringBuilder();
        TreeSet<String> actualLocales = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (parameters.shouldForceResubmission()) {
            try {
                RelatedAssetsManager relatedAssetsManager = this.relatedAssetsFactory.createManager(payloadResource.getPath(), resourceResolver);
                this.markToForceResubmission(pagesPaths, resourceResolver, relatedAssetsManager);
            }
            catch (RelatedAssetsException e) {
                LOGGER.error("Couldn't initialize related assets manager for path=\"{}\"", (Object)payloadResource.getPath(), (Object)e);
            }
            actualLocales.addAll(supportedLocales);
        } else {
            for (String sourcePath : pagesPaths) {
                Resource sourceResource = resourceResolver.resolve(sourcePath);
                Set<String> newActualLocales = this.getActualLocales(resourceResolver, this.pageLanguageCopyManager, cloudConfig, sourceResource, supportedLocales, skipUpToDateLocalesMessage);
                actualLocales.addAll(newActualLocales);
            }
        }
        this.putTargetLocales(workItem, actualLocales, skipUpToDateLocalesMessage, skipNonValidConfigMessage);
    }

    private void markToForceResubmission(List<String> pagesPaths, ResourceResolver resourceResolver, RelatedAssetsManager relatedAssetsManager) {
        try {
            for (String path : pagesPaths) {
                Resource pageResource = resourceResolver.resolve(path);
                WorkflowUtil.setContentLastModifiedNow(pageResource);
                this.markRelatedForceResubmission(resourceResolver, relatedAssetsManager, path);
            }
            ((Session)resourceResolver.adaptTo(Session.class)).save();
        }
        catch (RepositoryException ex) {
            LOGGER.error("Couldn't save changes", (Throwable)ex);
        }
    }

    private void markRelatedForceResubmission(ResourceResolver resourceResolver, RelatedAssetsManager relatedAssetsManager, String path) {
        try {
            List<String> relatedPaths = relatedAssetsManager.getRelatedAssets(path);
            for (String relatedPath : relatedPaths) {
                Resource relatedResource = resourceResolver.resolve(relatedPath);
                WorkflowUtil.setContentLastModifiedNow(relatedResource);
            }
        }
        catch (RelatedAssetsException e) {
            LOGGER.error("Couldn't touch related assets for path=\"{}\"", (Object)path, (Object)e);
        }
    }

    protected void bindPageLanguageCopyManager(PageLanguageCopyManager pageLanguageCopyManager) {
        this.pageLanguageCopyManager = pageLanguageCopyManager;
    }

    protected void unbindPageLanguageCopyManager(PageLanguageCopyManager pageLanguageCopyManager) {
        if (this.pageLanguageCopyManager == pageLanguageCopyManager) {
            this.pageLanguageCopyManager = null;
        }
    }

    protected void bindRelatedAssetsFactory(RelatedAssetsFactory relatedAssetsFactory) {
        this.relatedAssetsFactory = relatedAssetsFactory;
    }

    protected void unbindRelatedAssetsFactory(RelatedAssetsFactory relatedAssetsFactory) {
        if (this.relatedAssetsFactory == relatedAssetsFactory) {
            this.relatedAssetsFactory = null;
        }
    }
}

