/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.workflow;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.smartling.aem.connector.automation.impl.AssetLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import com.smartling.aem.connector.automation.impl.workflow.JobWorkflowParameters;
import com.smartling.aem.connector.automation.impl.workflow.WorkflowUtil;
import com.smartling.aem.connector.automation.impl.workflow.context.ContextAwareWorkflowProcess;
import com.smartling.aem.connector.core.Predicates;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component
public class CreateNotExistedAssetLanguageCopiesProcess
extends ContextAwareWorkflowProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateNotExistedAssetLanguageCopiesProcess.class);
    private static final String CREATE_LANGUAGE_COPY_ERROR_MESSAGE = "Failed to create asset language copy path=\"%s\"";
    @Reference
    protected AssetLanguageCopyManager languageCopyManager;

    @Override
    public void executeInternal(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        JobWorkflowParameters workflowParameters = new JobWorkflowParameters(workItem);
        ResourceResolver resourceResolver = (ResourceResolver)workflowSession.adaptTo(ResourceResolver.class);
        for (String sourcePath : workflowParameters.getSourcePathList()) {
            try {
                Iterable languageCopies = StreamSupport.stream(this.languageCopyManager.findLanguageCopies(resourceResolver, sourcePath).spliterator(), false).filter(WorkflowUtil.byLocaleCode(Predicates.in(workflowParameters.getTargetLocaleCodes()))).collect(Collectors.toList());
                List<String> targetLanguages = StreamSupport.stream(languageCopies.spliterator(), false).map(languageCopy -> languageCopy.getLanguage().getCode()).collect(Collectors.toList());
                List targetPaths = StreamSupport.stream(languageCopies.spliterator(), false).map(LanguageCopyManager.LanguageCopy::getPath).collect(Collectors.toList());
                this.languageCopyManager.createLanguageCopy(sourcePath, targetLanguages);
                LOGGER.info("Updated language DAM paths=\"{}\" from source path=\"{}\"", (Object)StringUtils.join(targetPaths, (String)";"), (Object)sourcePath);
            }
            catch (Exception e) {
                LOGGER.error(String.format(CREATE_LANGUAGE_COPY_ERROR_MESSAGE, sourcePath), (Throwable)e);
                throw new WorkflowException(String.format(CREATE_LANGUAGE_COPY_ERROR_MESSAGE, sourcePath), (Throwable)e);
            }
        }
    }

    protected void bindLanguageCopyManager(AssetLanguageCopyManager assetLanguageCopyManager) {
        this.languageCopyManager = assetLanguageCopyManager;
    }

    protected void unbindLanguageCopyManager(AssetLanguageCopyManager assetLanguageCopyManager) {
        if (this.languageCopyManager == assetLanguageCopyManager) {
            this.languageCopyManager = null;
        }
    }
}

