/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.workflow;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.smartling.aem.connector.automation.impl.workflow.JobWorkflowParameters;
import com.smartling.aem.connector.automation.impl.workflow.WorkflowUtil;
import com.smartling.aem.connector.automation.impl.workflow.context.ContextAwareWorkflowProcess;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.integration.platform.JobApiClient;
import com.smartling.aem.connector.core.impl.integration.platform.JobApiClientFactory;
import com.smartling.aem.connector.core.impl.integration.platform.jobs.JobUtil;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component
public class CreateJobProcess
extends ContextAwareWorkflowProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateJobProcess.class);
    @Reference
    private JobApiClientFactory clientFactory;

    @Override
    public void executeInternal(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        SmartlingCloudConfig config = this.getSmartlingCloudConfig(workItem, workflowSession);
        JobWorkflowParameters parameters = new JobWorkflowParameters(workItem);
        ResourceResolver resourceResolver = (ResourceResolver)workflowSession.adaptTo(ResourceResolver.class);
        String jobTitle = parameters.getSourcePathList().stream().map(arg_0 -> ((ResourceResolver)resourceResolver).resolve(arg_0)).map(WorkflowUtil::getPayloadTitle).collect(Collectors.joining(";"));
        String jobUid = this.createJob(jobTitle, parameters, config);
        workItem.getWorkflowData().getMetaDataMap().put((Object)"jobUid", (Object)jobUid);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String createJob(String jobTitle, JobWorkflowParameters parameters, SmartlingCloudConfig cloudConfig) throws WorkflowException {
        try (JobApiClient jobApiClient = this.clientFactory.createClient(cloudConfig);){
            String jobName = StringUtils.trim((String)parameters.getJobName().orElse(JobUtil.generateJobName(jobTitle)));
            Date dueDate = parameters.getJobDueDate().orElse(null);
            Collection targetLocaleCodes = parameters.getTargetLocaleCodes().stream().map(targetLocaleCode -> {
                boolean contains;
                String result = cloudConfig.getLanguageMapping().get(targetLocaleCode);
                boolean bl = contains = result != null || cloudConfig.getLanguageMapping().containsKey(targetLocaleCode);
                if (!contains) {
                    throw new IllegalArgumentException("Target locale code " + targetLocaleCode + " does not have a mapping.");
                }
                return result;
            }).collect(Collectors.toList());
            String jobUid = jobApiClient.createJob(jobName, targetLocaleCodes, dueDate, parameters.getCustomFields());
            LOGGER.info("Created a jobName=\"{}\" with jobUid=\"{}\" for locales=\"{}\"", new Object[]{jobName, jobUid, targetLocaleCodes});
            String string = jobUid;
            return string;
        }
        catch (SmartlingException e) {
            LOGGER.error("Failed to create a job in Smartling", (Throwable)e);
            throw new WorkflowException("Could not create Job in Smartling project", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("General error on creating a job in Smartling", (Throwable)e);
            throw new WorkflowException("General error on creating Job in Smartling project", (Throwable)e);
        }
    }

    protected void bindClientFactory(JobApiClientFactory jobApiClientFactory) {
        this.clientFactory = jobApiClientFactory;
    }

    protected void unbindClientFactory(JobApiClientFactory jobApiClientFactory) {
        if (this.clientFactory == jobApiClientFactory) {
            this.clientFactory = null;
        }
    }
}

