/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.wcm.project;

import com.smartling.aem.connector.automation.impl.Language;
import com.smartling.aem.connector.automation.impl.TranslationJob;
import com.smartling.aem.connector.automation.impl.TranslationProject;
import com.smartling.aem.connector.automation.impl.wcm.project.TranslationJobResource;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TranslationProjectResource
implements TranslationProject {
    private static final Logger LOGGER = LoggerFactory.getLogger(TranslationProjectResource.class);
    public static final String TITLE_PROP = "jcr:title";
    private static final String SOURCE_LOCALE_CODE_PROP = "sourceLanguage";
    private static final String TARGET_LOCALE_CODE_PROP = "destinationLanguage";
    public static final String BATCH_UID_PROP = "batchUid";
    public static final String JOB_UID_PROP = "jobUid";
    public static final String CONFIG_SOURCE_LOCALE_CODE_PROP = "configSourceLocaleCode";
    private static final String CQ_CONF_PROP = "cq:conf";
    private static final String ROLE_OWNER_PROP = "role_owner";
    private static final String ROLE_OBSERVER_PROP = "role_observer";
    public static final String PROJECT_UID_PROP = "projectUid";
    public static final String PSEUDO_PROP = "pseudo";
    private static final String AUTO_AUTHORIZE_PROP = "autoAuthorize";
    private final Resource projectContentResource;
    private final ModifiableValueMap projectProperties;
    private final ModifiableValueMap projectFolderProperties;
    private final ResourceResolver resourceResolver;

    TranslationProjectResource(Resource projectContentResource) {
        this.projectContentResource = projectContentResource;
        this.projectProperties = (ModifiableValueMap)projectContentResource.adaptTo(ModifiableValueMap.class);
        Resource projectFolderResource = projectContentResource.getParent().getParent();
        this.projectFolderProperties = (ModifiableValueMap)projectFolderResource.adaptTo(ModifiableValueMap.class);
        this.resourceResolver = projectContentResource.getResourceResolver();
    }

    @Override
    public String getTitle() {
        return (String)this.projectProperties.get(TITLE_PROP, String.class);
    }

    @Override
    public Language getSourceLanguage() {
        return Language.forCode((String)this.projectProperties.get(SOURCE_LOCALE_CODE_PROP, String.class));
    }

    @Override
    public Collection<Language> getTargetLanguages() {
        return Arrays.asList((Object[])this.projectProperties.get(TARGET_LOCALE_CODE_PROP, (Object)new String[0])).stream().map(Language::forCode).collect(Collectors.toList());
    }

    @Override
    public String getPath() {
        return this.projectContentResource.getParent().getPath();
    }

    @Override
    public String getBatchUid() {
        return (String)this.projectProperties.get(BATCH_UID_PROP, this.projectFolderProperties.get(BATCH_UID_PROP, String.class));
    }

    @Override
    public String getJobUid() {
        return (String)this.projectProperties.get(JOB_UID_PROP, this.projectFolderProperties.get(JOB_UID_PROP, String.class));
    }

    @Override
    public String getProjectUid() {
        return (String)this.projectProperties.get(PROJECT_UID_PROP, this.projectFolderProperties.get(PROJECT_UID_PROP, String.class));
    }

    @Override
    public void setJobUid(String jobUid) {
        if (jobUid == null) {
            this.projectProperties.remove((Object)JOB_UID_PROP);
        } else {
            this.projectProperties.put((Object)JOB_UID_PROP, (Object)jobUid);
        }
        this.save();
    }

    @Override
    public void setBatchUid(String batchUid) {
        if (batchUid == null) {
            this.projectProperties.remove((Object)BATCH_UID_PROP);
        } else {
            this.projectProperties.put((Object)BATCH_UID_PROP, (Object)batchUid);
        }
        this.save();
    }

    @Override
    public String getCqConf() {
        return (String)this.projectProperties.get(CQ_CONF_PROP, String.class);
    }

    @Override
    public String getRoleOwner() {
        return (String)this.projectContentResource.getParent().getValueMap().get(ROLE_OWNER_PROP, String.class);
    }

    @Override
    public String getRoleObserver() {
        return (String)this.projectContentResource.getParent().getValueMap().get(ROLE_OBSERVER_PROP, String.class);
    }

    @Override
    public Collection<TranslationJob> getTranslationJobs() {
        Resource gadgetsResource = this.projectContentResource.getChild("dashboard/gadgets");
        if (gadgetsResource == null) {
            return Collections.emptyList();
        }
        return StreamSupport.stream(gadgetsResource.getChildren().spliterator(), false).filter(resource -> resource.isResourceType("cq/gui/components/projects/admin/pod/translationjobpod")).map(TranslationJobResource::new).collect(Collectors.toList());
    }

    @Override
    public String getConfigSourceLocaleCode() {
        return (String)this.projectProperties.get(CONFIG_SOURCE_LOCALE_CODE_PROP, this.projectFolderProperties.get(CONFIG_SOURCE_LOCALE_CODE_PROP, this.projectProperties.get(SOURCE_LOCALE_CODE_PROP, String.class)));
    }

    @Override
    public boolean isPseudo() {
        return (Boolean)this.projectProperties.get(PSEUDO_PROP, this.projectFolderProperties.get(PSEUDO_PROP, (Object)false));
    }

    @Override
    public boolean autoAuthorize() {
        return (Boolean)this.projectProperties.get(AUTO_AUTHORIZE_PROP, this.projectFolderProperties.get(AUTO_AUTHORIZE_PROP, (Object)false));
    }

    private void save() {
        try {
            this.resourceResolver.commit();
        }
        catch (PersistenceException e) {
            LOGGER.error("Failed to save changes.", (Throwable)e);
        }
    }
}

