/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.wcm.localization;

import com.smartling.aem.connector.automation.impl.OrderResolver;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;

@Service
@Component
public class OrderResolverImpl
implements OrderResolver {
    @Override
    public String getNextPageName(Resource sourcePage, Resource targetPage) {
        Resource sourcePageParent = sourcePage.getParent();
        Resource targetPageParent = targetPage.getParent();
        if (sourcePageParent != null && targetPageParent != null) {
            List<Resource> pagesOnSameLevelInSourceTree = OrderResolverImpl.newArrayList(sourcePageParent.listChildren());
            List<Resource> pagesOnSameLevelInTargetTree = OrderResolverImpl.newArrayList(targetPageParent.listChildren());
            Iterable<Resource> nextPagesToSourceInSourceTree = this.getPagesAfter(sourcePage.getName(), pagesOnSameLevelInSourceTree);
            Optional<Resource> nextPageInTargetTree = this.getNextPageInTargetTree(nextPagesToSourceInSourceTree, pagesOnSameLevelInTargetTree);
            return nextPageInTargetTree.map(Resource::getName).orElse(null);
        }
        return null;
    }

    @NotNull
    private static List<Resource> newArrayList(Iterator<Resource> iterator) {
        return StreamSupport.stream(((Iterable)() -> iterator).spliterator(), false).collect(Collectors.toList());
    }

    private Optional<Resource> getNextPageInTargetTree(Iterable<Resource> nextPagesToSourceInSourceTree, List<Resource> pagesOnSameLevelInTargetTree) {
        return StreamSupport.stream(nextPagesToSourceInSourceTree.spliterator(), false).filter(this.hasPageWithSameNameInTargetTree(pagesOnSameLevelInTargetTree)).findFirst();
    }

    private Predicate<? super Resource> hasPageWithSameNameInTargetTree(final List<Resource> pagesOnSameLevelInTargetTree) {
        return new Predicate<Resource>(){

            @Override
            public boolean test(Resource nextPageInSourceTree) {
                return pagesOnSameLevelInTargetTree.stream().anyMatch(this.hasPageWithSameName(nextPageInSourceTree));
            }

            private Predicate<? super Resource> hasPageWithSameName(Resource nextPageInSourceTree) {
                return pageInTargetTree -> pageInTargetTree.getName().equals(nextPageInSourceTree.getName());
            }
        };
    }

    private Iterable<Resource> getPagesAfter(final String name, List<Resource> pagesOnSameLevelInSourceTree) {
        return pagesOnSameLevelInSourceTree.stream().filter(new Predicate<Resource>(){
            private boolean pageFound;

            @Override
            public boolean test(Resource input) {
                if (input.getName().equals(name)) {
                    this.pageFound = true;
                    return false;
                }
                return this.pageFound;
            }
        }).collect(Collectors.toList());
    }
}

