/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.wcm.localization;

import com.smartling.aem.connector.automation.impl.FormLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.Language;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(value={FormLanguageCopyManager.class})
@Component
public class FormLanguageCopyManagerImpl
implements FormLanguageCopyManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormLanguageCopyManagerImpl.class);
    public static final String GUIDE_LOCALIZATION_SERVICE = "com.adobe.aemds.guide.service.GuideLocalizationService";
    public static final String SUPPORTED_LOCALES = "getSupportedLocales";

    @Override
    public Iterable<LanguageCopyManager.LanguageCopy> findLanguageCopies(ResourceResolver resourceResolver, String path) {
        List<String> languages = this.getSupportedLocales();
        Language sourceLanguage = this.getLanguage(resourceResolver, path);
        return () -> languages.stream().filter(language -> !StringUtils.equalsIgnoreCase((CharSequence)language, (CharSequence)sourceLanguage.getCode())).map(language -> new LanguageCopyManager.LanguageCopy(null, Language.forCode(language), false)).iterator();
    }

    @Override
    public Language getLanguage(ResourceResolver resourceResolver, String path) {
        Resource jcrContent;
        String language = "en";
        Resource resource = resourceResolver.getResource(path);
        if (resource != null && (jcrContent = resource.getChild("jcr:content")) != null) {
            language = (String)jcrContent.getValueMap().get("jcr:language", (Object)language);
        }
        return StringUtils.isNotBlank((CharSequence)language) ? Language.forCode(language) : null;
    }

    @Override
    public String getCqLanguage(Resource res) {
        Language language = this.getLanguage(res.getResourceResolver(), res.getPath());
        return language.getCode();
    }

    @Override
    public boolean isSourceChangedAfterTranslation(ResourceResolver resourceResolver, String sourcePath, String targetPath) {
        return false;
    }

    @Override
    public Date getLastModified(ResourceResolver resourceResolver, String path) {
        return null;
    }

    private List<String> getSupportedLocales() {
        Method method;
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(GUIDE_LOCALIZATION_SERVICE);
        if (serviceReference == null) {
            LOGGER.error("There is no \"{}\" service registered. Please check if \"com.adobe.aemds.guide\" bundle is installed.", (Object)GUIDE_LOCALIZATION_SERVICE);
            return Collections.emptyList();
        }
        Object service = bundleContext.getService(serviceReference);
        if (service == null) {
            LOGGER.error("Failed to get service \"{}\" from service reference.", (Object)GUIDE_LOCALIZATION_SERVICE);
            return Collections.emptyList();
        }
        try {
            method = service.getClass().getMethod(SUPPORTED_LOCALES, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("Failed to get method \"{}\" from service \"{}\".", (Object)SUPPORTED_LOCALES, (Object)GUIDE_LOCALIZATION_SERVICE);
            return Collections.emptyList();
        }
        try {
            String[] locales = (String[])method.invoke(service, new Object[0]);
            return locales != null ? Arrays.asList(locales) : Collections.emptyList();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOGGER.error("Failed to invoke method \"{}\" from service \"{}\".", (Object)SUPPORTED_LOCALES, (Object)GUIDE_LOCALIZATION_SERVICE);
            return Collections.emptyList();
        }
    }
}

