/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.wcm.localization;

import com.adobe.granite.workflow.WorkflowException;
import com.day.cq.commons.LanguageUtil;
import com.day.cq.dam.commons.util.DamLanguageUtil;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.wcm.api.PageManagerFactory;
import com.smartling.aem.connector.automation.impl.AssetLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.Language;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import com.smartling.aem.connector.automation.impl.wcm.localization.LanguageCopyException;
import com.smartling.aem.connector.automation.impl.wcm.localization.LanguageCopyManagerImpl;
import com.smartling.aem.connector.automation.ui.SmartlingDialogConfiguration;
import com.smartling.aem.connector.core.Predicates;
import com.smartling.aem.connector.core.SmartlingException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(value={AssetLanguageCopyManager.class})
@Component
public class AssetLanguageCopyManagerImpl
extends LanguageCopyManagerImpl
implements AssetLanguageCopyManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AssetLanguageCopyManagerImpl.class);
    private static final int DESCENDANTS_ASSETS_COUNT_THRESHOLD = 100;
    @Reference
    private PageManagerFactory pageManagerFactory;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private SmartlingDialogConfiguration smartlingDialogConfiguration;

    @Override
    public Iterable<LanguageCopyManager.LanguageCopy> findLanguageCopies(ResourceResolver resourceResolver, String path) {
        Collection languageRoots = DamLanguageUtil.getLanguageRoots((ResourceResolver)resourceResolver, (String)path);
        if (this.smartlingDialogConfiguration.areLanguageRootSiblingsOnly()) {
            try {
                String sourceLanguageRoot = languageRoots.stream().map(Resource::getPath).filter(resourcePath -> StringUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)resourcePath)).findFirst().orElseThrow(() -> new LanguageCopyException("No language root for source asset"));
                String sourceLanguageRootParent = StringUtils.substringBeforeLast((String)sourceLanguageRoot, (String)"/");
                languageRoots = languageRoots.stream().filter(resource -> StringUtils.substringBeforeLast((String)resource.getPath(), (String)"/").equals(sourceLanguageRootParent)).collect(Collectors.toList());
            }
            catch (LanguageCopyException ex) {
                LOGGER.error("Failed to omit language roots on different levels", (Throwable)ex);
            }
        }
        languageRoots = languageRoots.stream().map(this::skipRootContentResource).collect(Collectors.toList());
        return languageRoots.stream().map(this.toLanguageCopy(resourceResolver, path)).filter(Predicates.not(AssetLanguageCopyManagerImpl.equalBy(AssetLanguageCopyManagerImpl.languageCopyPath(), path))).collect(Collectors.toList());
    }

    @Override
    public Language getLanguage(ResourceResolver resourceResolver, String path) {
        String thisLanguageRoot = LanguageUtil.getLanguageRoot((String)path);
        if (StringUtils.isBlank((CharSequence)thisLanguageRoot)) {
            return null;
        }
        return this.createFromLanguageRoot(resourceResolver, StringUtils.substringAfterLast((String)thisLanguageRoot, (String)"/"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createLanguageCopy(String sourcePath, List<String> targetLanguages) throws Exception {
        ResourceResolver resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(Collections.emptyMap());
        try {
            List createdCopies = DamLanguageUtil.createLanguageCopyWithAssetRelations((ResourceResolver)resourceResolver, (PageManagerFactory)this.pageManagerFactory, (String)sourcePath, (String[])targetLanguages.toArray(new String[0]));
            if (createdCopies == null || createdCopies.size() != targetLanguages.size()) {
                throw new WorkflowException("Error while creating language copy with asset relations for assets: " + sourcePath + ".");
            }
            Session session = (Session)resourceResolver.adaptTo(Session.class);
            session.save();
        }
        finally {
            if (resourceResolver.isLive()) {
                resourceResolver.close();
            }
        }
    }

    @Override
    public Date getLastModified(ResourceResolver resourceResolver, String path) {
        return AssetLanguageCopyManagerImpl.getProperty(resourceResolver, path, Date.class, "jcr:lastModified");
    }

    @Override
    public List<String> getAssetsUnderPaths(List<String> payloadPaths) throws SmartlingException {
        ArrayList<String> payloads = new ArrayList<String>();
        ArrayDeque<String> uncheckedPayloadPaths = new ArrayDeque<String>(payloadPaths);
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(Collections.emptyMap());
            int assetCount = 0;
            while (!uncheckedPayloadPaths.isEmpty()) {
                boolean shouldCheckFolder;
                if (assetCount >= 100) {
                    LOGGER.warn("Search of child/descendant assets exceeds the limit in \"{}\" items.", (Object)100);
                    break;
                }
                String path = uncheckedPayloadPaths.poll();
                Resource payloadResource = resourceResolver.getResource(path);
                if (payloadResource == null || ResourceUtil.isNonExistingResource((Resource)payloadResource)) continue;
                boolean bl = shouldCheckFolder = this.smartlingDialogConfiguration.isCheckDamFolderDescendantsOption() || assetCount < payloadPaths.size();
                if (DamUtil.isAsset((Resource)payloadResource)) {
                    payloads.add(payloadResource.getPath());
                } else if (shouldCheckFolder && AssetLanguageCopyManagerImpl.isFolder(payloadResource)) {
                    for (Resource childResource : payloadResource.getChildren()) {
                        uncheckedPayloadPaths.add(childResource.getPath());
                    }
                }
                ++assetCount;
            }
        }
        catch (LoginException e) {
            throw new SmartlingException("Couldn't login into repository.", e);
        }
        finally {
            if (resourceResolver != null && resourceResolver.isLive()) {
                resourceResolver.close();
            }
        }
        return payloads;
    }

    private Function<Resource, LanguageCopyManager.LanguageCopy> toLanguageCopy(ResourceResolver resourceResolver, String path) {
        String thisLanguageRootPath = LanguageUtil.getLanguageRoot((String)path);
        return languageRoot -> {
            String languageCopyPath = path.replace(thisLanguageRootPath, languageRoot.getPath());
            Language language = this.createFromLanguageRoot(resourceResolver, languageRoot.getName());
            boolean exist = resourceResolver.getResource(languageCopyPath) != null;
            Date lastModified = this.getLastModified(resourceResolver, languageCopyPath);
            LanguageCopyManager.LanguageCopy languageCopy = new LanguageCopyManager.LanguageCopy(languageCopyPath, language, exist);
            languageCopy.setLastModified(lastModified);
            Date lastTranslationApplied = AssetLanguageCopyManagerImpl.getProperty(resourceResolver, languageCopyPath, Date.class, "cq:lastTranslationDone");
            if (lastTranslationApplied == null) {
                lastTranslationApplied = AssetLanguageCopyManagerImpl.getProperty(resourceResolver, languageCopyPath, Date.class, "cq:lastTranslationUpdate");
            }
            languageCopy.setLastTranslationApplied(lastTranslationApplied);
            return languageCopy;
        };
    }

    private Language createFromLanguageRoot(ResourceResolver resourceResolver, String languageRootName) {
        return Language.create(languageRootName, AssetLanguageCopyManagerImpl.getLanguageDisplayName(resourceResolver, languageRootName));
    }

    private static boolean isFolder(Resource resource) {
        Node n = (Node)resource.adaptTo(Node.class);
        try {
            return n != null && n.isNodeType("nt:folder");
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    protected void bindPageManagerFactory(PageManagerFactory pageManagerFactory) {
        this.pageManagerFactory = pageManagerFactory;
    }

    protected void unbindPageManagerFactory(PageManagerFactory pageManagerFactory) {
        if (this.pageManagerFactory == pageManagerFactory) {
            this.pageManagerFactory = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindSmartlingDialogConfiguration(SmartlingDialogConfiguration smartlingDialogConfiguration) {
        this.smartlingDialogConfiguration = smartlingDialogConfiguration;
    }

    protected void unbindSmartlingDialogConfiguration(SmartlingDialogConfiguration smartlingDialogConfiguration) {
        if (this.smartlingDialogConfiguration == smartlingDialogConfiguration) {
            this.smartlingDialogConfiguration = null;
        }
    }
}

