/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.related;

import com.smartling.aem.connector.automation.impl.related.AssetNodeRule;
import com.smartling.aem.connector.automation.impl.related.NodeRule;
import com.smartling.aem.connector.automation.impl.related.RelatedAssetsException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TranslationRulesFileParser {
    public static final String ASSET_REFERENCE_ATTRIBUTE = "assetReferenceAttribute";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String RESOURCE_TYPE = "resourceType";
    public static final String NODE = "node";
    public static final String PROPERTY = "property";
    public static final String FILTER = "filter";
    public static final String PATH_CONTAINS = "pathContains";
    public static final String CONTAINS_PROPERTY = "containsProperty";
    public static final String PROPERTY_VALUE = "propertyValue";
    public static final String IS_DEEP = "isDeep";
    public static final String NAME = "name";
    public static final String INHERIT = "inherit";
    public static final String TRANSLATE = "translate";
    public static final String UPDATE_DESTINATION_LANGUAGE = "updateDestinationLanguage";
    public static final String PATH = "path";
    private final ArrayList<NodeRule> rulesCompleteArray;
    private final HashMap<String, List<AssetNodeRule>> assetNodeHash = new HashMap();
    private final ArrayList<NodeRule> rulesWithContainsArray;

    private TranslationRulesFileParser() {
        this.rulesCompleteArray = new ArrayList();
        this.rulesWithContainsArray = new ArrayList();
    }

    public static TranslationRulesFileParser initialize(InputStream contentStream) throws RelatedAssetsException {
        try {
            TranslationRulesFileParser parser = new TranslationRulesFileParser();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(contentStream);
            Node rootNode = doc.getFirstChild();
            NodeList nodeList = rootNode.getChildNodes();
            for (int index = 0; index < nodeList.getLength(); ++index) {
                Node childNode = nodeList.item(index);
                if (childNode.getNodeType() != 1) continue;
                if (NODE.equals(childNode.getNodeName())) {
                    parser.processNode(childNode, null);
                    continue;
                }
                if (!"assetNode".equals(childNode.getNodeName())) continue;
                parser.processAssetNode(childNode);
            }
            return parser;
        }
        catch (Exception e) {
            throw new RelatedAssetsException("Couldn't parse translation rules", e);
        }
    }

    public List<AssetNodeRule> getAssetNodeRules(String resourceType) {
        return this.assetNodeHash.get(resourceType);
    }

    public NodeRule findWithContainsOnlyRuleFromArray(String strNodePath, String strResourceType, String strActualNodePath) {
        return this.findRuleFromArrayInternal(this.rulesWithContainsArray, strNodePath, strResourceType, strActualNodePath);
    }

    public NodeRule findRuleFromArray(String strNodePath, String strResourceType, String strActualNodePath) {
        return this.findRuleFromArrayInternal(this.rulesCompleteArray, strNodePath, strResourceType, strActualNodePath);
    }

    private NodeRule findRuleFromArrayInternal(ArrayList<NodeRule> rulesArray, String strNodePath, String strResourceType, String strActualNodePath) {
        NodeRule retRule = null;
        for (NodeRule rule : rulesArray) {
            boolean bFound = false;
            if (!StringUtils.isEmpty((CharSequence)rule.getStrNodePath())) {
                if (rule.getStrNodePath().equals(strNodePath) && rule.getStrResourceType().equals(strResourceType)) {
                    bFound = StringUtils.isEmpty((CharSequence)rule.getStrNodePathContains()) || strActualNodePath.contains(rule.getStrNodePathContains());
                }
            } else if (!StringUtils.isEmpty((CharSequence)rule.getStrNodePathContains()) && strActualNodePath.contains(rule.getStrNodePathContains())) {
                bFound = true;
            }
            if (!bFound) continue;
            retRule = rule;
            break;
        }
        return retRule;
    }

    private void processAssetNode(Node currentNode) {
        if (currentNode != null) {
            String strResourceType = this.getNodeResourceType(currentNode);
            String strFileReference = this.getElementAttribute((Element)currentNode, ASSET_REFERENCE_ATTRIBUTE, "");
            if (!StringUtils.isEmpty((CharSequence)strResourceType)) {
                this.addAssetNodeDetails(strResourceType, strFileReference);
            }
        }
    }

    private void addAssetNodeDetails(String strResourceType, String strFileReference) {
        if (!this.assetNodeHash.containsKey(strResourceType)) {
            this.assetNodeHash.put(strResourceType, new ArrayList());
        }
        this.assetNodeHash.get(strResourceType).add(new AssetNodeRule(strResourceType, strFileReference));
    }

    private String getElementAttribute(Element element, String strAttributeName, String strDefaultValue) {
        return element.hasAttribute(strAttributeName) ? element.getAttribute(strAttributeName) : strDefaultValue;
    }

    private boolean getElementAttribute(Element element, String strAttributeName, boolean bDefault) {
        String strAttributeValue = this.getElementAttribute(element, strAttributeName, null);
        boolean bRetVal = bDefault;
        if (strAttributeValue != null) {
            if (strAttributeValue.equalsIgnoreCase(TRUE)) {
                bRetVal = true;
            } else if (strAttributeValue.equalsIgnoreCase(FALSE)) {
                bRetVal = false;
            }
        }
        return bRetVal;
    }

    private String getNodeResourceType(Node node) {
        return this.getElementAttribute((Element)node, RESOURCE_TYPE, "");
    }

    private NodeRule processNode(Node currentNode, NodeRule parentRule) {
        if (currentNode != null) {
            String strNodePath = this.getNodePath(currentNode);
            if (StringUtils.isEmpty((CharSequence)strNodePath) && parentRule != null) {
                strNodePath = parentRule.getStrNodePath();
            }
            String strNodePathContains = this.getNodePathContains(currentNode);
            String strResourceType = this.getNodeResourceType(currentNode);
            NodeRule nodeRule = this.createNodeRuleIfRequired(strNodePath, strResourceType, strNodePathContains);
            nodeRule.copyRules(parentRule);
            NodeList nodeList = currentNode.getChildNodes();
            ArrayList<NodeRule> childrenNodeRules = new ArrayList<NodeRule>();
            for (int index = 0; index < nodeList.getLength(); ++index) {
                Node childNode = nodeList.item(index);
                if (childNode.getNodeType() != 1) continue;
                String strChildNodeName = childNode.getNodeName();
                if (NODE.equals(strChildNodeName)) {
                    NodeRule childNodeRule = this.processNode(childNode, nodeRule);
                    childrenNodeRules.add(childNodeRule);
                    continue;
                }
                if (PROPERTY.equals(strChildNodeName)) {
                    this.processProperty(childNode, nodeRule);
                    continue;
                }
                if (!FILTER.equals(strChildNodeName)) continue;
                this.processFilter(childNode, nodeRule);
            }
            for (NodeRule childNodeRule : childrenNodeRules) {
                childNodeRule.copyRules(nodeRule);
            }
            return nodeRule;
        }
        return null;
    }

    private void processFilter(Node currentNode, NodeRule nodeRule) {
        if (currentNode != null) {
            NodeList nodeList = currentNode.getChildNodes();
            for (int index = 0; index < nodeList.getLength(); ++index) {
                String strChildNodeName;
                Node childNode = nodeList.item(index);
                if (childNode.getNodeType() != 1 || !NODE.equals(strChildNodeName = childNode.getNodeName())) continue;
                this.processFilterNode(childNode, nodeRule);
            }
        }
    }

    private void processFilterNode(Node currentNode, NodeRule currentNodeRule) {
        Element element = (Element)currentNode;
        String strPathContains = this.getElementAttribute(element, PATH_CONTAINS, "");
        String strContainsProperty = this.getElementAttribute(element, CONTAINS_PROPERTY, "");
        String strPropertyValue = this.getElementAttribute(element, PROPERTY_VALUE, "");
        boolean bIsDeep = this.getElementAttribute(element, IS_DEEP, true);
        currentNodeRule.addFilterNode(strPathContains, strContainsProperty, strPropertyValue, bIsDeep);
    }

    private void processProperty(Node currentNode, NodeRule currentNodeRule) {
        Element element = (Element)currentNode;
        String strPropertyName = this.getElementAttribute(element, NAME, "");
        if (strPropertyName != null && !strPropertyName.isEmpty()) {
            boolean bInherit = this.getElementAttribute(element, INHERIT, true);
            boolean bTranslate = this.getElementAttribute(element, TRANSLATE, true);
            boolean bPatchLanguage = this.getElementAttribute(element, UPDATE_DESTINATION_LANGUAGE, false);
            currentNodeRule.processProperty(strPropertyName, bInherit, bTranslate, bPatchLanguage);
        }
    }

    private String getNodePath(Node node) {
        return this.getElementAttribute((Element)node, PATH, "");
    }

    private String getNodePathContains(Node node) {
        return this.getElementAttribute((Element)node, PATH_CONTAINS, "");
    }

    private NodeRule createNodeRuleIfRequired(String strNodePath, String strResourceType, String strNodePathContains) {
        strNodePath = this.removeEndBackslash(strNodePath);
        strNodePath = strNodePath.toLowerCase();
        if (StringUtils.isEmpty((CharSequence)strResourceType)) {
            strResourceType = "";
        } else {
            strResourceType = this.removeEndBackslash(strResourceType);
            strResourceType = strResourceType.toLowerCase();
        }
        for (NodeRule rule : this.rulesCompleteArray) {
            if (!rule.getStrNodePath().equals(strNodePath) || !rule.getStrResourceType().equals(strResourceType) || !rule.getStrNodePathContains().equals(strNodePathContains)) continue;
            return rule;
        }
        NodeRule nodeRule = new NodeRule(strNodePath, strResourceType, strNodePathContains);
        this.rulesCompleteArray.add(nodeRule);
        if (!StringUtils.isEmpty((CharSequence)strNodePathContains)) {
            this.rulesWithContainsArray.add(nodeRule);
        }
        return nodeRule;
    }

    private String removeEndBackslash(String strNodePath) {
        if (strNodePath.endsWith("/")) {
            strNodePath = strNodePath.substring(0, strNodePath.length() - 1);
        }
        return strNodePath;
    }
}

