/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.related;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.util.DamUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.resource.collection.ResourceCollection;

public final class RelatedDamAssetUtils {
    public static List<Asset> getContentFragmentAssociatedAssets(Node currentNode, ResourceResolver resourceResolver) throws RepositoryException {
        ResourceCollection associatedContent;
        Resource associatedContentResource = RelatedDamAssetUtils.getAssociatedContentResource(currentNode.getPath(), resourceResolver);
        if (associatedContentResource != null && (associatedContent = (ResourceCollection)associatedContentResource.adaptTo(ResourceCollection.class)) != null) {
            return RelatedDamAssetUtils.getAssetsFromAssociatedContentNode(associatedContent);
        }
        return Collections.emptyList();
    }

    private static Resource getAssociatedContentResource(String cfPath, ResourceResolver resourceResolver) {
        Resource resource = resourceResolver.getResource(cfPath + "/jcr:content/associated");
        if (null == resource) {
            resource = resourceResolver.getResource(cfPath + "/associated");
        }
        return resource;
    }

    private static ArrayList<Asset> getAssetsFromAssociatedContentNode(ResourceCollection resourceCollection) throws RepositoryException {
        ArrayList<Asset> assetList = new ArrayList<Asset>();
        Iterator resourceIterator = resourceCollection.getResources();
        while (resourceIterator.hasNext()) {
            Resource collectionResource = (Resource)resourceIterator.next();
            RelatedDamAssetUtils.addAssetsFromCollectionResource(collectionResource, assetList);
        }
        return assetList;
    }

    private static ArrayList<Asset> addAssetsFromCollectionResource(Resource collectionResource, ArrayList<Asset> assetList) throws RepositoryException {
        ResourceCollection resourceCollection;
        if (null != collectionResource && null != (resourceCollection = (ResourceCollection)collectionResource.adaptTo(ResourceCollection.class))) {
            RelatedDamAssetUtils.addAssetsFromCollection(resourceCollection, assetList);
            RelatedDamAssetUtils.addAssetsFromNestedCollections(collectionResource, assetList);
        }
        return assetList;
    }

    private static void addAssetsFromCollection(ResourceCollection resourceCollection, ArrayList<Asset> assetList) throws RepositoryException {
        Iterator resourceIterator = resourceCollection.getResources();
        while (resourceIterator.hasNext()) {
            Resource resource = (Resource)resourceIterator.next();
            Asset asset = (Asset)resource.adaptTo(Asset.class);
            if (asset != null && !RelatedDamAssetUtils.isContentFragment(asset)) {
                assetList.add(asset);
                continue;
            }
            if (!RelatedDamAssetUtils.isFolder(resource)) continue;
            Iterator assetIterator = DamUtil.getAssets((Resource)resource);
            while (assetIterator.hasNext()) {
                Asset folderAsset = (Asset)assetIterator.next();
                if (RelatedDamAssetUtils.isContentFragment(folderAsset)) continue;
                assetList.add(folderAsset);
            }
        }
    }

    private static boolean isFolder(Resource resource) {
        Node n = (Node)resource.adaptTo(Node.class);
        try {
            return n != null && n.isNodeType("nt:folder");
        }
        catch (RepositoryException var3) {
            return false;
        }
    }

    private static boolean isContentFragment(Asset asset) throws RepositoryException {
        Node assetNode = (Node)asset.adaptTo(Node.class);
        Node jcrNode = assetNode == null ? null : assetNode.getNode("jcr:content");
        return jcrNode != null && jcrNode.hasProperty("contentFragment") && jcrNode.getProperty("contentFragment").getBoolean();
    }

    private static void addAssetsFromNestedCollections(Resource collectionResource, ArrayList<Asset> collectionAssets) throws RepositoryException {
        HashSet<Resource> nestedCollections = new HashSet<Resource>();
        RelatedDamAssetUtils.getNestedCollections(collectionResource, nestedCollections);
        for (Resource resource : nestedCollections) {
            ResourceCollection rc = (ResourceCollection)resource.adaptTo(ResourceCollection.class);
            if (rc == null) continue;
            RelatedDamAssetUtils.addAssetsFromCollection(rc, collectionAssets);
        }
    }

    private static void getNestedCollections(Resource sourceCollectionResource, HashSet<Resource> updatedCollections) {
        ResourceCollection sourceCollection = (ResourceCollection)sourceCollectionResource.adaptTo(ResourceCollection.class);
        if (sourceCollection == null) {
            return;
        }
        Iterator sourceResources = sourceCollection.getResources();
        while (sourceResources.hasNext()) {
            Resource sourceResource = (Resource)sourceResources.next();
            if (!RelatedDamAssetUtils.isDamCollection(sourceResource) || updatedCollections.contains(sourceResource)) continue;
            updatedCollections.add(sourceResource);
            RelatedDamAssetUtils.getNestedCollections(sourceResource, updatedCollections);
        }
    }

    private static boolean isDamCollection(Resource sourceResource) {
        return sourceResource.isResourceType("dam/collection");
    }
}

