/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.related;

import com.adobe.granite.translation.core.MachineTranslationCloudConfig;
import com.adobe.granite.translation.core.MachineTranslationUtil;
import com.smartling.aem.connector.automation.impl.related.RelatedAssetUtils;
import com.smartling.aem.connector.automation.impl.related.RelatedAssetsException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class RelatedAssetsConfiguration {
    private MachineTranslationCloudConfig rootResourceMachineCloudConfig;

    private RelatedAssetsConfiguration(MachineTranslationCloudConfig rootResourceMachineCloudConfig) {
        this.rootResourceMachineCloudConfig = rootResourceMachineCloudConfig;
    }

    public static RelatedAssetsConfiguration create(String pagePath, ResourceResolver resourceResolver, MachineTranslationUtil machineTranslationUtil) throws RelatedAssetsException {
        Resource pageResource;
        MachineTranslationUtil mtu = machineTranslationUtil != null ? machineTranslationUtil : (MachineTranslationUtil)resourceResolver.adaptTo(MachineTranslationUtil.class);
        MachineTranslationCloudConfig rootResourceMachineCloudConfig = RelatedAssetUtils.getMachineCloudConfigFromResource(mtu, pageResource = resourceResolver.getResource(pagePath));
        if (rootResourceMachineCloudConfig == null) {
            throw new RelatedAssetsException(String.format("Couldn't find cloud translation configuration for path=\"%s\"", pagePath));
        }
        return new RelatedAssetsConfiguration(rootResourceMachineCloudConfig);
    }

    public boolean checkAssets() {
        return RelatedAssetUtils.isAddAssetAllowedByCloudConfig(this.rootResourceMachineCloudConfig);
    }

    public boolean checkForEmbeddedAssets() {
        return RelatedAssetUtils.isAddEmbeddedAssetsAllowedByConfig(this.rootResourceMachineCloudConfig);
    }

    public boolean isTranslateAssociatedContentForAssets() {
        return this.rootResourceMachineCloudConfig.isTranslateAssociatedContentForAssets();
    }

    public boolean isTranslateInlineMediaAssets() {
        return this.rootResourceMachineCloudConfig.isTranslateInlineMediaAssets();
    }
}

