/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.property.mapping.service;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.smartling.aem.connector.automation.impl.property.mapping.PropertyMappingException;
import com.smartling.aem.connector.automation.impl.property.mapping.PropertyMappingNotFoundException;
import com.smartling.aem.connector.automation.impl.property.mapping.PropertyMappingService;
import com.smartling.aem.connector.automation.impl.property.mapping.data.PropertyMappingComponent;
import com.smartling.aem.connector.automation.impl.property.mapping.data.PropertyMappingContext;
import com.smartling.aem.connector.automation.impl.property.mapping.data.PropertyMappingData;
import com.smartling.aem.connector.automation.impl.property.mapping.data.PropertyMappingRepository;
import com.smartling.aem.connector.automation.impl.property.mapping.data.PropertyMappingRule;
import com.smartling.aem.connector.automation.impl.property.mapping.rules.TranslationRuleContext;
import com.smartling.aem.connector.automation.impl.property.mapping.rules.TranslationRulesRepository;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;

@Component
@Service
public class SmartlingPropertyMappingService
implements PropertyMappingService {
    private static final String PROPERTY_MAPPING_CACHE_KEY = PropertyMappingData.class.getName();
    private Cache<String, PropertyMappingData> propertyMappingCachedData = Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).build();
    public static final int MAX_INHERITANCE_LEVEL = 5;
    private static final String HTML_TAG_REGEX = "</[a-z][a-z0-9]*>|<(?:br|img)(?:\\s+[^>]*)?\\/?>|<(?:br|img)\\s*>";
    private static final Pattern HTML_TAG_PATTERN = Pattern.compile("</[a-z][a-z0-9]*>|<(?:br|img)(?:\\s+[^>]*)?\\/?>|<(?:br|img)\\s*>", 2);
    private static final String[] ENCODED_HTML_CHARS = new String[]{"&amp;", "&quot;"};
    @Reference
    private PropertyMappingRepository repository;
    @Reference
    private TranslationRulesRepository translationRulesRepository;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;

    @Override
    public void updateContext(PropertyMappingContext mappingContext) throws PropertyMappingException {
        PropertyMappingData data = this.repository.readMappings().orElse(new PropertyMappingData());
        data.getContexts().removeIf(ctx -> StringUtils.equalsIgnoreCase((CharSequence)mappingContext.getPath(), (CharSequence)ctx.getPath()));
        data.getContexts().add(mappingContext);
        this.repository.updateMappings(data);
    }

    @Override
    public Optional<PropertyMappingContext> getContext(String contextName) throws PropertyMappingException {
        Optional<PropertyMappingData> data = this.getCachedData();
        return data.flatMap(propertyMappingData -> propertyMappingData.getContexts().stream().filter(ctx -> StringUtils.equalsIgnoreCase((CharSequence)contextName, (CharSequence)ctx.getPath())).findFirst());
    }

    @Override
    public Optional<PropertyMappingContext> getContextRulesRespectInheritance(String contextName) throws PropertyMappingException {
        String contextPath;
        Optional<PropertyMappingData> data = this.getCachedData();
        Optional contextOpt = data.flatMap(propertyMappingData -> propertyMappingData.getContexts().stream().filter(ctx -> StringUtils.equalsIgnoreCase((CharSequence)contextName, (CharSequence)ctx.getPath())).findFirst());
        PropertyMappingContext context = contextOpt.orElseGet(PropertyMappingContext::new);
        TranslationRuleContext parentContext = null;
        int count = 5;
        while ((parentContext = this.translationRulesRepository.getParentContext(contextPath = parentContext == null ? contextName : parentContext.getPath())) != null) {
            String parentContextPath = parentContext.getPath();
            Optional parentContextOpt = data.flatMap(propertyMappingData -> propertyMappingData.getContexts().stream().filter(ctx -> StringUtils.equalsIgnoreCase((CharSequence)parentContextPath, (CharSequence)ctx.getPath())).findFirst());
            if (parentContextOpt.isPresent()) {
                for (PropertyMappingComponent parentComponent : ((PropertyMappingContext)parentContextOpt.get()).getComponents()) {
                    Optional<PropertyMappingComponent> componentOpt = context.getComponents().stream().filter(c -> StringUtils.equalsIgnoreCase((CharSequence)c.getType(), (CharSequence)parentComponent.getType())).findFirst();
                    List<PropertyMappingRule> inheritedRules = parentComponent.getMappings().stream().filter(PropertyMappingRule::isInherit).collect(Collectors.toList());
                    if (inheritedRules.isEmpty()) continue;
                    if (!componentOpt.isPresent()) {
                        parentComponent.setMappings(inheritedRules);
                        context.getComponents().add(parentComponent);
                        continue;
                    }
                    for (PropertyMappingRule parentRule : inheritedRules) {
                        if (!componentOpt.get().getMappings().stream().noneMatch(r -> StringUtils.equalsIgnoreCase((CharSequence)r.getPropertyName(), (CharSequence)parentRule.getPropertyName()))) continue;
                        componentOpt.get().getMappings().add(parentRule);
                    }
                }
            }
            if (--count > 0) continue;
        }
        return Optional.of(context);
    }

    @Override
    public PropertyMappingRule getRuleByProperty(String path, String propertyName, String content) throws PropertyMappingException {
        Optional<PropertyMappingRule> rule = this.getRuleByProperty(path, propertyName);
        if (rule.isPresent() && !StringUtils.equalsIgnoreCase((CharSequence)rule.get().getSmartlingParser(), (CharSequence)"auto")) {
            return rule.get();
        }
        if (StringUtils.isNotBlank((CharSequence)content) && !HTML_TAG_PATTERN.matcher(content).find() && Arrays.stream(ENCODED_HTML_CHARS).noneMatch(ch -> StringUtils.containsIgnoreCase((CharSequence)content, (CharSequence)ch))) {
            return new PropertyMappingRule(propertyName, "text", false);
        }
        return new PropertyMappingRule(propertyName, "html", false);
    }

    private Optional<PropertyMappingRule> getRuleByProperty(String path, String propertyName) throws PropertyMappingException {
        Optional<PropertyMappingData> data = this.getCachedData();
        if (!data.isPresent()) {
            return Optional.empty();
        }
        Optional<PropertyMappingContext> context = this.getContextByPath(data.get(), path);
        if (!context.isPresent()) {
            return Optional.empty();
        }
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(Collections.emptyMap());
            Optional<PropertyMappingRule> rule = Optional.empty();
            while (!rule.isPresent() && StringUtils.containsIgnoreCase((CharSequence)path, (CharSequence)"/content/")) {
                String componentType = this.getResourceType(resourceResolver, path);
                Optional<PropertyMappingComponent> component = this.getComponent(context.get(), componentType);
                rule = component.flatMap(cmp -> this.getRuleByPropertyName((PropertyMappingComponent)cmp, propertyName));
                if (!rule.isPresent()) {
                    rule = this.getInheritedRule(context.get(), componentType, propertyName);
                }
                path = StringUtils.substringBeforeLast((String)path, (String)"/");
            }
            Optional<PropertyMappingRule> optional = rule.isPresent() ? rule : this.getRuleFromGeneral(context.get(), propertyName);
            return optional;
        }
        catch (LoginException e) {
            throw new PropertyMappingException(String.format("Couldn't create resource resolver for node \"%s\"", path), (Exception)((Object)e));
        }
        finally {
            if (resourceResolver != null && resourceResolver.isLive()) {
                resourceResolver.close();
            }
        }
    }

    private Optional<PropertyMappingRule> getInheritedRule(PropertyMappingContext context, String componentType, String propertyName) throws PropertyMappingException {
        Optional<PropertyMappingRule> rule;
        int count = 5;
        do {
            if ((context = this.getParentContext(context.getPath())) == null) {
                return Optional.empty();
            }
            Optional<PropertyMappingComponent> component = this.getComponent(context, componentType);
            rule = component.flatMap(cmp -> this.getRuleByPropertyName((PropertyMappingComponent)cmp, propertyName));
            if (!rule.isPresent()) continue;
            return ((PropertyMappingRule)rule.get()).isInherit() ? rule : Optional.empty();
        } while (--count > 0);
        return rule;
    }

    private PropertyMappingContext getParentContext(String path) throws PropertyMappingException {
        TranslationRuleContext translationRuleContext = this.translationRulesRepository.getParentContext(path);
        if (translationRuleContext == null) {
            return null;
        }
        Optional<PropertyMappingData> data = this.getCachedData();
        return data.flatMap(propertyMappingData -> propertyMappingData.getContexts().stream().filter(context -> StringUtils.equalsIgnoreCase((CharSequence)translationRuleContext.getPath(), (CharSequence)context.getPath())).findFirst()).orElse(null);
    }

    private Optional<PropertyMappingRule> getRuleFromGeneral(PropertyMappingContext context, String propertyName) throws PropertyMappingNotFoundException {
        return context.getGeneralComponent().flatMap(cmp -> this.getRuleByPropertyName((PropertyMappingComponent)cmp, propertyName));
    }

    private Optional<PropertyMappingData> getCachedData() throws PropertyMappingException {
        PropertyMappingData data = this.getCachedDataPlain();
        if (data != null) {
            return Optional.of(data);
        }
        Optional<PropertyMappingData> actualData = this.repository.readMappings();
        actualData.ifPresent(propertyMappingData -> this.propertyMappingCachedData.put((Object)PROPERTY_MAPPING_CACHE_KEY, propertyMappingData));
        return actualData;
    }

    private PropertyMappingData getCachedDataPlain() {
        return (PropertyMappingData)this.propertyMappingCachedData.getIfPresent((Object)PROPERTY_MAPPING_CACHE_KEY);
    }

    private Optional<PropertyMappingRule> getRuleByPropertyName(PropertyMappingComponent component, String propertyName) {
        return component.getMappings().stream().filter(rule -> StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)rule.getPropertyName())).findFirst();
    }

    private Optional<PropertyMappingContext> getContextByPath(PropertyMappingData mappingData, String path) throws PropertyMappingNotFoundException {
        Stream mappingContextStream = mappingData.getContexts().stream();
        return mappingContextStream.filter(ctx -> StringUtils.containsIgnoreCase((CharSequence)path, (CharSequence)ctx.getPath())).max(Comparator.comparing(PropertyMappingContext::getPath));
    }

    private Optional<PropertyMappingComponent> getComponent(PropertyMappingContext context, String type) {
        Optional<PropertyMappingComponent> component = context.getComponents().stream().filter(comp -> StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)comp.getType())).findFirst();
        return component.isPresent() ? component : context.getGeneralComponent();
    }

    private String getResourceType(ResourceResolver resourceResolver, String path) {
        Resource nodeResource = resourceResolver.resolve(path);
        if (ResourceUtil.isNonExistingResource((Resource)nodeResource)) {
            return null;
        }
        return nodeResource.getResourceType();
    }

    private String getResourceSuperType(ResourceResolver resourceResolver, String path) {
        Resource nodeResource = resourceResolver.resolve(path);
        if (ResourceUtil.isNonExistingResource((Resource)nodeResource)) {
            return null;
        }
        return nodeResource.getResourceSuperType();
    }

    protected void bindRepository(PropertyMappingRepository propertyMappingRepository) {
        this.repository = propertyMappingRepository;
    }

    protected void unbindRepository(PropertyMappingRepository propertyMappingRepository) {
        if (this.repository == propertyMappingRepository) {
            this.repository = null;
        }
    }

    protected void bindTranslationRulesRepository(TranslationRulesRepository translationRulesRepository) {
        this.translationRulesRepository = translationRulesRepository;
    }

    protected void unbindTranslationRulesRepository(TranslationRulesRepository translationRulesRepository) {
        if (this.translationRulesRepository == translationRulesRepository) {
            this.translationRulesRepository = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

