/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.property.mapping.rules;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.smartling.aem.connector.automation.impl.property.mapping.rules.TranslationRuleContext;
import com.smartling.aem.connector.automation.impl.property.mapping.rules.TranslationRulesException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.jcr.api.SlingRepository;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Service(value={TranslationRulesRepository.class})
@Component
public class TranslationRulesRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(TranslationRulesRepository.class);
    public static final String TRANSLATION_RULES_FILE_PATH_LIBS = "/libs/settings/translation/rules/translation_rules.xml";
    public static final String TRANSLATION_RULES_FILE_PATH_APPS = "/apps/settings/translation/rules/translation_rules.xml";
    public static final String TRANSLATION_RULES_FILE_PATH_CONF = "/conf/global/settings/translation/rules/translation_rules.xml";
    public static final String[] TRANSLATION_RULES_FILE_PATHS = new String[]{"/conf/global/settings/translation/rules/translation_rules.xml", "/apps/settings/translation/rules/translation_rules.xml", "/libs/settings/translation/rules/translation_rules.xml"};
    private static final String TRANSLATION_RULES_CACHE_KEY = "TRANSLATION_RULES_CACHE_KEY";
    @Reference
    private SlingRepository repository;
    private Cache<String, List<TranslationRuleContext>> translationRulesCachedData = Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).build();

    public List<TranslationRuleContext> loadContexts() {
        List contexts = (List)this.translationRulesCachedData.getIfPresent((Object)TRANSLATION_RULES_CACHE_KEY);
        if (contexts != null) {
            return contexts;
        }
        try {
            contexts = this.sessionAction(this::loadContextFromRepository);
            this.translationRulesCachedData.put((Object)TRANSLATION_RULES_CACHE_KEY, (Object)contexts);
        }
        catch (TranslationRulesException e) {
            LOGGER.error("Couldn't take contexts from translation rules file");
        }
        return contexts;
    }

    public TranslationRuleContext getParentContext(String path) {
        List<TranslationRuleContext> contexts = this.loadContexts();
        if (CollectionUtils.isEmpty(contexts)) {
            return null;
        }
        Stack<TranslationRuleContext> stack = new Stack<TranslationRuleContext>();
        return this.getParentContext(path, contexts, stack);
    }

    private TranslationRuleContext getParentContext(String path, List<TranslationRuleContext> contexts, Stack<TranslationRuleContext> stack) {
        if (contexts == null) {
            return null;
        }
        for (TranslationRuleContext context : contexts) {
            if (StringUtils.equalsIgnoreCase((CharSequence)context.getPath(), (CharSequence)path)) {
                return stack.size() > 0 ? stack.pop() : null;
            }
            stack.push(context);
            TranslationRuleContext found = this.getParentContext(path, context.getSubContexts(), stack);
            if (found != null) {
                return found;
            }
            stack.pop();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private List<TranslationRuleContext> loadContextFromRepository(Session session) throws TranslationRulesException {
        try {
            javax.jcr.Node node = null;
            for (String path : TRANSLATION_RULES_FILE_PATHS) {
                if (!session.nodeExists(path)) continue;
                node = session.getNode(path);
                break;
            }
            if (node == null) {
                throw new TranslationRulesException("Couldn't find translation rules file.");
            }
            try (InputStream contentStream = JcrUtils.readFile(node);){
                List<TranslationRuleContext> list = this.parse(contentStream);
                return list;
            }
        }
        catch (PathNotFoundException e) {
            LOGGER.warn("Translation rules file is missed");
            return Collections.emptyList();
        }
        catch (RepositoryException e) {
            throw new TranslationRulesException("Couldn't read translation rules file", e);
        }
        catch (IOException e) {
            throw new TranslationRulesException("Couldn't read translation rules file stream", e);
        }
    }

    @NotNull
    private List<TranslationRuleContext> parse(InputStream contentStream) throws TranslationRulesException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(contentStream);
            Node rootNode = doc.getElementsByTagName("nodelist").item(0);
            if (rootNode == null) {
                throw new TranslationRulesException("Couldn't not find \"nodelist\" root element in translation rules file.");
            }
            return this.parseChildrenContexts(rootNode);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new TranslationRulesException("Couldn't parse translation rules file", e);
        }
    }

    @NotNull
    private List<TranslationRuleContext> parseChildrenContexts(Node node) {
        ArrayList<TranslationRuleContext> contexts = new ArrayList<TranslationRuleContext>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String path;
            Node attribute;
            NamedNodeMap attributes;
            Node childNode = nodeList.item(i);
            if (!StringUtils.equalsIgnoreCase((CharSequence)childNode.getNodeName(), (CharSequence)"node") || (attributes = childNode.getAttributes()) == null || (attribute = attributes.getNamedItem("path")) == null || StringUtils.isBlank((CharSequence)(path = attribute.getNodeValue())) || !StringUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)"/content")) continue;
            List<TranslationRuleContext> childrenContexts = this.parseChildrenContexts(childNode);
            TranslationRuleContext context = new TranslationRuleContext(path, childrenContexts);
            contexts.add(context);
        }
        return contexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T sessionAction(TranslationRulesReadFunction<Session, T> func) throws TranslationRulesException {
        try {
            Session session = this.repository.loginService(null, null);
            try {
                Session t = func.apply(session);
                return (T)t;
            }
            finally {
                session.logout();
            }
        }
        catch (RepositoryException e) {
            throw new TranslationRulesException("Couldn't get an access to JCR repository", e);
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    @FunctionalInterface
    public static interface TranslationRulesReadFunction<T, R> {
        public R apply(T var1) throws TranslationRulesException;
    }
}

