/*
 * Decompiled with CFR 0.152.
 */
package com.slimpay.hapiclient.hal;

import com.slimpay.hapiclient.exception.EmbeddedResourceNotUniqueException;
import com.slimpay.hapiclient.exception.EmbeddedResourceUniqueException;
import com.slimpay.hapiclient.exception.LinkNotUniqueException;
import com.slimpay.hapiclient.exception.LinkUniqueException;
import com.slimpay.hapiclient.exception.RelNotFoundException;
import com.slimpay.hapiclient.hal.CustomRel;
import com.slimpay.hapiclient.hal.Link;
import com.slimpay.hapiclient.hal.RegisteredRel;
import com.slimpay.hapiclient.hal.Rel;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Resource
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final JsonObject state;
    private final Map<Rel, Object> links;
    private final Map<Rel, Object> embeddedResources;

    private Resource(JsonObject state, Map<Rel, Object> links, Map<Rel, Object> embeddedResources) {
        this.state = state != null ? state : Json.createObjectBuilder().build();
        this.links = Collections.unmodifiableMap(links != null ? links : new HashMap());
        this.embeddedResources = Collections.unmodifiableMap(embeddedResources != null ? embeddedResources : new HashMap());
    }

    public JsonObject getState() {
        return this.state;
    }

    public Map<Rel, Object> getAllLinks() {
        return this.links;
    }

    public Map<Rel, Object> getAllEmbeddedResources() {
        return this.embeddedResources;
    }

    public Link getLink(Rel rel) {
        Object link = this.links.get(rel);
        if (link == null) {
            throw new RelNotFoundException(rel, this.links.keySet());
        }
        if (!(link instanceof Link)) {
            throw new LinkNotUniqueException();
        }
        return (Link)link;
    }

    public List<Link> getLinks(Rel rel) {
        Object links = this.links.get(rel);
        if (links == null) {
            throw new RelNotFoundException(rel, this.links.keySet());
        }
        if (links instanceof Link) {
            throw new LinkUniqueException();
        }
        return (List)links;
    }

    public Resource getEmbeddedResource(Rel rel) {
        Object resource = this.embeddedResources.get(rel);
        if (resource == null) {
            throw new RelNotFoundException(rel, this.embeddedResources.keySet());
        }
        if (!(resource instanceof Resource)) {
            throw new EmbeddedResourceNotUniqueException();
        }
        return (Resource)resource;
    }

    public List<Resource> getEmbeddedResources(Rel rel) {
        Object resources = this.embeddedResources.get(rel);
        if (resources == null) {
            throw new RelNotFoundException(rel, this.embeddedResources.keySet());
        }
        if (resources instanceof Resource) {
            throw new EmbeddedResourceUniqueException();
        }
        return (List)resources;
    }

    public static Resource fromJson(JsonObject json) {
        return new Builder().setState(Resource.extractState(json)).setLinks(Resource.extractLinks(json)).setEmbeddedResources(Resource.extractEmbeddedResources(json)).build();
    }

    public static Resource fromJson(String json) throws JsonException {
        if (json == null || json.trim().isEmpty()) {
            json = "{}";
        }
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(json));
        JsonObject jsonObject = jsonReader.readObject();
        jsonReader.close();
        return Resource.fromJson(jsonObject);
    }

    private static JsonObject extractState(JsonObject json) {
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        for (String key : json.keySet()) {
            if ("_links".equals(key) || "_embedded".equals(key)) continue;
            objectBuilder.add(key, (JsonValue)json.get((Object)key));
        }
        return objectBuilder.build();
    }

    private static Map<Rel, Object> extractLinks(JsonObject json) {
        HashMap<Rel, Object> links = new HashMap<Rel, Object>();
        if (!json.containsKey((Object)"_links")) {
            return links;
        }
        JsonObject _links = json.getJsonObject("_links");
        for (String name : _links.keySet()) {
            Rel rel = RegisteredRel.getByName(name);
            if (rel == null) {
                rel = new CustomRel(name);
            }
            try {
                JsonArray value = _links.getJsonArray(name);
                ArrayList<Link> arrayOfLinks = new ArrayList<Link>(value.size());
                int i = 0;
                int j = value.size();
                while (i < j) {
                    arrayOfLinks.add(Link.fromJson(value.getJsonObject(i)));
                    ++i;
                }
                links.put(rel, Collections.unmodifiableList(arrayOfLinks));
            }
            catch (ClassCastException ignored) {
                links.put(rel, Link.fromJson(_links.getJsonObject(name)));
            }
        }
        return links;
    }

    private static Map<Rel, Object> extractEmbeddedResources(JsonObject json) {
        HashMap<Rel, Object> embeddedResources = new HashMap<Rel, Object>();
        if (!json.containsKey((Object)"_embedded")) {
            return embeddedResources;
        }
        JsonObject _embedded = json.getJsonObject("_embedded");
        for (String name : _embedded.keySet()) {
            Rel rel = RegisteredRel.getByName(name);
            if (rel == null) {
                rel = new CustomRel(name);
            }
            try {
                JsonArray value = _embedded.getJsonArray(name);
                ArrayList<Resource> arrayOfEmbeddedResources = new ArrayList<Resource>(value.size());
                int i = 0;
                int j = value.size();
                while (i < j) {
                    arrayOfEmbeddedResources.add(Resource.fromJson(value.getJsonObject(i)));
                    ++i;
                }
                embeddedResources.put(rel, Collections.unmodifiableList(arrayOfEmbeddedResources));
            }
            catch (ClassCastException ignored) {
                embeddedResources.put(rel, Resource.fromJson(_embedded.getJsonObject(name)));
            }
        }
        return embeddedResources;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.embeddedResources == null ? 0 : this.embeddedResources.hashCode());
        result = 31 * result + (this.links == null ? 0 : this.links.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource)obj;
        return this.state.equals((Object)other.state) && this.links.equals(other.links) && this.embeddedResources.equals(other.embeddedResources);
    }

    public String toString() {
        return "Resource [" + "state=" + this.state + ", " + "links=" + this.links + ", " + "embeddedResources=" + this.embeddedResources + "]";
    }

    /* synthetic */ Resource(JsonObject jsonObject, Map map, Map map2, Resource resource) {
        this(jsonObject, map, map2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private JsonObject state;
        private Map<Rel, Object> links;
        private Map<Rel, Object> embeddedResources;

        public Builder setState(JsonObject state) {
            this.state = state;
            return this;
        }

        public Builder setLinks(Map<Rel, Object> links) {
            this.links = links;
            return this;
        }

        public Builder setEmbeddedResources(Map<Rel, Object> embeddedResources) {
            this.embeddedResources = embeddedResources;
            return this;
        }

        public Resource build() {
            return new Resource(this.state, this.links, this.embeddedResources, null);
        }
    }
}

