/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class TracerFormatter
extends Formatter {
    private static final String FORMAT = "yyyy-MM-dd HH:mm:ss.SSS z";
    private static final TimeZone TIMEZONE = TimeZone.getTimeZone("UTC");
    private final Date date = new Date();
    private final DateFormat formatter = TracerFormatter.makeDateFormat();
    private String envName;

    public TracerFormatter() {
    }

    public TracerFormatter(String envName) {
        this();
        this.envName = envName;
    }

    protected synchronized String getDate(long millis) {
        this.date.setTime(millis);
        return this.formatter.format(this.date);
    }

    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        String dateVal = this.getDate(record.getMillis());
        sb.append(dateVal);
        sb.append(" ");
        sb.append(record.getLevel().getLocalizedName());
        this.appendEnvironmentName(sb);
        sb.append(" ");
        sb.append(this.formatMessage(record));
        sb.append("\n");
        this.getThrown(record, sb);
        return sb.toString();
    }

    protected void appendEnvironmentName(StringBuilder sb) {
        if (this.envName != null) {
            sb.append(" [" + this.envName + "]");
        }
    }

    protected void getThrown(LogRecord record, StringBuilder sb) {
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static DateFormat makeDateFormat() {
        SimpleDateFormat df = new SimpleDateFormat(FORMAT);
        df.setTimeZone(TIMEZONE);
        return df;
    }
}

