/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongMinStat
extends LongStat {
    private static final long serialVersionUID = 1L;

    public LongMinStat(StatGroup group, StatDefinition definition) {
        super(group, definition);
        this.clear();
    }

    public LongMinStat(StatGroup group, StatDefinition definition, long counter) {
        super(group, definition);
        this.counter = counter;
    }

    @Override
    public void clear() {
        this.set(Long.MAX_VALUE);
    }

    public void setMin(long newValue) {
        this.counter = this.counter > newValue ? newValue : this.counter;
    }

    @Override
    public Stat<Long> computeInterval(Stat<Long> base) {
        return this.counter > base.get() ? base.copy() : this.copy();
    }

    @Override
    public void negate() {
    }

    @Override
    protected String getFormattedValue() {
        if (this.counter == Long.MAX_VALUE) {
            return "NONE";
        }
        return Stat.FORMAT.format(this.counter);
    }
}

