/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.node;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.MasterReplicaTransitionException;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.node.Feeder;
import com.sleepycat.je.rep.impl.node.FeederManagerStatDefinition;
import com.sleepycat.je.rep.impl.node.LocalCBVLSNTracker;
import com.sleepycat.je.rep.impl.node.LocalCBVLSNUpdater;
import com.sleepycat.je.rep.impl.node.MasterTransfer;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.stream.MasterStatus;
import com.sleepycat.je.rep.utilint.IntRunningTotalStat;
import com.sleepycat.je.rep.utilint.LongMaxZeroStat;
import com.sleepycat.je.rep.utilint.RepUtils;
import com.sleepycat.je.rep.utilint.SizeAwaitMap;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.StringStat;
import com.sleepycat.je.utilint.VLSN;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FeederManager {
    private final RepNode repNode;
    private final BlockingQueue<SocketChannel> channelQueue = new LinkedBlockingQueue<SocketChannel>();
    private final SizeAwaitMap<String, Feeder> activeFeeders;
    private final Set<Feeder> nascentFeeders = Collections.synchronizedSet(new HashSet());
    private int testDelayMs = 0;
    AtomicBoolean shutdown = new AtomicBoolean(false);
    private RuntimeException repNodeShutdownException;
    private final Logger logger;
    private final StatGroup stats;
    private final IntStat nFeedersCreated;
    private final IntStat nFeedersShutdown;
    private final LongMaxZeroStat nMaxReplicaLag;
    private final StringStat nMaxReplicaLagName;
    public static final int MASTER_CHANGE_CHECK_TIMEOUT = 1000;
    public static final String FEEDER_SERVICE = "Feeder";

    FeederManager(RepNode repNode) {
        this.repNode = repNode;
        Map underlyingMap = Collections.synchronizedMap(new HashMap());
        this.activeFeeders = new SizeAwaitMap(repNode.getRepImpl(), underlyingMap);
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.stats = new StatGroup("FeederManager", "A feeder is a replication stream connection between a master and replica nodes.");
        this.nFeedersCreated = new IntRunningTotalStat(this.stats, FeederManagerStatDefinition.N_FEEDERS_CREATED);
        this.nFeedersShutdown = new IntRunningTotalStat(this.stats, FeederManagerStatDefinition.N_FEEDERS_SHUTDOWN);
        this.nMaxReplicaLag = new LongMaxZeroStat(this.stats, FeederManagerStatDefinition.N_MAX_REPLICA_LAG);
        this.nMaxReplicaLagName = new StringStat(this.stats, FeederManagerStatDefinition.N_MAX_REPLICA_LAG_NAME);
    }

    public StatGroup getFeederManagerStats(StatsConfig config) {
        StatGroup cloneStats = this.stats.cloneGroup(config.getClear());
        return cloneStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatGroup getProtocolStats(StatsConfig config) {
        StatGroup protocolStats = new StatGroup("BinaryProtocol", "Network traffic due to the replication stream.");
        SizeAwaitMap<String, Feeder> sizeAwaitMap = this.activeFeeders;
        synchronized (sizeAwaitMap) {
            for (Feeder feeder : this.activeFeeders.values()) {
                protocolStats.addAll(feeder.getProtocolStats(config));
            }
        }
        return protocolStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStats() {
        SizeAwaitMap<String, Feeder> sizeAwaitMap = this.activeFeeders;
        synchronized (sizeAwaitMap) {
            this.stats.clear();
            for (Feeder feeder : this.activeFeeders.values()) {
                feeder.resetStats();
            }
        }
    }

    void incStats(StatGroup feederStats) {
        this.stats.addAll(feederStats);
    }

    public int getTestDelayMs() {
        return this.testDelayMs;
    }

    public void setTestDelayMs(int testDelayMs) {
        this.testDelayMs = testDelayMs;
    }

    RepNode repNode() {
        return this.repNode;
    }

    public Feeder getFeeder(String nodeName) {
        return this.activeFeeders.get(nodeName);
    }

    public Feeder putFeeder(String nodeName, Feeder feeder) {
        return this.activeFeeders.put(nodeName, feeder);
    }

    public LongMaxZeroStat getnMaxReplicaLag() {
        return this.nMaxReplicaLag;
    }

    public StringStat getnMaxReplicaLagName() {
        return this.nMaxReplicaLagName;
    }

    void setRepNodeShutdownException(RuntimeException rNSE) {
        this.repNodeShutdownException = rNSE;
    }

    public int activeReplicaCount() {
        return this.activeFeeders.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> activeReplicas() {
        SizeAwaitMap<String, Feeder> sizeAwaitMap = this.activeFeeders;
        synchronized (sizeAwaitMap) {
            return new HashSet<String>(this.activeFeeders.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Feeder> activeReplicasMap() {
        SizeAwaitMap<String, Feeder> sizeAwaitMap = this.activeFeeders;
        synchronized (sizeAwaitMap) {
            return new HashMap<String, Feeder>(this.activeFeeders);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activateFeeder(Feeder feeder) {
        Set<Feeder> set = this.nascentFeeders;
        synchronized (set) {
            SizeAwaitMap<String, Feeder> sizeAwaitMap = this.activeFeeders;
            synchronized (sizeAwaitMap) {
                boolean removed = this.nascentFeeders.remove(feeder);
                if (feeder.isShutdown()) {
                    return;
                }
                assert (removed);
                String replicaName = feeder.getReplicaNameIdPair().getName();
                assert (!feeder.getReplicaNameIdPair().equals(NameIdPair.NULL));
                Feeder dup = this.activeFeeders.get(replicaName);
                if (dup != null && !dup.isShutdown()) {
                    throw EnvironmentFailureException.unexpectedState(this.repNode.getRepImpl(), feeder.getReplicaNameIdPair() + " is present in both nascent and " + "active feeder sets");
                }
                this.activeFeeders.put(replicaName, feeder);
                MasterTransfer xfr = this.repNode.getActiveTransfer();
                if (xfr != null) {
                    xfr.addFeeder(feeder);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFeeder(Feeder feeder) {
        assert (feeder.isShutdown());
        Set<Feeder> set = this.nascentFeeders;
        synchronized (set) {
            SizeAwaitMap<String, Feeder> sizeAwaitMap = this.activeFeeders;
            synchronized (sizeAwaitMap) {
                this.nascentFeeders.remove(feeder);
                String replicaName = feeder.getReplicaNameIdPair().getName();
                this.activeFeeders.remove(replicaName);
            }
        }
    }

    void shutdownQueue() {
        if (!this.repNode.isShutdown()) {
            throw EnvironmentFailureException.unexpectedState("Rep node is still active");
        }
        this.channelQueue.clear();
        this.channelQueue.add(RepUtils.CHANNEL_EOF_MARKER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void runFeeders() throws DatabaseException {
        Exception feederShutdownException;
        block18: {
            if (this.shutdown.get()) {
                throw EnvironmentFailureException.unexpectedState("Feeder manager was shutdown");
            }
            feederShutdownException = null;
            LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Feeder manager accepting requests.");
            LocalCBVLSNUpdater updater = new LocalCBVLSNUpdater(this.repNode.getNameIdPair(), this.repNode);
            LocalCBVLSNTracker tracker = this.repNode.getCBVLSNTracker();
            try {
                try {
                    this.repNode.getServiceDispatcher().register(FEEDER_SERVICE, this.channelQueue);
                    this.repNode.getReadyLatch().countDown();
                    while (true) {
                        SocketChannel feederReplicaChannel;
                        if ((feederReplicaChannel = this.channelQueue.poll(1000L, TimeUnit.MILLISECONDS)) == RepUtils.CHANNEL_EOF_MARKER) {
                            LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Feeder manager soft shutdown.");
                            Object var8_10 = null;
                            this.repNode.resetReadyLatch(feederShutdownException);
                            this.repNode.getServiceDispatcher().cancel(FEEDER_SERVICE);
                            this.shutdownFeeders(feederShutdownException);
                            break;
                        }
                        this.repNode.getMasterStatus().assertSync();
                        if (feederReplicaChannel == null) {
                            if (this.repNode.isShutdownOrInvalid()) {
                                LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Feeder manager forced shutdown.");
                                break block18;
                            } else {
                                updater.updateForMaster(tracker);
                                continue;
                            }
                        }
                        this.nFeedersCreated.increment();
                        try {
                            Feeder feeder = new Feeder(this, feederReplicaChannel);
                            this.nascentFeeders.add(feeder);
                            feeder.startFeederThreads();
                        }
                        catch (IOException e) {
                            LoggerUtils.fine(this.logger, this.repNode.getRepImpl(), "Feeder I/O exception: " + e.getMessage());
                            try {
                                feederReplicaChannel.close();
                            }
                            catch (IOException e1) {
                                LoggerUtils.fine(this.logger, this.repNode.getRepImpl(), "Exception during cleanup." + e.getMessage());
                            }
                        }
                    }
                }
                catch (MasterStatus.MasterSyncException e) {
                    LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Master change: " + e.getMessage());
                    feederShutdownException = new MasterReplicaTransitionException((EnvironmentImpl)this.repNode.getRepImpl(), e);
                    Object var8_12 = null;
                    this.repNode.resetReadyLatch(feederShutdownException);
                    this.repNode.getServiceDispatcher().cancel(FEEDER_SERVICE);
                    this.shutdownFeeders(feederShutdownException);
                    LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Feeder manager exited. CurrentTxnEnd VLSN: " + this.repNode.getCurrentTxnEndVLSN());
                    return;
                }
                catch (InterruptedException e) {
                    if (this.repNodeShutdownException != null) {
                        LoggerUtils.warning(this.logger, this.repNode.getRepImpl(), "Feeder manager unexpected interrupt");
                        throw this.repNodeShutdownException;
                    }
                    if (this.repNode.isShutdown()) {
                        LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Feeder manager interrupted for shutdown");
                        Object var8_13 = null;
                        this.repNode.resetReadyLatch(feederShutdownException);
                        this.repNode.getServiceDispatcher().cancel(FEEDER_SERVICE);
                        this.shutdownFeeders(feederShutdownException);
                        LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Feeder manager exited. CurrentTxnEnd VLSN: " + this.repNode.getCurrentTxnEndVLSN());
                        return;
                    }
                    feederShutdownException = e;
                    LoggerUtils.warning(this.logger, this.repNode.getRepImpl(), "Feeder manager unexpected interrupt");
                    Object var8_14 = null;
                    this.repNode.resetReadyLatch(feederShutdownException);
                    this.repNode.getServiceDispatcher().cancel(FEEDER_SERVICE);
                    this.shutdownFeeders(feederShutdownException);
                    LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Feeder manager exited. CurrentTxnEnd VLSN: " + this.repNode.getCurrentTxnEndVLSN());
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var8_15 = null;
                this.repNode.resetReadyLatch(feederShutdownException);
                this.repNode.getServiceDispatcher().cancel(FEEDER_SERVICE);
                this.shutdownFeeders(feederShutdownException);
                LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Feeder manager exited. CurrentTxnEnd VLSN: " + this.repNode.getCurrentTxnEndVLSN());
                throw throwable;
            }
            LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Feeder manager exited. CurrentTxnEnd VLSN: " + this.repNode.getCurrentTxnEndVLSN());
            return;
        }
        Object var8_11 = null;
        this.repNode.resetReadyLatch(feederShutdownException);
        this.repNode.getServiceDispatcher().cancel(FEEDER_SERVICE);
        this.shutdownFeeders(feederShutdownException);
        LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Feeder manager exited. CurrentTxnEnd VLSN: " + this.repNode.getCurrentTxnEndVLSN());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownFeeders(Exception feederShutdownException) {
        boolean changed = this.shutdown.compareAndSet(false, true);
        if (!changed) {
            return;
        }
        try {
            HashSet<Feeder> feederSet = null;
            Object object = this.activeFeeders;
            synchronized (object) {
                feederSet = new HashSet<Feeder>(this.activeFeeders.values());
            }
            object = this.nascentFeeders;
            synchronized (object) {
                feederSet.addAll(this.nascentFeeders);
            }
            for (Feeder feeder : feederSet) {
                this.nFeedersShutdown.increment();
                feeder.shutdown(feederShutdownException);
            }
            Object var8_8 = null;
            if (feederShutdownException == null) {
                feederShutdownException = new IllegalStateException("FeederManager shutdown");
            }
            this.activeFeeders.clear(feederShutdownException);
            this.nascentFeeders.clear();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (feederShutdownException == null) {
                feederShutdownException = new IllegalStateException("FeederManager shutdown");
            }
            this.activeFeeders.clear(feederShutdownException);
            this.nascentFeeders.clear();
            throw throwable;
        }
    }

    public void shutdownFeeder(RepNodeImpl node) {
        Feeder feeder = this.activeFeeders.get(node.getName());
        if (feeder == null) {
            return;
        }
        this.nFeedersShutdown.increment();
        feeder.shutdown(null);
    }

    public boolean awaitFeederReplicaConnections(int requiredReplicaCount, long insufficientReplicasTimeout) throws InterruptedException {
        return this.activeFeeders.sizeAwait(requiredReplicaCount, insufficientReplicasTimeout, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpState() {
        StringBuilder sb = new StringBuilder();
        SizeAwaitMap<String, Feeder> sizeAwaitMap = this.activeFeeders;
        synchronized (sizeAwaitMap) {
            Set<Map.Entry<String, Feeder>> feeds = this.activeFeeders.entrySet();
            if (feeds.size() == 0) {
                sb.append("No feeders.");
            } else {
                sb.append("Current feeds:");
                for (Map.Entry<String, Feeder> feedEntry : feeds) {
                    sb.append("\n ").append(feedEntry.getKey()).append(": ").append(feedEntry.getValue().dumpState());
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumCurrentAckFeeders(VLSN commitVLSN) {
        int count = 0;
        SizeAwaitMap<String, Feeder> sizeAwaitMap = this.activeFeeders;
        synchronized (sizeAwaitMap) {
            for (Feeder feeder : this.activeFeeders.values()) {
                if (commitVLSN.compareTo(feeder.getReplicaTxnEndVLSN()) > 0) continue;
                ++count;
            }
            return count;
        }
    }
}

