/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.BINDeltaLogEntry;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilizationFileReader
extends FileReader {
    private static final boolean DEBUG = true;
    private final Map<Long, FileSummary> summaries = new HashMap<Long, FileSummary>();
    private final Map<DatabaseId, DatabaseImpl> dbCache = new HashMap<DatabaseId, DatabaseImpl>();
    private final DbTree dbTree;

    private UtilizationFileReader(EnvironmentImpl envImpl, int readBufferSize, long startLsn, long finishLsn) throws DatabaseException {
        super(envImpl, readBufferSize, true, startLsn, null, -1L, finishLsn);
        this.dbTree = envImpl.getDbTree();
    }

    @Override
    protected boolean isTargetEntry() {
        return this.currentEntryHeader.getType() != LogEntryType.LOG_FILE_HEADER.getTypeNum() && !this.currentEntryHeader.isInvisible();
    }

    @Override
    protected boolean processEntry(ByteBuffer entryBuffer) throws DatabaseException {
        LogEntryType lastEntryType = LogEntryType.findType(this.currentEntryHeader.getType());
        LogEntry entry = lastEntryType.getNewLogEntry();
        entry.readEntry(this.envImpl, this.currentEntryHeader, entryBuffer);
        ExtendedFileSummary summary = (ExtendedFileSummary)this.summaries.get(this.window.currentFileNum());
        if (summary == null) {
            summary = new ExtendedFileSummary();
            this.summaries.put(this.window.currentFileNum(), summary);
        }
        int size = this.getLastEntrySize();
        ++summary.totalCount;
        summary.totalSize += size;
        if (entry instanceof LNLogEntry) {
            LNLogEntry lnEntry = (LNLogEntry)entry;
            int otherSize = lnEntry.getLastLoggedSize();
            if (size != otherSize) {
                System.out.println("LogReader.getLastEntrySize=" + size + " LNEntry.getLastLoggedSize=" + otherSize + " " + lnEntry.getLogType());
            }
            DatabaseImpl dbImpl = this.getActiveDb(lnEntry.getDbId());
            boolean isActive = !lnEntry.isDeleted() && dbImpl != null && this.isLNActive(lnEntry, dbImpl);
            this.applyLN(summary, size, isActive);
        } else if (entry instanceof INLogEntry) {
            INLogEntry inEntry = (INLogEntry)entry;
            DatabaseImpl dbImpl = this.getActiveDb(inEntry.getDbId());
            boolean isActive = dbImpl != null && this.isINActive(inEntry, dbImpl);
            this.applyIN(summary, size, isActive);
        } else if (entry instanceof BINDeltaLogEntry) {
            ++summary.totalINCount;
            summary.totalINSize += size;
            ++summary.obsoleteINCount;
            summary.recalcObsoleteINSize += size;
        }
        return true;
    }

    private DatabaseImpl getActiveDb(DatabaseId dbId) {
        DatabaseImpl dbImpl = this.dbTree.getDb(dbId, -1L, this.dbCache);
        if (dbImpl == null) {
            return null;
        }
        if (dbImpl.isDeleteFinished()) {
            return null;
        }
        return dbImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLNActive(LNLogEntry<?> lnEntry, DatabaseImpl dbImpl) {
        boolean bl;
        block8: {
            long treeLsn;
            BIN bin;
            block6: {
                boolean bl2;
                block7: {
                    TreeLocation location;
                    block4: {
                        boolean bl3;
                        block5: {
                            lnEntry.postFetchInit(dbImpl);
                            byte[] key = lnEntry.getKey();
                            Tree tree = dbImpl.getTree();
                            location = new TreeLocation();
                            boolean parentFound = tree.getParentBINForChildLN(location, key, false, false, CacheMode.DEFAULT);
                            bin = location.bin;
                            try {
                                if (parentFound) break block4;
                                bl3 = false;
                                Object var15_10 = null;
                                if (bin == null) break block5;
                            }
                            catch (Throwable throwable) {
                                block9: {
                                    Object var15_13 = null;
                                    if (bin == null) break block9;
                                    bin.releaseLatch();
                                }
                                throw throwable;
                            }
                            bin.releaseLatch();
                        }
                        return bl3;
                    }
                    int index = location.index;
                    treeLsn = bin.getLsn(index);
                    if (treeLsn != -1L) break block6;
                    bl2 = false;
                    Object var15_11 = null;
                    if (bin == null) break block7;
                    bin.releaseLatch();
                }
                return bl2;
            }
            long logLsn = this.getLastLsn();
            bl = treeLsn == logLsn;
            Object var15_12 = null;
            if (bin == null) break block8;
            bin.releaseLatch();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isINActive(INLogEntry<?> inEntry, DatabaseImpl dbImpl) {
        long treeLsn;
        SearchResult result;
        long logLsn;
        block9: {
            IN logIn;
            block8: {
                block7: {
                    logLsn = this.getLastLsn();
                    logIn = inEntry.getIN(dbImpl);
                    logIn.setDatabase(dbImpl);
                    Tree tree = dbImpl.getTree();
                    if (logIn.isDbRoot()) {
                        return logLsn == tree.getRootLsn();
                    }
                    TreeLocation location = new TreeLocation();
                    logIn.latch(CacheMode.DEFAULT);
                    result = tree.getParentINForChildIN(logIn, true, CacheMode.DEFAULT, logIn.getLevel(), null);
                    if (!result.exactParentFound) {
                        return false;
                    }
                    try {
                        treeLsn = result.parent.getLsn(result.index);
                        if (treeLsn != -1L) break block7;
                        boolean bl = false;
                        Object var14_13 = null;
                        result.parent.releaseLatch();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        Object var14_17 = null;
                        result.parent.releaseLatch();
                        throw throwable;
                    }
                }
                if (treeLsn != logLsn) break block8;
                boolean bl = true;
                Object var14_14 = null;
                result.parent.releaseLatch();
                return bl;
            }
            if (logIn.isBIN()) break block9;
            boolean bl = false;
            Object var14_15 = null;
            result.parent.releaseLatch();
            return bl;
        }
        IN treeIn = (IN)result.parent.fetchTargetWithExclusiveLatch(result.index);
        treeLsn = treeIn.getLastFullVersion();
        boolean bl = treeLsn == logLsn;
        Object var14_16 = null;
        result.parent.releaseLatch();
        return bl;
    }

    private void applyLN(ExtendedFileSummary summary, int size, boolean isActive) {
        ++summary.totalLNCount;
        summary.totalLNSize += size;
        if (!isActive) {
            ++summary.obsoleteLNCount;
            summary.recalcObsoleteLNSize += size;
        }
    }

    private void applyIN(ExtendedFileSummary summary, int size, boolean isActive) {
        ++summary.totalINCount;
        summary.totalINSize += size;
        if (!isActive) {
            ++summary.obsoleteINCount;
            summary.recalcObsoleteINSize += size;
        }
    }

    private void cleanUp() {
        this.dbTree.releaseDbs(this.dbCache);
    }

    public static Map<Long, FileSummary> calcFileSummaryMap(EnvironmentImpl envImpl) {
        return UtilizationFileReader.calcFileSummaryMap(envImpl, -1L, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, FileSummary> calcFileSummaryMap(EnvironmentImpl envImpl, long startLsn, long finishLsn) {
        int readBufferSize = envImpl.getConfigManager().getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        UtilizationFileReader reader = new UtilizationFileReader(envImpl, readBufferSize, startLsn, finishLsn);
        try {
            while (reader.readNextEntry()) {
            }
            Map<Long, FileSummary> map = reader.summaries;
            Object var9_6 = null;
            reader.cleanUp();
            return map;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            reader.cleanUp();
            throw throwable;
        }
    }

    private static class NodeInfo {
        ExtendedFileSummary summary;
        int size;
        long dbId;

        private NodeInfo() {
        }
    }

    private static class ExtendedFileSummary
    extends FileSummary {
        private int recalcObsoleteINSize;
        private int recalcObsoleteLNSize;

        private ExtendedFileSummary() {
        }

        public int getObsoleteLNSize() {
            return this.recalcObsoleteLNSize;
        }

        public int getObsoleteINSize() {
            return this.recalcObsoleteINSize;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(super.toString());
            buf.append("<extended-info recalcObsoleteINSize=\"");
            buf.append(this.recalcObsoleteINSize);
            buf.append("\" recalcObsoleteLNSize=\"");
            buf.append(this.recalcObsoleteLNSize);
            buf.append("\"/>");
            return buf.toString();
        }
    }
}

