/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.evolve.Converter;
import com.sleepycat.persist.impl.Accessor;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.Reader;
import com.sleepycat.persist.impl.RefreshException;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.raw.RawObject;

public class ConverterReader
implements Reader {
    private static final long serialVersionUID = -305788321064984348L;
    private Converter converter;
    private transient Format oldFormat;

    ConverterReader(Converter converter) {
        this.converter = converter;
    }

    public void initializeReader(Catalog catalog, EntityModel model, int initVersion, Format oldFormat) {
        this.oldFormat = oldFormat;
    }

    public Object newInstance(EntityInput input, boolean rawAccess) throws RefreshException {
        return this.oldFormat.newInstance(input, true);
    }

    public void readPriKey(Object o, EntityInput input, boolean rawAccess) throws RefreshException {
        this.oldFormat.readPriKey(o, input, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readObject(Object o, EntityInput input, boolean rawAccess) throws RefreshException {
        Catalog catalog = input.getCatalog();
        boolean currentRawMode = input.setRawAccess(true);
        try {
            o = this.oldFormat.readObject(o, input, true);
            Object var7_6 = null;
            input.setRawAccess(currentRawMode);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            input.setRawAccess(currentRawMode);
            throw throwable;
        }
        o = this.converter.getConversion().convert(o);
        if (!rawAccess && o instanceof RawObject) {
            o = catalog.convertRawObject((RawObject)o, null);
        }
        return o;
    }

    public Accessor getAccessor(boolean rawAccess) {
        return this.oldFormat.getAccessor(rawAccess);
    }
}

