/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.monitor;

import com.sleepycat.je.rep.ReplicationGroup;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.monitor.GroupChangeEvent;
import com.sleepycat.je.rep.monitor.JoinGroupEvent;
import com.sleepycat.je.rep.monitor.LeaveGroupEvent;
import com.sleepycat.je.rep.monitor.Monitor;
import com.sleepycat.je.rep.monitor.Protocol;
import com.sleepycat.je.rep.utilint.ReplicationFormatter;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MonitorService
extends ServiceDispatcher.ExecutingService {
    private final Monitor monitor;
    private final Protocol protocol;
    private final Logger logger;
    private final Formatter formatter;
    public static final String SERVICE_NAME = "Monitor";

    public MonitorService(Monitor monitor, ServiceDispatcher dispatcher) {
        super(SERVICE_NAME, dispatcher);
        this.monitor = monitor;
        this.protocol = new Protocol(monitor.getGroupName(), monitor.getMonitorNameIdPair(), null);
        this.logger = LoggerUtils.getLoggerFormatterNeeded(this.getClass());
        this.formatter = new ReplicationFormatter(monitor.getMonitorNameIdPair());
    }

    public TextProtocol.ResponseMessage process(Protocol.GroupChange groupChange) {
        GroupChangeEvent event = new GroupChangeEvent(new ReplicationGroup(groupChange.getGroup()), groupChange.getNodeName(), groupChange.getOpType());
        this.monitor.notifyGroupChange(event);
        return null;
    }

    public TextProtocol.ResponseMessage process(Protocol.JoinGroup joinGroup) {
        this.monitor.notifyJoin(new JoinGroupEvent(joinGroup.getNodeName(), joinGroup.getMasterName(), joinGroup.getJoinTime()));
        return null;
    }

    public TextProtocol.ResponseMessage process(Protocol.LeaveGroup leaveGroup) {
        this.monitor.notifyLeave(new LeaveGroupEvent(leaveGroup.getNodeName(), leaveGroup.getMasterName(), leaveGroup.getLeaveReason(), leaveGroup.getJoinTime(), leaveGroup.getLeaveTime()));
        return null;
    }

    public Runnable getRunnable(SocketChannel socketChannel) {
        return new MonitorServiceRunnable(socketChannel, this.protocol);
    }

    class MonitorServiceRunnable
    extends ServiceDispatcher.ExecutingRunnable {
        MonitorServiceRunnable(SocketChannel socketChannel, Protocol protocol) {
            super(socketChannel, protocol, false);
        }

        protected TextProtocol.ResponseMessage getResponse(TextProtocol.RequestMessage request) throws IOException {
            return this.protocol.process(MonitorService.this, request);
        }

        protected void logMessage(String message) {
            LoggerUtils.logMsg(MonitorService.this.logger, MonitorService.this.formatter, Level.WARNING, message);
        }
    }
}

