/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DiskOrderedCursorConfig;
import com.sleepycat.je.DiskOrderedCursorProducerException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DupKeyData;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.LSNAccumulator;
import com.sleepycat.je.dbi.SortedLSNTreeWalker;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class DiskOrderedCursorImpl
implements EnvConfigObserver {
    private int queueSize = 1000;
    private int offerTimeout;
    private long maxSeedNanos = Long.MAX_VALUE;
    private final long maxSeedNodes;
    private TestHook maxSeedTestHook = null;
    private final KeyAndData END_OF_QUEUE = new KeyAndData();
    private final DiskOrderedScanProcessor callback;
    private final SortedLSNTreeWalker walker;
    private final BlockingQueue<KeyAndData> queue;
    private final Thread producer;
    private final DatabaseImpl dbImpl;
    private final boolean dups;
    private final boolean keysOnly;
    private final RuntimeException SHUTDOWN_REQUESTED_EXCEPTION = new RuntimeException("Producer Thread shutdown requested");
    private boolean closed = false;
    private KeyAndData currentNode = null;

    public DiskOrderedCursorImpl(final DatabaseImpl dbImpl, DiskOrderedCursorConfig config) throws DatabaseException {
        this.dbImpl = dbImpl;
        this.dups = dbImpl.getSortedDuplicates();
        DbConfigManager configMgr = dbImpl.getDbEnvironment().getConfigManager();
        this.offerTimeout = configMgr.getDuration(EnvironmentParams.DOS_PRODUCER_QUEUE_TIMEOUT);
        long configMSM = config.getMaxSeedMillisecs();
        if (configMSM != Long.MAX_VALUE) {
            this.maxSeedNanos = configMSM * 1000000L;
        }
        this.maxSeedNodes = config.getMaxSeedNodes();
        this.keysOnly = config.getKeysOnly();
        this.queueSize = config.getQueueSize();
        long rootLSN = dbImpl.getTree().getRootLsn();
        this.callback = this.makeDiskOrderedScanProcessor(this.keysOnly);
        this.walker = new DiskOrderedCursorTreeWalker(dbImpl, rootLSN, this.callback);
        this.walker.setLSNBatchSize(config.getLSNBatchSize());
        this.walker.setInternalMemoryLimit(config.getInternalMemoryLimit());
        this.walker.accumulateLNs = !this.keysOnly;
        this.maxSeedTestHook = config.getMaxSeedTestHook();
        this.queue = new ArrayBlockingQueue<KeyAndData>(this.queueSize);
        this.producer = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        dbImpl.getDbEnvironment().getCleaner().addProtectedFileRange(0L);
                        DiskOrderedCursorImpl.this.walker.walk();
                        DiskOrderedCursorImpl.this.callback.close();
                    }
                    catch (Throwable T) {
                        if (T == DiskOrderedCursorImpl.this.SHUTDOWN_REQUESTED_EXCEPTION) {
                            Object var3_2 = null;
                            dbImpl.getDbEnvironment().getCleaner().removeProtectedFileRange(0L);
                            return;
                        }
                        DiskOrderedCursorImpl.this.callback.setException(T);
                        DiskOrderedCursorImpl.this.queue.offer(DiskOrderedCursorImpl.this.END_OF_QUEUE);
                        Object var3_3 = null;
                        dbImpl.getDbEnvironment().getCleaner().removeProtectedFileRange(0L);
                    }
                    Object var3_1 = null;
                    dbImpl.getDbEnvironment().getCleaner().removeProtectedFileRange(0L);
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    dbImpl.getDbEnvironment().getCleaner().removeProtectedFileRange(0L);
                    throw throwable;
                }
            }
        };
        this.producer.setName("DiskOrderedScan Producer Thread for " + Thread.currentThread());
        this.producer.start();
    }

    private DiskOrderedScanProcessor makeDiskOrderedScanProcessor(boolean keysOnly) {
        if (keysOnly) {
            return new DiskOrderedScanProcessor(){

                public void processLSN(long childLsn, LogEntryType childType, Node node, byte[] ignore) {
                    if (childType != LogEntryType.LOG_BIN) {
                        return;
                    }
                    BIN bin = (BIN)node;
                    for (int i = 0; i < bin.getNEntries(); ++i) {
                        Node child;
                        if (bin.isEntryPendingDeleted(i) || bin.isEntryKnownDeleted(i) || (child = bin.getTarget(i)) != null && !child.isLN()) continue;
                        byte[] lnKey = bin.getKey(i);
                        try {
                            KeyAndData e = new KeyAndData(lnKey);
                            while (!DiskOrderedCursorImpl.this.queue.offer(e, DiskOrderedCursorImpl.this.offerTimeout, TimeUnit.MILLISECONDS)) {
                                this.checkShutdown();
                            }
                            continue;
                        }
                        catch (InterruptedException IE) {
                            this.setException(IE);
                        }
                    }
                }
            };
        }
        return new DiskOrderedScanProcessor();
    }

    public void envConfigUpdate(DbConfigManager cm, EnvironmentMutableConfig ignore) throws DatabaseException {
        this.offerTimeout = cm.getDuration(EnvironmentParams.DOS_PRODUCER_QUEUE_TIMEOUT);
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.callback.setShutdown();
        this.closed = true;
    }

    public void checkEnv() {
        this.dbImpl.getDbEnvironment().checkIfInvalid();
    }

    private OperationStatus setData(DatabaseEntry foundKey, DatabaseEntry foundData) {
        if (this.keysOnly) {
            if (foundKey == null) {
                return OperationStatus.KEYEMPTY;
            }
            byte[] keyBytes = this.currentNode.getKey();
            if (this.dups) {
                DupKeyData.split(keyBytes, keyBytes.length, foundKey, null);
            } else {
                LN.setEntry(foundKey, keyBytes);
            }
        } else {
            byte[] keyBytes = this.currentNode.getKey();
            if (this.dups) {
                DupKeyData.split(keyBytes, keyBytes.length, foundKey, foundData);
            } else {
                byte[] lnData;
                byte[] byArray = lnData = this.currentNode == null ? null : this.currentNode.getData();
                if (lnData == null) {
                    return OperationStatus.KEYEMPTY;
                }
                LN.setEntry(foundData, lnData);
                LN.setEntry(foundKey, keyBytes);
            }
        }
        return OperationStatus.SUCCESS;
    }

    public synchronized OperationStatus getCurrent(DatabaseEntry foundKey, DatabaseEntry foundData) {
        if (this.closed) {
            throw new IllegalStateException("ForwardCursor not initialized");
        }
        if (this.currentNode == this.END_OF_QUEUE) {
            return OperationStatus.KEYEMPTY;
        }
        return this.setData(foundKey, foundData);
    }

    public synchronized OperationStatus getNext(DatabaseEntry foundKey, DatabaseEntry foundData) {
        if (this.closed) {
            throw new IllegalStateException("ForwardCursor not initialized");
        }
        if (this.currentNode == this.END_OF_QUEUE) {
            return OperationStatus.NOTFOUND;
        }
        try {
            do {
                this.currentNode = this.queue.poll(1L, TimeUnit.SECONDS);
            } while (this.callback.getException() == null && this.currentNode == null);
        }
        catch (InterruptedException IE) {
            this.currentNode = this.END_OF_QUEUE;
        }
        if (this.callback.getException() != null) {
            throw new DiskOrderedCursorProducerException("Producer Thread Failure", this.callback.getException());
        }
        if (this.currentNode == this.END_OF_QUEUE) {
            return OperationStatus.NOTFOUND;
        }
        return this.setData(foundKey, foundData);
    }

    private class DiskOrderedScanProcessor
    implements SortedLSNTreeWalker.TreeNodeProcessor {
        private Throwable exception;
        private volatile boolean shutdownNow;

        private DiskOrderedScanProcessor() {
        }

        public void processLSN(long childLsn, LogEntryType childType, Node node, byte[] lnKey) {
            this.checkShutdown();
            if (!childType.isLNType()) {
                return;
            }
            LN ln = (LN)node;
            try {
                KeyAndData e = new KeyAndData(lnKey, ln);
                while (!DiskOrderedCursorImpl.this.queue.offer(e, DiskOrderedCursorImpl.this.offerTimeout, TimeUnit.MILLISECONDS)) {
                    this.checkShutdown();
                }
            }
            catch (InterruptedException IE) {
                this.setException(IE);
                this.setShutdown();
            }
        }

        public void processDirtyDeletedLN(long childLsn, LN ln, byte[] lnKey) {
            this.checkShutdown();
        }

        public void close() {
            try {
                if (!DiskOrderedCursorImpl.this.queue.offer(DiskOrderedCursorImpl.this.END_OF_QUEUE, DiskOrderedCursorImpl.this.offerTimeout, TimeUnit.MILLISECONDS)) {
                    this.setException(DiskOrderedCursorImpl.this.SHUTDOWN_REQUESTED_EXCEPTION.fillInStackTrace());
                    this.setShutdown();
                }
            }
            catch (InterruptedException IE) {
                this.setException(IE);
                this.setShutdown();
            }
        }

        protected void setException(Throwable t) {
            this.exception = t;
        }

        private Throwable getException() {
            return this.exception;
        }

        private void setShutdown() {
            this.shutdownNow = true;
        }

        protected void checkShutdown() {
            if (this.shutdownNow) {
                throw DiskOrderedCursorImpl.this.SHUTDOWN_REQUESTED_EXCEPTION;
            }
        }

        public void noteMemoryExceeded() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DiskOrderedCursorTreeWalker
    extends SortedLSNTreeWalker {
        private Set<IN> inList;
        private long seedStartTime;
        private final StopGatheringException STOP_GATHERING_EXCEPTION;

        DiskOrderedCursorTreeWalker(DatabaseImpl dbImpl, long rootLSN, DiskOrderedScanProcessor callback) {
            super(new DatabaseImpl[]{dbImpl}, false, new long[]{rootLSN}, callback, null, null);
            this.seedStartTime = Long.MAX_VALUE;
            this.STOP_GATHERING_EXCEPTION = new StopGatheringException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void walkInternal() throws DatabaseException {
            LSNAccumulator pendingLSNs = new LSNAccumulator(this);
            this.inList = this.gatherInMemoryINs();
            for (IN in : this.inList) {
                Object var5_4;
                try {
                    in.latchShared(CacheMode.UNCHANGED);
                    this.accumulateLSNs(in, pendingLSNs);
                    var5_4 = null;
                    in.releaseLatch();
                }
                catch (Throwable throwable) {
                    var5_4 = null;
                    in.releaseLatch();
                    throw throwable;
                }
            }
            this.processAccumulatedLSNs(pendingLSNs);
        }

        @Override
        protected void processResidentChild(long lsn, Node node, byte[] lnKey, LSNAccumulator pendingLSNs) {
            if (!(!this.inList.contains(node) || DiskOrderedCursorImpl.this.keysOnly && node instanceof BIN)) {
                return;
            }
            super.processResidentChild(lsn, node, lnKey, pendingLSNs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<IN> gatherInMemoryINs() {
            HashSet<IN> ret = new HashSet<IN>();
            IN root = this.getOrFetchRootIN(DiskOrderedCursorImpl.this.dbImpl, DiskOrderedCursorImpl.this.dbImpl.getTree().getRootLsn());
            if (root == null) {
                return ret;
            }
            try {
                this.seedStartTime = System.nanoTime();
                try {
                    this.gatherInMemoryINs1(root, ret);
                }
                catch (StopGatheringException stopGatheringException) {
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.releaseRootIN(root);
                throw throwable;
            }
            this.releaseRootIN(root);
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void gatherInMemoryINs1(IN in, Set<IN> ins) throws StopGatheringException {
            ins.add(in);
            long elapsedTime = System.nanoTime() - this.seedStartTime;
            assert (TestHookExecute.doHookIfSet(DiskOrderedCursorImpl.this.maxSeedTestHook, elapsedTime > 0L ? 1 : 0));
            if (elapsedTime > DiskOrderedCursorImpl.this.maxSeedNanos) {
                throw this.STOP_GATHERING_EXCEPTION;
            }
            if ((long)ins.size() > DiskOrderedCursorImpl.this.maxSeedNodes) {
                assert (TestHookExecute.doHookIfSet(DiskOrderedCursorImpl.this.maxSeedTestHook, ins.size()));
                throw this.STOP_GATHERING_EXCEPTION;
            }
            for (int i = 0; i < in.getNEntries(); ++i) {
                Object var9_7;
                Node node;
                if (in.isEntryPendingDeleted(i) || in.isEntryKnownDeleted(i) || (node = in.getTarget(i)) == null || !node.isIN()) continue;
                IN child = (IN)node;
                child.latchShared(CacheMode.UNCHANGED);
                try {
                    this.gatherInMemoryINs1(child, ins);
                    var9_7 = null;
                    child.releaseLatch();
                    continue;
                }
                catch (Throwable throwable) {
                    var9_7 = null;
                    child.releaseLatch();
                    throw throwable;
                }
            }
        }

        private class StopGatheringException
        extends Exception {
            private StopGatheringException() {
            }
        }
    }

    private class KeyAndData {
        final byte[] key;
        final byte[] data;

        private KeyAndData() {
            this.key = null;
            this.data = null;
        }

        private KeyAndData(byte[] key) {
            this.key = key;
            this.data = null;
        }

        private KeyAndData(byte[] key, LN ln) {
            this.key = key;
            this.data = ln == null ? null : ln.getData();
        }

        private byte[] getKey() {
            return this.key;
        }

        private byte[] getData() {
            return this.data;
        }
    }
}

