/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbType;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.incomp.INCompressor;
import com.sleepycat.je.log.DbOpReplicationContext;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.DbOperationType;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.NameLN;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.HandleLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.utilint.StringUtils;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbTree
implements Loggable {
    public static final DatabaseId ID_DB_ID = new DatabaseId(0L);
    public static final DatabaseId NAME_DB_ID = new DatabaseId(1L);
    private static final Map<String, DbType> INTERNAL_TYPES_BY_NAME;
    public static final long NEG_DB_ID_START = -256L;
    private final AtomicLong lastAllocatedLocalDbId;
    private final AtomicLong lastAllocatedReplicatedDbId;
    private final DatabaseImpl idDatabase;
    private final DatabaseImpl nameDatabase;
    private byte flags;
    private static final byte REPLICATED_BIT = 1;
    private static final byte REP_CONVERTED_BIT = 2;
    private static final byte DUPS_CONVERTED_BIT = 4;
    private static final byte PRESERVE_VLSN_BIT = 8;
    private static final long FAST_NAME_LOOKUP_MAX_LNS = 100L;
    private EnvironmentImpl envImpl;

    public static DbType typeForDbName(String dbName) {
        DbType t = INTERNAL_TYPES_BY_NAME.get(dbName);
        if (t != null) {
            return t;
        }
        return DbType.USER;
    }

    public DbTree() {
        this.envImpl = null;
        this.idDatabase = new DatabaseImpl();
        this.idDatabase.setDebugDatabaseName(DbType.ID.getInternalName());
        this.idDatabase.clearKeyPrefixing();
        this.nameDatabase = new DatabaseImpl();
        this.nameDatabase.clearKeyPrefixing();
        this.nameDatabase.setDebugDatabaseName(DbType.NAME.getInternalName());
        this.lastAllocatedLocalDbId = new AtomicLong();
        this.lastAllocatedReplicatedDbId = new AtomicLong();
    }

    public DbTree(EnvironmentImpl env, boolean replicationIntended, boolean preserveVLSN) throws DatabaseException {
        this.envImpl = env;
        this.lastAllocatedLocalDbId = new AtomicLong(1L);
        this.lastAllocatedReplicatedDbId = new AtomicLong(-256L);
        DatabaseConfig idConfig = new DatabaseConfig();
        DbInternal.setReplicated(idConfig, false);
        idConfig.setKeyPrefixing(false);
        this.idDatabase = new DatabaseImpl(null, DbType.ID.getInternalName(), new DatabaseId(0L), env, idConfig);
        this.idDatabase.clearKeyPrefixing();
        DatabaseConfig nameConfig = new DatabaseConfig();
        nameConfig.setKeyPrefixing(false);
        this.nameDatabase = new DatabaseImpl(null, DbType.NAME.getInternalName(), new DatabaseId(1L), env, nameConfig);
        this.nameDatabase.clearKeyPrefixing();
        if (replicationIntended) {
            this.setIsReplicated();
        }
        if (preserveVLSN) {
            this.setPreserveVLSN();
        }
        this.setDupsConverted();
    }

    public long getLastLocalDbId() {
        return this.lastAllocatedLocalDbId.get();
    }

    public long getLastReplicatedDbId() {
        return this.lastAllocatedReplicatedDbId.get();
    }

    private long getNextLocalDbId() {
        return this.lastAllocatedLocalDbId.incrementAndGet();
    }

    private long getNextReplicatedDbId() {
        return this.lastAllocatedReplicatedDbId.decrementAndGet();
    }

    public void setLastDbId(long lastReplicatedDbId, long lastLocalDbId) {
        this.lastAllocatedReplicatedDbId.set(lastReplicatedDbId);
        this.lastAllocatedLocalDbId.set(lastLocalDbId);
    }

    private boolean isReplicatedId(long id) {
        return id < -256L;
    }

    public void updateFromReplay(DatabaseId replayDbId) {
        assert (!this.envImpl.isMaster());
        long replayVal = replayDbId.getId();
        if (replayVal > 0L && !this.envImpl.isRepConverted()) {
            throw EnvironmentFailureException.unexpectedState("replay database id is unexpectedly positive " + replayDbId);
        }
        if (replayVal < this.lastAllocatedReplicatedDbId.get()) {
            this.lastAllocatedReplicatedDbId.set(replayVal);
        }
    }

    void initExistingEnvironment(EnvironmentImpl eImpl) throws DatabaseException {
        eImpl.checkRulesForExistingEnv(this.isReplicated(), this.getPreserveVLSN());
        this.envImpl = eImpl;
        this.idDatabase.setEnvironmentImpl(eImpl);
        this.nameDatabase.setEnvironmentImpl(eImpl);
    }

    public DatabaseImpl createDb(Locker locker, String databaseName, DatabaseConfig dbConfig, HandleLocker handleLocker) throws DatabaseException {
        return this.doCreateDb(locker, databaseName, dbConfig, handleLocker, null, null);
    }

    public DatabaseImpl createInternalDb(Locker locker, String databaseName, DatabaseConfig dbConfig) throws DatabaseException {
        dbConfig.setKeyPrefixing(false);
        DatabaseImpl ret = this.doCreateDb(locker, databaseName, dbConfig, null, null, null);
        ret.clearKeyPrefixing();
        return ret;
    }

    public DatabaseImpl createReplicaDb(Locker locker, String databaseName, DatabaseConfig dbConfig, NameLN replicatedLN, ReplicationContext repContext) throws DatabaseException {
        return this.doCreateDb(locker, databaseName, dbConfig, null, replicatedLN, repContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseImpl doCreateDb(Locker nameLocker, String databaseName, DatabaseConfig dbConfig, HandleLocker handleLocker, NameLN replicatedLN, ReplicationContext repContext) throws DatabaseException {
        DatabaseImpl newDb;
        block19: {
            Locker idDbLocker;
            boolean operationOk;
            CursorImpl nameCursor;
            long allocatedRepDbId;
            long allocatedLocalDbId;
            block18: {
                DatabaseId newId = null;
                allocatedLocalDbId = 0L;
                allocatedRepDbId = 0L;
                if (replicatedLN != null) {
                    newId = replicatedLN.getId();
                } else if (this.envImpl.isReplicated() && DbInternal.getReplicated(dbConfig)) {
                    newId = new DatabaseId(this.getNextReplicatedDbId());
                    allocatedRepDbId = newId.getId();
                } else {
                    newId = new DatabaseId(this.getNextLocalDbId());
                    allocatedLocalDbId = newId.getId();
                }
                newDb = null;
                CursorImpl idCursor = null;
                nameCursor = null;
                operationOk = false;
                idDbLocker = null;
                try {
                    newDb = new DatabaseImpl(nameLocker, databaseName, newId, this.envImpl, dbConfig);
                    ReplicationContext useRepContext = repContext;
                    if (repContext == null) {
                        useRepContext = newDb.getOperationRepContext(DbOperationType.CREATE);
                    }
                    this.checkReplicaWrite(nameLocker, useRepContext);
                    nameCursor = new CursorImpl(this.nameDatabase, nameLocker);
                    NameLN nameLN = null;
                    nameLN = replicatedLN != null ? replicatedLN : new NameLN(newId);
                    nameCursor.putLN(StringUtils.toUTF8(databaseName), nameLN, null, useRepContext);
                    if (handleLocker != null) {
                        this.acquireHandleLock(nameCursor, handleLocker);
                    }
                    idDbLocker = BasicLocker.createBasicLocker(this.envImpl);
                    idCursor = new CursorImpl(this.idDatabase, idDbLocker);
                    idCursor.putLN(newId.getBytes(), new MapLN(newDb), null, ReplicationContext.NO_REPLICATE);
                    newDb.incrementUseCount();
                    operationOk = true;
                    Object var20_17 = null;
                    if (idCursor == null) break block18;
                }
                catch (Throwable throwable) {
                    Object var20_18 = null;
                    if (idCursor != null) {
                        idCursor.close();
                    }
                    if (nameCursor != null) {
                        nameCursor.close();
                    }
                    if (idDbLocker != null) {
                        idDbLocker.operationEnd(operationOk);
                    }
                    if (!operationOk) {
                        if (allocatedRepDbId != 0L) {
                            this.lastAllocatedReplicatedDbId.compareAndSet(allocatedRepDbId, allocatedRepDbId + 1L);
                        }
                        if (allocatedLocalDbId != 0L) {
                            this.lastAllocatedLocalDbId.compareAndSet(allocatedLocalDbId, allocatedLocalDbId - 1L);
                        }
                    }
                    throw throwable;
                }
                idCursor.close();
            }
            if (nameCursor != null) {
                nameCursor.close();
            }
            if (idDbLocker != null) {
                idDbLocker.operationEnd(operationOk);
            }
            if (operationOk) break block19;
            if (allocatedRepDbId != 0L) {
                this.lastAllocatedReplicatedDbId.compareAndSet(allocatedRepDbId, allocatedRepDbId + 1L);
            }
            if (allocatedLocalDbId != 0L) {
                this.lastAllocatedLocalDbId.compareAndSet(allocatedLocalDbId, allocatedLocalDbId - 1L);
            }
        }
        return newDb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireHandleLock(CursorImpl nameCursor, HandleLocker handleLocker) {
        nameCursor.latchBIN();
        try {
            long lsn = nameCursor.getBIN().getLsn(nameCursor.getIndex());
            LockResult lockResult = handleLocker.nonBlockingLock(lsn, LockType.READ, true, this.nameDatabase);
            if (lockResult.getLockGrant() == LockGrantType.DENIED) {
                nameCursor.getLocker().checkPreempted(null);
                throw EnvironmentFailureException.unexpectedState("No contention is possible with HandleLocker: " + DbLsn.getNoFormatString(lsn));
            }
            Object var7_5 = null;
            nameCursor.releaseBIN();
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            nameCursor.releaseBIN();
            throw throwable;
        }
    }

    public void optionalModifyDbRoot(DatabaseImpl db) throws DatabaseException {
        if (db.isDeferredWriteMode()) {
            return;
        }
        this.modifyDbRoot(db);
    }

    public void modifyDbRoot(DatabaseImpl db) throws DatabaseException {
        this.modifyDbRoot(db, -1L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modifyDbRoot(DatabaseImpl db, long ifBeforeLsn, boolean mustExist) throws DatabaseException {
        if (db.getId().equals(ID_DB_ID) || db.getId().equals(NAME_DB_ID)) {
            this.envImpl.logMapTreeRoot();
            return;
        }
        DatabaseEntry keyDbt = new DatabaseEntry(db.getId().getBytes());
        while (true) {
            Object var13_10;
            BasicLocker idDbLocker = null;
            CursorImpl cursor = null;
            boolean operationOk = false;
            try {
                try {
                    boolean searchOk;
                    idDbLocker = BasicLocker.createBasicLocker(this.envImpl);
                    cursor = new CursorImpl(this.idDatabase, idDbLocker);
                    boolean bl = searchOk = (cursor.searchAndPosition(keyDbt, CursorImpl.SearchMode.SET, LockType.WRITE) & 1) != 0;
                    if (!searchOk) {
                        if (mustExist) {
                            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_INTEGRITY, "Can't find database ID: " + db.getId());
                        }
                        var13_10 = null;
                        if (cursor != null) {
                            cursor.releaseBIN();
                            cursor.close();
                        }
                        if (idDbLocker == null) return;
                        ((Locker)idDbLocker).operationEnd(operationOk);
                        return;
                    }
                    if (ifBeforeLsn == -1L || DbLsn.compareTo(cursor.getBIN().getLsn(cursor.getIndex()), ifBeforeLsn) < 0) {
                        MapLN mapLN = (MapLN)cursor.getCurrentLNAlreadyLatched(LockType.WRITE);
                        assert (mapLN != null);
                        RewriteMapLN writeMapLN = new RewriteMapLN(cursor);
                        mapLN.getDatabase().getTree().withRootLatchedExclusive(writeMapLN);
                        operationOk = true;
                    }
                    var13_10 = null;
                    if (cursor != null) {
                        cursor.releaseBIN();
                        cursor.close();
                    }
                    if (idDbLocker == null) return;
                    ((Locker)idDbLocker).operationEnd(operationOk);
                    return;
                }
                catch (LockConflictException e) {
                    var13_10 = null;
                    if (cursor != null) {
                        cursor.releaseBIN();
                        cursor.close();
                    }
                    if (idDbLocker == null) continue;
                    ((Locker)idDbLocker).operationEnd(operationOk);
                }
            }
            catch (Throwable throwable) {
                var13_10 = null;
                if (cursor != null) {
                    cursor.releaseBIN();
                    cursor.close();
                }
                if (idDbLocker == null) throw throwable;
                ((Locker)idDbLocker).operationEnd(operationOk);
                throw throwable;
            }
        }
    }

    private void checkReplicaWrite(Locker locker, ReplicationContext repContext) {
        if (repContext != null && repContext.mustGenerateVLSN()) {
            locker.disallowReplicaWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NameLockResult lockNameLN(Locker locker, String databaseName, String action, GetRepContext getRepContext) throws DatabaseNotFoundException {
        NameLockResult result;
        block11: {
            result = new NameLockResult();
            result.dbImpl = this.getDb(locker, databaseName, null);
            if (result.dbImpl == null) {
                throw new DatabaseNotFoundException("Attempted to " + action + " non-existent database " + databaseName);
            }
            result.repContext = getRepContext.get(result.dbImpl);
            this.checkReplicaWrite(locker, result.repContext);
            boolean success = false;
            try {
                boolean found;
                result.nameCursor = new CursorImpl(this.nameDatabase, locker);
                DatabaseEntry key = new DatabaseEntry(StringUtils.toUTF8(databaseName));
                boolean bl = found = (result.nameCursor.searchAndPosition(key, CursorImpl.SearchMode.SET, LockType.WRITE) & 1) != 0;
                if (!found) {
                    throw new DatabaseNotFoundException("Attempted to " + action + " non-existent database " + databaseName);
                }
                result.nameLN = (NameLN)result.nameCursor.getCurrentLNAlreadyLatched(LockType.WRITE);
                assert (result.nameLN != null);
                if (locker.getImportunate()) {
                    String msg = "Database " + databaseName + " has been forcibly closed in order to apply a" + " replicated " + action + " operation.  This Database" + " and all associated Cursors must be closed.  All" + " associated Transactions must be aborted.";
                    for (Database db : result.dbImpl.getReferringHandles()) {
                        DbInternal.setPreempted(db, databaseName, msg);
                    }
                } else {
                    int handleCount = result.dbImpl.getReferringHandleCount();
                    if (handleCount > 0) {
                        throw new IllegalStateException("Can't " + action + " database " + databaseName + ", " + handleCount + " open Database handles exist");
                    }
                }
                success = true;
                Object var13_13 = null;
                if (success) break block11;
                this.releaseDb(result.dbImpl);
                if (result.nameCursor == null) break block11;
                result.nameCursor.releaseBIN();
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                if (!success) {
                    this.releaseDb(result.dbImpl);
                    if (result.nameCursor != null) {
                        result.nameCursor.releaseBIN();
                        result.nameCursor.close();
                    }
                }
                throw throwable;
            }
            result.nameCursor.close();
            {
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNameLN(Locker locker, String dbName, final DbOpReplicationContext repContext) throws LockConflictException {
        assert (dbName != null);
        NameLockResult result = this.lockNameLN(locker, dbName, "updateConfig", new GetRepContext(){

            public ReplicationContext get(DatabaseImpl dbImpl) {
                return repContext != null ? repContext : dbImpl.getOperationRepContext(DbOperationType.UPDATE_CONFIG, null);
            }
        });
        CursorImpl nameCursor = result.nameCursor;
        DatabaseImpl dbImpl = result.dbImpl;
        ReplicationContext useRepContext = result.repContext;
        try {
            DatabaseEntry dataDbt = new DatabaseEntry(new byte[0]);
            nameCursor.putCurrent(null, dataDbt, null, null, null, useRepContext);
            Object var10_9 = null;
            this.releaseDb(dbImpl);
            nameCursor.releaseBIN();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.releaseDb(dbImpl);
            nameCursor.releaseBIN();
            nameCursor.close();
            throw throwable;
        }
        nameCursor.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseImpl doRenameDb(Locker locker, String databaseName, String newName, NameLN replicatedLN, final DbOpReplicationContext repContext) throws DatabaseNotFoundException {
        DatabaseImpl databaseImpl;
        NameLockResult result = this.lockNameLN(locker, databaseName, "rename", new GetRepContext(){

            public ReplicationContext get(DatabaseImpl dbImpl) {
                return repContext != null ? repContext : dbImpl.getOperationRepContext(DbOperationType.RENAME);
            }
        });
        CursorImpl nameCursor = result.nameCursor;
        DatabaseImpl dbImpl = result.dbImpl;
        ReplicationContext useRepContext = result.repContext;
        try {
            nameCursor.delete(ReplicationContext.NO_REPLICATE);
            NameLN useLN = replicatedLN != null ? replicatedLN : new NameLN(dbImpl.getId());
            nameCursor.reset();
            nameCursor.putLN(StringUtils.toUTF8(newName), useLN, null, useRepContext);
            dbImpl.setDebugDatabaseName(newName);
            databaseImpl = dbImpl;
            Object var13_12 = null;
            this.releaseDb(dbImpl);
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            this.releaseDb(dbImpl);
            nameCursor.close();
            throw throwable;
        }
        nameCursor.close();
        return databaseImpl;
    }

    public DatabaseImpl dbRename(Locker locker, String databaseName, String newName) throws DatabaseNotFoundException {
        return this.doRenameDb(locker, databaseName, newName, null, null);
    }

    public DatabaseImpl renameReplicaDb(Locker locker, String databaseName, String newName, NameLN replicatedLN, DbOpReplicationContext repContext) throws DatabaseNotFoundException {
        return this.doRenameDb(locker, databaseName, newName, replicatedLN, repContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseImpl doRemoveDb(Locker locker, String databaseName, DatabaseId checkId, final DbOpReplicationContext repContext) throws DatabaseNotFoundException {
        DatabaseImpl databaseImpl;
        block3: {
            CursorImpl nameCursor = null;
            NameLockResult result = this.lockNameLN(locker, databaseName, "remove", new GetRepContext(){

                public ReplicationContext get(DatabaseImpl dbImpl) {
                    return repContext != null ? repContext : dbImpl.getOperationRepContext(DbOperationType.REMOVE);
                }
            });
            ReplicationContext useRepContext = result.repContext;
            try {
                nameCursor = result.nameCursor;
                if (checkId != null && !checkId.equals(result.nameLN.getId())) {
                    throw new DatabaseNotFoundException("ID mismatch: " + databaseName);
                }
                nameCursor.delete(useRepContext);
                locker.markDeleteAtTxnEnd(result.dbImpl, true);
                databaseImpl = result.dbImpl;
                Object var10_9 = null;
                if (nameCursor == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var10_10 = null;
                    if (nameCursor == null) break block4;
                    nameCursor.close();
                }
                throw throwable;
            }
            nameCursor.close();
        }
        return databaseImpl;
    }

    public DatabaseImpl dbRemove(Locker locker, String databaseName, DatabaseId checkId) throws DatabaseNotFoundException {
        return this.doRemoveDb(locker, databaseName, checkId, null);
    }

    public void removeReplicaDb(Locker locker, String databaseName, DatabaseId checkId, DbOpReplicationContext repContext) throws DatabaseNotFoundException {
        this.doRemoveDb(locker, databaseName, checkId, repContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TruncateDbResult doTruncateDb(Locker locker, String databaseName, boolean returnCount, NameLN replicatedLN, final DbOpReplicationContext repContext) throws DatabaseNotFoundException {
        TruncateDbResult truncateDbResult;
        assert (replicatedLN == null || repContext != null);
        NameLockResult result = this.lockNameLN(locker, databaseName, "truncate", new GetRepContext(){

            public ReplicationContext get(DatabaseImpl dbImpl) {
                return repContext != null ? repContext : dbImpl.getOperationRepContext(DbOperationType.TRUNCATE, dbImpl.getId());
            }
        });
        CursorImpl nameCursor = result.nameCursor;
        ReplicationContext useRepContext = result.repContext;
        try {
            boolean operationOk;
            BasicLocker idDbLocker;
            DatabaseImpl newDb;
            DatabaseImpl oldDb;
            block8: {
                oldDb = result.dbImpl;
                DatabaseId newId = replicatedLN != null ? replicatedLN.getId() : new DatabaseId(this.isReplicatedId(oldDb.getId().getId()) ? this.getNextReplicatedDbId() : this.getNextLocalDbId());
                newDb = oldDb.cloneDatabase();
                newDb.incrementUseCount();
                newDb.setId(newId);
                newDb.setTree(new Tree(newDb));
                idDbLocker = null;
                CursorImpl idCursor = null;
                operationOk = false;
                try {
                    idDbLocker = BasicLocker.createBasicLocker(this.envImpl);
                    idCursor = new CursorImpl(this.idDatabase, idDbLocker);
                    idCursor.putLN(newId.getBytes(), new MapLN(newDb), null, ReplicationContext.NO_REPLICATE);
                    operationOk = true;
                    Object var16_15 = null;
                    if (idCursor == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var16_16 = null;
                    if (idCursor != null) {
                        idCursor.close();
                    }
                    if (idDbLocker != null) {
                        ((Locker)idDbLocker).operationEnd(operationOk);
                    }
                    throw throwable;
                }
                idCursor.close();
            }
            if (idDbLocker != null) {
                ((Locker)idDbLocker).operationEnd(operationOk);
            }
            result.nameLN.setId(newDb.getId());
            long recordCount = returnCount ? oldDb.count() : 0L;
            DatabaseEntry dataDbt = new DatabaseEntry(new byte[0]);
            nameCursor.putCurrent(null, dataDbt, null, null, null, useRepContext);
            locker.markDeleteAtTxnEnd(oldDb, true);
            locker.markDeleteAtTxnEnd(newDb, false);
            truncateDbResult = new TruncateDbResult(oldDb, newDb, recordCount);
            Object var20_21 = null;
            nameCursor.releaseBIN();
        }
        catch (Throwable throwable) {
            Object var20_22 = null;
            nameCursor.releaseBIN();
            nameCursor.close();
            throw throwable;
        }
        nameCursor.close();
        return truncateDbResult;
    }

    public TruncateDbResult truncate(Locker locker, String databaseName, boolean returnCount) throws DatabaseNotFoundException {
        return this.doTruncateDb(locker, databaseName, returnCount, null, null);
    }

    public TruncateDbResult truncateReplicaDb(Locker locker, String databaseName, boolean returnCount, NameLN replicatedLN, DbOpReplicationContext repContext) throws DatabaseNotFoundException {
        return this.doTruncateDb(locker, databaseName, returnCount, replicatedLN, repContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void deleteMapLN(DatabaseId id) throws DatabaseException {
        boolean done = false;
        while (true) {
            boolean operationOk;
            BasicLocker idDbLocker;
            block13: {
                Object var10_10;
                if (done) {
                    return;
                }
                idDbLocker = null;
                CursorImpl idCursor = null;
                operationOk = false;
                try {
                    try {
                        boolean found;
                        idDbLocker = BasicLocker.createBasicLocker(this.envImpl);
                        idCursor = new CursorImpl(this.idDatabase, idDbLocker);
                        boolean bl = found = (idCursor.searchAndPosition(new DatabaseEntry(id.getBytes()), CursorImpl.SearchMode.SET, LockType.WRITE) & 1) != 0;
                        if (found) {
                            MapLN mapLN = (MapLN)idCursor.getCurrentLNAlreadyLatched(LockType.WRITE);
                            assert (mapLN != null);
                            DatabaseImpl dbImpl = mapLN.getDatabase();
                            if (!dbImpl.isInUseDuringDbRemove()) {
                                idCursor.delete(ReplicationContext.NO_REPLICATE);
                                done = true;
                            }
                        } else {
                            done = true;
                        }
                        operationOk = true;
                    }
                    catch (LockConflictException e) {
                        var10_10 = null;
                        if (idCursor != null) {
                            idCursor.releaseBIN();
                            idCursor.close();
                        }
                        if (idDbLocker == null) continue;
                        ((Locker)idDbLocker).operationEnd(operationOk);
                        continue;
                    }
                    var10_10 = null;
                    if (idCursor == null) break block13;
                    idCursor.releaseBIN();
                }
                catch (Throwable throwable) {
                    var10_10 = null;
                    if (idCursor != null) {
                        idCursor.releaseBIN();
                        idCursor.close();
                    }
                    if (idDbLocker != null) {
                        ((Locker)idDbLocker).operationEnd(operationOk);
                    }
                    throw throwable;
                }
                idCursor.close();
            }
            if (idDbLocker == null) continue;
            ((Locker)idDbLocker).operationEnd(operationOk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseImpl getDb(Locker nameLocker, String databaseName, HandleLocker handleLocker) throws DatabaseException {
        DatabaseId id;
        block9: {
            if (databaseName.equals(DbType.ID.getInternalName())) {
                return this.idDatabase;
            }
            if (databaseName.equals(DbType.NAME.getInternalName())) {
                return this.nameDatabase;
            }
            CursorImpl nameCursor = null;
            id = null;
            try {
                boolean found;
                nameCursor = new CursorImpl(this.nameDatabase, nameLocker);
                DatabaseEntry keyDbt = new DatabaseEntry(StringUtils.toUTF8(databaseName));
                boolean bl = found = (nameCursor.searchAndPosition(keyDbt, CursorImpl.SearchMode.SET, LockType.READ) & 1) != 0;
                if (found) {
                    NameLN nameLN = (NameLN)nameCursor.getCurrentLNAlreadyLatched(LockType.READ);
                    assert (nameLN != null);
                    id = nameLN.getId();
                    if (handleLocker != null) {
                        this.acquireHandleLock(nameCursor, handleLocker);
                    }
                }
                Object var10_9 = null;
                if (nameCursor == null) break block9;
                nameCursor.releaseBIN();
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (nameCursor != null) {
                    nameCursor.releaseBIN();
                    nameCursor.close();
                }
                throw throwable;
            }
            nameCursor.close();
            {
            }
        }
        if (id == null) {
            return null;
        }
        return this.getDb(id, -1L, databaseName);
    }

    public DatabaseImpl getDb(DatabaseId dbId) throws DatabaseException {
        return this.getDb(dbId, -1L);
    }

    public DatabaseImpl getDb(DatabaseId dbId, long lockTimeout) throws DatabaseException {
        return this.getDb(dbId, lockTimeout, (String)null);
    }

    public DatabaseImpl getDb(DatabaseId dbId, long lockTimeout, Map<DatabaseId, DatabaseImpl> dbCache) throws DatabaseException {
        if (dbCache.containsKey(dbId)) {
            return dbCache.get(dbId);
        }
        DatabaseImpl db = this.getDb(dbId, lockTimeout, (String)null);
        dbCache.put(dbId, db);
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DatabaseImpl getDb(DatabaseId dbId, long lockTimeout, String dbNameIfAvailable) throws DatabaseException {
        if (dbId.equals(this.idDatabase.getId())) {
            return this.idDatabase;
        }
        if (dbId.equals(this.nameDatabase.getId())) {
            return this.nameDatabase;
        }
        DatabaseImpl foundDbImpl = null;
        while (true) {
            Object var13_10;
            BasicLocker locker = null;
            CursorImpl idCursor = null;
            boolean operationOk = false;
            try {
                try {
                    DatabaseEntry keyDbt;
                    boolean found;
                    locker = BasicLocker.createBasicLocker(this.envImpl);
                    if (lockTimeout != -1L) {
                        locker.setLockTimeout(lockTimeout);
                    }
                    boolean bl = found = ((idCursor = new CursorImpl(this.idDatabase, locker)).searchAndPosition(keyDbt = new DatabaseEntry(dbId.getBytes()), CursorImpl.SearchMode.SET, LockType.READ) & 1) != 0;
                    if (found) {
                        MapLN mapLN = (MapLN)idCursor.getCurrentLNAlreadyLatched(LockType.READ);
                        assert (mapLN != null);
                        foundDbImpl = mapLN.getDatabase();
                        foundDbImpl.incrementUseCount();
                    }
                    operationOk = true;
                    var13_10 = null;
                    if (idCursor != null) {
                        idCursor.releaseBIN();
                        idCursor.close();
                    }
                    if (locker == null) break;
                    ((Locker)locker).operationEnd(operationOk);
                    break;
                }
                catch (LockConflictException e) {
                    var13_10 = null;
                    if (idCursor != null) {
                        idCursor.releaseBIN();
                        idCursor.close();
                    }
                    if (locker == null) continue;
                    ((Locker)locker).operationEnd(operationOk);
                }
            }
            catch (Throwable throwable) {
                var13_10 = null;
                if (idCursor != null) {
                    idCursor.releaseBIN();
                    idCursor.close();
                }
                if (locker != null) {
                    ((Locker)locker).operationEnd(operationOk);
                }
                throw throwable;
            }
        }
        this.setDebugNameForDatabaseImpl(foundDbImpl, dbNameIfAvailable);
        return foundDbImpl;
    }

    public void releaseDb(DatabaseImpl db) {
        if (db != null && db != this.idDatabase && db != this.nameDatabase) {
            db.decrementUseCount();
        }
    }

    public void releaseDbs(Map<DatabaseId, DatabaseImpl> dbCache) {
        if (dbCache != null) {
            for (DatabaseImpl databaseImpl : dbCache.values()) {
                this.releaseDb(databaseImpl);
            }
        }
    }

    private void setDebugNameForDatabaseImpl(DatabaseImpl dbImpl, String dbName) throws DatabaseException {
        if (dbImpl != null) {
            if (dbName != null) {
                dbImpl.setDebugDatabaseName(dbName);
            } else if (this.envImpl.isValid() && !dbImpl.isDebugNameAvailable() && this.getFastNameLookup()) {
                dbImpl.setDebugDatabaseName(this.getDbName(dbImpl.getId()));
            }
        }
    }

    public void rebuildINListMapDb() throws DatabaseException {
        this.idDatabase.getTree().rebuildINList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(final VerifyConfig config, PrintStream out) throws DatabaseException {
        boolean ret = true;
        try {
            boolean ok = this.idDatabase.verify(config, this.idDatabase.getEmptyStats());
            if (!ok) {
                ret = false;
            }
            if (!(ok = this.nameDatabase.verify(config, this.nameDatabase.getEmptyStats()))) {
                ret = false;
            }
        }
        catch (DatabaseException DE) {
            ret = false;
        }
        INCompressor iNCompressor = this.envImpl.getINCompressor();
        synchronized (iNCompressor) {
            final LockType lockType = LockType.NONE;
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Traversal
            implements CursorImpl.WithCursor {
                boolean allOk = true;

                Traversal() {
                }

                @Override
                public boolean withCursor(CursorImpl cursor, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
                    DatabaseImpl dbImpl;
                    boolean ok;
                    MapLN mapLN = (MapLN)cursor.getCurrentLN(lockType);
                    if (mapLN != null && !mapLN.isDeleted() && !(ok = (dbImpl = mapLN.getDatabase()).verify(config, dbImpl.getEmptyStats()))) {
                        this.allOk = false;
                    }
                    return true;
                }
            }
            Traversal traversal = new Traversal();
            CursorImpl.traverseDbWithCursor(this.idDatabase, lockType, true, traversal);
            if (!traversal.allOk) {
                ret = false;
            }
        }
        return ret;
    }

    private boolean getFastNameLookup() {
        return this.nameDatabase.getTree().getMaxLNs() <= 100L;
    }

    public String getDbName(final DatabaseId id) throws DatabaseException {
        if (id.equals(ID_DB_ID)) {
            return DbType.ID.getInternalName();
        }
        if (id.equals(NAME_DB_ID)) {
            return DbType.NAME.getInternalName();
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Traversal
        implements CursorImpl.WithCursor {
            String name = null;

            Traversal() {
            }

            @Override
            public boolean withCursor(CursorImpl cursor, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
                NameLN nameLN = (NameLN)cursor.getCurrentLN(LockType.NONE);
                if (nameLN != null && nameLN.getId().equals(id)) {
                    this.name = StringUtils.fromUTF8(key.getData());
                    return false;
                }
                return true;
            }
        }
        Traversal traversal = new Traversal();
        CursorImpl.traverseDbWithCursor(this.nameDatabase, LockType.NONE, false, traversal);
        return traversal.name;
    }

    public Map<DatabaseId, String> getDbNamesAndIds() throws DatabaseException {
        final HashMap<DatabaseId, String> nameMap = new HashMap<DatabaseId, String>();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Traversal
        implements CursorImpl.WithCursor {
            Traversal() {
            }

            @Override
            public boolean withCursor(CursorImpl cursor, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
                NameLN nameLN = (NameLN)cursor.getCurrentLN(LockType.NONE);
                DatabaseId id = nameLN.getId();
                nameMap.put(id, StringUtils.fromUTF8(key.getData()));
                return true;
            }
        }
        Traversal traversal = new Traversal();
        CursorImpl.traverseDbWithCursor(this.nameDatabase, LockType.NONE, false, traversal);
        return nameMap;
    }

    public List<String> getDbNames() throws DatabaseException {
        final ArrayList<String> nameList = new ArrayList<String>();
        CursorImpl.traverseDbWithCursor(this.nameDatabase, LockType.NONE, true, new CursorImpl.WithCursor(){

            public boolean withCursor(CursorImpl cursor, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
                String name = StringUtils.fromUTF8(key.getData());
                if (!DbTree.isReservedDbName(name)) {
                    nameList.add(name);
                }
                return true;
            }
        });
        return nameList;
    }

    public List<String> getInternalNoLookupDbNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(DbType.ID.getInternalName());
        names.add(DbType.NAME.getInternalName());
        return names;
    }

    public List<String> getInternalNoRepDbNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(DbType.UTILIZATION.getInternalName());
        return names;
    }

    public List<String> getInternalRepDbNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(DbType.REP_GROUP.getInternalName());
        names.add(DbType.VLSN_MAP.getInternalName());
        return names;
    }

    public static boolean isReservedDbName(String name) {
        return DbTree.typeForDbName(name).isInternal();
    }

    public int getHighestLevel() throws DatabaseException {
        int idHighLevel = this.getHighestLevel(this.idDatabase);
        int nameHighLevel = this.getHighestLevel(this.nameDatabase);
        return nameHighLevel > idHighLevel ? nameHighLevel : idHighLevel;
    }

    public int getHighestLevel(DatabaseImpl dbImpl) throws DatabaseException {
        RootLevel getLevel = new RootLevel(dbImpl);
        dbImpl.getTree().withRootLatchedShared(getLevel);
        return getLevel.getRootLevel();
    }

    boolean isReplicated() {
        return (this.flags & 1) != 0;
    }

    void setIsReplicated() {
        this.flags = (byte)(this.flags | 1);
    }

    boolean isRepConverted() {
        return (this.flags & 2) != 0;
    }

    void setIsRepConverted() {
        this.flags = (byte)(this.flags | 2);
    }

    public DatabaseImpl getIdDatabaseImpl() {
        return this.idDatabase;
    }

    boolean getDupsConverted() {
        return (this.flags & 4) != 0;
    }

    void setDupsConverted() {
        this.flags = (byte)(this.flags | 4);
    }

    private boolean getPreserveVLSN() {
        return (this.flags & 8) != 0;
    }

    private void setPreserveVLSN() {
        this.flags = (byte)(this.flags | 8);
    }

    public void close() {
        this.idDatabase.releaseTreeAdminMemory();
        this.nameDatabase.releaseTreeAdminMemory();
    }

    long getTreeAdminMemory() {
        return this.idDatabase.getTreeAdminMemory() + this.nameDatabase.getTreeAdminMemory();
    }

    @Override
    public int getLogSize() {
        return LogUtils.getLongLogSize() + LogUtils.getLongLogSize() + this.idDatabase.getLogSize() + this.nameDatabase.getLogSize() + 1;
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeLong(logBuffer, this.lastAllocatedLocalDbId.get());
        LogUtils.writeLong(logBuffer, this.lastAllocatedReplicatedDbId.get());
        this.idDatabase.writeToLog(logBuffer);
        this.nameDatabase.writeToLog(logBuffer);
        logBuffer.put(this.flags);
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        if (entryVersion >= 8) {
            this.lastAllocatedLocalDbId.set(LogUtils.readLong(itemBuffer));
            this.lastAllocatedReplicatedDbId.set(LogUtils.readLong(itemBuffer));
        } else {
            this.lastAllocatedLocalDbId.set(LogUtils.readInt(itemBuffer));
            if (entryVersion >= 6) {
                this.lastAllocatedReplicatedDbId.set(LogUtils.readInt(itemBuffer));
            }
        }
        this.idDatabase.readFromLog(itemBuffer, entryVersion);
        this.nameDatabase.readFromLog(itemBuffer, entryVersion);
        this.flags = entryVersion >= 6 ? itemBuffer.get() : (byte)0;
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append("<dbtree lastLocalDbId = \"");
        sb.append(this.lastAllocatedLocalDbId);
        sb.append("\" lastReplicatedDbId = \"");
        sb.append(this.lastAllocatedReplicatedDbId);
        sb.append("\">");
        sb.append("<idDb>");
        this.idDatabase.dumpLog(sb, verbose);
        sb.append("</idDb><nameDb>");
        this.nameDatabase.dumpLog(sb, verbose);
        sb.append("</nameDb>");
        sb.append("</dbtree>");
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        return false;
    }

    String dumpString(int nSpaces) {
        StringBuilder self = new StringBuilder();
        self.append(TreeUtils.indent(nSpaces));
        self.append("<dbTree lastDbId =\"");
        self.append(this.lastAllocatedLocalDbId);
        self.append("\">");
        self.append('\n');
        self.append(this.idDatabase.dumpString(nSpaces + 1));
        self.append('\n');
        self.append(this.nameDatabase.dumpString(nSpaces + 1));
        self.append('\n');
        self.append("</dbtree>");
        return self.toString();
    }

    public String toString() {
        return this.dumpString(0);
    }

    public void dump() {
        this.idDatabase.getTree().dump();
        this.nameDatabase.getTree().dump();
    }

    static {
        EnumSet<DbType> set = EnumSet.allOf(DbType.class);
        INTERNAL_TYPES_BY_NAME = new HashMap<String, DbType>(set.size());
        for (DbType t : set) {
            if (!t.isInternal()) continue;
            INTERNAL_TYPES_BY_NAME.put(t.getInternalName(), t);
        }
    }

    private static class RootLevel
    implements WithRootLatched {
        private final DatabaseImpl db;
        private int rootLevel;

        RootLevel(DatabaseImpl db) {
            this.db = db;
            this.rootLevel = 0;
        }

        public IN doWork(ChildReference root) throws DatabaseException {
            IN rootIN = (IN)root.fetchTarget(this.db, null);
            this.rootLevel = rootIN.getLevel();
            return null;
        }

        int getRootLevel() {
            return this.rootLevel;
        }
    }

    public static class TruncateDbResult {
        public final DatabaseImpl oldDB;
        public final DatabaseImpl newDb;
        public final long recordCount;

        public TruncateDbResult(DatabaseImpl oldDB, DatabaseImpl newDb, long recordCount) {
            this.oldDB = oldDB;
            this.newDb = newDb;
            this.recordCount = recordCount;
        }
    }

    private static class NameLockResult {
        CursorImpl nameCursor;
        DatabaseImpl dbImpl;
        NameLN nameLN;
        ReplicationContext repContext;

        private NameLockResult() {
        }
    }

    static interface GetRepContext {
        public ReplicationContext get(DatabaseImpl var1);
    }

    private static class RewriteMapLN
    implements WithRootLatched {
        private final CursorImpl cursor;

        RewriteMapLN(CursorImpl cursor) {
            this.cursor = cursor;
        }

        public IN doWork(ChildReference root) throws DatabaseException {
            DatabaseEntry dataDbt = new DatabaseEntry(new byte[0]);
            this.cursor.putCurrent(null, dataDbt, null, null, null, ReplicationContext.NO_REPLICATE);
            return null;
        }
    }
}

