/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.BaseIterator;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.StoredCollection;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.collections.StoredMapEntry;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.OperationStatus;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredEntrySet<K, V>
extends StoredCollection<Map.Entry<K, V>>
implements Set<Map.Entry<K, V>> {
    StoredEntrySet(DataView mapView) {
        super(mapView);
    }

    @Override
    public boolean add(Map.Entry<K, V> mapEntry) {
        return this.add(mapEntry.getKey(), mapEntry.getValue());
    }

    @Override
    public boolean remove(Object mapEntry) {
        if (!(mapEntry instanceof Map.Entry)) {
            return false;
        }
        DataCursor cursor = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            cursor = new DataCursor(this.view, true);
            Map.Entry entry = (Map.Entry)mapEntry;
            OperationStatus status = cursor.findBoth(entry.getKey(), entry.getValue(), true);
            if (status == OperationStatus.SUCCESS) {
                cursor.delete();
            }
            this.closeCursor(cursor);
            this.commitAutoCommit(doAutoCommit);
            return status == OperationStatus.SUCCESS;
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            throw this.handleException(e, doAutoCommit);
        }
    }

    @Override
    public boolean contains(Object mapEntry) {
        boolean bl;
        if (!(mapEntry instanceof Map.Entry)) {
            return false;
        }
        DataCursor cursor = null;
        try {
            cursor = new DataCursor(this.view, false);
            Map.Entry entry = (Map.Entry)mapEntry;
            OperationStatus status = cursor.findBoth(entry.getKey(), entry.getValue(), false);
            bl = status == OperationStatus.SUCCESS;
            Object var7_7 = null;
        }
        catch (Exception e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.closeCursor(cursor);
                throw throwable;
            }
        }
        this.closeCursor(cursor);
        return bl;
    }

    @Override
    public String toString() {
        Object entry;
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        StoredIterator i = null;
        try {
            i = this.storedIterator();
            while (i.hasNext()) {
                entry = (Map.Entry)i.next();
                if (buf.length() > 1) {
                    buf.append(',');
                }
                Object key = entry.getKey();
                Object val = entry.getValue();
                if (key != null) {
                    buf.append(key.toString());
                }
                buf.append('=');
                if (val == null) continue;
                buf.append(val.toString());
            }
            buf.append(']');
            entry = buf.toString();
            Object var7_7 = null;
        }
        catch (Exception e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                StoredIterator.close(i);
                throw throwable;
            }
        }
        StoredIterator.close(i);
        return entry;
    }

    @Override
    Map.Entry<K, V> makeIteratorData(BaseIterator iterator, DatabaseEntry keyEntry, DatabaseEntry priKeyEntry, DatabaseEntry valueEntry) {
        return new StoredMapEntry(this.view.makeKey(keyEntry, priKeyEntry), this.view.makeValue(priKeyEntry, valueEntry), this, iterator);
    }

    @Override
    boolean hasValues() {
        return true;
    }
}

