/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.rep.InsufficientAcksException;
import com.sleepycat.je.rep.InsufficientReplicasException;
import com.sleepycat.je.rep.NodeType;
import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.node.Feeder;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.stream.Protocol;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.utilint.NamedChannel;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.logging.Logger;

public class FeederReplicaHandshake {
    private final RepNode repNode;
    private final NamedChannel namedChannel;
    private final NameIdPair feederNameIdPair;
    private NameIdPair replicaNameIdPair = null;
    private Protocol.ReplicaJEVersions replicaJEVersions;
    private final Logger logger;
    private static int testCurrentLogVersion = 0;

    public FeederReplicaHandshake(RepNode repNode, Feeder feeder, NamedChannel namedChannel) {
        this.repNode = repNode;
        this.namedChannel = namedChannel;
        this.feederNameIdPair = repNode.getNameIdPair();
        this.logger = LoggerUtils.getLogger(this.getClass());
    }

    public NameIdPair getReplicaNameIdPair() {
        return this.replicaNameIdPair;
    }

    private int getCurrentLogVersion() {
        return testCurrentLogVersion != 0 ? testCurrentLogVersion : 8;
    }

    public static void setTestLogVersion(int testLogVersion) {
        testCurrentLogVersion = testLogVersion;
    }

    private Protocol.JEVersionsReject checkJECompatibility(Protocol protocol, Protocol.JEVersions jeVersions) {
        Protocol.JEVersionsReject jEVersionsReject;
        if (jeVersions.getLogVersion() >= this.getCurrentLogVersion()) {
            jEVersionsReject = null;
        } else {
            Protocol protocol2 = protocol;
            protocol2.getClass();
            jEVersionsReject = new Protocol.JEVersionsReject(protocol2, "Incompatible log versions. Feeder version: 8, Feeder JE version: " + JEVersion.CURRENT_VERSION + ", Replica log version: " + jeVersions.getLogVersion() + ", Replica JE version: " + jeVersions.getVersion());
        }
        return jEVersionsReject;
    }

    public Protocol execute() throws DatabaseException, IOException, BinaryProtocol.ProtocolException, Feeder.ExitException {
        LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Feeder-replica handshake start");
        Protocol protocol = this.negotiateProtocol();
        this.replicaJEVersions = (Protocol.ReplicaJEVersions)protocol.read(this.namedChannel);
        LoggerUtils.fine(this.logger, this.repNode.getRepImpl(), " Replica " + this.replicaNameIdPair.getName() + " JE version: " + this.replicaJEVersions.getVersion().getVersionString() + " Log version: " + this.replicaJEVersions.getLogVersion());
        Protocol.JEVersionsReject reject = this.checkJECompatibility(protocol, this.replicaJEVersions);
        if (reject != null) {
            LoggerUtils.warning(this.logger, this.repNode.getRepImpl(), "Version incompatibility: " + reject.getErrorMessage() + " with replica " + this.replicaNameIdPair.getName());
            protocol.write((BinaryProtocol.Message)reject, this.namedChannel);
            return protocol;
        }
        Protocol protocol2 = protocol;
        protocol2.getClass();
        protocol.write((BinaryProtocol.Message)new Protocol.FeederJEVersions(protocol2, JEVersion.CURRENT_VERSION, 8), this.namedChannel);
        this.verifyMembershipInfo(protocol);
        this.checkClockSkew(protocol);
        LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Feeder-replica " + this.replicaNameIdPair.getName() + " handshake completed.");
        return protocol;
    }

    private void checkClockSkew(Protocol protocol) throws IOException, BinaryProtocol.ProtocolException {
        Protocol.SNTPRequest request = null;
        do {
            request = protocol.read(this.namedChannel.getChannel(), Protocol.SNTPRequest.class);
            Protocol protocol2 = protocol;
            protocol2.getClass();
            protocol.write((BinaryProtocol.Message)new Protocol.SNTPResponse(protocol2, request), this.namedChannel);
        } while (!request.isLast());
    }

    private void verifyMembershipInfo(Protocol protocol) throws IOException, DatabaseException, Feeder.ExitException {
        Protocol.NodeGroupInfo nodeGroup = (Protocol.NodeGroupInfo)protocol.read(this.namedChannel);
        RepGroupImpl group = this.repNode.getGroup();
        RepNodeImpl node = group.getNode(nodeGroup.getNodeName());
        try {
            block10: {
                if (nodeGroup.getNodeId() != this.replicaNameIdPair.getId()) {
                    throw new Feeder.ExitException("The replica node ID sent during protocol negotiation: " + this.replicaNameIdPair + " differs from the one sent in the MembershipInfo " + "request: " + nodeGroup.getNodeId());
                }
                if (node == null) {
                    try {
                        this.repNode.getRepGroupDB().ensureMember(nodeGroup);
                        node = this.repNode.getGroup().getMember(nodeGroup.getNodeName());
                        if (node == null) {
                            throw EnvironmentFailureException.unexpectedState("Node: " + nodeGroup.getNameIdPair() + " not found");
                        }
                        break block10;
                    }
                    catch (InsufficientReplicasException e) {
                        throw new Feeder.ExitException(e);
                    }
                    catch (InsufficientAcksException e) {
                        throw new Feeder.ExitException(e);
                    }
                    catch (RepGroupImpl.NodeConflictException e) {
                        throw new Feeder.ExitException(e);
                    }
                }
                if (node.isRemoved()) {
                    throw new Feeder.ExitException("Node: " + nodeGroup.getNameIdPair() + " is no longer a member of the group." + " It was explicitly removed.");
                }
            }
            this.doGroupChecks(nodeGroup, group);
            this.doNodeChecks(nodeGroup, node);
        }
        catch (Feeder.ExitException exception) {
            LoggerUtils.info(this.logger, this.repNode.getRepImpl(), exception.getMessage());
            Protocol protocol2 = protocol;
            protocol2.getClass();
            protocol.write((BinaryProtocol.Message)new Protocol.NodeGroupInfoReject(protocol2, exception.getMessage()), this.namedChannel);
            throw exception;
        }
        this.replicaNameIdPair.update(node.getNameIdPair());
        this.namedChannel.setNameIdPair(this.replicaNameIdPair);
        LoggerUtils.fine(this.logger, this.repNode.getRepImpl(), "Channel Mapping: " + this.replicaNameIdPair + " is at " + this.namedChannel.getChannel());
        Protocol protocol3 = protocol;
        protocol3.getClass();
        protocol.write((BinaryProtocol.Message)new Protocol.NodeGroupInfoOK(protocol3, group.getUUID(), this.replicaNameIdPair), this.namedChannel);
    }

    private void doGroupChecks(Protocol.NodeGroupInfo nodeGroup, RepGroupImpl group) throws Feeder.ExitException {
        if (nodeGroup.isDesignatedPrimary() && this.repNode.getRepImpl().isDesignatedPrimary()) {
            throw new Feeder.ExitException("Conflicting Primary designations. Feeder node: " + this.repNode.getNodeName() + " and replica node: " + nodeGroup.getNodeName() + " cannot simultaneously be designated primaries");
        }
        if (!nodeGroup.getGroupName().equals(group.getName())) {
            throw new Feeder.ExitException("The feeder belongs to the group: " + group.getName() + " but replica id" + this.replicaNameIdPair + " belongs to the group: " + nodeGroup.getGroupName());
        }
        if (!RepGroupImpl.isUnknownUUID(nodeGroup.getUUID()) && !nodeGroup.getUUID().equals(group.getUUID())) {
            throw new Feeder.ExitException("The environments have the same name: " + group.getName() + " but represent different environment instances." + " The environment at the master has UUID " + group.getUUID() + ", while the replica " + this.replicaNameIdPair.getName() + " has UUID: " + nodeGroup.getUUID());
        }
    }

    private void doNodeChecks(Protocol.NodeGroupInfo nodeGroup, RepNodeImpl node) throws Feeder.ExitException {
        if (!nodeGroup.getHostName().equals(node.getHostName())) {
            throw new Feeder.ExitException("Conflicting hostnames for replica id: " + this.replicaNameIdPair + " Feeder thinks it is: " + node.getHostName() + " Replica is configured to use: " + nodeGroup.getHostName());
        }
        if (nodeGroup.port() != node.getPort()) {
            throw new Feeder.ExitException("Conflicting ports for replica id: " + this.replicaNameIdPair + " Feeder thinks it uses: " + node.getPort() + " Replica is configured to use: " + nodeGroup.port());
        }
        if (NodeType.ELECTABLE != node.getType() && NodeType.MONITOR != node.getType()) {
            throw new Feeder.ExitException("The replica node: " + this.replicaNameIdPair + " is of type: " + (Object)((Object)node.getType()));
        }
        if (!nodeGroup.getNodeType().equals((Object)node.getType())) {
            throw new Feeder.ExitException("Conflicting node types for: " + this.replicaNameIdPair + " Feeder thinks it uses: " + (Object)((Object)node.getType()) + " Replica is configured as type: " + (Object)((Object)nodeGroup.getNodeType()));
        }
    }

    private Protocol negotiateProtocol() throws IOException, Feeder.ExitException {
        Protocol defaultProtocol = Protocol.getProtocol(this.repNode);
        Protocol.ReplicaProtocolVersion message = (Protocol.ReplicaProtocolVersion)defaultProtocol.read(this.namedChannel);
        this.replicaNameIdPair = message.getNameIdPair();
        Feeder dup = this.repNode.feederManager().getFeeder(this.replicaNameIdPair.getName());
        if (dup != null || message.getNameIdPair().getName().equals(this.feederNameIdPair.getName())) {
            Protocol protocol = defaultProtocol;
            protocol.getClass();
            defaultProtocol.write((BinaryProtocol.Message)new Protocol.DuplicateNodeReject(protocol, "This node: " + this.replicaNameIdPair + " is already in active use at the feeder "), this.namedChannel);
            SocketAddress dupAddress = this.namedChannel.getChannel().socket().getRemoteSocketAddress();
            throw new Feeder.ExitException("A replica with the id: " + this.replicaNameIdPair + " is already active with this feeder. " + " The duplicate replica resides at: " + dupAddress);
        }
        int replicaVersion = message.getVersion();
        Protocol protocol = Protocol.get(this.repNode, replicaVersion);
        protocol = protocol == null ? defaultProtocol : protocol;
        Protocol protocol2 = defaultProtocol;
        protocol2.getClass();
        defaultProtocol.write((BinaryProtocol.Message)new Protocol.FeederProtocolVersion(protocol2, protocol.getVersion()), this.namedChannel);
        return protocol;
    }
}

