/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.cleaner.OffsetList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.dbi.SortedLSNTreeWalker;
import com.sleepycat.je.utilint.DbLsn;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

class LSNAccumulator {
    private Map<Long, OffsetList> offsetsByFile;
    private int nTotalEntries;
    private long lsnAccMemoryUsage;
    private SortedLSNTreeWalker parent;

    LSNAccumulator(SortedLSNTreeWalker parent) {
        this.parent = parent;
        this.init();
    }

    private void init() {
        this.incInternalMemoryUsage(-this.lsnAccMemoryUsage);
        this.offsetsByFile = new TreeMap<Long, OffsetList>();
        this.nTotalEntries = 0;
        this.incInternalMemoryUsage(MemoryBudget.TREEMAP_OVERHEAD);
    }

    int getNTotalEntries() {
        return this.nTotalEntries;
    }

    private void incInternalMemoryUsage(long increment) {
        this.lsnAccMemoryUsage += increment;
        this.parent.incInternalMemoryUsage(increment);
    }

    void add(long lsn) {
        boolean newSegment;
        long fileNumber = DbLsn.getFileNumber(lsn);
        OffsetList offsetsForFile = this.offsetsByFile.get(fileNumber);
        if (offsetsForFile == null) {
            offsetsForFile = new OffsetList();
            this.offsetsByFile.put(fileNumber, offsetsForFile);
            this.incInternalMemoryUsage(MemoryBudget.TFS_LIST_INITIAL_OVERHEAD);
            this.incInternalMemoryUsage(MemoryBudget.TREEMAP_ENTRY_OVERHEAD);
        }
        if (newSegment = offsetsForFile.add(DbLsn.getFileOffset(lsn), false)) {
            this.incInternalMemoryUsage(MemoryBudget.TFS_LIST_SEGMENT_OVERHEAD);
        }
        ++this.nTotalEntries;
    }

    long[] getAndSortPendingLSNs() {
        long[] currentLSNs = new long[this.nTotalEntries];
        int curIdx = 0;
        for (Map.Entry<Long, OffsetList> fileEntry : this.offsetsByFile.entrySet()) {
            long fileNumber = fileEntry.getKey();
            for (long fileOffset : fileEntry.getValue().toArray()) {
                currentLSNs[curIdx] = DbLsn.makeLsn(fileNumber, fileOffset);
                ++curIdx;
            }
        }
        Arrays.sort(currentLSNs);
        this.init();
        return currentLSNs;
    }

    boolean isEmpty() {
        return this.nTotalEntries == 0;
    }

    void clear() {
        this.offsetsByFile.clear();
        this.nTotalEntries = 0;
        this.incInternalMemoryUsage(-this.lsnAccMemoryUsage);
    }
}

