/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.statcap;

import com.sleepycat.je.cleaner.CleanerStatDefinition;
import com.sleepycat.je.dbi.DbiStatDefinition;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.evictor.EvictorStatDefinition;
import com.sleepycat.je.incomp.INCompStatDefinition;
import com.sleepycat.je.latch.LatchStatDefinition;
import com.sleepycat.je.log.LogStatDefinition;
import com.sleepycat.je.recovery.CheckpointStatDefinition;
import com.sleepycat.je.txn.LockStatDefinition;
import com.sleepycat.je.utilint.StatDefinition;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatCaptureDefinitions {
    protected Map<String, StatDefinition> nameToDef = new HashMap<String, StatDefinition>();
    private static StatDefinition[] cleanerStats = new StatDefinition[]{CleanerStatDefinition.CLEANER_BACKLOG, CleanerStatDefinition.CLEANER_FILE_DELETION_BACKLOG, CleanerStatDefinition.CLEANER_RUNS, CleanerStatDefinition.CLEANER_PROBE_RUNS, CleanerStatDefinition.CLEANER_DELETIONS, CleanerStatDefinition.CLEANER_PENDING_LN_QUEUE_SIZE, CleanerStatDefinition.CLEANER_INS_OBSOLETE, CleanerStatDefinition.CLEANER_INS_CLEANED, CleanerStatDefinition.CLEANER_INS_DEAD, CleanerStatDefinition.CLEANER_INS_MIGRATED, CleanerStatDefinition.CLEANER_BIN_DELTAS_OBSOLETE, CleanerStatDefinition.CLEANER_BIN_DELTAS_CLEANED, CleanerStatDefinition.CLEANER_BIN_DELTAS_DEAD, CleanerStatDefinition.CLEANER_BIN_DELTAS_MIGRATED, CleanerStatDefinition.CLEANER_LNS_OBSOLETE, CleanerStatDefinition.CLEANER_LNS_CLEANED, CleanerStatDefinition.CLEANER_LNS_DEAD, CleanerStatDefinition.CLEANER_LNS_LOCKED, CleanerStatDefinition.CLEANER_LNS_MIGRATED, CleanerStatDefinition.CLEANER_LNS_MARKED, CleanerStatDefinition.CLEANER_LNQUEUE_HITS, CleanerStatDefinition.CLEANER_PENDING_LNS_PROCESSED, CleanerStatDefinition.CLEANER_MARKED_LNS_PROCESSED, CleanerStatDefinition.CLEANER_TO_BE_CLEANED_LNS_PROCESSED, CleanerStatDefinition.CLEANER_CLUSTER_LNS_PROCESSED, CleanerStatDefinition.CLEANER_PENDING_LNS_LOCKED, CleanerStatDefinition.CLEANER_ENTRIES_READ, CleanerStatDefinition.CLEANER_REPEAT_ITERATOR_READS, CleanerStatDefinition.CLEANER_TOTAL_LOG_SIZE, CleanerStatDefinition.CLEANER_LN_SIZE_CORRECTION_FACTOR, CleanerStatDefinition.CLEANER_LAST_KNOWN_UTILIZATION};
    private static StatDefinition[] dbiStats = new StatDefinition[]{DbiStatDefinition.MB_SHARED_CACHE_TOTAL_BYTES, DbiStatDefinition.MB_TOTAL_BYTES, DbiStatDefinition.MB_DATA_BYTES, DbiStatDefinition.MB_DATA_ADMIN_BYTES, DbiStatDefinition.MB_ADMIN_BYTES, DbiStatDefinition.MB_LOCK_BYTES};
    private static StatDefinition[] environmentStats = new StatDefinition[]{DbiStatDefinition.ENVIMPL_RELATCHES_REQUIRED, DbiStatDefinition.ENVIMPL_CREATION_TIME};
    private static StatDefinition[] evictorStats = new StatDefinition[]{EvictorStatDefinition.EVICTOR_EVICT_PASSES, EvictorStatDefinition.EVICTOR_NODES_SELECTED, EvictorStatDefinition.EVICTOR_NODES_SCANNED, EvictorStatDefinition.EVICTOR_NODES_EVICTED, EvictorStatDefinition.EVICTOR_ROOT_NODES_EVICTED, EvictorStatDefinition.EVICTOR_BINS_STRIPPED, EvictorStatDefinition.EVICTOR_REQUIRED_EVICT_BYTES, EvictorStatDefinition.EVICTOR_SHARED_CACHE_ENVS, EvictorStatDefinition.LN_FETCH, EvictorStatDefinition.UPPER_IN_FETCH, EvictorStatDefinition.BIN_FETCH, EvictorStatDefinition.LN_FETCH_MISS, EvictorStatDefinition.UPPER_IN_FETCH_MISS, EvictorStatDefinition.BIN_FETCH_MISS, EvictorStatDefinition.CACHED_UPPER_INS, EvictorStatDefinition.CACHED_BINS, EvictorStatDefinition.THREAD_UNAVAILABLE, EvictorStatDefinition.CACHED_IN_SPARSE_TARGET, EvictorStatDefinition.CACHED_IN_NO_TARGET, EvictorStatDefinition.CACHED_IN_COMPACT_KEY, Evictor.EvictionSource.CACHEMODE.getAvgBatchStatDef(), Evictor.EvictionSource.CACHEMODE.getBINStatDef(), Evictor.EvictionSource.CACHEMODE.getNumBatchesStatDef(), Evictor.EvictionSource.CACHEMODE.getUpperINStatDef(), Evictor.EvictionSource.CRITICAL.getAvgBatchStatDef(), Evictor.EvictionSource.CRITICAL.getBINStatDef(), Evictor.EvictionSource.CRITICAL.getNumBatchesStatDef(), Evictor.EvictionSource.CRITICAL.getUpperINStatDef(), Evictor.EvictionSource.DAEMON.getAvgBatchStatDef(), Evictor.EvictionSource.DAEMON.getBINStatDef(), Evictor.EvictionSource.DAEMON.getNumBatchesStatDef(), Evictor.EvictionSource.DAEMON.getUpperINStatDef(), Evictor.EvictionSource.EVICTORTHREAD.getAvgBatchStatDef(), Evictor.EvictionSource.EVICTORTHREAD.getBINStatDef(), Evictor.EvictionSource.EVICTORTHREAD.getNumBatchesStatDef(), Evictor.EvictionSource.EVICTORTHREAD.getUpperINStatDef(), Evictor.EvictionSource.MANUAL.getAvgBatchStatDef(), Evictor.EvictionSource.MANUAL.getBINStatDef(), Evictor.EvictionSource.MANUAL.getNumBatchesStatDef(), Evictor.EvictionSource.MANUAL.getUpperINStatDef()};
    private static StatDefinition[] inCompStats = new StatDefinition[]{INCompStatDefinition.INCOMP_SPLIT_BINS, INCompStatDefinition.INCOMP_DBCLOSED_BINS, INCompStatDefinition.INCOMP_CURSORS_BINS, INCompStatDefinition.INCOMP_NON_EMPTY_BINS, INCompStatDefinition.INCOMP_PROCESSED_BINS, INCompStatDefinition.INCOMP_QUEUE_SIZE};
    private static StatDefinition[] latchStats = new StatDefinition[]{LatchStatDefinition.LATCH_NO_WAITERS, LatchStatDefinition.LATCH_SELF_OWNED, LatchStatDefinition.LATCH_CONTENTION, LatchStatDefinition.LATCH_NOWAIT_SUCCESS, LatchStatDefinition.LATCH_NOWAIT_UNSUCCESS, LatchStatDefinition.LATCH_RELEASES};
    private static StatDefinition[] logStats = new StatDefinition[]{LogStatDefinition.FILEMGR_RANDOM_READS, LogStatDefinition.FILEMGR_RANDOM_WRITES, LogStatDefinition.FILEMGR_SEQUENTIAL_READS, LogStatDefinition.FILEMGR_SEQUENTIAL_WRITES, LogStatDefinition.FILEMGR_RANDOM_READ_BYTES, LogStatDefinition.FILEMGR_RANDOM_WRITE_BYTES, LogStatDefinition.FILEMGR_SEQUENTIAL_READ_BYTES, LogStatDefinition.FILEMGR_SEQUENTIAL_WRITE_BYTES, LogStatDefinition.FILEMGR_FILE_OPENS, LogStatDefinition.FILEMGR_OPEN_FILES, LogStatDefinition.FILEMGR_BYTES_READ_FROM_WRITEQUEUE, LogStatDefinition.FILEMGR_BYTES_WRITTEN_FROM_WRITEQUEUE, LogStatDefinition.FILEMGR_READS_FROM_WRITEQUEUE, LogStatDefinition.FILEMGR_WRITES_FROM_WRITEQUEUE, LogStatDefinition.FILEMGR_WRITEQUEUE_OVERFLOW, LogStatDefinition.FILEMGR_WRITEQUEUE_OVERFLOW_FAILURES, LogStatDefinition.FSYNCMGR_FSYNCS, LogStatDefinition.FSYNCMGR_FSYNC_REQUESTS, LogStatDefinition.FSYNCMGR_TIMEOUTS, LogStatDefinition.FILEMGR_LOG_FSYNCS, LogStatDefinition.GRPCMGR_FSYNC_TIME, LogStatDefinition.GRPCMGR_N_GROUP_COMMIT_REQUESTS, LogStatDefinition.GRPCMGR_N_GROUP_COMMIT_WAITS, LogStatDefinition.GRPCMGR_N_LOG_INTERVAL_EXCEEDED, LogStatDefinition.GRPCMGR_N_LOG_MAX_GROUP_COMMIT, LogStatDefinition.LOGMGR_REPEAT_FAULT_READS, LogStatDefinition.LOGMGR_TEMP_BUFFER_WRITES, LogStatDefinition.LOGMGR_END_OF_LOG, LogStatDefinition.LBFP_NO_FREE_BUFFER, LogStatDefinition.LBFP_NOT_RESIDENT, LogStatDefinition.LBFP_MISS, LogStatDefinition.LBFP_LOG_BUFFERS, LogStatDefinition.LBFP_BUFFER_BYTES};
    private static StatDefinition[] checkpointStats = new StatDefinition[]{CheckpointStatDefinition.CKPT_CHECKPOINTS, CheckpointStatDefinition.CKPT_LAST_CKPTID, CheckpointStatDefinition.CKPT_FULL_IN_FLUSH, CheckpointStatDefinition.CKPT_FULL_BIN_FLUSH, CheckpointStatDefinition.CKPT_DELTA_IN_FLUSH, CheckpointStatDefinition.CKPT_LAST_CKPT_START, CheckpointStatDefinition.CKPT_LAST_CKPT_END};
    private static StatDefinition[] throughputStats = new StatDefinition[]{DbiStatDefinition.THROUGHPUT_DB_DELETE, DbiStatDefinition.THROUGHPUT_DB_GET, DbiStatDefinition.THROUGHPUT_DB_GETSEARCHBOTH, DbiStatDefinition.THROUGHPUT_DB_PUT, DbiStatDefinition.THROUGHPUT_DB_PUTNODUPDATA, DbiStatDefinition.THROUGHPUT_DB_PUTNOOVERWRITE, DbiStatDefinition.THROUGHPUT_DB_REMOVESEQUENCE, DbiStatDefinition.THROUGHPUT_CURSOR_DELETE, DbiStatDefinition.THROUGHPUT_CURSOR_GETCURRENT, DbiStatDefinition.THROUGHPUT_CURSOR_GETFIRST, DbiStatDefinition.THROUGHPUT_CURSOR_GETLAST, DbiStatDefinition.THROUGHPUT_CURSOR_GETNEXT, DbiStatDefinition.THROUGHPUT_CURSOR_GETNEXTDUP, DbiStatDefinition.THROUGHPUT_CURSOR_GETNEXTNODUP, DbiStatDefinition.THROUGHPUT_CURSOR_GETPREV, DbiStatDefinition.THROUGHPUT_CURSOR_GETPREVDUP, DbiStatDefinition.THROUGHPUT_CURSOR_GETPREVNODUP, DbiStatDefinition.THROUGHPUT_CURSOR_PUT, DbiStatDefinition.THROUGHPUT_CURSOR_PUTCURRENT, DbiStatDefinition.THROUGHPUT_CURSOR_PUTNODUPDATA, DbiStatDefinition.THROUGHPUT_CURSOR_PUTNOOVERWRITE, DbiStatDefinition.THROUGHPUT_SECONDARYCURSOR_DELETE, DbiStatDefinition.THROUGHPUT_SECONDARYCURSOR_GETCURRENT, DbiStatDefinition.THROUGHPUT_SECONDARYCURSOR_GETFIRST, DbiStatDefinition.THROUGHPUT_SECONDARYCURSOR_GETLAST, DbiStatDefinition.THROUGHPUT_SECONDARYCURSOR_GETNEXT, DbiStatDefinition.THROUGHPUT_SECONDARYCURSOR_GETNEXTDUP, DbiStatDefinition.THROUGHPUT_SECONDARYCURSOR_GETNEXTNODUP, DbiStatDefinition.THROUGHPUT_SECONDARYCURSOR_GETPREV, DbiStatDefinition.THROUGHPUT_SECONDARYCURSOR_GETPREVDUP, DbiStatDefinition.THROUGHPUT_SECONDARYCURSOR_GETPREVNODUP, DbiStatDefinition.THROUGHPUT_SECONDARYDB_DELETE, DbiStatDefinition.THROUGHPUT_SECONDARYDB_GET, DbiStatDefinition.THROUGHPUT_SECONDARYDB_GETSEARCHBOTH, DbiStatDefinition.THROUGHPUT_DOSCURSOR_GETNEXT};
    private static StatDefinition[] lockStats = new StatDefinition[]{LockStatDefinition.LOCK_REQUESTS, LockStatDefinition.LOCK_WAITS};

    public StatCaptureDefinitions() {
        String groupname = "Cache";
        for (StatDefinition stat : evictorStats) {
            this.nameToDef.put(groupname + ":" + stat.getName(), stat);
        }
        for (StatDefinition stat : dbiStats) {
            this.nameToDef.put(groupname + ":" + stat.getName(), stat);
        }
        groupname = "Checkpoints";
        for (StatDefinition stat : checkpointStats) {
            this.nameToDef.put(groupname + ":" + stat.getName(), stat);
        }
        groupname = "Cleaning";
        for (StatDefinition stat : cleanerStats) {
            this.nameToDef.put(groupname + ":" + stat.getName(), stat);
        }
        groupname = "I/O";
        for (StatDefinition stat : logStats) {
            this.nameToDef.put(groupname + ":" + stat.getName(), stat);
        }
        groupname = "Locks";
        for (StatDefinition stat : lockStats) {
            this.nameToDef.put(groupname + ":" + stat.getName(), stat);
        }
        for (StatDefinition stat : latchStats) {
            this.nameToDef.put(groupname + ":" + stat.getName(), stat);
        }
        groupname = "Environment";
        for (StatDefinition stat : environmentStats) {
            this.nameToDef.put(groupname + ":" + stat.getName(), stat);
        }
        groupname = "Node Compression";
        for (StatDefinition stat : inCompStats) {
            this.nameToDef.put(groupname + ":" + stat.getName(), stat);
        }
        groupname = "Op";
        for (StatDefinition stat : throughputStats) {
            this.nameToDef.put(groupname + ":" + stat.getName(), stat);
        }
    }

    public SortedSet<String> getStatisticProjections() {
        TreeSet<String> retval = new TreeSet<String>();
        this.getProjectionsInternal(retval);
        return retval;
    }

    protected void getProjectionsInternal(SortedSet<String> pmap) {
        String groupname = "Cache";
        for (StatDefinition stat : evictorStats) {
            pmap.add(groupname + ":" + stat.getName());
        }
        for (StatDefinition stat : dbiStats) {
            pmap.add(groupname + ":" + stat.getName());
        }
        groupname = "Checkpoints";
        for (StatDefinition stat : checkpointStats) {
            pmap.add(groupname + ":" + stat.getName());
        }
        groupname = "Cleaning";
        for (StatDefinition stat : cleanerStats) {
            pmap.add(groupname + ":" + stat.getName());
        }
        groupname = "I/O";
        for (StatDefinition stat : logStats) {
            pmap.add(groupname + ":" + stat.getName());
        }
        groupname = "Locks";
        for (StatDefinition stat : lockStats) {
            pmap.add(groupname + ":" + stat.getName());
        }
        for (StatDefinition stat : latchStats) {
            pmap.add(groupname + ":" + stat.getName());
        }
        groupname = "Environment";
        for (StatDefinition stat : environmentStats) {
            pmap.add(groupname + ":" + stat.getName());
        }
        groupname = "Node Compression";
        for (StatDefinition stat : inCompStats) {
            pmap.add(groupname + ":" + stat.getName());
        }
        groupname = "Op";
        for (StatDefinition stat : throughputStats) {
            pmap.add(groupname + ":" + stat.getName());
        }
    }

    public StatDefinition getDefinition(String colname) {
        return this.nameToDef.get(colname);
    }
}

