/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.utilint.BinaryProtocolStatDefinition;
import com.sleepycat.je.rep.utilint.NamedChannel;
import com.sleepycat.je.rep.utilint.ReplicationFormatter;
import com.sleepycat.je.utilint.InternalException;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.VLSN;
import com.sleepycat.utilint.StringUtils;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BinaryProtocol {
    protected static final int MESSAGE_HEADER_SIZE = 6;
    protected final ByteBuffer header = ByteBuffer.allocate(6);
    protected final int codeVersion;
    protected int configuredVersion;
    protected final NameIdPair nameIdPair;
    private final Map<Short, MessageOp> ops = new HashMap<Short, MessageOp>();
    private final int predefinedMessageCount;
    private final long maxMessageSize;
    private final boolean useStringDefaultEncoding;
    public final MessageOp CLIENT_VERSION = new MessageOp(1001, ClientVersion.class);
    public final MessageOp SERVER_VERSION = new MessageOp(1002, ServerVersion.class);
    public final MessageOp INCOMPATIBLE_VERSION = new MessageOp(1003, IncompatibleVersion.class);
    public final MessageOp PROTOCOL_ERROR = new MessageOp(1004, ProtocolError.class);
    protected final StatGroup stats;
    protected final LongStat nReadNanos;
    protected final LongStat nWriteNanos;
    protected final LongStat nBytesRead;
    protected final LongStat nMessagesRead;
    protected final LongStat nBytesWritten;
    protected final LongStat nMessagesWritten;
    protected final LongStat nEntriesWrittenOldVersion;
    protected final Logger logger;
    protected final Formatter formatter;
    protected final EnvironmentImpl envImpl;
    private static int CACHED_BUFFER_SIZE = 16384;
    private final ByteBuffer cachedReadBuffer = ByteBuffer.allocate(CACHED_BUFFER_SIZE);
    private final ByteBuffer cachedWriteBuffer = ByteBuffer.allocate(CACHED_BUFFER_SIZE);

    protected BinaryProtocol(NameIdPair nameIdPair, int codeVersion, int configuredVersion, EnvironmentImpl envImpl) {
        this.nameIdPair = nameIdPair;
        this.codeVersion = codeVersion;
        this.configuredVersion = configuredVersion;
        this.envImpl = envImpl;
        this.logger = envImpl != null ? LoggerUtils.getLogger(this.getClass()) : LoggerUtils.getLoggerFormatterNeeded(this.getClass());
        this.formatter = new ReplicationFormatter(nameIdPair);
        this.stats = new StatGroup("BinaryProtocol", "Network traffic due to the replication stream.");
        this.nReadNanos = new LongStat(this.stats, BinaryProtocolStatDefinition.N_READ_NANOS);
        this.nWriteNanos = new LongStat(this.stats, BinaryProtocolStatDefinition.N_WRITE_NANOS);
        this.nBytesRead = new LongStat(this.stats, BinaryProtocolStatDefinition.N_BYTES_READ);
        this.nMessagesRead = new LongStat(this.stats, BinaryProtocolStatDefinition.N_MESSAGES_READ);
        this.nBytesWritten = new LongStat(this.stats, BinaryProtocolStatDefinition.N_BYTES_WRITTEN);
        this.nMessagesWritten = new LongStat(this.stats, BinaryProtocolStatDefinition.N_MESSAGES_WRITTEN);
        this.nEntriesWrittenOldVersion = new LongStat(this.stats, BinaryProtocolStatDefinition.N_ENTRIES_WRITTEN_OLD_VERSION);
        for (MessageOp op : new MessageOp[]{this.CLIENT_VERSION, this.SERVER_VERSION, this.INCOMPATIBLE_VERSION, this.PROTOCOL_ERROR}) {
            if (this.ops.put(op.opId, op) == null) continue;
            throw EnvironmentFailureException.unexpectedState("Duplicate op: " + op.opId);
        }
        this.predefinedMessageCount = this.ops.size();
        if (envImpl != null) {
            DbConfigManager configManager = envImpl.getConfigManager();
            long mMSz = configManager.getLong(RepParams.MAX_MESSAGE_SIZE);
            this.maxMessageSize = mMSz == 0L ? envImpl.getMemoryBudget().getMaxMemory() >> 1 : mMSz;
            this.useStringDefaultEncoding = configManager.getBoolean(RepParams.PROTOCOL_OLD_STRING_ENCODING);
        } else {
            this.maxMessageSize = 0x100000L;
            this.useStringDefaultEncoding = true;
        }
    }

    protected void initializeMessageOps(MessageOp[] protocolOps) {
        for (MessageOp op : protocolOps) {
            if (this.ops.put(op.opId, op) == null) continue;
            throw EnvironmentFailureException.unexpectedState("Duplicate op: " + op.opId);
        }
    }

    public int messageCount() {
        return this.ops.size();
    }

    public final int getPredefinedMessageCount() {
        return this.predefinedMessageCount;
    }

    public int getVersion() {
        return this.configuredVersion;
    }

    public StatGroup getStats(StatsConfig config) {
        StatGroup ret = this.stats.cloneGroup(config.getClear());
        return ret;
    }

    public void resetStats() {
        this.stats.clear();
    }

    private ByteBuffer allocateReadBuffer(int size) {
        if (size <= CACHED_BUFFER_SIZE) {
            this.cachedReadBuffer.rewind();
            this.cachedReadBuffer.limit(size);
            return this.cachedReadBuffer;
        }
        return ByteBuffer.allocate(size);
    }

    private ByteBuffer allocateWriteBuffer(int size) {
        if (size <= CACHED_BUFFER_SIZE) {
            this.cachedWriteBuffer.rewind();
            this.cachedWriteBuffer.limit(size);
            return this.cachedWriteBuffer;
        }
        return ByteBuffer.allocate(size);
    }

    public int stringSize(String s) {
        return this.stringToBytes(s).length + 4;
    }

    public void putString(String s, ByteBuffer buffer) {
        byte[] b = this.stringToBytes(s);
        LogUtils.writeInt(buffer, b.length);
        buffer.put(b);
    }

    public String getString(ByteBuffer buffer) {
        int length = LogUtils.readInt(buffer);
        byte[] b = new byte[length];
        buffer.get(b);
        return this.bytesToString(b);
    }

    private byte[] stringToBytes(String s) {
        if (this.useStringDefaultEncoding) {
            return s.getBytes();
        }
        return StringUtils.toUTF8(s);
    }

    private String bytesToString(byte[] b) {
        if (this.useStringDefaultEncoding) {
            return new String(b);
        }
        return StringUtils.fromUTF8(b);
    }

    private MessageOp getOp(ByteBuffer messageBuffer) {
        short opId = LogUtils.readShort(messageBuffer);
        MessageOp messageOp = this.ops.get(opId);
        if (messageOp == null) {
            throw EnvironmentFailureException.unexpectedState(this.envImpl, "Unknown message op id:" + opId + " Known op ids:" + Arrays.toString(this.ops.keySet().toArray()));
        }
        return messageOp;
    }

    private void fillBuffer(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        long start = System.nanoTime();
        assert (buffer.position() == 0);
        while (buffer.position() < buffer.limit()) {
            int numRead = channel.read(buffer);
            if (numRead > 0) continue;
            throw new IOException("Expected bytes: " + buffer.limit() + " read bytes: " + buffer.position());
        }
        this.nReadNanos.add(System.nanoTime() - start);
        buffer.flip();
    }

    public Message read(ReadableByteChannel channel) throws IOException {
        this.fillBuffer(channel, this.header);
        MessageOp op = this.getOp(this.header);
        try {
            Constructor<? extends Message> cons = op.getConstructor();
            int messageBodySize = LogUtils.readInt(this.header);
            this.nBytesRead.add(6 + messageBodySize);
            this.nMessagesRead.increment();
            if (messageBodySize > 0) {
                if ((long)messageBodySize > this.maxMessageSize) {
                    throw EnvironmentFailureException.unexpectedState("Message op: " + op + " Body size: " + messageBodySize + " is too large.  maxSizeAllowed: " + this.maxMessageSize + "\nIf a larger value is needed, set the " + "'je.rep.maxMessageSize' parameter.");
                }
                ByteBuffer body = this.allocateReadBuffer(messageBodySize);
                this.fillBuffer(channel, body);
                Message message = cons.newInstance(this, body);
                return message;
            }
            if (messageBodySize < 0) {
                throw EnvironmentFailureException.unexpectedState("Message op: " + op + " Body size: " + messageBodySize);
            }
            Message message = cons.newInstance(this, null);
            return message;
        }
        catch (InstantiationException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        catch (IllegalAccessException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        catch (SecurityException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        catch (InvocationTargetException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        finally {
            this.header.clear();
        }
    }

    public <T extends Message> T read(ReadableByteChannel channel, Class<T> cl) throws IOException, ProtocolException {
        Message message = this.read(channel);
        if (cl.isAssignableFrom(message.getClass())) {
            return (T)message;
        }
        throw new ProtocolException(message, cl);
    }

    public void write(Message message, NamedChannel namedChannel) throws IOException {
        this.write(message, namedChannel, namedChannel.getNameIdPair());
    }

    public void write(Message message, WritableByteChannel channel) throws IOException {
        this.write(message, channel, NameIdPair.NULL);
    }

    private void write(Message message, WritableByteChannel channel, NameIdPair destinationNameIdPair) throws IOException {
        ByteBuffer messageBuffer = message.wireFormat();
        this.nBytesWritten.add(6 + messageBuffer.limit() - messageBuffer.position());
        this.nMessagesWritten.increment();
        long start = System.nanoTime();
        while (messageBuffer.remaining() > 0) {
            int bytes = channel.write(messageBuffer);
            if (bytes != 0) continue;
            Thread.yield();
        }
        this.nWriteNanos.add(System.nanoTime() - start);
        if (this.logger.isLoggable(Level.FINER)) {
            if (destinationNameIdPair == NameIdPair.NULL) {
                LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINER, "Sent " + message + " to " + channel);
            } else {
                LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINER, "Sent to " + destinationNameIdPair.getName() + ": " + message);
            }
        }
        messageBuffer.rewind();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProtocolException
    extends InternalException {
        private final Message unexpectedMessage;
        private final Class<? extends Message> cl;

        public ProtocolException(Message unexpectedMessage, Class<? extends Message> cl) {
            this.unexpectedMessage = unexpectedMessage;
            this.cl = cl;
        }

        public ProtocolException(String message) {
            super(message);
            this.unexpectedMessage = null;
            this.cl = null;
        }

        @Override
        public String getMessage() {
            return this.unexpectedMessage != null ? "Expected message type: " + this.cl + " but found: " + this.unexpectedMessage.getClass() : super.getMessage();
        }

        public Message getUnexpectedMessage() {
            return this.unexpectedMessage;
        }
    }

    public class IncompatibleVersion
    extends RejectMessage {
        public IncompatibleVersion(String message) {
            super(message);
        }

        public IncompatibleVersion(ByteBuffer buffer) {
            super(buffer);
        }

        public MessageOp getOp() {
            return BinaryProtocol.this.INCOMPATIBLE_VERSION;
        }
    }

    public class ServerVersion
    extends ProtocolVersion {
        public ServerVersion() {
            super(BinaryProtocol.this.codeVersion);
        }

        public ServerVersion(ByteBuffer buffer) {
            super(buffer);
        }

        public MessageOp getOp() {
            return BinaryProtocol.this.SERVER_VERSION;
        }
    }

    public class ClientVersion
    extends ProtocolVersion {
        public ClientVersion() {
            super(BinaryProtocol.this.codeVersion);
        }

        public ClientVersion(ByteBuffer buffer) {
            super(buffer);
        }

        public MessageOp getOp() {
            return BinaryProtocol.this.CLIENT_VERSION;
        }
    }

    abstract class ProtocolVersion
    extends SimpleMessage {
        private final int version;
        private final int nodeId;

        public ProtocolVersion(int version) {
            this.version = version;
            this.nodeId = BinaryProtocol.this.nameIdPair.getId();
        }

        public ByteBuffer wireFormat() {
            return this.wireFormat(this.version, this.nodeId);
        }

        public ProtocolVersion(ByteBuffer buffer) {
            this.version = LogUtils.readInt(buffer);
            this.nodeId = LogUtils.readInt(buffer);
        }

        public int getVersion() {
            return this.version;
        }

        public int getNodeId() {
            return this.nodeId;
        }
    }

    public class ProtocolError
    extends RejectMessage {
        public ProtocolError(String errorMessage) {
            super(errorMessage);
        }

        public ProtocolError(ByteBuffer buffer) {
            super(buffer);
        }

        public MessageOp getOp() {
            return BinaryProtocol.this.PROTOCOL_ERROR;
        }
    }

    public abstract class RejectMessage
    extends SimpleMessage {
        protected String errorMessage;

        protected RejectMessage(String errorMessage) {
            this.errorMessage = errorMessage == null ? " " : errorMessage;
        }

        public ByteBuffer wireFormat() {
            return this.wireFormat(this.errorMessage);
        }

        public RejectMessage(ByteBuffer buffer) {
            this.errorMessage = BinaryProtocol.this.getString(buffer);
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String toString() {
            return this.errorMessage;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class SimpleMessage
    extends Message {
        protected SimpleMessage() {
        }

        protected ByteBuffer wireFormat(Object ... arguments) {
            int size = this.getMessageSize(arguments);
            ByteBuffer buffer = this.allocateInitializedBuffer(size);
            for (Object obj : arguments) {
                Class<?> cl = obj.getClass();
                if (cl == Long.class) {
                    LogUtils.writeLong(buffer, (Long)obj);
                    continue;
                }
                if (cl == Integer.class) {
                    LogUtils.writeInt(buffer, (Integer)obj);
                    continue;
                }
                if (cl == Short.class) {
                    LogUtils.writeShort(buffer, (Short)obj);
                    continue;
                }
                if (cl == Byte.class) {
                    buffer.put((Byte)obj);
                    continue;
                }
                if (cl == Boolean.class) {
                    buffer.put((Boolean)obj != false ? (byte)1 : 0);
                    continue;
                }
                if (cl == VLSN.class) {
                    LogUtils.writeLong(buffer, ((VLSN)obj).getSequence());
                    continue;
                }
                if (Enum.class.isAssignableFrom(cl)) {
                    Enum e = (Enum)obj;
                    BinaryProtocol.this.putString(e.name(), buffer);
                    continue;
                }
                if (cl == String.class) {
                    BinaryProtocol.this.putString((String)obj, buffer);
                    continue;
                }
                if (cl == Double.class) {
                    BinaryProtocol.this.putString(((Double)obj).toString(), buffer);
                    continue;
                }
                if (cl == String[].class) {
                    String[] sa = (String[])obj;
                    LogUtils.writeInt(buffer, sa.length);
                    for (String element : sa) {
                        BinaryProtocol.this.putString(element, buffer);
                    }
                    continue;
                }
                if (cl == byte[].class) {
                    this.putByteArray(buffer, (byte[])obj);
                    continue;
                }
                if (cl == RepNodeImpl[].class) {
                    this.putRepNodeImplArray(buffer, (RepNodeImpl[])obj);
                    continue;
                }
                if (obj instanceof NameIdPair) {
                    ((NameIdPair)obj).serialize(buffer, BinaryProtocol.this);
                    continue;
                }
                throw EnvironmentFailureException.unexpectedState("Unknow type: " + cl);
            }
            buffer.flip();
            return buffer;
        }

        private void putByteArray(ByteBuffer buffer, byte[] ba) {
            LogUtils.writeInt(buffer, ba.length);
            buffer.put(ba);
        }

        private void putRepNodeImplArray(ByteBuffer buffer, RepNodeImpl[] ra) {
            LogUtils.writeInt(buffer, ra.length);
            for (RepNodeImpl node : ra) {
                this.putByteArray(buffer, RepGroupImpl.serializeBytes(node));
            }
        }

        protected RepNodeImpl[] getRepNodeImplArray(ByteBuffer buffer) {
            RepNodeImpl[] ra = new RepNodeImpl[LogUtils.readInt(buffer)];
            for (int i = 0; i < ra.length; ++i) {
                ra[i] = RepGroupImpl.deserializeNode(this.getByteArray(buffer));
            }
            return ra;
        }

        private int getSize(RepNodeImpl[] ra) {
            int size = 4;
            for (RepNodeImpl node : ra) {
                size += 4 + RepGroupImpl.serializeBytes(node).length;
            }
            return size;
        }

        private int getMessageSize(Object ... arguments) {
            int size = 0;
            for (Object obj : arguments) {
                Class<?> cl = obj.getClass();
                if (cl == Long.class) {
                    size += 8;
                    continue;
                }
                if (cl == Integer.class) {
                    size += 4;
                    continue;
                }
                if (cl == Short.class) {
                    size += 2;
                    continue;
                }
                if (cl == Byte.class) {
                    ++size;
                    continue;
                }
                if (cl == Boolean.class) {
                    ++size;
                    continue;
                }
                if (cl == VLSN.class) {
                    size += 8;
                    continue;
                }
                if (Enum.class.isAssignableFrom(cl)) {
                    size += BinaryProtocol.this.stringSize(((Enum)obj).name());
                    continue;
                }
                if (cl == String.class) {
                    size += BinaryProtocol.this.stringSize((String)obj);
                    continue;
                }
                if (cl == Double.class) {
                    size += BinaryProtocol.this.stringSize(((Double)obj).toString());
                    continue;
                }
                if (cl == String[].class) {
                    String[] sa;
                    size += 4;
                    for (String element : sa = (String[])obj) {
                        size += BinaryProtocol.this.stringSize(element);
                    }
                    continue;
                }
                if (cl == byte[].class) {
                    size += 4 + ((byte[])obj).length;
                    continue;
                }
                if (cl == RepNodeImpl[].class) {
                    size += this.getSize((RepNodeImpl[])obj);
                    continue;
                }
                if (obj instanceof NameIdPair) {
                    size += ((NameIdPair)obj).serializedSize(BinaryProtocol.this);
                    continue;
                }
                throw EnvironmentFailureException.unexpectedState("Unknown type: " + cl);
            }
            return size;
        }

        protected String[] getStringArray(ByteBuffer buffer) {
            String[] sa = new String[LogUtils.readInt(buffer)];
            for (int i = 0; i < sa.length; ++i) {
                sa[i] = BinaryProtocol.this.getString(buffer);
            }
            return sa;
        }

        protected byte[] getByteArray(ByteBuffer buffer) {
            byte[] ba = new byte[LogUtils.readInt(buffer)];
            buffer.get(ba);
            return ba;
        }

        protected boolean getBoolean(ByteBuffer buffer) {
            byte b = buffer.get();
            if (b == 0) {
                return false;
            }
            if (b == 1) {
                return true;
            }
            throw EnvironmentFailureException.unexpectedState("Unknown boolean value: " + b);
        }

        protected VLSN getVLSN(ByteBuffer buffer) {
            long vlsn = LogUtils.readLong(buffer);
            return vlsn == VLSN.NULL_VLSN.getSequence() ? VLSN.NULL_VLSN : new VLSN(vlsn);
        }

        protected <T extends Enum<T>> T getEnum(Class<T> enumType, ByteBuffer buffer) {
            String enumName = BinaryProtocol.this.getString(buffer);
            return Enum.valueOf(enumType, enumName);
        }

        protected Double getDouble(ByteBuffer buffer) {
            return new Double(BinaryProtocol.this.getString(buffer));
        }

        protected NameIdPair getNameIdPair(ByteBuffer buffer) {
            return NameIdPair.deserialize(buffer, BinaryProtocol.this);
        }
    }

    public abstract class Message
    implements WireFormatable {
        public abstract MessageOp getOp();

        public ByteBuffer wireFormat() {
            ByteBuffer messageBuffer = this.allocateInitializedBuffer(0);
            messageBuffer.flip();
            return messageBuffer;
        }

        public String toString() {
            return this.getOp().toString();
        }

        public boolean match(Message other) {
            return Arrays.equals((byte[])this.wireFormat().array().clone(), (byte[])other.wireFormat().array().clone());
        }

        public ByteBuffer allocateInitializedBuffer(int size) {
            ByteBuffer messageBuffer = BinaryProtocol.this.allocateWriteBuffer(6 + size);
            LogUtils.writeShort(messageBuffer, this.getOp().getOpId());
            LogUtils.writeInt(messageBuffer, size);
            return messageBuffer;
        }
    }

    static interface WireFormatable {
        public ByteBuffer wireFormat();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MessageOp {
        private final short opId;
        private final Class<? extends Message> messageClass;
        private Constructor<? extends Message> constructor;
        private final String label;

        public MessageOp(short opId, Class<? extends Message> messageClass) {
            this.opId = opId;
            this.messageClass = messageClass;
            this.label = messageClass.getSimpleName();
            try {
                this.constructor = messageClass.getConstructor(messageClass.getEnclosingClass(), ByteBuffer.class);
            }
            catch (SecurityException e) {
                throw EnvironmentFailureException.unexpectedException(e);
            }
            catch (NoSuchMethodException e) {
                throw EnvironmentFailureException.unexpectedException(e);
            }
        }

        public short getOpId() {
            return this.opId;
        }

        Class<? extends Message> getMessageClass() {
            return this.messageClass;
        }

        public Constructor<? extends Message> getConstructor() {
            return this.constructor;
        }

        public String toString() {
            return this.label;
        }
    }
}

