/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.recovery.RecoveryManager;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.txn.LockAttemptResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.txn.TxnChain;
import com.sleepycat.je.txn.TxnManager;
import com.sleepycat.je.txn.UndoReader;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.VLSN;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplayTxn
extends Txn {
    private final long startTime = System.currentTimeMillis();
    private long endTime = 0L;
    private VLSN lastApplied = VLSN.NULL_VLSN;
    private boolean repGroupDbChange = false;
    private int masterNodeId;
    private Map<Long, ReplayTxn> activeTxns;
    private final Logger logger;

    public ReplayTxn(EnvironmentImpl envImpl, TransactionConfig config, long txnId, Map<Long, ReplayTxn> activeTxns, Logger logger) throws DatabaseException {
        this(envImpl, config, txnId, logger);
        this.registerWithActiveTxns(activeTxns);
    }

    public ReplayTxn(EnvironmentImpl envImpl, TransactionConfig config, long txnId, Logger logger) throws DatabaseException {
        super(envImpl, config, null, txnId);
        this.setImportunate(true);
        this.logger = logger;
    }

    @Override
    protected long getInitialLockTimeout() {
        return this.envImpl.getReplayTxnTimeout();
    }

    public boolean getRepGroupDbChange() {
        return this.repGroupDbChange;
    }

    public void noteRepGroupDbChange() {
        this.repGroupDbChange = true;
    }

    public void registerWithActiveTxns(Map<Long, ReplayTxn> newActiveTxns) {
        assert (this.activeTxns == null);
        this.activeTxns = newActiveTxns;
        this.activeTxns.put(this.getId(), this);
    }

    @Override
    protected long generateId(TxnManager txnManager, long mandatedId) {
        return mandatedId;
    }

    @Override
    protected int getReplicatorNodeId() {
        return this.masterNodeId;
    }

    public long commit(Durability.SyncPolicy syncPolicy, ReplicationContext clientRepContext, int commitMasterNodeId) throws DatabaseException {
        if (this.logger.isLoggable(Level.FINE)) {
            LoggerUtils.fine(this.logger, this.envImpl, "commit called for " + this.getId());
        }
        this.setRepContext(clientRepContext);
        Durability durability = null;
        if (syncPolicy == Durability.SyncPolicy.SYNC) {
            durability = Durability.COMMIT_SYNC;
        } else if (syncPolicy == Durability.SyncPolicy.NO_SYNC) {
            durability = Durability.COMMIT_NO_SYNC;
        } else if (syncPolicy == Durability.SyncPolicy.WRITE_NO_SYNC) {
            durability = Durability.COMMIT_WRITE_NO_SYNC;
        } else {
            throw EnvironmentFailureException.unexpectedState("Unknown sync policy: " + (Object)((Object)syncPolicy));
        }
        this.masterNodeId = commitMasterNodeId;
        long lsn = super.commit(durability);
        this.endTime = System.currentTimeMillis();
        return lsn;
    }

    @Override
    public long commit() {
        throw EnvironmentFailureException.unexpectedState("Replay Txn abort semantics require use of internal commit api");
    }

    @Override
    public long commit(Durability durability) {
        throw EnvironmentFailureException.unexpectedState("Replay Txn abort semantics require use of internal commit api");
    }

    @Override
    public void abort() {
        throw EnvironmentFailureException.unexpectedState("Replay Txn abort semantics require use of internal abort api");
    }

    @Override
    public long abort(boolean forceFlush) {
        throw EnvironmentFailureException.unexpectedState("Replay Txn abort semantics require use of internal abort api");
    }

    public long abort(ReplicationContext clientRepContext, int abortMasterNodeId) throws DatabaseException {
        this.setRepContext(clientRepContext);
        this.masterNodeId = abortMasterNodeId;
        long lsn = super.abort(false);
        this.endTime = System.currentTimeMillis();
        return lsn;
    }

    @Override
    protected boolean updateLoggedForTxn() {
        return true;
    }

    @Override
    public void close(boolean isCommit) throws DatabaseException {
        super.close(isCommit);
        if (this.activeTxns != null) {
            Txn removed = this.activeTxns.remove(this.getId());
            assert (removed != null) : "txn was not in map " + this + " " + LoggerUtils.getStackTrace();
        }
    }

    public void cleanup() throws DatabaseException {
        this.releaseWriteLocks();
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Long> rollback(long matchpointLsn) throws DatabaseException {
        ArrayList<Long> rollbackLsns = new ArrayList<Long>();
        LoggerUtils.finest(this.logger, this.envImpl, "Partial Rollback of " + this);
        ReplayTxn replayTxn = this;
        synchronized (replayTxn) {
            this.checkState(true);
            if (this.lastLoggedLsn == -1L) {
                return rollbackLsns;
            }
            if (DbLsn.compareTo(this.lastLoggedLsn, matchpointLsn) <= 0) {
                return rollbackLsns;
            }
            this.setRollback();
            this.undoWrites(matchpointLsn, rollbackLsns);
        }
        if (this.lastLoggedLsn == -1L) {
            try {
                this.cleanupDatabaseImpls(false);
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                this.close(false);
                throw throwable;
            }
            this.close(false);
            {
            }
        }
        if (this.openedDatabaseHandles != null) {
            throw EnvironmentFailureException.unexpectedState("Replay Txn " + this.getId() + " has a openedDatabaseHandles");
        }
        return rollbackLsns;
    }

    private void undoWrites(long matchpointLsn, List<Long> rollbackLsns) throws DatabaseException {
        TreeLocation location = new TreeLocation();
        Long undoLsn = this.lastLoggedLsn;
        TxnChain chain = new TxnChain(undoLsn, this.id, matchpointLsn, this.undoDatabases, this.envImpl);
        try {
            while (undoLsn != -1L && DbLsn.compareTo(undoLsn, matchpointLsn) > 0) {
                UndoReader undo = UndoReader.create(this.envImpl, undoLsn, this.undoDatabases);
                TxnChain.RevertInfo revertTo = chain.pop();
                this.logFinest(undoLsn, undo, revertTo);
                RecoveryManager.rollbackUndo(this.logger, Level.FINER, undo, revertTo, location, undoLsn);
                this.countObsoleteInexact(undoLsn, undo);
                rollbackLsns.add(undoLsn);
                undoLsn = undo.logEntry.getUserTxn().getLastLsn();
                this.lastLoggedLsn = undoLsn;
            }
            this.lastApplied = chain.getLastValidVLSN();
            if (!this.updateLoggedForTxn()) {
                this.firstLoggedLsn = -1L;
            }
        }
        catch (DatabaseException e) {
            LoggerUtils.traceAndLogException(this.envImpl, "Txn", "undo", "For LSN=" + DbLsn.getNoFormatString(undoLsn), e);
            throw e;
        }
        catch (RuntimeException e) {
            throw EnvironmentFailureException.unexpectedException("Txn undo for LSN=" + DbLsn.getNoFormatString(undoLsn), (Exception)e);
        }
        if (this.lastLoggedLsn == -1L) {
            this.setDeletedDatabaseState(false);
        }
        this.clearWriteLocks(chain.getRemainingLockedNodes());
    }

    private void countObsoleteInexact(long undoLsn, UndoReader undo) {
        if (undo.ln.isDeleted()) {
            return;
        }
        this.envImpl.getLogManager().countObsoleteNode(undoLsn, null, undo.ln.getLastLoggedSize(), undo.db, false);
    }

    public long elapsedTime() {
        return (this.endTime > 0L ? this.endTime : System.currentTimeMillis()) - this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setLastAppliedVLSN(VLSN justApplied) {
        if (justApplied.compareTo(this.lastApplied) <= 0) {
            throw EnvironmentFailureException.unexpectedState("Txn " + this.getId() + " attempted VLSN = " + justApplied + " txnLastApplied = " + this.lastApplied);
        }
        this.lastApplied = justApplied;
    }

    public void setRepContext(ReplicationContext repContext) {
        this.repContext = repContext;
    }

    private void logFinest(long lsn, UndoReader undo, TxnChain.RevertInfo revertTo) {
        if (this.logger != null && this.logger.isLoggable(Level.FINEST)) {
            LoggerUtils.finest(this.logger, this.envImpl, "undoLsn=" + DbLsn.getNoFormatString(lsn) + " undo=" + undo + " revertInfo=" + revertTo);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("<ReplayTxn id=\"");
        sb.append(this.id);
        sb.append("\">");
        sb.append(super.toString());
        return sb.toString();
    }

    @Override
    public boolean isReplicationDefined() {
        return true;
    }

    public void copyDatabasesForConversion(Txn masterTxn) {
        if (masterTxn.getUndoDatabases() != null) {
            if (this.undoDatabases == null) {
                this.undoDatabases = new HashMap();
            }
            this.undoDatabases.putAll(masterTxn.getUndoDatabases());
        }
        if (masterTxn.getDeletedDatabases() != null) {
            if (this.deletedDatabases == null) {
                this.deletedDatabases = new HashSet();
            }
            this.deletedDatabases.addAll(masterTxn.getDeletedDatabases());
        }
    }

    public void stealLockFromMasterTxn(Long lsn) {
        LockAttemptResult result = this.lockManager.stealLock(lsn, this, LockType.WRITE);
        if (!result.success) {
            throw EnvironmentFailureException.unexpectedState(this.envImpl, "Transferring from master to replica state, txn " + this.getId() + " was unable to transfer lock for " + DbLsn.getNoFormatString(lsn) + ", lock grant type=" + (Object)((Object)result.lockGrant));
        }
        this.addLock((long)lsn, LockType.WRITE, result.lockGrant);
        this.addLogInfo(lsn);
    }
}

