/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.DatabaseStats;
import com.sleepycat.je.dbi.BTreeStatDefinition;
import com.sleepycat.je.utilint.StatGroup;

public class BtreeStats
extends DatabaseStats {
    private static final long serialVersionUID = 298825033L;
    private StatGroup dbImplStats = new StatGroup("BTree", "Composition of btree, types and counts of nodes.");
    private StatGroup treeStats = new StatGroup("BTree", "Composition of btree, types and counts of nodes.");

    public void setDbImplStats(StatGroup stats) {
        this.dbImplStats = stats;
    }

    public void setTreeStats(StatGroup tStats) {
        this.treeStats = tStats;
    }

    public long getBottomInternalNodeCount() {
        return this.dbImplStats.getLong(BTreeStatDefinition.BTREE_BIN_COUNT);
    }

    public long getDuplicateBottomInternalNodeCount() {
        return 0L;
    }

    public long getDeletedLeafNodeCount() {
        return this.dbImplStats.getLong(BTreeStatDefinition.BTREE_DELETED_LN_COUNT);
    }

    public long getDupCountLeafNodeCount() {
        return 0L;
    }

    public long getInternalNodeCount() {
        return this.dbImplStats.getLong(BTreeStatDefinition.BTREE_IN_COUNT);
    }

    public long getDuplicateInternalNodeCount() {
        return 0L;
    }

    public long getLeafNodeCount() {
        return this.dbImplStats.getLong(BTreeStatDefinition.BTREE_LN_COUNT);
    }

    public int getMainTreeMaxDepth() {
        return this.dbImplStats.getInt(BTreeStatDefinition.BTREE_MAINTREE_MAXDEPTH);
    }

    public int getDuplicateTreeMaxDepth() {
        return 0;
    }

    public long[] getINsByLevel() {
        return this.dbImplStats.getLongArray(BTreeStatDefinition.BTREE_INS_BYLEVEL);
    }

    public long[] getBINsByLevel() {
        return this.dbImplStats.getLongArray(BTreeStatDefinition.BTREE_BINS_BYLEVEL);
    }

    public long[] getBINEntriesHistogram() {
        return this.dbImplStats.getLongArray(BTreeStatDefinition.BTREE_BIN_ENTRIES_HISTOGRAM);
    }

    public long[] getDINsByLevel() {
        return new long[0];
    }

    public long[] getDBINsByLevel() {
        return new long[0];
    }

    public long getRelatches() {
        return this.treeStats.getLong(BTreeStatDefinition.BTREE_RELATCHES_REQUIRED);
    }

    public int getRootSplits() {
        return this.treeStats.getInt(BTreeStatDefinition.BTREE_ROOT_SPLITS);
    }

    public String toString() {
        return this.dbImplStats.toString() + "\n" + this.treeStats.toString();
    }

    public String toStringVerbose() {
        return this.dbImplStats.toStringVerbose() + "\n" + this.treeStats.toStringVerbose();
    }
}

