/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.ExceptionListener;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.CleanerStatDefinition;
import com.sleepycat.je.cleaner.FileProcessor;
import com.sleepycat.je.cleaner.FileSelector;
import com.sleepycat.je.cleaner.LNInfo;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DaemonRunner;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.ExceptionListenerUser;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.VLSN;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Cleaner
implements DaemonRunner,
EnvConfigObserver,
ExceptionListenerUser {
    static final String CLEAN_IN = "CleanIN:";
    static final String CLEAN_LN = "CleanLN:";
    static final String CLEAN_MIGRATE_LN = "CleanMigrateLN:";
    static final String CLEAN_PENDING_LN = "CleanPendingLN:";
    static final CacheMode UPDATE_GENERATION = CacheMode.UNCHANGED;
    static final boolean DO_CRITICAL_EVICTION = true;
    StatGroup stats;
    LongStat nCleanerRuns;
    LongStat nCleanerDeletions;
    LongStat nINsObsolete;
    LongStat nINsCleaned;
    LongStat nINsDead;
    LongStat nINsMigrated;
    LongStat nLNsObsolete;
    LongStat nLNsCleaned;
    LongStat nLNsDead;
    LongStat nLNsLocked;
    LongStat nLNsMigrated;
    LongStat nLNsMarked;
    LongStat nLNQueueHits;
    LongStat nPendingLNsProcessed;
    LongStat nMarkedLNsProcessed;
    LongStat nToBeCleanedLNsProcessed;
    LongStat nClusterLNsProcessed;
    LongStat nPendingLNsLocked;
    LongStat nEntriesRead;
    LongStat nRepeatIteratorReads;
    LongStat totalLogSize;
    long lockTimeout;
    int readBufferSize;
    int lookAheadCacheSize;
    long nDeadlockRetries;
    boolean expunge;
    boolean clusterResident;
    boolean clusterAll;
    int maxBatchFiles;
    long cleanerBytesInterval;
    boolean trackDetail;
    boolean fetchObsoleteSize;
    boolean lazyMigration;
    private boolean foregroundProactiveMigration;
    private boolean backgroundProactiveMigration;
    private Set<Long> toBeCleanedFiles = Collections.emptySet();
    private Set<Long> lowUtilizationFiles = Collections.emptySet();
    private final String name;
    private final EnvironmentImpl env;
    private final UtilizationProfile profile;
    private final UtilizationTracker tracker;
    private final FileSelector fileSelector;
    private FileProcessor[] threads;
    private final List<Long> protectedFileRanges;
    private long lastCleanerBarrierStartFile;
    private final Logger logger;

    public Cleaner(EnvironmentImpl env, String name) throws DatabaseException {
        this.env = env;
        this.name = name;
        this.stats = new StatGroup("Cleaning", "Frequency and extent of log file cleaning activity.");
        this.nCleanerRuns = new LongStat(this.stats, CleanerStatDefinition.CLEANER_RUNS);
        this.nCleanerDeletions = new LongStat(this.stats, CleanerStatDefinition.CLEANER_DELETIONS);
        this.nINsObsolete = new LongStat(this.stats, CleanerStatDefinition.CLEANER_INS_OBSOLETE);
        this.nINsCleaned = new LongStat(this.stats, CleanerStatDefinition.CLEANER_INS_CLEANED);
        this.nINsDead = new LongStat(this.stats, CleanerStatDefinition.CLEANER_INS_DEAD);
        this.nINsMigrated = new LongStat(this.stats, CleanerStatDefinition.CLEANER_INS_MIGRATED);
        this.nLNsObsolete = new LongStat(this.stats, CleanerStatDefinition.CLEANER_LNS_OBSOLETE);
        this.nLNsCleaned = new LongStat(this.stats, CleanerStatDefinition.CLEANER_LNS_CLEANED);
        this.nLNsDead = new LongStat(this.stats, CleanerStatDefinition.CLEANER_LNS_DEAD);
        this.nLNsLocked = new LongStat(this.stats, CleanerStatDefinition.CLEANER_LNS_LOCKED);
        this.nLNsMigrated = new LongStat(this.stats, CleanerStatDefinition.CLEANER_LNS_MIGRATED);
        this.nLNsMarked = new LongStat(this.stats, CleanerStatDefinition.CLEANER_LNS_MARKED);
        this.nLNQueueHits = new LongStat(this.stats, CleanerStatDefinition.CLEANER_LNQUEUE_HITS);
        this.nPendingLNsProcessed = new LongStat(this.stats, CleanerStatDefinition.CLEANER_PENDING_LNS_PROCESSED);
        this.nMarkedLNsProcessed = new LongStat(this.stats, CleanerStatDefinition.CLEANER_MARKED_LNS_PROCESSED);
        this.nToBeCleanedLNsProcessed = new LongStat(this.stats, CleanerStatDefinition.CLEANER_TO_BE_CLEANED_LNS_PROCESSED);
        this.nClusterLNsProcessed = new LongStat(this.stats, CleanerStatDefinition.CLEANER_CLUSTER_LNS_PROCESSED);
        this.nPendingLNsLocked = new LongStat(this.stats, CleanerStatDefinition.CLEANER_PENDING_LNS_LOCKED);
        this.nEntriesRead = new LongStat(this.stats, CleanerStatDefinition.CLEANER_ENTRIES_READ);
        this.nRepeatIteratorReads = new LongStat(this.stats, CleanerStatDefinition.CLEANER_REPEAT_ITERATOR_READS);
        this.totalLogSize = new LongStat(this.stats, CleanerStatDefinition.CLEANER_TOTAL_LOG_SIZE);
        this.tracker = new UtilizationTracker(env, this);
        this.profile = new UtilizationProfile(env, this.tracker);
        this.fileSelector = new FileSelector();
        this.threads = new FileProcessor[0];
        this.protectedFileRanges = new LinkedList<Long>();
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.trackDetail = env.getConfigManager().getBoolean(EnvironmentParams.CLEANER_TRACK_DETAIL);
        this.envConfigUpdate(env.getConfigManager(), null);
        env.addConfigObserver(this);
        env.registerExceptionListenerUser(this);
    }

    public void envConfigUpdate(DbConfigManager cm, EnvironmentMutableConfig ignore) throws DatabaseException {
        this.lockTimeout = cm.getDuration(EnvironmentParams.CLEANER_LOCK_TIMEOUT);
        this.readBufferSize = cm.getInt(EnvironmentParams.CLEANER_READ_SIZE);
        if (this.readBufferSize <= 0) {
            this.readBufferSize = cm.getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        }
        this.lookAheadCacheSize = cm.getInt(EnvironmentParams.CLEANER_LOOK_AHEAD_CACHE_SIZE);
        this.foregroundProactiveMigration = cm.getBoolean(EnvironmentParams.CLEANER_FOREGROUND_PROACTIVE_MIGRATION);
        this.backgroundProactiveMigration = cm.getBoolean(EnvironmentParams.CLEANER_BACKGROUND_PROACTIVE_MIGRATION);
        this.nDeadlockRetries = cm.getInt(EnvironmentParams.CLEANER_DEADLOCK_RETRY);
        this.expunge = cm.getBoolean(EnvironmentParams.CLEANER_REMOVE);
        this.clusterResident = cm.getBoolean(EnvironmentParams.CLEANER_CLUSTER);
        this.clusterAll = cm.getBoolean(EnvironmentParams.CLEANER_CLUSTER_ALL);
        this.maxBatchFiles = cm.getInt(EnvironmentParams.CLEANER_MAX_BATCH_FILES);
        if (this.clusterResident && this.clusterAll) {
            throw new IllegalArgumentException("Both " + EnvironmentParams.CLEANER_CLUSTER + " and " + EnvironmentParams.CLEANER_CLUSTER_ALL + " may not be set to true.");
        }
        int nThreads = cm.getInt(EnvironmentParams.CLEANER_THREADS);
        assert (nThreads > 0);
        if (nThreads != this.threads.length) {
            int i;
            for (int i2 = nThreads; i2 < this.threads.length; ++i2) {
                if (this.threads[i2] == null) continue;
                this.threads[i2].shutdown();
                this.threads[i2] = null;
            }
            FileProcessor[] newThreads = new FileProcessor[nThreads];
            for (i = 0; i < nThreads && i < this.threads.length; ++i) {
                newThreads[i] = this.threads[i];
            }
            this.threads = newThreads;
            for (i = 0; i < nThreads; ++i) {
                if (this.threads[i] != null) continue;
                this.threads[i] = new FileProcessor(this.name + '-' + (i + 1), this.env, this, this.profile, this.fileSelector);
            }
        }
        this.cleanerBytesInterval = cm.getLong(EnvironmentParams.CLEANER_BYTES_INTERVAL);
        if (this.cleanerBytesInterval == 0L) {
            this.cleanerBytesInterval = cm.getLong(EnvironmentParams.LOG_FILE_MAX) / 4L;
        }
        this.fetchObsoleteSize = cm.getBoolean(EnvironmentParams.CLEANER_FETCH_OBSOLETE_SIZE);
        this.lazyMigration = cm.getBoolean(EnvironmentParams.CLEANER_LAZY_MIGRATION) && !cm.getBoolean(EnvironmentParams.CHECKPOINTER_HIGH_PRIORITY);
    }

    public UtilizationTracker getUtilizationTracker() {
        return this.tracker;
    }

    public UtilizationProfile getUtilizationProfile() {
        return this.profile;
    }

    public FileSelector getFileSelector() {
        return this.fileSelector;
    }

    public boolean getFetchObsoleteSize() {
        return this.fetchObsoleteSize;
    }

    public void runOrPause(boolean run) {
        if (!this.env.isNoLocking()) {
            for (FileProcessor processor : this.threads) {
                if (processor == null) continue;
                processor.runOrPause(run);
            }
        }
    }

    public void wakeup() {
        for (FileProcessor thread : this.threads) {
            if (thread == null) continue;
            thread.wakeup();
        }
    }

    public void requestShutdown() {
        for (FileProcessor thread : this.threads) {
            if (thread == null) continue;
            thread.requestShutdown();
        }
    }

    public void shutdown() {
        for (int i = 0; i < this.threads.length; ++i) {
            if (this.threads[i] == null) continue;
            this.threads[i].shutdown();
            this.threads[i].clearEnv();
            this.threads[i] = null;
        }
    }

    public int getNWakeupRequests() {
        int count = 0;
        for (FileProcessor thread : this.threads) {
            if (thread == null) continue;
            count += thread.getNWakeupRequests();
        }
        return count;
    }

    private boolean areThreadsRunning() {
        for (FileProcessor thread : this.threads) {
            if (thread == null) continue;
            return thread.isRunning();
        }
        return false;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        for (FileProcessor thread : this.threads) {
            if (thread == null) continue;
            thread.setExceptionListener(exceptionListener);
        }
    }

    public int doClean(boolean cleanMultipleFiles, boolean forceCleaning) throws DatabaseException {
        FileProcessor processor = new FileProcessor("", this.env, this, this.profile, this.fileSelector);
        return processor.doClean(false, cleanMultipleFiles, forceCleaning);
    }

    public StatGroup loadStats(StatsConfig config) {
        if (!config.getFast()) {
            this.totalLogSize.set(this.profile.getTotalLogSize());
        }
        StatGroup copyStats = this.stats.cloneGroup(config.getClear());
        copyStats.addAll(this.fileSelector.loadStats());
        return copyStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void deleteSafeToDeleteFiles() throws DatabaseException {
        FileManager fileManager;
        Object fileNum;
        this.env.checkIfInvalid();
        if (this.env.mayNotWrite()) {
            return;
        }
        SortedSet<Long> safeToDeleteFiles = this.fileSelector.copySafeToDeleteFiles();
        if (safeToDeleteFiles == null) {
            return;
        }
        long minProtectedFile = this.env.getCleanerBarrierStartFile();
        if (minProtectedFile == -1L) {
            return;
        }
        if (this.lastCleanerBarrierStartFile > minProtectedFile) {
            throw EnvironmentFailureException.unexpectedState("CBVLSN file has moved backward, prevValue=" + this.lastCleanerBarrierStartFile + " newValue=" + minProtectedFile);
        }
        this.lastCleanerBarrierStartFile = minProtectedFile;
        SortedSet<Long> unprotectedFiles = safeToDeleteFiles.headSet(minProtectedFile);
        if (unprotectedFiles.isEmpty()) {
            LoggerUtils.traceAndLog(this.logger, this.env, Level.WARNING, "Cleaner has " + safeToDeleteFiles.size() + " files not deleted because they are " + "protected by replication.");
            return;
        }
        Long[] unprotectedFilesArray = unprotectedFiles.toArray(new Long[0]);
        for (int i = unprotectedFilesArray.length - 1; i >= 0; --i) {
            fileNum = unprotectedFilesArray[i];
            VLSN lastVlsn = this.fileSelector.getLastVLSN((Long)fileNum);
            if (lastVlsn == null || lastVlsn.isNull()) continue;
            this.env.vlsnHeadTruncate(lastVlsn, (Long)fileNum);
            break;
        }
        if (!(fileManager = this.env.getFileManager()).lockEnvironment(false, true)) {
            LoggerUtils.traceAndLog(this.logger, this.env, Level.WARNING, "Cleaner has " + safeToDeleteFiles.size() + " files not deleted because of read-only" + " processes.");
            return;
        }
        try {
            fileNum = this.protectedFileRanges;
            synchronized (fileNum) {
                if (!this.protectedFileRanges.isEmpty()) {
                    unprotectedFiles = unprotectedFiles.headSet(Collections.min(this.protectedFileRanges));
                }
                Iterator iter = unprotectedFiles.iterator();
                while (iter.hasNext()) {
                    boolean deleted;
                    Long fileNum2 = (Long)iter.next();
                    try {
                        deleted = this.expunge ? fileManager.deleteFile(fileNum2) : fileManager.renameFile(fileNum2, ".del");
                    }
                    catch (IOException e) {
                        throw new EnvironmentFailureException(this.env, EnvironmentFailureReason.LOG_WRITE, "Unable to delete or rename " + fileNum2, e);
                    }
                    if (deleted) {
                        LoggerUtils.traceAndLog(this.logger, this.env, Level.FINE, "Cleaner deleted file 0x" + Long.toHexString(fileNum2));
                        continue;
                    }
                    if (!fileManager.isFileValid(fileNum2)) {
                        LoggerUtils.traceAndLog(this.logger, this.env, Level.SEVERE, "Cleaner deleteSafeToDeleteFiles Log file 0x" + Long.toHexString(fileNum2) + " was previously " + (this.expunge ? "deleted" : "renamed") + ".  State: " + this.fileSelector);
                        continue;
                    }
                    iter.remove();
                    LoggerUtils.traceAndLog(this.logger, this.env, Level.WARNING, "Cleaner deleteSafeToDeleteFiles Log file 0x" + Long.toHexString(fileNum2) + " could not be " + (this.expunge ? "deleted" : "renamed") + ". This " + "operation will be retried at the next " + "checkpoint. State: " + this.fileSelector);
                }
            }
        }
        finally {
            fileManager.releaseExclusiveLock();
        }
        for (Long fileNum3 : unprotectedFiles) {
            try {
                this.profile.removeFile(fileNum3, this.fileSelector.getCleanedDatabases(fileNum3));
            }
            finally {
                this.fileSelector.removeDeletedFile(fileNum3, this.env.getMemoryBudget());
            }
            this.nCleanerDeletions.increment();
        }
        if (safeToDeleteFiles.size() > unprotectedFiles.size()) {
            LoggerUtils.traceAndLog(this.logger, this.env, Level.WARNING, "Cleaner has " + (safeToDeleteFiles.size() - unprotectedFiles.size()) + " files not deleted because they are protected by DbBackup " + "or replication.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProtectedFileRange(long firstProtectedFile) {
        List<Long> list = this.protectedFileRanges;
        synchronized (list) {
            this.protectedFileRanges.add(firstProtectedFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProtectedFileRange(long firstProtectedFile) {
        List<Long> list = this.protectedFileRanges;
        synchronized (list) {
            if (!this.protectedFileRanges.remove(firstProtectedFile)) {
                throw EnvironmentFailureException.unexpectedState("File range starting with 0x" + Long.toHexString(firstProtectedFile) + " is not currently protected");
            }
        }
    }

    public FileSelector.CheckpointStartCleanerState getFilesAtCheckpointStart() throws DatabaseException {
        this.processPending();
        return this.fileSelector.getFilesAtCheckpointStart();
    }

    public void updateFilesAtCheckpointEnd(FileSelector.CheckpointStartCleanerState info) throws DatabaseException {
        this.fileSelector.updateFilesAtCheckpointEnd(info);
        this.deleteSafeToDeleteFiles();
    }

    public void updateReadOnlyFileCollections() {
        this.toBeCleanedFiles = this.fileSelector.getToBeCleanedFiles();
        this.lowUtilizationFiles = this.fileSelector.getLowUtilizationFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processPending() throws DatabaseException {
        DatabaseId[] pendingDBs;
        DbTree dbMapTree = this.env.getDbTree();
        LNInfo[] pendingLNs = this.fileSelector.getPendingLNs();
        if (pendingLNs != null) {
            TreeLocation location = new TreeLocation();
            for (LNInfo info : pendingLNs) {
                DatabaseId dbId = info.getDbId();
                DatabaseImpl db = dbMapTree.getDb(dbId, this.lockTimeout);
                try {
                    byte[] key = info.getKey();
                    byte[] dupKey = info.getDupKey();
                    LN ln = info.getLN();
                    this.env.daemonEviction(true);
                    this.processPendingLN(ln, db, key, dupKey, location);
                }
                finally {
                    dbMapTree.releaseDb(db);
                }
                this.env.sleepAfterBackgroundIO();
            }
        }
        if ((pendingDBs = this.fileSelector.getPendingDBs()) != null) {
            for (DatabaseId dbId : pendingDBs) {
                DatabaseImpl db = dbMapTree.getDb(dbId, this.lockTimeout);
                try {
                    if (db != null && !db.isDeleteFinished()) continue;
                    this.fileSelector.removePendingDB(dbId);
                }
                finally {
                    dbMapTree.releaseDb(db);
                }
            }
        }
    }

    private void processPendingLN(LN ln, DatabaseImpl db, byte[] key, byte[] dupKey, TreeLocation location) throws DatabaseException {
        boolean parentFound = false;
        boolean processedHere = true;
        boolean lockDenied = false;
        boolean obsolete = false;
        boolean completed = false;
        Locker locker = null;
        IN bin = null;
        IN parentDIN = null;
        try {
            this.nPendingLNsProcessed.increment();
            if (db == null || db.isDeleted()) {
                this.addPendingDB(db);
                this.nLNsDead.increment();
                obsolete = true;
                completed = true;
                return;
            }
            Tree tree = db.getTree();
            assert (tree != null);
            locker = BasicLocker.createBasicLocker(this.env, false);
            locker.setPreemptable(false);
            LockResult lockRet = locker.nonBlockingLock(ln.getNodeId(), LockType.READ, db);
            if (lockRet.getLockGrant() == LockGrantType.DENIED) {
                this.nPendingLNsLocked.increment();
                lockDenied = true;
                completed = true;
                return;
            }
            parentFound = tree.getParentBINForChildLN(location, key, dupKey, ln, false, true, true, UPDATE_GENERATION);
            bin = location.bin;
            int index = location.index;
            if (!parentFound) {
                this.nLNsDead.increment();
                obsolete = true;
                completed = true;
                return;
            }
            if (ln.containsDuplicates()) {
                parentDIN = (DIN)((BIN)bin).fetchTarget(index);
                parentDIN.latch(UPDATE_GENERATION);
                ChildReference dclRef = ((DIN)parentDIN).getDupCountLNRef();
                processedHere = false;
                this.migrateDupCountLN(db, dclRef.getLsn(), (DIN)parentDIN, dclRef, true, true, ln.getNodeId(), CLEAN_PENDING_LN);
            } else {
                processedHere = false;
                this.migrateLN(db, bin.getLsn(index), (BIN)bin, index, true, true, ln.getNodeId(), true, CLEAN_PENDING_LN);
            }
            completed = true;
        }
        catch (DatabaseException DBE) {
            DBE.printStackTrace();
            LoggerUtils.traceAndLogException(this.env, "com.sleepycat.je.cleaner.Cleaner", "processLN", "Exception thrown: ", DBE);
            throw DBE;
        }
        finally {
            if (parentDIN != null) {
                parentDIN.releaseLatch();
            }
            if (bin != null) {
                bin.releaseLatch();
            }
            if (locker != null) {
                locker.operationEnd();
            }
            if (processedHere) {
                if (completed && !lockDenied) {
                    this.fileSelector.removePendingLN(ln.getNodeId());
                }
                this.logFine(CLEAN_PENDING_LN, ln, -1L, completed, obsolete, false);
            }
        }
    }

    public boolean isEvictable(BIN bin, int index) {
        if (bin.getDirty()) {
            if (bin.getMigrate(index)) {
                return false;
            }
            long lsn = bin.getLsn(index);
            if (lsn == -1L) {
                return true;
            }
            boolean isResident = bin.getTarget(index) != null;
            Long fileNum = DbLsn.getFileNumber(lsn);
            if ((this.foregroundProactiveMigration || isResident) && this.toBeCleanedFiles.contains(fileNum)) {
                return false;
            }
            if ((this.clusterAll || this.clusterResident && isResident) && this.lowUtilizationFiles.contains(fileNum)) {
                return false;
            }
        }
        return true;
    }

    public void lazyMigrateLNs(final BIN bin, boolean backgroundIO) throws DatabaseException {
        DatabaseImpl db = bin.getDatabase();
        boolean isBinInDupDb = db.getSortedDuplicates() && !bin.containsDuplicates();
        Integer[] sortedIndices = null;
        int nSortedIndices = 0;
        int nEntries = bin.getNEntries();
        for (int index = 0; index < nEntries; ++index) {
            boolean migrateFlag = bin.getMigrate(index);
            boolean isResident = bin.getTarget(index) != null;
            long childLsn = bin.getLsn(index);
            if (childLsn == -1L || !this.shouldMigrateLN(migrateFlag, isResident, backgroundIO, isBinInDupDb, childLsn)) continue;
            if (isResident) {
                this.migrateLN(db, childLsn, bin, index, migrateFlag, false, 0L, backgroundIO, CLEAN_MIGRATE_LN);
                continue;
            }
            if (sortedIndices == null) {
                sortedIndices = new Integer[nEntries];
            }
            sortedIndices[nSortedIndices++] = index;
        }
        if (sortedIndices != null) {
            Arrays.sort(sortedIndices, 0, nSortedIndices, new Comparator<Integer>(){

                @Override
                public int compare(Integer int1, Integer int2) {
                    return DbLsn.compareTo(bin.getLsn(int1), bin.getLsn(int2));
                }
            });
            for (int i = 0; i < nSortedIndices; ++i) {
                int index = sortedIndices[i].intValue();
                long childLsn = bin.getLsn(index);
                boolean migrateFlag = bin.getMigrate(index);
                this.migrateLN(db, childLsn, bin, index, migrateFlag, false, 0L, backgroundIO, CLEAN_MIGRATE_LN);
            }
        }
    }

    public void lazyMigrateDupCountLN(DIN din, ChildReference dclRef, boolean backgroundIO) throws DatabaseException {
        long childLsn;
        boolean isBinInDupDb;
        boolean isResident;
        DatabaseImpl db = din.getDatabase();
        boolean migrateFlag = dclRef.getMigrate();
        if (this.shouldMigrateLN(migrateFlag, isResident = dclRef.getTarget() != null, backgroundIO, isBinInDupDb = false, childLsn = dclRef.getLsn())) {
            this.migrateDupCountLN(db, childLsn, din, dclRef, migrateFlag, false, 0L, CLEAN_MIGRATE_LN);
        }
    }

    private boolean shouldMigrateLN(boolean migrateFlag, boolean isResident, boolean backgroundIO, boolean isBinInDupDb, long childLsn) {
        if (migrateFlag) {
            this.nMarkedLNsProcessed.increment();
            return true;
        }
        if (isBinInDupDb || this.env.isClosing()) {
            return false;
        }
        Long fileNum = DbLsn.getFileNumber(childLsn);
        if ((isResident || (backgroundIO ? this.backgroundProactiveMigration : this.foregroundProactiveMigration)) && this.toBeCleanedFiles.contains(fileNum)) {
            this.nToBeCleanedLNsProcessed.increment();
            return true;
        }
        if ((this.clusterAll || this.clusterResident && isResident) && this.lowUtilizationFiles.contains(fileNum)) {
            this.nClusterLNsProcessed.increment();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void migrateLN(DatabaseImpl db, long lsn, BIN bin, int index, boolean wasCleaned, boolean isPending, long lockedPendingNodeId, boolean backgroundIO, String cleanAction) throws DatabaseException {
        LN ln;
        Locker locker;
        boolean clearTarget;
        boolean completed;
        boolean lockDenied;
        boolean migrated;
        boolean obsolete;
        block66: {
            block65: {
                block64: {
                    block63: {
                        block62: {
                            block61: {
                                block60: {
                                    obsolete = false;
                                    migrated = false;
                                    lockDenied = false;
                                    completed = false;
                                    clearTarget = false;
                                    locker = null;
                                    ln = null;
                                    try {
                                        Long fileNum;
                                        if (lsn == -1L) {
                                            completed = true;
                                            Object var23_17 = null;
                                            if (!isPending) break block60;
                                            if (completed && !lockDenied) {
                                                this.fileSelector.removePendingLN(lockedPendingNodeId);
                                            }
                                            break block61;
                                        }
                                        if (!bin.isEntryKnownDeleted(index) && (ln = (LN)bin.getTarget(index)) == null) {
                                            ln = (LN)bin.fetchTarget(index);
                                            boolean bl = clearTarget = !db.getId().equals(DbTree.ID_DB_ID);
                                        }
                                        if (ln == null) {
                                            if (wasCleaned) {
                                                this.nLNsDead.increment();
                                            }
                                            obsolete = true;
                                            completed = true;
                                            break block62;
                                        }
                                        if (lockedPendingNodeId != ln.getNodeId()) {
                                            locker = BasicLocker.createBasicLocker(this.env, false);
                                            locker.setPreemptable(false);
                                            LockResult lockRet = locker.nonBlockingLock(ln.getNodeId(), LockType.READ, db);
                                            if (lockRet.getLockGrant() == LockGrantType.DENIED) {
                                                if (wasCleaned) {
                                                    this.nLNsLocked.increment();
                                                }
                                                lockDenied = true;
                                                completed = true;
                                                break block63;
                                            }
                                        }
                                        if (ln.isDeleted()) {
                                            bin.setKnownDeletedLeaveTarget(index);
                                            if (wasCleaned) {
                                                this.nLNsDead.increment();
                                            }
                                            obsolete = true;
                                            completed = true;
                                            break block64;
                                        }
                                        if (bin.getMigrate(index) && !this.fileSelector.isFileCleaningInProgress(fileNum = Long.valueOf(DbLsn.getFileNumber(lsn)))) {
                                            obsolete = true;
                                            completed = true;
                                            if (wasCleaned) {
                                                this.nLNsDead.increment();
                                            }
                                            break block65;
                                        }
                                        byte[] key = this.getLNMainKey(bin, index);
                                        long newLNLsn = ln.log(this.env, db, key, lsn, locker, backgroundIO, ReplicationContext.NO_REPLICATE);
                                        bin.updateEntry(index, newLNLsn);
                                        this.nLNsMigrated.increment();
                                        migrated = true;
                                        completed = true;
                                        break block66;
                                    }
                                    catch (Throwable throwable) {
                                        Object var23_23 = null;
                                        if (isPending) {
                                            if (completed && !lockDenied) {
                                                this.fileSelector.removePendingLN(lockedPendingNodeId);
                                            }
                                        } else if (bin.getMigrate(index) && (!completed || lockDenied) && ln != null) {
                                            byte[] key = this.getLNMainKey(bin, index);
                                            byte[] dupKey = this.getLNDupKey(bin, index, ln);
                                            this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                                            if (!this.areThreadsRunning()) {
                                                this.env.getUtilizationTracker().activateCleaner();
                                            }
                                            clearTarget = false;
                                        }
                                        bin.setMigrate(index, false);
                                        if (clearTarget) {
                                            bin.updateNode(index, null, null);
                                        }
                                        if (locker != null) {
                                            locker.operationEnd();
                                        }
                                        this.logFine(cleanAction, ln, lsn, completed, obsolete, migrated);
                                        throw throwable;
                                    }
                                }
                                if (bin.getMigrate(index) && (!completed || lockDenied) && ln != null) {
                                    byte[] key = this.getLNMainKey(bin, index);
                                    byte[] dupKey = this.getLNDupKey(bin, index, ln);
                                    this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                                    if (!this.areThreadsRunning()) {
                                        this.env.getUtilizationTracker().activateCleaner();
                                    }
                                    clearTarget = false;
                                }
                            }
                            bin.setMigrate(index, false);
                            if (clearTarget) {
                                bin.updateNode(index, null, null);
                            }
                            if (locker != null) {
                                locker.operationEnd();
                            }
                            this.logFine(cleanAction, ln, lsn, completed, obsolete, migrated);
                            return;
                        }
                        Object var23_18 = null;
                        if (isPending) {
                            if (completed && !lockDenied) {
                                this.fileSelector.removePendingLN(lockedPendingNodeId);
                            }
                        } else if (bin.getMigrate(index) && (!completed || lockDenied) && ln != null) {
                            byte[] key = this.getLNMainKey(bin, index);
                            byte[] dupKey = this.getLNDupKey(bin, index, ln);
                            this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                            if (!this.areThreadsRunning()) {
                                this.env.getUtilizationTracker().activateCleaner();
                            }
                            clearTarget = false;
                        }
                        bin.setMigrate(index, false);
                        if (clearTarget) {
                            bin.updateNode(index, null, null);
                        }
                        if (locker != null) {
                            locker.operationEnd();
                        }
                        this.logFine(cleanAction, ln, lsn, completed, obsolete, migrated);
                        return;
                    }
                    Object var23_19 = null;
                    if (isPending) {
                        if (completed && !lockDenied) {
                            this.fileSelector.removePendingLN(lockedPendingNodeId);
                        }
                    } else if (bin.getMigrate(index) && (!completed || lockDenied) && ln != null) {
                        byte[] key = this.getLNMainKey(bin, index);
                        byte[] dupKey = this.getLNDupKey(bin, index, ln);
                        this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                        if (!this.areThreadsRunning()) {
                            this.env.getUtilizationTracker().activateCleaner();
                        }
                        clearTarget = false;
                    }
                    bin.setMigrate(index, false);
                    if (clearTarget) {
                        bin.updateNode(index, null, null);
                    }
                    if (locker != null) {
                        locker.operationEnd();
                    }
                    this.logFine(cleanAction, ln, lsn, completed, obsolete, migrated);
                    return;
                }
                Object var23_20 = null;
                if (isPending) {
                    if (completed && !lockDenied) {
                        this.fileSelector.removePendingLN(lockedPendingNodeId);
                    }
                } else if (bin.getMigrate(index) && (!completed || lockDenied) && ln != null) {
                    byte[] key = this.getLNMainKey(bin, index);
                    byte[] dupKey = this.getLNDupKey(bin, index, ln);
                    this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                    if (!this.areThreadsRunning()) {
                        this.env.getUtilizationTracker().activateCleaner();
                    }
                    clearTarget = false;
                }
                bin.setMigrate(index, false);
                if (clearTarget) {
                    bin.updateNode(index, null, null);
                }
                if (locker != null) {
                    locker.operationEnd();
                }
                this.logFine(cleanAction, ln, lsn, completed, obsolete, migrated);
                return;
            }
            Object var23_21 = null;
            if (isPending) {
                if (completed && !lockDenied) {
                    this.fileSelector.removePendingLN(lockedPendingNodeId);
                }
            } else if (bin.getMigrate(index) && (!completed || lockDenied) && ln != null) {
                byte[] key = this.getLNMainKey(bin, index);
                byte[] dupKey = this.getLNDupKey(bin, index, ln);
                this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                if (!this.areThreadsRunning()) {
                    this.env.getUtilizationTracker().activateCleaner();
                }
                clearTarget = false;
            }
            bin.setMigrate(index, false);
            if (clearTarget) {
                bin.updateNode(index, null, null);
            }
            if (locker != null) {
                locker.operationEnd();
            }
            this.logFine(cleanAction, ln, lsn, completed, obsolete, migrated);
            return;
        }
        Object var23_22 = null;
        if (isPending) {
            if (completed && !lockDenied) {
                this.fileSelector.removePendingLN(lockedPendingNodeId);
            }
        } else if (bin.getMigrate(index) && (!completed || lockDenied) && ln != null) {
            byte[] key = this.getLNMainKey(bin, index);
            byte[] dupKey = this.getLNDupKey(bin, index, ln);
            this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
            if (!this.areThreadsRunning()) {
                this.env.getUtilizationTracker().activateCleaner();
            }
            clearTarget = false;
        }
        bin.setMigrate(index, false);
        if (clearTarget) {
            bin.updateNode(index, null, null);
        }
        if (locker != null) {
            locker.operationEnd();
        }
        this.logFine(cleanAction, ln, lsn, completed, obsolete, migrated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void migrateDupCountLN(DatabaseImpl db, long lsn, DIN parentDIN, ChildReference dclRef, boolean wasCleaned, boolean isPending, long lockedPendingNodeId, String cleanAction) throws DatabaseException {
        LN ln;
        Locker locker;
        boolean clearTarget;
        boolean completed;
        boolean lockDenied;
        boolean migrated;
        boolean obsolete;
        block47: {
            block46: {
                block45: {
                    block43: {
                        block44: {
                            obsolete = false;
                            migrated = false;
                            lockDenied = false;
                            completed = false;
                            clearTarget = false;
                            locker = null;
                            ln = null;
                            try {
                                Long fileNum;
                                if (lsn == -1L) {
                                    completed = true;
                                    Object var23_16 = null;
                                    if (isPending) {
                                        if (completed && !lockDenied) {
                                            this.fileSelector.removePendingLN(lockedPendingNodeId);
                                        }
                                        break block43;
                                    }
                                    if (!dclRef.getMigrate() || completed && !lockDenied || ln == null) break block43;
                                    byte[] key = parentDIN.getDupKey();
                                    byte[] dupKey = null;
                                    this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                                    break block44;
                                }
                                ln = (LN)dclRef.getTarget();
                                if (ln == null) {
                                    ln = (LN)dclRef.fetchTarget(db, parentDIN);
                                    assert (ln != null);
                                    boolean bl = clearTarget = !db.getId().equals(DbTree.ID_DB_ID);
                                }
                                if (lockedPendingNodeId != ln.getNodeId()) {
                                    locker = BasicLocker.createBasicLocker(this.env, false);
                                    locker.setPreemptable(false);
                                    LockResult lockRet = locker.nonBlockingLock(ln.getNodeId(), LockType.READ, db);
                                    if (lockRet.getLockGrant() == LockGrantType.DENIED) {
                                        if (wasCleaned) {
                                            this.nLNsLocked.increment();
                                        }
                                        lockDenied = true;
                                        completed = true;
                                        break block45;
                                    }
                                }
                                if (!this.fileSelector.isFileCleaningInProgress(fileNum = Long.valueOf(DbLsn.getFileNumber(lsn)))) {
                                    obsolete = true;
                                    completed = true;
                                    if (wasCleaned) {
                                        this.nLNsDead.increment();
                                    }
                                    break block46;
                                }
                                byte[] key = parentDIN.getDupKey();
                                long newLNLsn = ln.log(this.env, db, key, lsn, locker, false, ReplicationContext.NO_REPLICATE);
                                parentDIN.updateDupCountLNRef(newLNLsn);
                                this.nLNsMigrated.increment();
                                migrated = true;
                                completed = true;
                                break block47;
                            }
                            catch (Throwable throwable) {
                                Object var23_20 = null;
                                if (isPending) {
                                    if (completed && !lockDenied) {
                                        this.fileSelector.removePendingLN(lockedPendingNodeId);
                                    }
                                } else if (dclRef.getMigrate() && (!completed || lockDenied) && ln != null) {
                                    byte[] key = parentDIN.getDupKey();
                                    byte[] dupKey = null;
                                    this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                                    if (!this.areThreadsRunning()) {
                                        this.env.getUtilizationTracker().activateCleaner();
                                    }
                                    clearTarget = false;
                                }
                                dclRef.setMigrate(false);
                                if (clearTarget) {
                                    parentDIN.updateDupCountLN(null);
                                }
                                if (locker != null) {
                                    locker.operationEnd();
                                }
                                this.logFine(cleanAction, ln, lsn, completed, obsolete, migrated);
                                throw throwable;
                            }
                        }
                        if (!this.areThreadsRunning()) {
                            this.env.getUtilizationTracker().activateCleaner();
                        }
                        clearTarget = false;
                    }
                    dclRef.setMigrate(false);
                    if (clearTarget) {
                        parentDIN.updateDupCountLN(null);
                    }
                    if (locker != null) {
                        locker.operationEnd();
                    }
                    this.logFine(cleanAction, ln, lsn, completed, obsolete, migrated);
                    return;
                }
                Object var23_17 = null;
                if (isPending) {
                    if (completed && !lockDenied) {
                        this.fileSelector.removePendingLN(lockedPendingNodeId);
                    }
                } else if (dclRef.getMigrate() && (!completed || lockDenied) && ln != null) {
                    byte[] key = parentDIN.getDupKey();
                    byte[] dupKey = null;
                    this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                    if (!this.areThreadsRunning()) {
                        this.env.getUtilizationTracker().activateCleaner();
                    }
                    clearTarget = false;
                }
                dclRef.setMigrate(false);
                if (clearTarget) {
                    parentDIN.updateDupCountLN(null);
                }
                if (locker != null) {
                    locker.operationEnd();
                }
                this.logFine(cleanAction, ln, lsn, completed, obsolete, migrated);
                return;
            }
            Object var23_18 = null;
            if (isPending) {
                if (completed && !lockDenied) {
                    this.fileSelector.removePendingLN(lockedPendingNodeId);
                }
            } else if (dclRef.getMigrate() && (!completed || lockDenied) && ln != null) {
                byte[] key = parentDIN.getDupKey();
                byte[] dupKey = null;
                this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                if (!this.areThreadsRunning()) {
                    this.env.getUtilizationTracker().activateCleaner();
                }
                clearTarget = false;
            }
            dclRef.setMigrate(false);
            if (clearTarget) {
                parentDIN.updateDupCountLN(null);
            }
            if (locker != null) {
                locker.operationEnd();
            }
            this.logFine(cleanAction, ln, lsn, completed, obsolete, migrated);
            return;
        }
        Object var23_19 = null;
        if (isPending) {
            if (completed && !lockDenied) {
                this.fileSelector.removePendingLN(lockedPendingNodeId);
            }
        } else if (dclRef.getMigrate() && (!completed || lockDenied) && ln != null) {
            byte[] key = parentDIN.getDupKey();
            byte[] dupKey = null;
            this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
            if (!this.areThreadsRunning()) {
                this.env.getUtilizationTracker().activateCleaner();
            }
            clearTarget = false;
        }
        dclRef.setMigrate(false);
        if (clearTarget) {
            parentDIN.updateDupCountLN(null);
        }
        if (locker != null) {
            locker.operationEnd();
        }
        this.logFine(cleanAction, ln, lsn, completed, obsolete, migrated);
    }

    byte[] getLNMainKey(BIN bin, int index) {
        if (bin.containsDuplicates()) {
            return bin.getDupKey();
        }
        return bin.getKey(index);
    }

    private byte[] getLNDupKey(BIN bin, int index, LN ln) {
        DatabaseImpl db = bin.getDatabase();
        if (!db.getSortedDuplicates() || ln.containsDuplicates()) {
            return null;
        }
        if (bin.containsDuplicates()) {
            return bin.getKey(index);
        }
        return ln.getData();
    }

    void addPendingDB(DatabaseImpl db) {
        DatabaseId id;
        if (db != null && db.isDeleted() && !db.isDeleteFinished() && this.fileSelector.addPendingDB(id = db.getId())) {
            LoggerUtils.logMsg(this.logger, this.env, Level.FINE, "CleanAddPendingDB " + id);
        }
    }

    void logFine(String action, Node node, long logLsn, boolean completed, boolean obsolete, boolean dirtiedMigrated) {
        if (this.logger.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer();
            sb.append(action);
            if (node != null) {
                sb.append(" node=");
                sb.append(node.getNodeId());
            }
            sb.append(" logLsn=");
            sb.append(DbLsn.getNoFormatString(logLsn));
            sb.append(" complete=").append(completed);
            sb.append(" obsolete=").append(obsolete);
            sb.append(" dirtiedOrMigrated=").append(dirtiedMigrated);
            LoggerUtils.logMsg(this.logger, this.env, Level.FINE, sb.toString());
        }
    }

    public void close() {
        this.profile.close();
        this.tracker.close();
        this.fileSelector.close(this.env.getMemoryBudget());
    }
}

