/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.KeyLocation;
import com.sleepycat.persist.impl.Reader;
import java.util.HashMap;
import java.util.Map;

class RecordInput
extends TupleInput
implements EntityInput {
    static final int VISITED_INIT_SIZE = 50;
    static final int PRI_KEY_VISITED_OFFSET = 0x7FFFFFFE;
    static final int PROHIBIT_REF_OFFSET = 0x7FFFFFFD;
    static final Object PROHIBIT_REF_OBJECT = new Object();
    static final String PROHIBIT_NESTED_REF_MSG = "Cannot embed a reference to a proxied object in the proxy; for example, a collection may not be an element of the collection because collections are proxied";
    private Catalog catalog;
    private boolean rawAccess;
    private Map<Integer, Object> visited;
    private DatabaseEntry priKeyEntry;
    private int priKeyFormatId;

    RecordInput(Catalog catalog, boolean rawAccess, DatabaseEntry priKeyEntry, int priKeyFormatId, byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
        this.catalog = catalog;
        this.rawAccess = rawAccess;
        this.priKeyEntry = priKeyEntry;
        this.priKeyFormatId = priKeyFormatId;
    }

    private RecordInput(RecordInput other, int offset) {
        this(other.catalog, other.rawAccess, other.priKeyEntry, other.priKeyFormatId, other.buf, offset, other.len);
        this.visited = other.visited;
    }

    private RecordInput(RecordInput other, DatabaseEntry entry) {
        this(other.catalog, other.rawAccess, other.priKeyEntry, other.priKeyFormatId, entry.getData(), entry.getOffset(), entry.getSize());
        this.visited = other.visited;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public boolean isRawAccess() {
        return this.rawAccess;
    }

    public boolean setRawAccess(boolean rawAccessParam) {
        boolean original = this.rawAccess;
        this.rawAccess = rawAccessParam;
        return original;
    }

    public Object readObject() {
        Integer visitedOffset = this.off;
        RecordInput useInput = this;
        int formatId = this.readPackedInt();
        Object o = null;
        if (formatId == 0) {
            return null;
        }
        if (formatId < 0) {
            int offset = -(formatId + 1);
            if (this.visited != null) {
                o = this.visited.get(offset);
            }
            if (o == PROHIBIT_REF_OBJECT) {
                throw new IllegalArgumentException(PROHIBIT_NESTED_REF_MSG);
            }
            if (o != null) {
                return o;
            }
            visitedOffset = offset;
            if (offset == 0x7FFFFFFE) {
                assert (this.priKeyEntry != null && this.priKeyFormatId > 0);
                useInput = new RecordInput(this, this.priKeyEntry);
                formatId = this.priKeyFormatId;
            } else {
                useInput = new RecordInput(this, offset);
                formatId = useInput.readPackedInt();
            }
        }
        if (this.visited == null) {
            this.visited = new HashMap<Integer, Object>(50);
        }
        this.visited.put(visitedOffset, PROHIBIT_REF_OBJECT);
        Format format = this.catalog.getFormat(formatId, true);
        Reader reader = format.getReader();
        o = reader.newInstance(useInput, this.rawAccess);
        this.visited.put(visitedOffset, o);
        Object o2 = reader.readObject(o, useInput, this.rawAccess);
        if (o != o2) {
            this.visited.put(visitedOffset, o2);
        }
        return o2;
    }

    public Object readKeyObject(Format format) {
        Reader reader = format.getReader();
        Object o = reader.newInstance(this, this.rawAccess);
        return reader.readObject(o, this, this.rawAccess);
    }

    KeyLocation getKeyLocation(Format fieldFormat) {
        RecordInput input = this;
        if (!fieldFormat.isPrimitive()) {
            int formatId = input.readPackedInt();
            if (formatId == 0) {
                return null;
            }
            if (formatId < 0) {
                int offset = -(formatId + 1);
                if (offset == 0x7FFFFFFE) {
                    assert (this.priKeyEntry != null && this.priKeyFormatId > 0);
                    input = new RecordInput(this, this.priKeyEntry);
                    formatId = this.priKeyFormatId;
                } else {
                    input = new RecordInput(this, offset);
                    formatId = input.readPackedInt();
                }
            }
            fieldFormat = this.catalog.getFormat(formatId, true);
        }
        return new KeyLocation(input, fieldFormat);
    }

    public void registerPriKeyObject(Object o) {
        if (this.visited == null) {
            this.visited = new HashMap<Integer, Object>(50);
        }
        this.visited.put(0x7FFFFFFE, o);
    }

    public void skipField(Format declaredFormat) {
        if (declaredFormat != null && declaredFormat.isPrimitive()) {
            declaredFormat.skipContents(this);
        } else {
            int formatId = this.readPackedInt();
            if (formatId > 0) {
                Format format = this.catalog.getFormat(formatId, true);
                format.skipContents(this);
            }
        }
    }

    public int readArrayLength() {
        return this.readPackedInt();
    }

    public int readEnumConstant(String[] names) {
        return this.readPackedInt();
    }
}

