/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.log.ChecksumException;
import com.sleepycat.je.log.LogSource;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;

public class LogBuffer
implements LogSource {
    private static final String DEBUG_NAME = LogBuffer.class.getName();
    private final ByteBuffer buffer;
    private long firstLsn;
    private long lastLsn;
    private Latch readLatch;
    private boolean rewriteAllowed;

    LogBuffer(int capacity, EnvironmentImpl env) throws DatabaseException {
        this.buffer = ByteBuffer.allocate(capacity);
        this.readLatch = new Latch(DEBUG_NAME);
        this.reinit();
    }

    LogBuffer(ByteBuffer buffer, long firstLsn) {
        this.buffer = buffer;
        this.firstLsn = firstLsn;
        this.lastLsn = firstLsn;
        this.rewriteAllowed = false;
    }

    void reinit() throws DatabaseException {
        this.readLatch.acquire();
        this.buffer.clear();
        this.firstLsn = -1L;
        this.lastLsn = -1L;
        this.rewriteAllowed = false;
        this.readLatch.release();
    }

    public long getFirstLsn() {
        return this.firstLsn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerLsn(long lsn) throws DatabaseException {
        this.readLatch.acquire();
        try {
            if (this.lastLsn != -1L) assert (DbLsn.compareTo(lsn, this.lastLsn) > 0) : "lsn=" + lsn + " lastlsn=" + this.lastLsn;
            this.lastLsn = lsn;
            if (this.firstLsn == -1L) {
                this.firstLsn = lsn;
            }
            Object var4_2 = null;
            this.readLatch.release();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.readLatch.release();
            throw throwable;
        }
    }

    boolean hasRoom(int numBytes) {
        return numBytes <= this.buffer.capacity() - this.buffer.position();
    }

    public ByteBuffer getDataBuffer() {
        return this.buffer;
    }

    int getCapacity() {
        return this.buffer.capacity();
    }

    boolean containsLsn(long lsn) {
        assert (lsn != -1L);
        this.readLatch.acquire();
        boolean found = false;
        if (this.firstLsn != -1L && DbLsn.getFileNumber(this.firstLsn) == DbLsn.getFileNumber(lsn)) {
            long fileOffset = DbLsn.getFileOffset(lsn);
            int contentSize = this.buffer.position() == 0 ? this.buffer.limit() : this.buffer.position();
            long firstLsnOffset = DbLsn.getFileOffset(this.firstLsn);
            long lastContentOffset = firstLsnOffset + (long)contentSize;
            if (firstLsnOffset <= fileOffset && lastContentOffset > fileOffset) {
                found = true;
            }
        }
        if (found) {
            return true;
        }
        this.readLatch.release();
        return false;
    }

    public void latchForWrite() throws DatabaseException {
        this.readLatch.acquire();
    }

    public void release() {
        this.readLatch.releaseIfOwner();
    }

    boolean getRewriteAllowed() {
        return this.rewriteAllowed;
    }

    void setRewriteAllowed() {
        this.rewriteAllowed = true;
    }

    public ByteBuffer getBytes(long fileOffset) {
        ByteBuffer copy = null;
        while (true) {
            try {
                copy = this.buffer.duplicate();
                copy.position((int)(fileOffset - DbLsn.getFileOffset(this.firstLsn)));
            }
            catch (IllegalArgumentException IAE) {
                continue;
            }
            break;
        }
        return copy;
    }

    public ByteBuffer getBytes(long fileOffset, int numBytes) throws ChecksumException {
        ByteBuffer copy = this.getBytes(fileOffset);
        if (copy.remaining() < numBytes) {
            throw new ChecksumException("copy.remaining=" + copy.remaining() + " numBytes=" + numBytes);
        }
        return copy;
    }

    public int getLogVersion() {
        return 7;
    }
}

