/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.je.LogWriteException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.log.ChecksumException;
import com.sleepycat.je.log.ChecksumValidator;
import com.sleepycat.je.log.FSyncManager;
import com.sleepycat.je.log.FileHandle;
import com.sleepycat.je.log.FileHeader;
import com.sleepycat.je.log.JEFileFilter;
import com.sleepycat.je.log.LogBuffer;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.LogStatDefinition;
import com.sleepycat.je.log.entry.FileHeaderEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.HexFormatter;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.RelatchRequiredException;
import com.sleepycat.je.utilint.StatGroup;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileManager {
    static boolean IO_EXCEPTION_TESTING_ON_WRITE = false;
    static boolean IO_EXCEPTION_TESTING_ON_READ = false;
    static boolean THROW_RRE_FOR_UNIT_TESTS = false;
    private static final String DEBUG_NAME = FileManager.class.getName();
    private static final boolean DEBUG = false;
    public static long WRITE_COUNT = 0L;
    public static long STOP_ON_WRITE_COUNT = Long.MAX_VALUE;
    public static long N_BAD_WRITES = Long.MAX_VALUE;
    public static boolean THROW_ON_WRITE = false;
    public static final String JE_SUFFIX = ".jdb";
    public static final String DEL_SUFFIX = ".del";
    public static final String BAD_SUFFIX = ".bad";
    private static final String LOCK_FILE = "je.lck";
    static final String[] DEL_SUFFIXES = new String[]{".del"};
    static final String[] JE_SUFFIXES = new String[]{".jdb"};
    private static final String[] JE_AND_DEL_SUFFIXES = new String[]{".jdb", ".del"};
    public static final String TMP_SUFFIX = ".tmp";
    public static final String BUP_SUFFIX = ".bup";
    private boolean syncAtFileEnd = true;
    private final EnvironmentImpl envImpl;
    private long maxFileSize;
    private final File dbEnvHome;
    private boolean includeDeletedFiles = false;
    private FileCache fileCache;
    private Latch fileCacheLatch;
    private RandomAccessFile lockFile;
    private FileChannel channel;
    private FileLock envLock;
    private FileLock exclLock;
    private final boolean readOnly;
    private long currentFileNum;
    private long nextAvailableLsn;
    private long lastUsedLsn;
    private long prevOffset;
    private boolean forceNewFile;
    private long savedCurrentFileNum;
    private long savedNextAvailableLsn;
    private long savedLastUsedLsn;
    private long savedPrevOffset;
    private boolean savedForceNewFile;
    private final LogEndFileDescriptor endOfLog;
    private FSyncManager syncManager;
    private Map<Long, Long> perFileLastUsedLsn;
    private boolean useWriteQueue;
    private int writeQueueSize;
    private final boolean useODSYNC;
    public boolean VERIFY_CHECKSUMS = false;
    long lastFileNumberTouched = -1L;
    long lastFileTouchedOffset = 0L;
    private static final long ADJACENT_TRACK_SEEK_DELTA = 0x100000L;
    final StatGroup stats;
    final LongStat nRandomReads;
    final LongStat nRandomWrites;
    final LongStat nSequentialReads;
    final LongStat nSequentialWrites;
    final LongStat nRandomReadBytes;
    final LongStat nRandomWriteBytes;
    final LongStat nSequentialReadBytes;
    final LongStat nSequentialWriteBytes;
    final IntStat nFileOpens;
    final IntStat nOpenFiles;
    final LongStat nBytesReadFromWriteQueue;
    final LongStat nBytesWrittenFromWriteQueue;
    final LongStat nReadsFromWriteQueue;
    final LongStat nWritesFromWriteQueue;
    final LongStat nWriteQueueOverflow;
    final LongStat nWriteQueueOverflowFailures;
    final LongStat nLogFSyncs;
    public static final boolean LOGWRITE_EXCEPTION_TESTING;
    private static String RRET_PROPERTY_NAME;
    private static final int LOGWRITE_EXCEPTION_MAX = 100;
    private int logWriteExceptionCounter = 0;
    private boolean logWriteExceptionThrown = false;
    private Random logWriteExceptionRandom = null;

    public static boolean continueAfterWriteException() {
        return IO_EXCEPTION_TESTING_ON_WRITE && !THROW_RRE_FOR_UNIT_TESTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileManager(EnvironmentImpl envImpl, File dbEnvHome, boolean readOnly) throws EnvironmentLockedException {
        this.envImpl = envImpl;
        this.dbEnvHome = dbEnvHome;
        this.readOnly = readOnly;
        boolean success = false;
        this.stats = new StatGroup("FileManager", "FileManager statistics");
        this.nRandomReads = new LongStat(this.stats, LogStatDefinition.FILEMGR_RANDOM_READS);
        this.nRandomWrites = new LongStat(this.stats, LogStatDefinition.FILEMGR_RANDOM_WRITES);
        this.nSequentialReads = new LongStat(this.stats, LogStatDefinition.FILEMGR_SEQUENTIAL_READS);
        this.nSequentialWrites = new LongStat(this.stats, LogStatDefinition.FILEMGR_SEQUENTIAL_WRITES);
        this.nRandomReadBytes = new LongStat(this.stats, LogStatDefinition.FILEMGR_RANDOM_READ_BYTES);
        this.nRandomWriteBytes = new LongStat(this.stats, LogStatDefinition.FILEMGR_RANDOM_WRITE_BYTES);
        this.nSequentialReadBytes = new LongStat(this.stats, LogStatDefinition.FILEMGR_SEQUENTIAL_READ_BYTES);
        this.nSequentialWriteBytes = new LongStat(this.stats, LogStatDefinition.FILEMGR_SEQUENTIAL_WRITE_BYTES);
        this.nFileOpens = new IntStat(this.stats, LogStatDefinition.FILEMGR_FILE_OPENS);
        this.nOpenFiles = new IntStat(this.stats, LogStatDefinition.FILEMGR_OPEN_FILES);
        this.nBytesReadFromWriteQueue = new LongStat(this.stats, LogStatDefinition.FILEMGR_BYTES_READ_FROM_WRITEQUEUE);
        this.nBytesWrittenFromWriteQueue = new LongStat(this.stats, LogStatDefinition.FILEMGR_BYTES_WRITTEN_FROM_WRITEQUEUE);
        this.nReadsFromWriteQueue = new LongStat(this.stats, LogStatDefinition.FILEMGR_READS_FROM_WRITEQUEUE);
        this.nWritesFromWriteQueue = new LongStat(this.stats, LogStatDefinition.FILEMGR_WRITES_FROM_WRITEQUEUE);
        this.nWriteQueueOverflow = new LongStat(this.stats, LogStatDefinition.FILEMGR_WRITEQUEUE_OVERFLOW);
        this.nWriteQueueOverflowFailures = new LongStat(this.stats, LogStatDefinition.FILEMGR_WRITEQUEUE_OVERFLOW_FAILURES);
        this.nLogFSyncs = new LongStat(this.stats, LogStatDefinition.FILEMGR_LOG_FSYNCS);
        try {
            DbConfigManager configManager = envImpl.getConfigManager();
            this.maxFileSize = configManager.getLong(EnvironmentParams.LOG_FILE_MAX);
            this.useWriteQueue = configManager.getBoolean(EnvironmentParams.LOG_USE_WRITE_QUEUE);
            this.writeQueueSize = configManager.getInt(EnvironmentParams.LOG_WRITE_QUEUE_SIZE);
            this.useODSYNC = configManager.getBoolean(EnvironmentParams.LOG_USE_ODSYNC);
            this.VERIFY_CHECKSUMS = configManager.getBoolean(EnvironmentParams.LOG_VERIFY_CHECKSUMS);
            if (!envImpl.isMemOnly()) {
                if (!dbEnvHome.exists()) {
                    throw new IllegalArgumentException("Environment home " + dbEnvHome + " doesn't exist");
                }
                if (!this.lockEnvironment(readOnly, false)) {
                    throw new EnvironmentLockedException(envImpl, "The environment cannot be locked for " + (readOnly ? "shared" : "single writer") + " access.");
                }
            }
            this.fileCache = new FileCache(configManager);
            this.fileCacheLatch = new Latch(DEBUG_NAME + "_fileCache");
            this.currentFileNum = 0L;
            this.nextAvailableLsn = DbLsn.makeLsn(this.currentFileNum, FileManager.firstLogEntryOffset());
            this.lastUsedLsn = -1L;
            this.perFileLastUsedLsn = new HashMap<Long, Long>();
            this.prevOffset = 0L;
            this.endOfLog = new LogEndFileDescriptor();
            this.forceNewFile = false;
            this.saveLastPosition();
            String stopOnWriteCountName = "je.debug.stopOnWriteCount";
            String stopOnWriteCountProp = System.getProperty("je.debug.stopOnWriteCount");
            if (stopOnWriteCountProp != null) {
                try {
                    STOP_ON_WRITE_COUNT = Long.parseLong(stopOnWriteCountProp);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Could not parse: je.debug.stopOnWriteCount", e);
                }
            }
            String stopOnWriteActionName = "je.debug.stopOnWriteAction";
            String stopOnWriteActionProp = System.getProperty("je.debug.stopOnWriteAction");
            if (stopOnWriteActionProp != null) {
                if (stopOnWriteActionProp.compareToIgnoreCase("throw") == 0) {
                    THROW_ON_WRITE = true;
                } else {
                    if (stopOnWriteActionProp.compareToIgnoreCase("stop") != 0) throw new IllegalArgumentException("Unknown value for: je.debug.stopOnWriteAction" + stopOnWriteActionProp);
                    THROW_ON_WRITE = false;
                }
            }
            this.syncManager = new FSyncManager(envImpl);
            return;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (success) throw throwable;
            try {
                this.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void setLastPosition(long nextAvailableLsn, long lastUsedLsn, long prevOffset) {
        this.lastUsedLsn = lastUsedLsn;
        this.perFileLastUsedLsn.put(DbLsn.getFileNumber(lastUsedLsn), lastUsedLsn);
        this.nextAvailableLsn = nextAvailableLsn;
        this.currentFileNum = DbLsn.getFileNumber(this.nextAvailableLsn);
        this.prevOffset = prevOffset;
        this.saveLastPosition();
    }

    void saveLastPosition() {
        this.savedNextAvailableLsn = this.nextAvailableLsn;
        this.savedLastUsedLsn = this.lastUsedLsn;
        this.savedPrevOffset = this.prevOffset;
        this.savedForceNewFile = this.forceNewFile;
        this.savedCurrentFileNum = this.currentFileNum;
    }

    void restoreLastPosition() {
        this.nextAvailableLsn = this.savedNextAvailableLsn;
        this.lastUsedLsn = this.savedLastUsedLsn;
        this.prevOffset = this.savedPrevOffset;
        this.forceNewFile = this.savedForceNewFile;
        this.currentFileNum = this.savedCurrentFileNum;
    }

    public void setSyncAtFileEnd(boolean sync) {
        this.syncAtFileEnd = sync;
    }

    public Long getFirstFileNum() {
        return this.getFileNum(true);
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public Long getLastFileNum() {
        return this.getFileNum(false);
    }

    public long getCurrentFileNum() {
        return this.currentFileNum;
    }

    boolean getUseWriteQueue() {
        return this.useWriteQueue;
    }

    public boolean isFileValid(long fileNum) {
        if (fileNum == this.currentFileNum || this.envImpl.isMemOnly()) {
            return true;
        }
        String fileName = this.getFullFileName(fileNum, JE_SUFFIX);
        File file = new File(fileName);
        return file.exists();
    }

    public void setIncludeDeletedFiles(boolean includeDeletedFiles) {
        this.includeDeletedFiles = includeDeletedFiles;
    }

    public Long[] getAllFileNumbers() {
        String[] names = this.listFiles(JE_SUFFIXES);
        Long[] nums = new Long[names.length];
        for (int i = 0; i < nums.length; ++i) {
            nums[i] = this.getNumFromName(names[i]);
        }
        return nums;
    }

    public Long getFollowingFileNum(long currentFileNum1, boolean forward) {
        Object[] names = this.listFiles(JE_SUFFIXES);
        String searchName = FileManager.getFileName(currentFileNum1, JE_SUFFIX);
        int foundIdx = Arrays.binarySearch(names, searchName);
        boolean foundTarget = false;
        if (foundIdx >= 0) {
            foundIdx = forward ? ++foundIdx : --foundIdx;
        } else {
            foundIdx = Math.abs(foundIdx + 1);
            if (!forward) {
                --foundIdx;
            }
        }
        if (forward && foundIdx < names.length) {
            foundTarget = true;
        } else if (!forward && foundIdx > -1) {
            foundTarget = true;
        }
        if (foundTarget) {
            return this.getNumFromName((String)names[foundIdx]);
        }
        return null;
    }

    public boolean filesExist() {
        String[] names = this.listFiles(JE_SUFFIXES);
        return names.length != 0;
    }

    private Long getFileNum(boolean first) {
        String[] names = this.listFiles(JE_SUFFIXES);
        if (names.length == 0) {
            return null;
        }
        int index = 0;
        if (!first) {
            index = names.length - 1;
        }
        return this.getNumFromName(names[index]);
    }

    public Long getNumFromName(String fileName) {
        String fileNumber = fileName.substring(0, fileName.indexOf("."));
        return Long.parseLong(fileNumber, 16);
    }

    public String[] listFiles(String[] suffixes) {
        Object[] fileNames = this.dbEnvHome.list(new JEFileFilter(suffixes));
        if (fileNames != null) {
            Arrays.sort(fileNames);
        } else {
            fileNames = new String[]{};
        }
        return fileNames;
    }

    public String[] listFiles(long minFileNumber, long maxFileNumber) {
        Object[] fileNames = this.dbEnvHome.list(new JEFileFilter(JE_SUFFIXES, minFileNumber, maxFileNumber));
        Arrays.sort(fileNames);
        return fileNames;
    }

    public static String[] listFiles(File envDirFile, String[] suffixes) {
        Object[] fileNames = envDirFile.list(new JEFileFilter(suffixes));
        if (fileNames != null) {
            Arrays.sort(fileNames);
        } else {
            fileNames = new String[]{};
        }
        return fileNames;
    }

    String[] getFullFileNames(long fileNum) {
        if (this.includeDeletedFiles) {
            int nSuffixes = JE_AND_DEL_SUFFIXES.length;
            String[] ret = new String[nSuffixes];
            for (int i = 0; i < nSuffixes; ++i) {
                ret[i] = this.getFullFileName(FileManager.getFileName(fileNum, JE_AND_DEL_SUFFIXES[i]));
            }
            return ret;
        }
        return new String[]{this.getFullFileName(FileManager.getFileName(fileNum, JE_SUFFIX))};
    }

    public static void removeFiles(File envFile) {
        File[] targetFiles;
        for (File f : targetFiles = envFile.listFiles()) {
            boolean done;
            if (f.isDirectory() || f.getName().equals("je.properties") || (done = f.delete())) continue;
            System.out.println("Warning, couldn't delete " + f + " out of " + targetFiles[targetFiles.length - 1]);
        }
    }

    public String getFullFileName(long fileNum, String suffix) {
        return this.getFullFileName(FileManager.getFileName(fileNum, suffix));
    }

    private String getFullFileName(String fileName) {
        return this.dbEnvHome + File.separator + fileName;
    }

    public static String getFileName(long fileNum, String suffix) {
        return FileManager.getFileNumberString(fileNum) + suffix;
    }

    private static String getFileNumberString(long fileNum) {
        return HexFormatter.formatLong(fileNum).substring(10);
    }

    public boolean renameFile(long fileNum, String newSuffix) throws IOException, DatabaseException {
        String generation = "";
        int repeatNum = 0;
        while (true) {
            String newName;
            File targetFile;
            if (!(targetFile = new File(newName = this.getFullFileName(FileManager.getFileName(fileNum, newSuffix) + generation))).exists()) {
                String oldFileName = this.getFullFileNames(fileNum)[0];
                this.clearFileCache(fileNum);
                File oldFile = new File(oldFileName);
                return oldFile.renameTo(targetFile);
            }
            generation = "." + ++repeatNum;
        }
    }

    public boolean deleteFile(long fileNum) throws IOException, DatabaseException {
        String fileName = this.getFullFileNames(fileNum)[0];
        this.clearFileCache(fileNum);
        File file = new File(fileName);
        return file.delete();
    }

    public int getFileLogVersion(long fileNum) throws DatabaseException {
        try {
            FileHandle handle = this.getFileHandle(fileNum);
            int logVersion = handle.getLogVersion();
            handle.release();
            return logVersion;
        }
        catch (FileNotFoundException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, (Throwable)e);
        }
        catch (ChecksumException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_CHECKSUM, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileHandle getFileHandle(long fileNum) throws FileNotFoundException, ChecksumException, DatabaseException {
        Long fileId = fileNum;
        FileHandle fileHandle = null;
        try {
            while (true) {
                block19: {
                    fileHandle = this.fileCache.get(fileId);
                    boolean newHandle = false;
                    if (fileHandle == null) {
                        if (EnvironmentImpl.getFairLatches()) {
                            Object var7_10;
                            this.fileCacheLatch.acquire();
                            try {
                                fileHandle = this.fileCache.get(fileId);
                                if (fileHandle == null) {
                                    newHandle = true;
                                    fileHandle = this.addFileHandle(fileId);
                                }
                                var7_10 = null;
                                this.fileCacheLatch.release();
                            }
                            catch (Throwable throwable) {
                                var7_10 = null;
                                this.fileCacheLatch.release();
                                throw throwable;
                            }
                        } else {
                            Latch latch = this.fileCacheLatch;
                            synchronized (latch) {
                                fileHandle = this.fileCache.get(fileId);
                                if (fileHandle == null) {
                                    newHandle = true;
                                    fileHandle = this.addFileHandle(fileId);
                                }
                            }
                        }
                    }
                    if (newHandle) {
                        Object var10_11;
                        boolean success = false;
                        try {
                            this.openFileHandle(fileHandle, FileMode.READ_MODE);
                            success = true;
                            var10_11 = null;
                            if (success) break block19;
                        }
                        catch (Throwable throwable) {
                            var10_11 = null;
                            if (success) throw throwable;
                            fileHandle.release();
                            this.clearFileCache(fileNum);
                            throw throwable;
                        }
                        fileHandle.release();
                        this.clearFileCache(fileNum);
                    } else {
                        fileHandle.latch();
                    }
                }
                if (fileHandle.getFile() != null) return fileHandle;
                fileHandle.release();
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_READ, (Throwable)e);
        }
    }

    private FileHandle addFileHandle(Long fileNum) throws IOException, DatabaseException {
        FileHandle fileHandle = new FileHandle(fileNum, FileManager.getFileNumberString(fileNum));
        this.fileCache.add(fileNum, fileHandle);
        fileHandle.latch();
        return fileHandle;
    }

    private FileMode getAppropriateReadWriteMode() {
        if (this.useODSYNC) {
            return FileMode.READWRITE_ODSYNC_MODE;
        }
        return FileMode.READWRITE_MODE;
    }

    private FileHandle makeFileHandle(long fileNum, FileMode mode) throws FileNotFoundException, ChecksumException {
        FileHandle fileHandle = new FileHandle(fileNum, FileManager.getFileNumberString(fileNum));
        this.openFileHandle(fileHandle, mode);
        return fileHandle;
    }

    private void openFileHandle(FileHandle fileHandle, FileMode mode) throws FileNotFoundException, ChecksumException {
        this.nFileOpens.increment();
        long fileNum = fileHandle.getFileNum();
        String[] fileNames = this.getFullFileNames(fileNum);
        RandomAccessFile newFile = null;
        String fileName = null;
        boolean success = false;
        try {
            try {
                FileNotFoundException FNFE = null;
                String[] arr$ = fileNames;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String fileName2;
                    fileName = fileName2 = arr$[i$];
                    try {
                        newFile = new RandomAccessFile(fileName, mode.getModeValue()){

                            public synchronized long length() throws IOException {
                                return super.length();
                            }
                        };
                        break;
                    }
                    catch (FileNotFoundException e) {
                        if (FNFE != null) continue;
                        FNFE = e;
                        continue;
                    }
                }
                if (newFile == null) {
                    assert (FNFE != null);
                    throw FNFE;
                }
                int logVersion = 7;
                if (newFile.length() == 0L) {
                    if (mode.isWritable()) {
                        long lastLsn = DbLsn.longToLsn(this.perFileLastUsedLsn.remove(fileNum - 1L));
                        long headerPrevOffset = 0L;
                        if (lastLsn != -1L) {
                            headerPrevOffset = DbLsn.getFileOffset(lastLsn);
                        }
                        FileHeader fileHeader = new FileHeader(fileNum, headerPrevOffset);
                        this.writeFileHeader(newFile, fileName, fileHeader, fileNum);
                    }
                } else {
                    logVersion = this.readAndValidateFileHeader(newFile, fileName, fileNum);
                }
                fileHandle.init(newFile, logVersion);
                success = true;
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_READ, "Couldn't open file " + fileName, e);
            }
            catch (DatabaseException e) {
                this.closeFileInErrorCase(newFile);
                e.addErrorMessage("Couldn't open file " + fileName);
                throw e;
            }
            Object var17_21 = null;
            if (!success) {
                this.closeFileInErrorCase(newFile);
            }
        }
        catch (Throwable throwable) {
            Object var17_22 = null;
            if (!success) {
                this.closeFileInErrorCase(newFile);
            }
            throw throwable;
        }
    }

    private void closeFileInErrorCase(RandomAccessFile file) {
        try {
            if (file != null) {
                file.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int readAndValidateFileHeader(RandomAccessFile file, String fileName, long fileNum) throws ChecksumException, DatabaseException {
        LogManager logManager = this.envImpl.getLogManager();
        LogEntry headerEntry = logManager.getLogEntryAllowChecksumException(DbLsn.makeLsn(fileNum, 0), file, -1);
        FileHeader header = (FileHeader)headerEntry.getMainItem();
        return header.validate(this.envImpl, fileName, fileNum);
    }

    private void writeFileHeader(RandomAccessFile file, String fileName, FileHeader header, long fileNum) throws DatabaseException {
        int bytesWritten;
        this.envImpl.checkIfInvalid();
        if (this.envImpl.mayNotWrite()) {
            return;
        }
        FileHeaderEntry headerLogEntry = new FileHeaderEntry(LogEntryType.LOG_FILE_HEADER, header);
        ByteBuffer headerBuf = this.envImpl.getLogManager().putIntoBuffer(headerLogEntry, 0L);
        try {
            if (LOGWRITE_EXCEPTION_TESTING) {
                this.generateLogWriteException(file, headerBuf, 0L, fileNum);
            }
            bytesWritten = this.writeToFile(file, headerBuf, 0L, fileNum, false);
            if (fileNum > this.savedCurrentFileNum) {
                long lsnAfterHeader = DbLsn.makeLsn(fileNum, bytesWritten);
                if (DbLsn.compareTo(this.nextAvailableLsn, lsnAfterHeader) < 0) {
                    this.nextAvailableLsn = lsnAfterHeader;
                }
                this.lastUsedLsn = DbLsn.makeLsn(fileNum, bytesWritten);
                this.prevOffset = bytesWritten;
                this.forceNewFile = false;
                this.currentFileNum = fileNum;
                this.saveLastPosition();
            }
        }
        catch (ClosedChannelException e) {
            throw new ThreadInterruptedException(this.envImpl, "Channel closed, may be due to thread interrupt", (Throwable)e);
        }
        catch (IOException e) {
            throw new LogWriteException(this.envImpl, (Throwable)e);
        }
        if (bytesWritten != headerLogEntry.getSize() + 14) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_INTEGRITY, "File " + fileName + " was created with an incomplete header. Only " + bytesWritten + " bytes were written.");
        }
    }

    long getFileHeaderPrevOffset(long fileNum) throws ChecksumException, DatabaseException {
        try {
            LogEntry headerEntry = this.envImpl.getLogManager().getLogEntryAllowChecksumException(DbLsn.makeLsn(fileNum, 0));
            FileHeader header = (FileHeader)headerEntry.getMainItem();
            return header.getLastEntryInPrevFileOffset();
        }
        catch (FileNotFoundException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, (Throwable)e);
        }
    }

    long getPrevEntryOffset() {
        return this.prevOffset;
    }

    boolean bumpLsn(long size) {
        this.saveLastPosition();
        boolean flippedFiles = false;
        if (this.forceNewFile || DbLsn.getFileOffset(this.nextAvailableLsn) + size > this.maxFileSize) {
            this.forceNewFile = false;
            ++this.currentFileNum;
            if (this.lastUsedLsn != -1L) {
                this.perFileLastUsedLsn.put(DbLsn.getFileNumber(this.lastUsedLsn), this.lastUsedLsn);
            }
            this.prevOffset = 0L;
            this.lastUsedLsn = DbLsn.makeLsn(this.currentFileNum, FileManager.firstLogEntryOffset());
            flippedFiles = true;
        } else {
            this.prevOffset = this.lastUsedLsn == -1L ? 0L : DbLsn.getFileOffset(this.lastUsedLsn);
            this.lastUsedLsn = this.nextAvailableLsn;
        }
        this.nextAvailableLsn = DbLsn.makeLsn(DbLsn.getFileNumber(this.lastUsedLsn), DbLsn.getFileOffset(this.lastUsedLsn) + size);
        return flippedFiles;
    }

    void writeLogBuffer(LogBuffer fullBuffer, boolean flushRequired) throws DatabaseException {
        this.envImpl.checkIfInvalid();
        if (this.envImpl.mayNotWrite()) {
            return;
        }
        long firstLsn = fullBuffer.getFirstLsn();
        if (firstLsn != -1L) {
            RandomAccessFile file = this.endOfLog.getWritableFile(DbLsn.getFileNumber(firstLsn), true);
            ByteBuffer data = fullBuffer.getDataBuffer();
            try {
                assert (fullBuffer.getRewriteAllowed() || DbLsn.getFileOffset(firstLsn) >= file.length() || file.length() == (long)FileManager.firstLogEntryOffset()) : "FileManager would overwrite non-empty file 0x" + Long.toHexString(DbLsn.getFileNumber(firstLsn)) + " lsnOffset=0x" + Long.toHexString(DbLsn.getFileOffset(firstLsn)) + " fileLength=0x" + Long.toHexString(file.length());
                if (IO_EXCEPTION_TESTING_ON_WRITE) {
                    throw new IOException("generated for testing (write)");
                }
                if (LOGWRITE_EXCEPTION_TESTING) {
                    this.generateLogWriteException(file, data, DbLsn.getFileOffset(firstLsn), DbLsn.getFileNumber(firstLsn));
                }
                this.writeToFile(file, data, DbLsn.getFileOffset(firstLsn), DbLsn.getFileNumber(firstLsn), flushRequired);
            }
            catch (ClosedChannelException e) {
                throw new ThreadInterruptedException(this.envImpl, "File closed, may be due to thread interrupt", (Throwable)e);
            }
            catch (IOException e) {
                if (!FileManager.continueAfterWriteException()) {
                    throw new LogWriteException(this.envImpl, (Throwable)e);
                }
                this.abortCommittedTxns(data);
                try {
                    if (IO_EXCEPTION_TESTING_ON_WRITE) {
                        throw new IOException("generated for testing (write)");
                    }
                    this.writeToFile(file, data, DbLsn.getFileOffset(firstLsn), DbLsn.getFileNumber(firstLsn), flushRequired);
                }
                catch (IOException e2) {
                    fullBuffer.setRewriteAllowed();
                    throw EnvironmentFailureException.unexpectedException(e2);
                }
            }
            assert (EnvironmentImpl.maybeForceYield());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeToFile(RandomAccessFile file, ByteBuffer data, long destOffset, long fileNum, boolean flushRequired) throws IOException, DatabaseException {
        int totalBytesWritten = 0;
        this.bumpWriteCount("write");
        int pos = data.position();
        int size = data.limit() - pos;
        if (this.lastFileNumberTouched == fileNum && Math.abs(destOffset - this.lastFileTouchedOffset) < 0x100000L) {
            this.nSequentialWrites.increment();
            this.nSequentialWriteBytes.add(size);
        } else {
            this.nRandomWrites.increment();
            this.nRandomWriteBytes.add(size);
        }
        if (this.VERIFY_CHECKSUMS) {
            this.verifyChecksums(data, destOffset, "pre-write");
        }
        boolean fsyncLatchAcquired = this.endOfLog.fsyncFileSynchronizer.tryLock();
        boolean enqueueSuccess = false;
        if (!fsyncLatchAcquired && this.useWriteQueue && !flushRequired) {
            enqueueSuccess = this.endOfLog.enqueueWrite(fileNum, data.array(), destOffset, pos + data.arrayOffset(), size);
        }
        if (!enqueueSuccess) {
            if (!fsyncLatchAcquired) {
                this.endOfLog.fsyncFileSynchronizer.lock();
            }
            try {
                if (this.useWriteQueue) {
                    this.endOfLog.dequeuePendingWrites1();
                }
                RandomAccessFile randomAccessFile = file;
                synchronized (randomAccessFile) {
                    file.seek(destOffset);
                    file.write(data.array(), pos + data.arrayOffset(), size);
                    if (this.VERIFY_CHECKSUMS) {
                        file.seek(destOffset);
                        file.read(data.array(), pos + data.arrayOffset(), size);
                        this.verifyChecksums(data, destOffset, "post-write");
                    }
                }
                Object var16_13 = null;
                this.endOfLog.fsyncFileSynchronizer.unlock();
            }
            catch (Throwable throwable) {
                Object var16_14 = null;
                this.endOfLog.fsyncFileSynchronizer.unlock();
                throw throwable;
            }
        }
        data.position(pos + size);
        totalBytesWritten = size;
        this.lastFileNumberTouched = fileNum;
        this.lastFileTouchedOffset = destOffset + (long)size;
        return totalBytesWritten;
    }

    private void bumpWriteCount(String debugMsg) throws IOException {
        if (++WRITE_COUNT >= STOP_ON_WRITE_COUNT && WRITE_COUNT < STOP_ON_WRITE_COUNT + N_BAD_WRITES) {
            if (THROW_ON_WRITE) {
                throw new IOException("IOException generated for testing: " + WRITE_COUNT + " " + debugMsg);
            }
            Runtime.getRuntime().halt(255);
        }
    }

    void readFromFile(RandomAccessFile file, ByteBuffer readBuffer, long offset, long fileNo) throws DatabaseException {
        this.readFromFile(file, readBuffer, offset, fileNo, true);
    }

    boolean readFromFile(RandomAccessFile file, ByteBuffer readBuffer, long offset, long fileNo, boolean dataKnownToBeInFile) throws DatabaseException {
        try {
            if (this.useWriteQueue && this.endOfLog.checkWriteCache(readBuffer, offset, fileNo)) {
                return true;
            }
            boolean readThisFile = true;
            if (!dataKnownToBeInFile) {
                boolean bl = readThisFile = offset < file.length();
            }
            if (readThisFile) {
                this.readFromFileInternal(file, readBuffer, offset, fileNo);
                return true;
            }
            return false;
        }
        catch (ClosedChannelException e) {
            throw new ThreadInterruptedException(this.envImpl, "Channel closed, may be due to thread interrupt", (Throwable)e);
        }
        catch (IOException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_READ, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFromFileInternal(RandomAccessFile file, ByteBuffer readBuffer, long offset, long fileNum) throws IOException {
        RandomAccessFile randomAccessFile = file;
        synchronized (randomAccessFile) {
            int pos = readBuffer.position();
            int size = readBuffer.limit() - pos;
            if (this.lastFileNumberTouched == fileNum && Math.abs(offset - this.lastFileTouchedOffset) < 0x100000L) {
                this.nSequentialReads.increment();
                this.nSequentialReadBytes.add(size);
            } else {
                this.nRandomReads.increment();
                this.nRandomReadBytes.add(size);
            }
            file.seek(offset);
            if (IO_EXCEPTION_TESTING_ON_READ) {
                throw new IOException("generated for testing (read)");
            }
            int bytesRead = file.read(readBuffer.array(), pos + readBuffer.arrayOffset(), size);
            if (bytesRead > 0) {
                readBuffer.position(pos + bytesRead);
            }
            this.lastFileNumberTouched = fileNum;
            this.lastFileTouchedOffset = offset + (long)bytesRead;
        }
    }

    private void verifyChecksums(ByteBuffer entryBuffer, long lsn, String comment) {
        int curPos = entryBuffer.position();
        try {
            while (entryBuffer.remaining() > 0) {
                int recStartPos = entryBuffer.position();
                LogEntryHeader header = new LogEntryHeader(entryBuffer, 7);
                this.verifyChecksum(entryBuffer, header, lsn, comment);
                entryBuffer.position(recStartPos + header.getSize() + header.getItemSize());
            }
        }
        catch (ChecksumException e) {
            System.err.println("ChecksumException: (" + comment + ") " + e);
            System.err.println("start stack trace");
            e.printStackTrace(System.err);
            System.err.println("end stack trace");
        }
        entryBuffer.position(curPos);
    }

    private void verifyChecksum(ByteBuffer entryBuffer, LogEntryHeader header, long lsn, String comment) throws ChecksumException {
        ChecksumValidator validator = null;
        validator = new ChecksumValidator();
        int headerSizeMinusChecksum = header.getSizeMinusChecksum();
        int itemStart = entryBuffer.position();
        entryBuffer.position(itemStart - headerSizeMinusChecksum);
        validator.update(entryBuffer, headerSizeMinusChecksum);
        entryBuffer.position(itemStart);
        int itemSize = header.getItemSize();
        if (entryBuffer.remaining() < itemSize) {
            System.err.println("Couldn't verify checksum (" + comment + ")");
            return;
        }
        validator.update(entryBuffer, itemSize);
        validator.validate(header.getChecksum(), lsn);
    }

    private void abortCommittedTxns(ByteBuffer data) throws DatabaseException {
        byte commitType = LogEntryType.LOG_TXN_COMMIT.getTypeNum();
        data.position(0);
        while (data.remaining() > 0) {
            LogEntryHeader header;
            int recStartPos = data.position();
            try {
                header = new LogEntryHeader(data, 7);
            }
            catch (ChecksumException e) {
                throw EnvironmentFailureException.unexpectedException(e);
            }
            if (header.getType() == commitType) {
                header.convertCommitToAbort(data);
            }
            data.position(recStartPos + header.getSize() + header.getItemSize());
        }
        data.position(0);
    }

    void syncLogEnd() throws DatabaseException {
        try {
            this.endOfLog.force();
        }
        catch (IOException e) {
            throw new LogWriteException(this.envImpl, "IOException during fsync", (Throwable)e);
        }
    }

    void syncLogEndAndFinishFile() throws DatabaseException, IOException {
        if (this.syncAtFileEnd) {
            this.syncLogEnd();
        }
        this.endOfLog.close();
    }

    void groupSync() throws DatabaseException {
        this.syncManager.fsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException, DatabaseException {
        if (EnvironmentImpl.getFairLatches()) {
            this.fileCacheLatch.acquire();
            try {
                this.fileCache.clear();
                Object var2_1 = null;
                this.fileCacheLatch.release();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.fileCacheLatch.release();
                throw throwable;
            }
        }
        Latch latch = this.fileCacheLatch;
        synchronized (latch) {
            this.fileCache.clear();
        }
        this.endOfLog.close();
    }

    public void close() throws IOException {
        if (this.envLock != null) {
            this.envLock.release();
        }
        if (this.exclLock != null) {
            this.exclLock.release();
        }
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.lockFile != null) {
            this.lockFile.close();
            this.lockFile = null;
        }
    }

    public boolean lockEnvironment(boolean rdOnly, boolean exclusive) {
        try {
            if (this.checkEnvHomePermissions(rdOnly)) {
                return true;
            }
            if (this.lockFile == null) {
                this.lockFile = new RandomAccessFile(new File(this.dbEnvHome, LOCK_FILE), FileMode.READWRITE_MODE.getModeValue());
            }
            this.channel = this.lockFile.getChannel();
            try {
                if (exclusive) {
                    this.exclLock = this.channel.tryLock(1L, 1L, false);
                    return this.exclLock != null;
                }
                this.envLock = rdOnly ? this.channel.tryLock(1L, 1L, true) : this.channel.tryLock(0L, 1L, false);
                return this.envLock != null;
            }
            catch (OverlappingFileLockException e) {
                return false;
            }
        }
        catch (IOException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_INTEGRITY, (Throwable)e);
        }
    }

    public void releaseExclusiveLock() throws DatabaseException {
        try {
            if (this.exclLock != null) {
                this.exclLock.release();
            }
        }
        catch (IOException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_INTEGRITY, (Throwable)e);
        }
    }

    public boolean checkEnvHomePermissions(boolean rdOnly) throws DatabaseException {
        boolean envDirIsReadOnly;
        boolean bl = envDirIsReadOnly = !this.dbEnvHome.canWrite();
        if (envDirIsReadOnly && !rdOnly) {
            throw new IllegalArgumentException("The Environment directory " + this.dbEnvHome.getAbsolutePath() + " is not writable, but the " + "Environment was opened for read-write access.");
        }
        return envDirIsReadOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateLog(long fileNum, long offset) throws IOException, DatabaseException {
        try {
            FileHandle handle = this.makeFileHandle(fileNum, this.getAppropriateReadWriteMode());
            RandomAccessFile file = handle.getFile();
            try {
                file.getChannel().truncate(offset);
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                file.close();
                throw throwable;
            }
            file.close();
            if (handle.isOldHeaderVersion()) {
                this.forceNewFile = true;
            }
        }
        catch (ChecksumException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_CHECKSUM, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void makeInvisible(long fileNum, List<Long> lsns) {
        if (lsns.size() == 0) {
            return;
        }
        FileHandle handle = null;
        try {
            handle = this.makeFileHandle(fileNum, this.getAppropriateReadWriteMode());
        }
        catch (ChecksumException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_CHECKSUM, "Opening file " + fileNum + " for invisible marking ", e);
        }
        catch (FileNotFoundException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, "Opening file " + fileNum + " for invisible marking ", e);
        }
        RandomAccessFile file = handle.getFile();
        try {
            try {
                for (Long lsn : lsns) {
                    if (DbLsn.getFileNumber(lsn) != fileNum) {
                        throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.UNEXPECTED_STATE, "LSN of " + DbLsn.getNoFormatString(lsn) + " did not match file number" + fileNum);
                    }
                    int entryFlagsOffset = (int)(DbLsn.getFileOffset(lsn) + 5L);
                    file.seek(entryFlagsOffset);
                    byte flags = file.readByte();
                    byte newFlags = LogEntryHeader.makeInvisible(flags);
                    file.seek(entryFlagsOffset);
                    file.writeByte(newFlags);
                }
                Object var12_13 = null;
            }
            catch (IOException e) {
                throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_WRITE, "Flipping invisibility in file " + fileNum, e);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            try {
                file.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_WRITE, "Closing after invisibility cloaking: file " + fileNum, e);
            }
        }
        try {}
        catch (IOException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_WRITE, "Closing after invisibility cloaking: file " + fileNum, e);
        }
        file.close();
    }

    /*
     * Loose catch block
     */
    public void force(Set<Long> fileNums) {
        for (long fileNum : fileNums) {
            RandomAccessFile file = null;
            FileHandle handle = this.makeFileHandle(fileNum, this.getAppropriateReadWriteMode());
            file = handle.getFile();
            file.getChannel().force(false);
            this.nLogFSyncs.increment();
            Object var8_9 = null;
            if (file == null) continue;
            try {
                file.close();
                continue;
            }
            catch (IOException e) {
                throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_WRITE, "Invisible fsyncing file " + fileNum, e);
            }
            {
                catch (FileNotFoundException e) {
                    throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, "Invisible fsyncing file " + fileNum, e);
                }
                catch (ChecksumException e) {
                    throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_CHECKSUM, "Invisible fsyncing file " + fileNum, e);
                }
                catch (IOException e) {
                    throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_WRITE, "Invisible fsyncing file " + fileNum, e);
                }
            }
            catch (Throwable throwable) {
                var8_9 = null;
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (IOException e) {
                        throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_WRITE, "Invisible fsyncing file " + fileNum, e);
                    }
                }
                throw throwable;
            }
        }
    }

    void forceNewLogFile() {
        this.forceNewFile = true;
    }

    public static int firstLogEntryOffset() {
        return FileHeader.entrySize() + 14;
    }

    public long getNextLsn() {
        return this.nextAvailableLsn;
    }

    public long getLastUsedLsn() {
        return this.lastUsedLsn;
    }

    public long getNFSyncs() {
        return this.syncManager.getNFSyncs();
    }

    public long getNFSyncRequests() {
        return this.syncManager.getNFSyncRequests();
    }

    public long getNFSyncTimeouts() {
        return this.syncManager.getNTimeouts();
    }

    StatGroup loadStats(StatsConfig config) {
        this.nOpenFiles.set(this.fileCache.size());
        StatGroup copyStats = this.stats.cloneGroup(config.getClear());
        copyStats.addAll(this.syncManager.loadStats(config));
        return copyStats;
    }

    Set<Long> getCacheKeys() {
        return this.fileCache.getCacheKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearFileCache(long fileNum) throws IOException, DatabaseException {
        if (EnvironmentImpl.getFairLatches()) {
            this.fileCacheLatch.acquire();
            try {
                this.fileCache.remove(fileNum);
                Object var4_2 = null;
                this.fileCacheLatch.release();
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                this.fileCacheLatch.release();
                throw throwable;
            }
        }
        Latch latch = this.fileCacheLatch;
        synchronized (latch) {
            this.fileCache.remove(fileNum);
        }
    }

    private void generateLogWriteException(RandomAccessFile file, ByteBuffer data, long destOffset, long fileNum) throws DatabaseException, IOException {
        if (this.logWriteExceptionThrown) {
            new Exception("Write after LogWriteException").printStackTrace();
        }
        ++this.logWriteExceptionCounter;
        if (this.logWriteExceptionCounter >= 100) {
            this.logWriteExceptionCounter = 0;
        }
        if (this.logWriteExceptionRandom == null) {
            this.logWriteExceptionRandom = new Random(System.currentTimeMillis());
        }
        if (this.logWriteExceptionCounter == this.logWriteExceptionRandom.nextInt(100)) {
            int len = this.logWriteExceptionRandom.nextInt(data.remaining());
            if (len > 0) {
                byte[] a = new byte[len];
                data.get(a, 0, len);
                ByteBuffer buf = ByteBuffer.wrap(a);
                this.writeToFile(file, buf, destOffset, fileNum, false);
            }
            this.logWriteExceptionThrown = true;
            throw new IOException("Randomly generated for testing");
        }
    }

    static {
        RRET_PROPERTY_NAME = "je.logwrite.exception.testing";
        LOGWRITE_EXCEPTION_TESTING = System.getProperty(RRET_PROPERTY_NAME) != null;
    }

    class LogEndFileDescriptor {
        private RandomAccessFile endOfLogRWFile = null;
        private RandomAccessFile endOfLogSyncFile = null;
        private final ReentrantLock fsyncFileSynchronizer = new ReentrantLock();
        private final byte[] queuedWrites = FileManager.access$1000(FileManager.this) ? new byte[FileManager.access$1100(FileManager.this)] : null;
        private int queuedWritesPosition = 0;
        private long qwStartingOffset;
        private long qwFileNum = -1L;

        LogEndFileDescriptor() {
        }

        void setQueueFileNum(long qwFileNum) {
            this.qwFileNum = qwFileNum;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean checkWriteCache(ByteBuffer readBuffer, long requestedOffset, long fileNum) {
            int pos = readBuffer.position();
            int targetBufSize = readBuffer.limit() - pos;
            byte[] byArray = this.queuedWrites;
            synchronized (this.queuedWrites) {
                if (this.qwFileNum != fileNum) {
                    // ** MonitorExit[var8_6] (shouldn't be in output)
                    return false;
                }
                if (this.queuedWritesPosition == 0) {
                    // ** MonitorExit[var8_6] (shouldn't be in output)
                    return false;
                }
                if (requestedOffset < this.qwStartingOffset || this.qwStartingOffset + (long)this.queuedWritesPosition <= requestedOffset) {
                    // ** MonitorExit[var8_6] (shouldn't be in output)
                    return false;
                }
                int nBytesToCopy = (int)((long)this.queuedWritesPosition - (requestedOffset - this.qwStartingOffset));
                nBytesToCopy = Math.min(nBytesToCopy, targetBufSize);
                readBuffer.put(this.queuedWrites, (int)(requestedOffset - this.qwStartingOffset), nBytesToCopy);
                FileManager.this.nBytesReadFromWriteQueue.add(nBytesToCopy);
                FileManager.this.nReadsFromWriteQueue.increment();
                // ** MonitorExit[var8_6] (shouldn't be in output)
                return true;
            }
        }

        boolean enqueueWrite(long fileNum, byte[] data, long destOffset, int arrayOffset, int size) throws DatabaseException {
            assert (!this.fsyncFileSynchronizer.isHeldByCurrentThread());
            for (int i = 0; i < 2; ++i) {
                try {
                    this.enqueueWrite1(fileNum, data, destOffset, arrayOffset, size);
                    return true;
                }
                catch (RelatchRequiredException RE) {
                    this.dequeuePendingWrites();
                    continue;
                }
            }
            FileManager.this.nWriteQueueOverflowFailures.increment();
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void enqueueWrite1(long fileNum, byte[] data, long destOffset, int arrayOffset, int size) throws RelatchRequiredException, DatabaseException {
            if (this.qwFileNum < fileNum) {
                this.dequeuePendingWrites();
                this.qwFileNum = fileNum;
            }
            byte[] byArray = this.queuedWrites;
            synchronized (this.queuedWrites) {
                boolean overflow;
                boolean bl = overflow = FileManager.this.writeQueueSize - this.queuedWritesPosition < size;
                if (overflow) {
                    FileManager.this.nWriteQueueOverflow.increment();
                    throw RelatchRequiredException.relatchRequiredException;
                }
                assert (this.qwFileNum == fileNum);
                int curPos = this.queuedWritesPosition;
                if (curPos == 0) {
                    this.qwStartingOffset = destOffset;
                }
                if ((long)curPos + this.qwStartingOffset != destOffset) {
                    throw new EnvironmentFailureException(FileManager.this.envImpl, EnvironmentFailureReason.LOG_INTEGRITY, "non-consecutive writes queued. qwPos=" + this.queuedWritesPosition + " write destOffset=" + destOffset);
                }
                System.arraycopy(data, arrayOffset, this.queuedWrites, this.queuedWritesPosition, size);
                this.queuedWritesPosition += size;
                // ** MonitorExit[var8_6] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dequeuePendingWrites() throws DatabaseException {
            assert (!this.fsyncFileSynchronizer.isHeldByCurrentThread());
            this.fsyncFileSynchronizer.lock();
            try {
                this.dequeuePendingWrites1();
                Object var2_1 = null;
                this.fsyncFileSynchronizer.unlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.fsyncFileSynchronizer.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dequeuePendingWrites1() throws DatabaseException {
            assert (this.fsyncFileSynchronizer.isHeldByCurrentThread());
            try {
                byte[] byArray = this.queuedWrites;
                synchronized (this.queuedWrites) {
                    RandomAccessFile file;
                    if (this.queuedWritesPosition == 0) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                    RandomAccessFile randomAccessFile = file = this.getWritableFile(this.qwFileNum, false);
                    synchronized (randomAccessFile) {
                        file.seek(this.qwStartingOffset);
                        file.write(this.queuedWrites, 0, this.queuedWritesPosition);
                        FileManager.this.nBytesWrittenFromWriteQueue.add(this.queuedWritesPosition);
                        FileManager.this.nWritesFromWriteQueue.increment();
                        if (FileManager.this.VERIFY_CHECKSUMS) {
                            file.seek(this.qwStartingOffset);
                            file.read(this.queuedWrites, 0, this.queuedWritesPosition);
                            ByteBuffer bb = ByteBuffer.allocate(this.queuedWritesPosition);
                            bb.put(this.queuedWrites, 0, this.queuedWritesPosition);
                            bb.position(0);
                            FileManager.this.verifyChecksums(bb, this.qwStartingOffset, "post-write");
                        }
                    }
                    this.queuedWritesPosition = 0;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            catch (IOException e) {
                throw new LogWriteException(FileManager.this.envImpl, "IOException during fsync", (Throwable)e);
            }
            {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RandomAccessFile getWritableFile(long fileNumber, boolean doLock) {
            try {
                if (this.endOfLogRWFile == null) {
                    this.endOfLogRWFile = FileManager.this.makeFileHandle(fileNumber, FileManager.this.getAppropriateReadWriteMode()).getFile();
                    if (doLock) {
                        this.fsyncFileSynchronizer.lock();
                    }
                    try {
                        this.endOfLogSyncFile = FileManager.this.makeFileHandle(fileNumber, FileManager.this.getAppropriateReadWriteMode()).getFile();
                        Object var5_3 = null;
                        if (doLock) {
                            this.fsyncFileSynchronizer.unlock();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_4 = null;
                        if (doLock) {
                            this.fsyncFileSynchronizer.unlock();
                        }
                        throw throwable;
                    }
                }
                return this.endOfLogRWFile;
            }
            catch (Exception e) {
                throw new EnvironmentFailureException(FileManager.this.envImpl, EnvironmentFailureReason.LOG_INTEGRITY, (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void force() throws DatabaseException, IOException {
            this.fsyncFileSynchronizer.lock();
            try {
                RandomAccessFile file;
                if (FileManager.this.useWriteQueue) {
                    this.dequeuePendingWrites1();
                }
                if ((file = this.endOfLogSyncFile) != null) {
                    FileManager.this.bumpWriteCount("fsync");
                    FileChannel ch = file.getChannel();
                    try {
                        ch.force(false);
                        FileManager.this.nLogFSyncs.increment();
                    }
                    catch (ClosedChannelException e) {
                        throw new ThreadInterruptedException(FileManager.this.envImpl, "Channel closed, may be due to thread interrupt", (Throwable)e);
                    }
                    assert (EnvironmentImpl.maybeForceYield());
                }
                if (FileManager.this.useWriteQueue) {
                    this.dequeuePendingWrites1();
                }
                Object var5_4 = null;
                this.fsyncFileSynchronizer.unlock();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.fsyncFileSynchronizer.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() throws IOException {
            RandomAccessFile file;
            IOException firstException = null;
            if (this.endOfLogRWFile != null) {
                file = this.endOfLogRWFile;
                this.endOfLogRWFile = null;
                try {
                    file.close();
                }
                catch (IOException e) {
                    firstException = e;
                }
            }
            this.fsyncFileSynchronizer.lock();
            try {
                if (this.endOfLogSyncFile != null) {
                    file = this.endOfLogSyncFile;
                    this.endOfLogSyncFile = null;
                    file.close();
                }
                if (firstException != null) {
                    throw firstException;
                }
                Object var5_4 = null;
                this.fsyncFileSynchronizer.unlock();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.fsyncFileSynchronizer.unlock();
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileCache {
        private final Map<Long, FileHandle> fileMap = new Hashtable<Long, FileHandle>();
        private final List<Long> fileList = new LinkedList<Long>();
        private final int fileCacheSize;

        FileCache(DbConfigManager configManager) {
            this.fileCacheSize = configManager.getInt(EnvironmentParams.LOG_FILE_CACHE_SIZE);
        }

        private FileHandle get(Long fileId) {
            return this.fileMap.get(fileId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(Long fileId, FileHandle fileHandle) throws IOException, DatabaseException {
            if (this.fileList.size() >= this.fileCacheSize) {
                Iterator<Long> iter = this.fileList.iterator();
                while (iter.hasNext()) {
                    Long evictId = iter.next();
                    FileHandle evictTarget = this.fileMap.get(evictId);
                    if (!evictTarget.latchNoWait()) continue;
                    try {
                        this.fileMap.remove(evictId);
                        iter.remove();
                        evictTarget.close();
                        Object var7_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        evictTarget.release();
                        throw throwable;
                    }
                    evictTarget.release();
                    {
                        break;
                    }
                }
            }
            this.fileList.add(fileId);
            this.fileMap.put(fileId, fileHandle);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remove(long fileNum) throws IOException, DatabaseException {
            Iterator<Long> iter = this.fileList.iterator();
            while (iter.hasNext()) {
                Object var7_5;
                Long evictId = iter.next();
                if (evictId != fileNum) continue;
                FileHandle evictTarget = this.fileMap.get(evictId);
                try {
                    evictTarget.latch();
                    this.fileMap.remove(evictId);
                    iter.remove();
                    evictTarget.close();
                    var7_5 = null;
                }
                catch (Throwable throwable) {
                    var7_5 = null;
                    evictTarget.release();
                    throw throwable;
                }
                evictTarget.release();
                {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clear() throws IOException, DatabaseException {
            Iterator<FileHandle> iter = this.fileMap.values().iterator();
            while (iter.hasNext()) {
                Object var4_3;
                FileHandle fileHandle = iter.next();
                try {
                    fileHandle.latch();
                    fileHandle.close();
                    iter.remove();
                    var4_3 = null;
                }
                catch (Throwable throwable) {
                    var4_3 = null;
                    fileHandle.release();
                    throw throwable;
                }
                fileHandle.release();
                {
                }
            }
            this.fileMap.clear();
            this.fileList.clear();
        }

        private Set<Long> getCacheKeys() {
            return this.fileMap.keySet();
        }

        private int size() {
            return this.fileMap.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileMode {
        READ_MODE("r", false),
        READWRITE_MODE("rw", true),
        READWRITE_ODSYNC_MODE("rwd", true),
        READWRITE_OSYNC_MODE("rws", true);

        private String fileModeValue;
        private boolean isWritable;

        private FileMode(String fileModeValue, boolean isWritable) {
            this.fileModeValue = fileModeValue;
            this.isWritable = isWritable;
        }

        public String getModeValue() {
            return this.fileModeValue;
        }

        public boolean isWritable() {
            return this.isWritable;
        }
    }
}

