/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.utilint.CmdUtil;
import java.io.File;
import java.text.DecimalFormat;

public class DbRunAction {
    private static final int CLEAN = 1;
    private static final int COMPRESS = 2;
    private static final int EVICT = 3;
    private static final int CHECKPOINT = 4;
    private static final int REMOVEDB = 5;
    private static final int DBSTATS = 6;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        long recoveryStart = 0L;
        long actionStart = 0L;
        long actionEnd = 0L;
        try {
            try {
                int whichArg = 0;
                if (argv.length == 0) {
                    DbRunAction.usage();
                    System.exit(1);
                }
                String dbName = null;
                int doAction = 0;
                String envHome = ".";
                boolean readOnly = false;
                while (whichArg < argv.length) {
                    String nextArg = argv[whichArg];
                    if (nextArg.equals("-h")) {
                        envHome = CmdUtil.getArg(argv, ++whichArg);
                    } else if (nextArg.equals("-a")) {
                        String action;
                        if ((action = CmdUtil.getArg(argv, ++whichArg)).equalsIgnoreCase("clean")) {
                            doAction = 1;
                        } else if (action.equalsIgnoreCase("compress")) {
                            doAction = 2;
                        } else if (action.equalsIgnoreCase("checkpoint")) {
                            doAction = 4;
                        } else if (action.equalsIgnoreCase("evict")) {
                            doAction = 3;
                        } else if (action.equalsIgnoreCase("removedb")) {
                            doAction = 5;
                        } else if (action.equalsIgnoreCase("dbstats")) {
                            doAction = 6;
                        } else {
                            DbRunAction.usage();
                            System.exit(1);
                        }
                    } else if (nextArg.equals("-ro")) {
                        readOnly = true;
                    } else if (nextArg.equals("-s")) {
                        dbName = argv[++whichArg];
                    } else {
                        throw new IllegalArgumentException(nextArg + " is not a supported option.");
                    }
                    ++whichArg;
                }
                EnvironmentConfig envConfig = new EnvironmentConfig();
                envConfig.setConfigParam(EnvironmentParams.JE_LOGGING_CONSOLE.getName(), "true");
                if (readOnly) {
                    envConfig.setConfigParam(EnvironmentParams.JE_LOGGING_DBLOG.getName(), "false");
                    envConfig.setReadOnly(true);
                }
                if (doAction == 3) {
                    envConfig.setConfigParam(EnvironmentParams.ENV_RUN_EVICTOR.getName(), "false");
                    envConfig.setConfigParam(EnvironmentParams.EVICTOR_CRITICAL_PERCENTAGE.getName(), "1000");
                }
                recoveryStart = System.currentTimeMillis();
                Environment env = new Environment(new File(envHome), envConfig);
                CheckpointConfig forceConfig = new CheckpointConfig();
                forceConfig.setForce(true);
                actionStart = System.currentTimeMillis();
                switch (doAction) {
                    case 1: {
                        int nFiles;
                        do {
                            nFiles = env.cleanLog();
                            System.out.println("Files cleaned: " + nFiles);
                        } while (nFiles != 0);
                        env.checkpoint(forceConfig);
                        break;
                    }
                    case 2: {
                        env.compress();
                        break;
                    }
                    case 3: {
                        DbRunAction.preload(env, dbName);
                        break;
                    }
                    case 4: {
                        env.checkpoint(forceConfig);
                        break;
                    }
                    case 5: {
                        DbRunAction.removeAndClean(env, dbName);
                        break;
                    }
                    case 6: {
                        DatabaseConfig dbConfig = new DatabaseConfig();
                        dbConfig.setReadOnly(true);
                        DbInternal.setUseExistingConfig(dbConfig, true);
                        Database db = env.openDatabase(null, dbName, dbConfig);
                        try {
                            System.out.println(db.getStats(new StatsConfig()));
                            break;
                        }
                        finally {
                            db.close();
                        }
                    }
                }
                actionEnd = System.currentTimeMillis();
                env.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(e.getMessage());
                DbRunAction.usage();
                System.exit(1);
                Object var19_18 = null;
                DecimalFormat f = new DecimalFormat();
                f.setMaximumFractionDigits(2);
                long recoveryDuration = actionStart - recoveryStart;
                System.out.println("\nrecovery time = " + f.format(recoveryDuration) + " millis " + f.format((double)recoveryDuration / 60000.0) + " minutes");
                long actionDuration = actionEnd - actionStart;
                System.out.println("action time = " + f.format(actionDuration) + " millis " + f.format(actionDuration / 60000L) + " minutes");
            }
            Object var19_17 = null;
            DecimalFormat f = new DecimalFormat();
            f.setMaximumFractionDigits(2);
            long recoveryDuration = actionStart - recoveryStart;
            System.out.println("\nrecovery time = " + f.format(recoveryDuration) + " millis " + f.format((double)recoveryDuration / 60000.0) + " minutes");
            long actionDuration = actionEnd - actionStart;
            System.out.println("action time = " + f.format(actionDuration) + " millis " + f.format(actionDuration / 60000L) + " minutes");
        }
        catch (Throwable throwable) {
            Object var19_19 = null;
            DecimalFormat f = new DecimalFormat();
            f.setMaximumFractionDigits(2);
            long recoveryDuration = actionStart - recoveryStart;
            System.out.println("\nrecovery time = " + f.format(recoveryDuration) + " millis " + f.format((double)recoveryDuration / 60000.0) + " minutes");
            long actionDuration = actionEnd - actionStart;
            System.out.println("action time = " + f.format(actionDuration) + " millis " + f.format(actionDuration / 60000L) + " minutes");
            throw throwable;
        }
    }

    private static void removeAndClean(Environment env, String name) throws DatabaseException {
        Transaction txn = env.beginTransaction(null, null);
        CheckpointConfig force = new CheckpointConfig();
        force.setForce(true);
        long a = System.currentTimeMillis();
        env.removeDatabase(txn, name);
        long b = System.currentTimeMillis();
        txn.commit();
        long c = System.currentTimeMillis();
        int cleanedCount = 0;
        while (env.cleanLog() > 0) {
            ++cleanedCount;
        }
        long d = System.currentTimeMillis();
        System.out.println("cleanedCount=" + cleanedCount);
        long e = 0L;
        long f = 0L;
        if (cleanedCount > 0) {
            e = System.currentTimeMillis();
            env.checkpoint(force);
            f = System.currentTimeMillis();
        }
        System.out.println("Remove of " + name + " remove: " + DbRunAction.getSecs(a, b) + " commit: " + DbRunAction.getSecs(b, c) + " clean: " + DbRunAction.getSecs(c, d) + " checkpoint: " + DbRunAction.getSecs(e, f));
    }

    private static String getSecs(long start, long end) {
        return (end - start) / 1000L + " secs";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void preload(Environment env, String dbName) throws DatabaseException {
        System.out.println("Preload starting");
        Database db = env.openDatabase(null, dbName, null);
        Cursor cursor = db.openCursor(null, null);
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            int count = 0;
            while (cursor.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                if (++count % 50000 != 0) continue;
                System.out.println(count + "...");
            }
            System.out.println("Preloaded " + count + " records");
        }
        finally {
            cursor.close();
            db.close();
        }
    }

    private static void doEvict(Environment env) throws DatabaseException {
        EnvironmentImpl envImpl = DbInternal.envGetEnvironmentImpl(env);
        long cacheUsage = envImpl.getMemoryBudget().getCacheMemoryUsage();
        EnvironmentMutableConfig c = new EnvironmentMutableConfig();
        c.setCacheSize(cacheUsage / 2L);
        env.setMutableConfig(c);
        long start = System.currentTimeMillis();
        env.evictMemory();
        long end = System.currentTimeMillis();
        DecimalFormat f = new DecimalFormat();
        f.setMaximumFractionDigits(2);
        System.out.println("evict time=" + f.format(end - start));
    }

    private static void usage() {
        System.out.println("Usage: \n " + CmdUtil.getJavaCommand(DbRunAction.class));
        System.out.println("  -h <environment home> ");
        System.out.println("  -a <clean|compress|evict|checkpoint|removedb>");
        System.out.println("  -ro (read-only - defaults to read-write)");
        System.out.println("  -s <dbName> (for preloading of evict or db remove)");
    }
}

