/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.util.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.slack.api.model.block.ContextActionsBlockElement;
import com.slack.api.model.block.UnknownContextActionsBlockElement;
import com.slack.api.model.block.element.FeedbackButtonsElement;
import com.slack.api.model.block.element.IconButtonElement;
import java.lang.reflect.Type;

public class GsonContextActionsBlockElementFactory
implements JsonDeserializer<ContextActionsBlockElement>,
JsonSerializer<ContextActionsBlockElement> {
    private boolean failOnUnknownProperties;

    public GsonContextActionsBlockElementFactory() {
        this(false);
    }

    public GsonContextActionsBlockElementFactory(boolean failOnUnknownProperties) {
        this.failOnUnknownProperties = failOnUnknownProperties;
    }

    public ContextActionsBlockElement deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        JsonPrimitive prim = (JsonPrimitive)jsonObject.get("type");
        String typeName = prim.getAsString();
        Class<? extends ContextActionsBlockElement> clazz = this.getContextActionsBlockElementClassInstance(typeName);
        return (ContextActionsBlockElement)context.deserialize((JsonElement)jsonObject, clazz);
    }

    public JsonElement serialize(ContextActionsBlockElement src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize((Object)src);
    }

    private Class<? extends ContextActionsBlockElement> getContextActionsBlockElementClassInstance(String typeName) {
        switch (typeName) {
            case "feedback_buttons": {
                return FeedbackButtonsElement.class;
            }
            case "icon_button": {
                return IconButtonElement.class;
            }
        }
        if (this.failOnUnknownProperties) {
            throw new JsonParseException("Unknown context actions block element type: " + typeName);
        }
        return UnknownContextActionsBlockElement.class;
    }
}

