/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.rtm;

import com.slack.api.Slack;
import com.slack.api.methods.SlackApiException;
import com.slack.api.methods.request.rtm.RTMConnectRequest;
import com.slack.api.methods.response.rtm.RTMConnectResponse;
import com.slack.api.model.User;
import com.slack.api.rtm.RTMCloseHandler;
import com.slack.api.rtm.RTMErrorHandler;
import com.slack.api.rtm.RTMMessageHandler;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import lombok.Generated;
import org.glassfish.tyrus.client.ClientManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientEndpoint
public class RTMClient
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RTMClient.class);
    private final Slack slack;
    private final String botApiToken;
    private URI wssUri;
    private User connectedBotUser;
    private Session currentSession;
    private final List<RTMMessageHandler> messageHandlers = new ArrayList<RTMMessageHandler>();
    private final List<RTMErrorHandler> errorHandlers = new ArrayList<RTMErrorHandler>();
    private final List<RTMCloseHandler> closeHandlers = new ArrayList<RTMCloseHandler>();

    public RTMClient(Slack slack, String botApiToken, String wssUrl, User connectedBotUser) throws URISyntaxException {
        if (wssUrl == null) {
            throw new IllegalArgumentException("The wss URL to start Real Time Messaging API is absent.");
        }
        if (connectedBotUser == null) {
            throw new IllegalArgumentException("The self user data is absent.");
        }
        this.slack = slack;
        this.botApiToken = botApiToken;
        this.wssUri = new URI(wssUrl);
        this.connectedBotUser = connectedBotUser;
    }

    public void connect() throws IOException, DeploymentException {
        Map<String, String> proxyHeaders;
        ClientManager client = ClientManager.createClient();
        String proxy = null;
        proxy = this.slack.getHttpClient().getConfig().getProxyUrl();
        if (proxy != null) {
            if (log.isDebugEnabled()) {
                log.debug("The RTM client's going to use an HTTP proxy: {}", (Object)proxy);
            }
            client.getProperties().put("org.glassfish.tyrus.client.proxy", proxy);
        }
        if ((proxyHeaders = this.slack.getHttpClient().getConfig().getProxyHeaders()) != null && !proxyHeaders.isEmpty()) {
            client.getProperties().put("org.glassfish.tyrus.client.proxy.headers", proxyHeaders);
        }
        client.connectToServer((Object)this, this.wssUri);
        log.debug("client connected to the server: {}", (Object)this.wssUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws IOException {
        if (this.currentSession != null && this.currentSession.isOpen()) {
            Session session = this.currentSession;
            synchronized (session) {
                this.currentSession.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, RTMClient.class.getCanonicalName() + " did it"));
            }
        }
    }

    public void reconnect() throws IOException, SlackApiException, URISyntaxException, DeploymentException {
        RTMConnectResponse response = this.slack.methods().rtmConnect(RTMConnectRequest.builder().token(this.botApiToken).build());
        if (!response.isOk()) {
            throw new IllegalStateException("Failed to connect to the RTM endpoint URL (error: " + response.getError() + ")");
        }
        this.wssUri = new URI(response.getUrl());
        this.connectedBotUser = response.getSelf();
        this.connect();
    }

    @Override
    public void close() throws IOException {
        this.disconnect();
    }

    @OnOpen
    public void onOpen(Session session) {
        this.updateSession(session);
        log.debug("session opened: {}", (Object)session.getId());
    }

    @OnClose
    public void onClose(Session session, CloseReason reason) {
        this.updateSession(session);
        log.debug("session closed: {}, reason: {}", (Object)session.getId(), (Object)reason.getReasonPhrase());
        for (RTMCloseHandler closeHandler : this.closeHandlers) {
            closeHandler.handle(reason);
        }
    }

    @OnError
    public void onError(Session session, Throwable reason) {
        log.error("session error occurred, exception is below", reason);
        for (RTMErrorHandler errorHandler : this.errorHandlers) {
            errorHandler.handle(reason);
        }
    }

    @OnMessage
    public void onMessage(String message) {
        log.debug("message: {}", (Object)message);
        for (RTMMessageHandler messageHandler : this.messageHandlers) {
            messageHandler.handle(message);
        }
    }

    public void addMessageHandler(RTMMessageHandler messageHandler) {
        this.messageHandlers.add(messageHandler);
    }

    public void removeMessageHandler(RTMMessageHandler messageHandler) {
        this.messageHandlers.remove(messageHandler);
    }

    public void addErrorHandler(RTMErrorHandler errorHandler) {
        this.errorHandlers.add(errorHandler);
    }

    public void removeErrorHandler(RTMErrorHandler errorHandler) {
        this.errorHandlers.remove(errorHandler);
    }

    public void addCloseHandler(RTMCloseHandler closeHandler) {
        this.closeHandlers.add(closeHandler);
    }

    public void removeCloseHandler(RTMCloseHandler closeHandler) {
        this.closeHandlers.remove(closeHandler);
    }

    public void sendMessage(String message) {
        this.currentSession.getAsyncRemote().sendText(message);
    }

    public URI getWssUri() {
        return this.wssUri;
    }

    public User getConnectedBotUser() {
        return this.connectedBotUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSession(Session newSession) {
        if (this.currentSession == null) {
            this.currentSession = newSession;
        } else {
            Session session = this.currentSession;
            synchronized (session) {
                this.currentSession = newSession;
            }
        }
    }
}

