/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.methods.metrics.impl;

import com.google.gson.Gson;
import com.slack.api.methods.MethodsStats;
import com.slack.api.methods.impl.AsyncRateLimitQueue;
import com.slack.api.methods.metrics.LastMinuteRequests;
import com.slack.api.methods.metrics.MetricsDatastore;
import com.slack.api.methods.metrics.WaitingMessageIds;
import com.slack.api.util.json.GsonFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class MemoryMetricsDatastore
implements MetricsDatastore {
    private final ScheduledExecutorService cleanerExecutor;
    private final int numberOfNodes;
    private static final Gson GSON = GsonFactory.createSnakeCase();
    private static final ConcurrentMap<String, ConcurrentMap<String, LiveMethodsStats>> ALL_LIVE_STATS = new ConcurrentHashMap<String, ConcurrentMap<String, LiveMethodsStats>>();
    private static final ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<String, WaitingMessageIds>>> ALL_MESSAGE_IDS = new ConcurrentHashMap<String, ConcurrentMap<String, ConcurrentMap<String, WaitingMessageIds>>>();
    private static final ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<String, LastMinuteRequests>>> ALL_LAST_MINUTE_REQUESTS = new ConcurrentHashMap<String, ConcurrentMap<String, ConcurrentMap<String, LastMinuteRequests>>>();

    public MemoryMetricsDatastore(int numberOfNodes) {
        this.numberOfNodes = numberOfNodes;
        this.cleanerExecutor = Executors.newSingleThreadScheduledExecutor();
        this.cleanerExecutor.scheduleAtFixedRate(new MaintenanceJob(this), 1000L, 50L, TimeUnit.MILLISECONDS);
    }

    protected void finalize() throws Throwable {
        this.cleanerExecutor.shutdown();
        super.finalize();
    }

    @Override
    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    @Override
    public Map<String, Map<String, MethodsStats>> getAllStats() {
        HashMap<String, Map<String, MethodsStats>> result = new HashMap<String, Map<String, MethodsStats>>();
        for (Map.Entry executor : ALL_LIVE_STATS.entrySet()) {
            HashMap allTeams = new HashMap();
            for (Map.Entry team : ((ConcurrentMap)executor.getValue()).entrySet()) {
                MethodsStats stats = (MethodsStats)GSON.fromJson(GSON.toJson(team.getValue()), MethodsStats.class);
                allTeams.put(team.getKey(), stats);
            }
            result.put((String)executor.getKey(), allTeams);
        }
        return result;
    }

    @Override
    public MethodsStats getStats(String executorName, String teamId) {
        LiveMethodsStats internal = this.getOrCreateTeamLiveStats(executorName, teamId);
        MethodsStats stats = (MethodsStats)GSON.fromJson(GSON.toJson((Object)internal), MethodsStats.class);
        return stats;
    }

    @Override
    public void incrementAllCompletedCalls(String executorName, String teamId, String methodName) {
        LiveMethodsStats stats = this.getOrCreateTeamLiveStats(executorName, teamId);
        if (stats.getAllCompletedCalls().get(methodName) == null) {
            stats.getAllCompletedCalls().putIfAbsent(methodName, new AtomicLong(0L));
        }
        ((AtomicLong)stats.getAllCompletedCalls().get(methodName)).incrementAndGet();
    }

    @Override
    public void incrementSuccessfulCalls(String executorName, String teamId, String methodName) {
        LiveMethodsStats stats = this.getOrCreateTeamLiveStats(executorName, teamId);
        if (stats.getSuccessfulCalls().get(methodName) == null) {
            stats.getSuccessfulCalls().putIfAbsent(methodName, new AtomicLong(0L));
        }
        ((AtomicLong)stats.getSuccessfulCalls().get(methodName)).incrementAndGet();
    }

    @Override
    public void incrementUnsuccessfulCalls(String executorName, String teamId, String methodName) {
        LiveMethodsStats stats = this.getOrCreateTeamLiveStats(executorName, teamId);
        if (stats.getUnsuccessfulCalls().get(methodName) == null) {
            stats.getUnsuccessfulCalls().putIfAbsent(methodName, new AtomicLong(0L));
        }
        ((AtomicLong)stats.getUnsuccessfulCalls().get(methodName)).incrementAndGet();
    }

    @Override
    public void incrementFailedCalls(String executorName, String teamId, String methodName) {
        LiveMethodsStats stats = this.getOrCreateTeamLiveStats(executorName, teamId);
        if (stats.getFailedCalls().get(methodName) == null) {
            stats.getFailedCalls().putIfAbsent(methodName, new AtomicLong(0L));
        }
        ((AtomicLong)stats.getFailedCalls().get(methodName)).incrementAndGet();
    }

    @Override
    public void updateCurrentQueueSize(String executorName, String teamId, String methodName) {
        WaitingMessageIds messageIds = this.getOrCreateMessageIds(executorName, teamId, methodName);
        Integer totalSize = messageIds.size();
        AsyncRateLimitQueue queue = AsyncRateLimitQueue.get(executorName, teamId);
        if (queue != null) {
            totalSize = totalSize + queue.getCurrentActiveQueueSize(methodName);
        }
        this.setCurrentQueueSize(executorName, teamId, methodName, totalSize);
    }

    @Override
    public void setCurrentQueueSize(String executorName, String teamId, String methodName, Integer size) {
        WaitingMessageIds messageIds = this.getOrCreateMessageIds(executorName, teamId, methodName);
        Integer totalSize = messageIds.size();
        AsyncRateLimitQueue queue = AsyncRateLimitQueue.get(executorName, teamId);
        if (queue != null) {
            totalSize = totalSize + queue.getCurrentActiveQueueSize(methodName);
        }
        this.getOrCreateTeamLiveStats(executorName, teamId).getCurrentQueueSize().put(methodName, totalSize);
        this.getOrCreateTeamLiveStats(executorName, teamId).getCurrentQueueSize().put(methodName, size);
    }

    @Override
    public Integer getNumberOfLastMinuteRequests(String executorName, String teamId, String methodName) {
        return this.getOrCreateLastMinuteRequests(executorName, teamId, methodName).size();
    }

    @Override
    public void updateNumberOfLastMinuteRequests(String executorName, String teamId, String methodName) {
        LastMinuteRequests requests = this.getOrCreateLastMinuteRequests(executorName, teamId, methodName);
        long oneMinuteAgo = System.currentTimeMillis() - 60000L;
        for (Long millis : requests) {
            if (millis >= oneMinuteAgo) continue;
            requests.remove(millis);
        }
        this.setNumberOfLastMinuteRequests(executorName, teamId, methodName, requests.size());
    }

    @Override
    public void setNumberOfLastMinuteRequests(String executorName, String teamId, String methodName, Integer value) {
        ConcurrentMap<String, Integer> lastMinuteRequests = this.getOrCreateTeamLiveStats(executorName, teamId).getLastMinuteRequests();
        lastMinuteRequests.put(methodName, value);
    }

    @Override
    public Long getRateLimitedMethodRetryEpochMillis(String executorName, String teamId, String methodName) {
        return (Long)this.getOrCreateTeamLiveStats(executorName, teamId).getRateLimitedMethods().get(methodName);
    }

    @Override
    public void setRateLimitedMethodRetryEpochMillis(String executorName, String teamId, String methodName, Long epochTimeMillis) {
        this.getOrCreateTeamLiveStats(executorName, teamId).getRateLimitedMethods().put(methodName, epochTimeMillis);
    }

    @Override
    public void addToLastMinuteRequests(String executorName, String teamId, String methodName, Long currentMillis) {
        this.getOrCreateLastMinuteRequests(executorName, teamId, methodName).add(currentMillis);
        this.updateNumberOfLastMinuteRequests(executorName, teamId, methodName);
    }

    @Override
    public LastMinuteRequests getLastMinuteRequests(String executorName, String teamId, String methodName) {
        return this.getOrCreateLastMinuteRequests(executorName, teamId, methodName);
    }

    @Override
    public void addToWaitingMessageIds(String executorName, String teamId, String methodName, String messageId) {
        if (teamId == null) {
            teamId = "none";
        }
        WaitingMessageIds messageIds = this.getOrCreateMessageIds(executorName, teamId, methodName);
        messageIds.add(messageId);
    }

    @Override
    public void deleteFromWaitingMessageIds(String executorName, String teamId, String methodName, String messageId) {
        if (teamId == null) {
            teamId = "none";
        }
        WaitingMessageIds messageIds = this.getOrCreateMessageIds(executorName, teamId, methodName);
        messageIds.remove(messageId);
    }

    private ConcurrentMap<String, LiveMethodsStats> getOrCreateExecutorLiveStats(String executorName) {
        if (ALL_LIVE_STATS.get(executorName) == null) {
            ALL_LIVE_STATS.putIfAbsent(executorName, new ConcurrentHashMap());
        }
        return (ConcurrentMap)ALL_LIVE_STATS.get(executorName);
    }

    private LiveMethodsStats getOrCreateTeamLiveStats(String executorName, String teamId) {
        ConcurrentMap<String, LiveMethodsStats> executor = this.getOrCreateExecutorLiveStats(executorName);
        if (executor.get(teamId) == null) {
            executor.putIfAbsent(teamId, new LiveMethodsStats());
        }
        return (LiveMethodsStats)executor.get(teamId);
    }

    private WaitingMessageIds getOrCreateMessageIds(String executorName, String teamId, String methodName) {
        if (ALL_MESSAGE_IDS.get(executorName) == null) {
            ALL_MESSAGE_IDS.putIfAbsent(executorName, new ConcurrentHashMap());
        }
        if (((ConcurrentMap)ALL_MESSAGE_IDS.get(executorName)).get(teamId) == null) {
            ((ConcurrentMap)ALL_MESSAGE_IDS.get(executorName)).putIfAbsent(teamId, new ConcurrentHashMap());
        }
        if (((ConcurrentMap)((ConcurrentMap)ALL_MESSAGE_IDS.get(executorName)).get(teamId)).get(methodName) == null) {
            ((ConcurrentMap)((ConcurrentMap)ALL_MESSAGE_IDS.get(executorName)).get(teamId)).putIfAbsent(methodName, new WaitingMessageIds());
        }
        return (WaitingMessageIds)((ConcurrentMap)((ConcurrentMap)ALL_MESSAGE_IDS.get(executorName)).get(teamId)).get(methodName);
    }

    private LastMinuteRequests getOrCreateLastMinuteRequests(String executorName, String teamId, String methodName) {
        if (ALL_LAST_MINUTE_REQUESTS.get(executorName) == null) {
            ALL_LAST_MINUTE_REQUESTS.putIfAbsent(executorName, new ConcurrentHashMap());
        }
        if (((ConcurrentMap)ALL_LAST_MINUTE_REQUESTS.get(executorName)).get(teamId) == null) {
            ((ConcurrentMap)ALL_LAST_MINUTE_REQUESTS.get(executorName)).putIfAbsent(teamId, new ConcurrentHashMap());
        }
        if (((ConcurrentMap)((ConcurrentMap)ALL_LAST_MINUTE_REQUESTS.get(executorName)).get(teamId)).get(methodName) == null) {
            ((ConcurrentMap)((ConcurrentMap)ALL_LAST_MINUTE_REQUESTS.get(executorName)).get(teamId)).putIfAbsent(methodName, new LastMinuteRequests());
        }
        return (LastMinuteRequests)((ConcurrentMap)((ConcurrentMap)ALL_LAST_MINUTE_REQUESTS.get(executorName)).get(teamId)).get(methodName);
    }

    private static class MaintenanceJob
    implements Runnable {
        private final MemoryMetricsDatastore store;

        MaintenanceJob(MemoryMetricsDatastore store) {
            this.store = store;
        }

        @Override
        public void run() {
            for (Map.Entry executor : ALL_LIVE_STATS.entrySet()) {
                String executorName = (String)executor.getKey();
                for (Map.Entry team : ((ConcurrentMap)executor.getValue()).entrySet()) {
                    String teamId = (String)team.getKey();
                    LiveMethodsStats stats = (LiveMethodsStats)team.getValue();
                    for (String methodName : stats.getLastMinuteRequests().keySet()) {
                        this.store.updateNumberOfLastMinuteRequests(executorName, teamId, methodName);
                    }
                    for (String methodName : stats.getCurrentQueueSize().keySet()) {
                        this.store.updateCurrentQueueSize(executorName, teamId, methodName);
                    }
                    ArrayList<String> methodNamesToRemove = new ArrayList<String>();
                    for (Map.Entry each : stats.getRateLimitedMethods().entrySet()) {
                        String methodName = (String)each.getKey();
                        Long millisToRetry = (Long)each.getValue();
                        long nowMillis = System.currentTimeMillis();
                        if (millisToRetry >= nowMillis) continue;
                        methodNamesToRemove.add(methodName);
                    }
                    for (String methodName : methodNamesToRemove) {
                        stats.getRateLimitedMethods().remove(methodName);
                    }
                }
            }
        }
    }

    public class LiveMethodsStats {
        private final ConcurrentMap<String, AtomicLong> allCompletedCalls = new ConcurrentHashMap<String, AtomicLong>();
        private final ConcurrentMap<String, AtomicLong> successfulCalls = new ConcurrentHashMap<String, AtomicLong>();
        private final ConcurrentMap<String, AtomicLong> unsuccessfulCalls = new ConcurrentHashMap<String, AtomicLong>();
        private final ConcurrentMap<String, AtomicLong> failedCalls = new ConcurrentHashMap<String, AtomicLong>();
        private final ConcurrentMap<String, Integer> currentQueueSize = new ConcurrentHashMap<String, Integer>();
        private final ConcurrentMap<String, Integer> lastMinuteRequests = new ConcurrentHashMap<String, Integer>();
        private final ConcurrentMap<String, Long> rateLimitedMethods = new ConcurrentHashMap<String, Long>();

        public ConcurrentMap<String, AtomicLong> getAllCompletedCalls() {
            return this.allCompletedCalls;
        }

        public ConcurrentMap<String, AtomicLong> getSuccessfulCalls() {
            return this.successfulCalls;
        }

        public ConcurrentMap<String, AtomicLong> getUnsuccessfulCalls() {
            return this.unsuccessfulCalls;
        }

        public ConcurrentMap<String, AtomicLong> getFailedCalls() {
            return this.failedCalls;
        }

        public ConcurrentMap<String, Integer> getCurrentQueueSize() {
            return this.currentQueueSize;
        }

        public ConcurrentMap<String, Integer> getLastMinuteRequests() {
            return this.lastMinuteRequests;
        }

        public ConcurrentMap<String, Long> getRateLimitedMethods() {
            return this.rateLimitedMethods;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LiveMethodsStats)) {
                return false;
            }
            LiveMethodsStats other = (LiveMethodsStats)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ConcurrentMap<String, AtomicLong> this$allCompletedCalls = this.getAllCompletedCalls();
            ConcurrentMap<String, AtomicLong> other$allCompletedCalls = other.getAllCompletedCalls();
            if (this$allCompletedCalls == null ? other$allCompletedCalls != null : !this$allCompletedCalls.equals(other$allCompletedCalls)) {
                return false;
            }
            ConcurrentMap<String, AtomicLong> this$successfulCalls = this.getSuccessfulCalls();
            ConcurrentMap<String, AtomicLong> other$successfulCalls = other.getSuccessfulCalls();
            if (this$successfulCalls == null ? other$successfulCalls != null : !this$successfulCalls.equals(other$successfulCalls)) {
                return false;
            }
            ConcurrentMap<String, AtomicLong> this$unsuccessfulCalls = this.getUnsuccessfulCalls();
            ConcurrentMap<String, AtomicLong> other$unsuccessfulCalls = other.getUnsuccessfulCalls();
            if (this$unsuccessfulCalls == null ? other$unsuccessfulCalls != null : !this$unsuccessfulCalls.equals(other$unsuccessfulCalls)) {
                return false;
            }
            ConcurrentMap<String, AtomicLong> this$failedCalls = this.getFailedCalls();
            ConcurrentMap<String, AtomicLong> other$failedCalls = other.getFailedCalls();
            if (this$failedCalls == null ? other$failedCalls != null : !this$failedCalls.equals(other$failedCalls)) {
                return false;
            }
            ConcurrentMap<String, Integer> this$currentQueueSize = this.getCurrentQueueSize();
            ConcurrentMap<String, Integer> other$currentQueueSize = other.getCurrentQueueSize();
            if (this$currentQueueSize == null ? other$currentQueueSize != null : !this$currentQueueSize.equals(other$currentQueueSize)) {
                return false;
            }
            ConcurrentMap<String, Integer> this$lastMinuteRequests = this.getLastMinuteRequests();
            ConcurrentMap<String, Integer> other$lastMinuteRequests = other.getLastMinuteRequests();
            if (this$lastMinuteRequests == null ? other$lastMinuteRequests != null : !this$lastMinuteRequests.equals(other$lastMinuteRequests)) {
                return false;
            }
            ConcurrentMap<String, Long> this$rateLimitedMethods = this.getRateLimitedMethods();
            ConcurrentMap<String, Long> other$rateLimitedMethods = other.getRateLimitedMethods();
            return !(this$rateLimitedMethods == null ? other$rateLimitedMethods != null : !this$rateLimitedMethods.equals(other$rateLimitedMethods));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LiveMethodsStats;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ConcurrentMap<String, AtomicLong> $allCompletedCalls = this.getAllCompletedCalls();
            result = result * 59 + ($allCompletedCalls == null ? 43 : $allCompletedCalls.hashCode());
            ConcurrentMap<String, AtomicLong> $successfulCalls = this.getSuccessfulCalls();
            result = result * 59 + ($successfulCalls == null ? 43 : $successfulCalls.hashCode());
            ConcurrentMap<String, AtomicLong> $unsuccessfulCalls = this.getUnsuccessfulCalls();
            result = result * 59 + ($unsuccessfulCalls == null ? 43 : $unsuccessfulCalls.hashCode());
            ConcurrentMap<String, AtomicLong> $failedCalls = this.getFailedCalls();
            result = result * 59 + ($failedCalls == null ? 43 : $failedCalls.hashCode());
            ConcurrentMap<String, Integer> $currentQueueSize = this.getCurrentQueueSize();
            result = result * 59 + ($currentQueueSize == null ? 43 : $currentQueueSize.hashCode());
            ConcurrentMap<String, Integer> $lastMinuteRequests = this.getLastMinuteRequests();
            result = result * 59 + ($lastMinuteRequests == null ? 43 : $lastMinuteRequests.hashCode());
            ConcurrentMap<String, Long> $rateLimitedMethods = this.getRateLimitedMethods();
            result = result * 59 + ($rateLimitedMethods == null ? 43 : $rateLimitedMethods.hashCode());
            return result;
        }

        public String toString() {
            return "MemoryMetricsDatastore.LiveMethodsStats(allCompletedCalls=" + this.getAllCompletedCalls() + ", successfulCalls=" + this.getSuccessfulCalls() + ", unsuccessfulCalls=" + this.getUnsuccessfulCalls() + ", failedCalls=" + this.getFailedCalls() + ", currentQueueSize=" + this.getCurrentQueueSize() + ", lastMinuteRequests=" + this.getLastMinuteRequests() + ", rateLimitedMethods=" + this.getRateLimitedMethods() + ")";
        }
    }
}

