/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.methods;

import com.slack.api.SlackConfig;
import com.slack.api.methods.SlackApiErrorResponse;
import com.slack.api.util.json.GsonFactory;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackApiException
extends Exception {
    private static final Logger log = LoggerFactory.getLogger(SlackApiException.class);
    private final Response response;
    private final String responseBody;
    private final SlackApiErrorResponse error;

    public SlackApiException(Response response, String responseBody) {
        this(SlackConfig.DEFAULT, response, responseBody);
    }

    public SlackApiException(SlackConfig config, Response response, String responseBody) {
        this(response, responseBody, SlackApiException.parse(config, responseBody));
    }

    public SlackApiException(Response response, String responseBody, SlackApiErrorResponse error) {
        super(SlackApiException.buildErrorMessage(response, error));
        this.response = response;
        this.responseBody = responseBody;
        this.error = error;
    }

    private static String buildErrorMessage(Response response, SlackApiErrorResponse error) {
        String message = "status: " + response.code();
        if (error != null) {
            return message + ", error: " + error.getError() + ", needed: " + error.getNeeded() + ", provided: " + error.getProvided() + ", warning: " + error.getWarning();
        }
        return message + ", no response body";
    }

    private static SlackApiErrorResponse parse(SlackConfig config, String responseBody) {
        SlackApiErrorResponse parsedErrorResponse;
        block2: {
            parsedErrorResponse = null;
            try {
                parsedErrorResponse = (SlackApiErrorResponse)GsonFactory.createSnakeCase(config).fromJson(responseBody, SlackApiErrorResponse.class);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                String responseToPrint = responseBody.length() > 1000 ? responseBody.subSequence(0, 1000) + " ..." : responseBody;
                log.debug("Failed to parse the error response body: {}", (Object)responseToPrint);
            }
        }
        return parsedErrorResponse;
    }

    public Response getResponse() {
        return this.response;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public SlackApiErrorResponse getError() {
        return this.error;
    }

    @Override
    public String toString() {
        return "SlackApiException(response=" + this.getResponse() + ", responseBody=" + this.getResponseBody() + ", error=" + this.getError() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SlackApiException)) {
            return false;
        }
        SlackApiException other = (SlackApiException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Response this$response = this.getResponse();
        Response other$response = other.getResponse();
        if (this$response == null ? other$response != null : !this$response.equals(other$response)) {
            return false;
        }
        String this$responseBody = this.getResponseBody();
        String other$responseBody = other.getResponseBody();
        if (this$responseBody == null ? other$responseBody != null : !this$responseBody.equals(other$responseBody)) {
            return false;
        }
        SlackApiErrorResponse this$error = this.getError();
        SlackApiErrorResponse other$error = other.getError();
        return !(this$error == null ? other$error != null : !((Object)this$error).equals(other$error));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SlackApiException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Response $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : $response.hashCode());
        String $responseBody = this.getResponseBody();
        result = result * 59 + ($responseBody == null ? 43 : $responseBody.hashCode());
        SlackApiErrorResponse $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
        return result;
    }
}

