/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.methods.impl;

import com.slack.api.SlackConfig;
import com.slack.api.methods.RequestFormBuilder;
import com.slack.api.methods.SlackApiException;
import com.slack.api.methods.impl.MethodsClientImpl;
import com.slack.api.methods.request.auth.AuthTestRequest;
import com.slack.api.methods.response.auth.AuthTestResponse;
import com.slack.api.util.http.SlackHttpClient;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import okhttp3.FormBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeamIdCache {
    private static final Logger log = LoggerFactory.getLogger(TeamIdCache.class);
    private static final ConcurrentMap<String, String> TOKEN_TO_TEAM_ID = new ConcurrentHashMap<String, String>();
    private final MethodsClientImpl methodsImpl;

    public TeamIdCache(SlackConfig config) {
        this(new MethodsClientImpl(TeamIdCache.buildHttpClient(config)));
    }

    public TeamIdCache(MethodsClientImpl methodsImpl) {
        this.methodsImpl = methodsImpl;
    }

    private static SlackHttpClient buildHttpClient(SlackConfig config) {
        SlackHttpClient httpClient = new SlackHttpClient();
        httpClient.setConfig(config);
        return httpClient;
    }

    public String lookupOrResolve(String token) {
        return TeamIdCache.lookupOrResolve(token, newToken -> {
            try {
                FormBody.Builder form = RequestFormBuilder.toForm(AuthTestRequest.builder().token((String)newToken).build());
                Response response = this.methodsImpl.runPostFormWithToken(form, "auth.test", token);
                AuthTestResponse authTest = this.methodsImpl.parseJsonResponseAndRunListeners(null, null, response, AuthTestResponse.class);
                if (authTest.isOk()) {
                    return authTest.getTeamId();
                }
                log.error("Got an unsuccessful response from auth.test API (error: {})", (Object)authTest.getError());
            }
            catch (SlackApiException | IOException e) {
                log.error("Failed to call auth.test API (error: {})", (Object)e.getMessage(), (Object)e);
            }
            return null;
        });
    }

    private static String lookupOrResolve(String token, Function<String, String> compute) {
        if (token == null) {
            return null;
        }
        return TOKEN_TO_TEAM_ID.computeIfAbsent(token, compute);
    }
}

