/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.middleware.builtin;

import com.slack.api.app_backend.events.payload.EventsApiPayload;
import com.slack.api.bolt.context.builtin.EventContext;
import com.slack.api.bolt.handler.AssistantEventHandler;
import com.slack.api.bolt.middleware.Middleware;
import com.slack.api.bolt.middleware.MiddlewareChain;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestType;
import com.slack.api.bolt.request.builtin.EventRequest;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.service.AssistantThreadContextService;
import com.slack.api.bolt.service.builtin.DefaultAssistantThreadContextService;
import com.slack.api.bolt.util.EventsApiPayloadParser;
import com.slack.api.model.assistant.AssistantThreadContext;
import com.slack.api.model.event.AssistantThreadContextChangedEvent;
import com.slack.api.model.event.AssistantThreadStartedEvent;
import com.slack.api.model.event.MessageEvent;
import com.slack.api.model.event.MessageFileShareEvent;
import com.slack.api.util.thread.DaemonThreadExecutorServiceProvider;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Assistant
implements Middleware {
    private AssistantThreadContextService threadContextService;
    private boolean threadContextAutoSave;
    private ExecutorService executorService;
    private Logger logger = LoggerFactory.getLogger(Assistant.class);
    private AssistantEventHandler<AssistantThreadStartedEvent> threadStarted;
    private AssistantEventHandler<AssistantThreadContextChangedEvent> threadContextChanged;
    private AssistantEventHandler<MessageEvent> userMessage;
    private AssistantEventHandler<MessageFileShareEvent> userMessageWithFiles;
    private AssistantEventHandler<MessageEvent> botMessage;

    public Assistant() {
        this(null, Assistant.buildDefaultExecutorService(), Assistant.buildDefaultLogger());
    }

    public Assistant(ExecutorService executorService) {
        this(null, executorService, Assistant.buildDefaultLogger());
    }

    public Assistant(ExecutorService executorService, Logger logger) {
        this(null, executorService, logger);
    }

    public Assistant(AssistantThreadContextService threadContextService) {
        this(threadContextService, Assistant.buildDefaultExecutorService(), Assistant.buildDefaultLogger());
    }

    public Assistant(AssistantThreadContextService threadContextService, ExecutorService executorService) {
        this(threadContextService, executorService, Assistant.buildDefaultLogger());
    }

    public Assistant(AssistantThreadContextService threadContextService, ExecutorService executorService, Logger logger) {
        this.setThreadContextAutoSave(true);
        this.setThreadContextService(threadContextService);
        this.setExecutorService(executorService);
        this.setLogger(logger);
    }

    @Override
    public Response apply(Request req, Response resp, MiddlewareChain chain) throws Exception {
        if (req.getRequestType().equals((Object)RequestType.Event) && ((EventContext)req.getContext()).isAssistantThreadEvent()) {
            EventRequest request = (EventRequest)req;
            EventContext context = request.getContext();
            if (this.getThreadContextService() == null) {
                this.setThreadContextService(new DefaultAssistantThreadContextService(request.getContext()));
            }
            context.setThreadContextService(this.getThreadContextService());
            if (this.isThreadContextAutoSave() && context.getThreadContext() != null) {
                this.getThreadContextService().saveCurrentContext(context.getChannelId(), context.getThreadTs(), context.getThreadContext());
            }
            switch (request.getEventType()) {
                case "assistant_thread_started": {
                    if (this.threadStarted == null) {
                        this.getExecutorService().submit(() -> {
                            try {
                                context.say(r -> r.text("Hi, how can I help you today?"));
                            }
                            catch (Exception e) {
                                this.getLogger().error("Failed to send the first response: {e}", (Throwable)e);
                            }
                        });
                    } else {
                        this.getExecutorService().submit(() -> {
                            try {
                                this.threadStarted.apply(EventsApiPayloadParser.buildEventPayload(request), context);
                            }
                            catch (Exception e) {
                                this.getLogger().error("Failed to run threadStarted handler: {e}", (Throwable)e);
                            }
                        });
                    }
                    return context.ack();
                }
                case "assistant_thread_context_changed": {
                    if (this.threadContextChanged == null) {
                        this.getExecutorService().submit(() -> {
                            try {
                                this.getThreadContextService().saveCurrentContext(context.getChannelId(), context.getThreadTs(), context.getThreadContext());
                            }
                            catch (Exception e) {
                                this.getLogger().error("Failed to save new thread context: {e}", (Throwable)e);
                            }
                        });
                    } else {
                        this.getExecutorService().submit(() -> {
                            try {
                                this.threadContextChanged.apply(EventsApiPayloadParser.buildEventPayload(request), context);
                            }
                            catch (Exception e) {
                                this.getLogger().error("Failed to run threadContextChanged handler: {e}", (Throwable)e);
                            }
                        });
                    }
                    return context.ack();
                }
                case "message": {
                    String[] elements = request.getEventTypeAndSubtype().split(":");
                    if (elements.length == 1) {
                        this.loadCurrentThreadContext(context);
                        this.getExecutorService().submit(() -> {
                            EventsApiPayload payload = EventsApiPayloadParser.buildEventPayload(request);
                            if (((MessageEvent)payload.getEvent()).getBotId() != null) {
                                try {
                                    this.botMessage.apply(payload, context);
                                }
                                catch (Exception e) {
                                    this.getLogger().error("Failed to run botMessage handler: {e}", (Throwable)e);
                                }
                            } else {
                                try {
                                    this.userMessage.apply(payload, context);
                                }
                                catch (Exception e) {
                                    this.getLogger().error("Failed to run userMessage handler: {e}", (Throwable)e);
                                }
                            }
                        });
                        return context.ack();
                    }
                    if (elements.length == 2 && elements[1].equals("file_share")) {
                        this.loadCurrentThreadContext(context);
                        this.getExecutorService().submit(() -> {
                            try {
                                this.userMessageWithFiles.apply(EventsApiPayloadParser.buildEventPayload(request), request.getContext());
                            }
                            catch (Exception e) {
                                this.getLogger().error("Failed to run userMessageWithFiles handler: {e}", (Throwable)e);
                            }
                        });
                        return context.ack();
                    }
                    return context.ack();
                }
            }
        }
        return chain.next(req);
    }

    public Assistant threadStarted(AssistantEventHandler<AssistantThreadStartedEvent> handler) {
        this.threadStarted = handler;
        return this;
    }

    public Assistant threadContextChanged(AssistantEventHandler<AssistantThreadContextChangedEvent> handler) {
        this.threadContextChanged = handler;
        return this;
    }

    public Assistant userMessage(AssistantEventHandler<MessageEvent> handler) {
        this.userMessage = handler;
        return this;
    }

    public Assistant userMessageWithFiles(AssistantEventHandler<MessageFileShareEvent> handler) {
        this.userMessageWithFiles = handler;
        return this;
    }

    public Assistant botMessage(AssistantEventHandler<MessageEvent> handler) {
        this.botMessage = handler;
        return this;
    }

    private void loadCurrentThreadContext(EventContext context) {
        Optional<AssistantThreadContext> threadContext = this.getThreadContextService().findCurrentContext(context.getChannelId(), context.getThreadTs());
        if (threadContext != null && threadContext.isPresent()) {
            context.setThreadContext(threadContext.get());
        }
    }

    private static ExecutorService buildDefaultExecutorService() {
        return DaemonThreadExecutorServiceProvider.getInstance().createThreadPoolExecutor("bolt-assistant-app-threads", 10);
    }

    private static Logger buildDefaultLogger() {
        return LoggerFactory.getLogger(Assistant.class);
    }

    @Generated
    public AssistantThreadContextService getThreadContextService() {
        return this.threadContextService;
    }

    @Generated
    public void setThreadContextService(AssistantThreadContextService threadContextService) {
        this.threadContextService = threadContextService;
    }

    @Generated
    public boolean isThreadContextAutoSave() {
        return this.threadContextAutoSave;
    }

    @Generated
    public void setThreadContextAutoSave(boolean threadContextAutoSave) {
        this.threadContextAutoSave = threadContextAutoSave;
    }

    @Generated
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Generated
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

