/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.middleware.builtin;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.slack.api.app_backend.slash_commands.SlashCommandPayloadDetector;
import com.slack.api.app_backend.slash_commands.SlashCommandPayloadParser;
import com.slack.api.app_backend.util.JsonPayloadExtractor;
import com.slack.api.app_backend.util.RequestTokenVerifier;
import com.slack.api.bolt.middleware.Middleware;
import com.slack.api.bolt.middleware.MiddlewareChain;
import com.slack.api.bolt.middleware.MiddlewareOps;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.response.Response;
import com.slack.api.util.json.GsonFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class LegacyRequestVerification
implements Middleware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LegacyRequestVerification.class);
    private final RequestTokenVerifier verifier;
    private final JsonPayloadExtractor jsonPayloadExtractor = new JsonPayloadExtractor();
    private final SlashCommandPayloadDetector commandRequestDetector = new SlashCommandPayloadDetector();
    private final SlashCommandPayloadParser commandPayloadParser = new SlashCommandPayloadParser();
    private final Gson gson = GsonFactory.createSnakeCase();

    public LegacyRequestVerification(String verificationToken) {
        this.verifier = new RequestTokenVerifier(verificationToken);
    }

    @Override
    public Response apply(Request req, Response resp, MiddlewareChain chain) throws Exception {
        String actualToken;
        if (MiddlewareOps.isNoSlackSignatureRequest(req.getRequestType())) {
            return chain.next(req);
        }
        String body = req.getRequestBodyAsString();
        String json = this.jsonPayloadExtractor.extractIfExists(body);
        if (json != null) {
            JsonElement j = (JsonElement)this.gson.fromJson(json, JsonElement.class);
            actualToken = j.getAsJsonObject().get("token").getAsString();
        } else if (this.commandRequestDetector.isCommand(body)) {
            actualToken = this.commandPayloadParser.parse(body).getToken();
        } else {
            log.info("Failed to find a verification token - {}", (Object)body);
            return Response.json(401, "{\"error\":\"invalid request\"}");
        }
        if (this.verifier.isValid(actualToken)) {
            return chain.next(req);
        }
        log.info("Invalid verification token detected - {}", (Object)actualToken);
        return Response.json(401, "{\"error\":\"invalid request\"}");
    }
}

