/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.request.builtin;

import com.slack.api.app_backend.dialogs.payload.DialogSuggestionPayload;
import com.slack.api.bolt.context.builtin.DialogSuggestionContext;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.request.RequestType;
import com.slack.api.util.json.GsonFactory;
import lombok.Generated;

public class DialogSuggestionRequest
extends Request<DialogSuggestionContext> {
    private final String requestBody;
    private final RequestHeaders headers;
    private final DialogSuggestionPayload payload;
    private DialogSuggestionContext context = new DialogSuggestionContext();

    public DialogSuggestionRequest(String requestBody, String payloadBody, RequestHeaders headers) {
        this.requestBody = requestBody;
        this.headers = headers;
        this.payload = (DialogSuggestionPayload)GsonFactory.createSnakeCase().fromJson(payloadBody, DialogSuggestionPayload.class);
        this.getContext().setEnterpriseId(this.payload.getTeam().getEnterpriseId());
        this.getContext().setTeamId(this.payload.getTeam().getId());
        this.getContext().setRequestUserId(this.payload.getUser().getId());
    }

    @Override
    public DialogSuggestionContext getContext() {
        return this.context;
    }

    @Override
    public RequestType getRequestType() {
        return RequestType.DialogSuggestion;
    }

    @Override
    public String getRequestBodyAsString() {
        return this.requestBody;
    }

    @Override
    public RequestHeaders getHeaders() {
        return this.headers;
    }

    public DialogSuggestionPayload getPayload() {
        return this.payload;
    }

    @Override
    @Generated
    public String toString() {
        return "DialogSuggestionRequest(super=" + super.toString() + ", requestBody=" + this.requestBody + ", headers=" + this.getHeaders() + ", payload=" + this.getPayload() + ", context=" + this.getContext() + ")";
    }
}

